/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.base.dusts;

import gregtech.api.enums.Mods;
import gregtech.api.enums.TextureSet;
import gregtech.api.util.GT_OreDictUnificator;
import gtPlusPlus.core.item.base.BaseItemComponent;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import org.apache.commons.lang3.StringUtils;

public class BaseItemDustEx
extends BaseItemComponent {
    public static Map<String, String> mCachedPileLinkages = new HashMap<String, String>();
    protected IIcon[] baseAr = new IIcon[3];
    protected IIcon[] overlayAr = new IIcon[3];
    public static final BaseItemComponent.ComponentTypes[] componentTypeAr = new BaseItemComponent.ComponentTypes[]{BaseItemComponent.ComponentTypes.DUST, BaseItemComponent.ComponentTypes.DUSTSMALL, BaseItemComponent.ComponentTypes.DUSTTINY};

    public BaseItemDustEx(Material material) {
        super(material, componentTypeAr[0]);
        GT_OreDictUnificator.registerOre((Object)(componentTypeAr[0].getOreDictName() + material.getUnlocalizedName()), (ItemStack)ItemUtils.simpleMetaStack(this, 0, 1));
        GT_OreDictUnificator.registerOre((Object)(componentTypeAr[1].getOreDictName() + material.getUnlocalizedName()), (ItemStack)ItemUtils.simpleMetaStack(this, 0, 1));
        GT_OreDictUnificator.registerOre((Object)(componentTypeAr[2].getOreDictName() + material.getUnlocalizedName()), (ItemStack)ItemUtils.simpleMetaStack(this, 0, 1));
        this.bakeRegistry();
    }

    private void bakeRegistry() {
        String unlocalName = this.func_77658_a();
        if (unlocalName.contains("item.")) {
            unlocalName = StringUtils.remove((String)unlocalName, (String)"item.");
        }
        if (unlocalName.contains("itemDust")) {
            unlocalName = StringUtils.remove((String)unlocalName, (String)"itemDust");
        }
        mCachedPileLinkages.put(this.func_77658_a(), "itemDust" + unlocalName);
        mCachedPileLinkages.put(this.func_77658_a(), "itemDustSmall" + unlocalName);
        mCachedPileLinkages.put(this.func_77658_a(), "itemDustTiny" + unlocalName);
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < 3; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    @Override
    public IIcon func_77618_c(int meta, int pass) {
        if (CORE.ConfigSwitches.useGregtechTextures) {
            if (meta == 0) {
                if (pass == 0) {
                    return this.baseAr[0];
                }
                return this.overlayAr[0];
            }
            if (meta == 1) {
                if (pass == 0) {
                    return this.baseAr[1];
                }
                return this.overlayAr[1];
            }
            if (pass == 0) {
                return this.baseAr[2];
            }
            return this.overlayAr[2];
        }
        return this.baseAr[meta];
    }

    @Override
    public void func_94581_a(IIconRegister i) {
        if (CORE.ConfigSwitches.useGregtechTextures) {
            this.baseAr[0] = i.func_94245_a(this.getCorrectTextures());
            this.overlayAr[0] = i.func_94245_a(this.getCorrectTextures() + "_OVERLAY");
            this.baseAr[1] = i.func_94245_a(this.getCorrectTextures() + "Small");
            this.overlayAr[1] = i.func_94245_a(this.getCorrectTextures() + "Small_OVERLAY");
            this.baseAr[2] = i.func_94245_a(this.getCorrectTextures() + "Tiny");
            this.overlayAr[2] = i.func_94245_a(this.getCorrectTextures() + "Tiny_OVERLAY");
        } else {
            this.baseAr[0] = i.func_94245_a(this.getCorrectTextures());
            this.baseAr[1] = i.func_94245_a(this.getCorrectTextures() + "Small");
            this.baseAr[2] = i.func_94245_a(this.getCorrectTextures() + "Tiny");
        }
    }

    @Override
    public String getCorrectTextures() {
        TextureSet u;
        if (!CORE.ConfigSwitches.useGregtechTextures) {
            return Mods.GTPlusPlus.ID + ":item" + this.componentType.getComponent();
        }
        String metType = "9j4852jyo3rjmh3owlhw9oe";
        if (this.componentMaterial != null && (u = this.componentMaterial.getTextureSet()) != null) {
            metType = u.mSetName;
        }
        metType = metType.equals("9j4852jyo3rjmh3owlhw9oe") ? "METALLIC" : metType;
        return Mods.GregTech.ID + ":materialicons/" + metType + "/" + this.componentType.getOreDictName();
    }
}

