/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.handler;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import gregtech.api.enums.Mods;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.network.handler.AbstractClientMessageHandler;
import gtPlusPlus.core.network.packet.AbstractPacket;
import gtPlusPlus.core.network.packet.Packet_VolumetricFlaskGui;
import gtPlusPlus.core.network.packet.Packet_VolumetricFlaskGui2;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class PacketHandler {
    private static byte packetId = 0;
    private static final SimpleNetworkWrapper INSTANCE = NetworkRegistry.INSTANCE.newSimpleChannel(Mods.GTPlusPlus.ID);

    public static final void init() {
        PacketHandler.registerMessage(Packet_VolumetricFlaskGui.class, Packet_VolumetricFlaskGui.class);
        PacketHandler.registerMessage(Packet_VolumetricFlaskGui2.class, Packet_VolumetricFlaskGui2.class);
    }

    private static final void registerMessage(Class handlerClass, Class messageClass) {
        Side side = AbstractClientMessageHandler.class.isAssignableFrom(handlerClass) ? Side.CLIENT : Side.SERVER;
        PacketHandler.registerMessage(handlerClass, messageClass, side);
    }

    private static final void registerMessage(Class handlerClass, Class messageClass, Side side) {
        AbstractPacket aPacket;
        byte by = packetId;
        packetId = (byte)(by + 1);
        INSTANCE.registerMessage(handlerClass, messageClass, (int)by, side);
        if (AbstractPacket.class.isInstance(messageClass.getClass()) && (aPacket = (AbstractPacket)ReflectionUtils.createNewInstanceFromConstructor(ReflectionUtils.getConstructor(messageClass, new Class[0]), new Object[0])) != null) {
            Logger.INFO("Registered Packet: " + aPacket.getPacketName());
        }
    }

    public static final void sendTo(IMessage message, EntityPlayerMP player) {
        INSTANCE.sendTo(message, player);
    }

    public static final void sendToAllAround(IMessage message, NetworkRegistry.TargetPoint point) {
        INSTANCE.sendToAllAround(message, point);
    }

    public static final void sendToAllAround(IMessage message, int dimension, double x, double y, double z, double range) {
        PacketHandler.sendToAllAround(message, new NetworkRegistry.TargetPoint(dimension, x, y, z, range));
    }

    public static final void sendToAllAround(IMessage message, EntityPlayer player, double range) {
        PacketHandler.sendToAllAround(message, player.field_70170_p.field_73011_w.field_76574_g, player.field_70165_t, player.field_70163_u, player.field_70161_v, range);
    }

    public static final void sendToDimension(IMessage message, int dimensionId) {
        INSTANCE.sendToDimension(message, dimensionId);
    }

    public static final void sendToServer(IMessage message) {
        INSTANCE.sendToServer(message);
    }
}

