/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.util.FishPondFakeRecipe;
import gregtech.api.util.GTPP_Recipe;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.SemiFluidFuelHandler;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.chunkloading.GTPP_ChunkManager;
import gtPlusPlus.core.commands.CommandDebugChunks;
import gtPlusPlus.core.commands.CommandEnableDebugWhileRunning;
import gtPlusPlus.core.commands.CommandMath;
import gtPlusPlus.core.common.CommonProxy;
import gtPlusPlus.core.config.ConfigHandler;
import gtPlusPlus.core.handler.BookHandler;
import gtPlusPlus.core.handler.MobMentality;
import gtPlusPlus.core.handler.PacketHandler;
import gtPlusPlus.core.handler.Recipes.RegistrationHandler;
import gtPlusPlus.core.handler.events.LoginEventHandler;
import gtPlusPlus.core.handler.events.MissingMappingsEvent;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.data.LocaleUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.nei.NEI_IMC_Sender;
import gtPlusPlus.plugin.manager.Core_Manager;
import gtPlusPlus.xmod.gregtech.common.Meta_GT_Proxy;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtTools;
import gtPlusPlus.xmod.gregtech.loaders.RecipeGen_BlastSmelterGT_GTNH;
import gtPlusPlus.xmod.gregtech.loaders.RecipeGen_MultisUsingFluidInsteadOfCells;
import gtPlusPlus.xmod.thaumcraft.commands.CommandDumpAspects;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.item.Item;
import net.minecraft.launchwrapper.Launch;

@IFMLLoadingPlugin.MCVersion(value="1.7.10")
@Mod(modid="miscutils", name="GT++", version="1.10.11", dependencies="required-after:Forge; after:TConstruct; after:PlayerAPI; after:dreamcraft; after:IC2; required-after:gregtech; after:Forestry; after:MagicBees; after:CoFHCore; after:Railcraft; after:CompactWindmills; after:ForbiddenMagic; after:ExtraUtilities; after:Thaumcraft; after:EnderIO; after:tectech; after:OpenBlocks; after:IC2NuclearControl; after:TGregworks; after:StevesCarts; required-after:gtnhlib@[0.0.10,);")
public class GTplusplus
implements ActionListener {
    public static INIT_PHASE CURRENT_LOAD_PHASE = INIT_PHASE.SUPER;
    @Mod.Instance(value="miscutils")
    public static GTplusplus instance;
    @SidedProxy(clientSide="gtPlusPlus.core.proxy.ClientProxy", serverSide="gtPlusPlus.core.proxy.ServerProxy")
    public static CommonProxy proxy;
    private static final HashMap<String, Item> sMissingItemMappings;
    private static final HashMap<String, Block> sMissingBlockMappings;

    @SideOnly(value=Side.CLIENT)
    public static void loadTextures() {
        Logger.INFO("Loading some textures on the client.");
        Logger.WARNING("Processing texture: " + TexturesGtTools.ANGLE_GRINDER.getTextureFile().func_110623_a());
        Logger.WARNING("Processing texture: " + TexturesGtTools.ELECTRIC_SNIPS.getTextureFile().func_110623_a());
        Logger.WARNING("Processing texture: " + TexturesGtTools.ELECTRIC_LIGHTER.getTextureFile().func_110623_a());
        Logger.WARNING("Processing texture: " + TexturesGtTools.ELECTRIC_BUTCHER_KNIFE.getTextureFile().func_110623_a());
        Logger.WARNING("Processing texture: " + TexturesGtBlock.Casing_Machine_Dimensional.getTextureFile().func_110623_a());
    }

    public GTplusplus() {
        INIT_PHASE.SUPER.setPhaseActive(true);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        INIT_PHASE.PRE_INIT.setPhaseActive(true);
        Core_Manager.veryEarlyInit();
        PacketHandler.init();
        if (!Utils.isServer()) {
            CORE.ConfigSwitches.enableCustomCapes = true;
        }
        GTplusplus.setupMaterialBlacklist();
        ConfigHandler.handleConfigFile(event);
        CORE.DEVENV = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
        Utils.registerEvent(new LoginEventHandler());
        Utils.registerEvent(new MissingMappingsEvent());
        Utils.registerEvent(new MobMentality());
        Logger.INFO("Login Handler Initialized");
        proxy.preInit(event);
        Logger.INFO("Setting up our own GT_Proxy.");
        Meta_GT_Proxy.preInit();
        Core_Manager.preInit();
        GTPP_ChunkManager.init();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        INIT_PHASE.INIT.setPhaseActive(true);
        proxy.init(event);
        proxy.registerNetworkStuff();
        Meta_GT_Proxy.init();
        Core_Manager.init();
        NEI_IMC_Sender.IMCSender();
        if (CORE.ConfigSwitches.dumpItemAndBlockData) {
            LocaleUtils.generateFakeLocaleFile();
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        INIT_PHASE.POST_INIT.setPhaseActive(true);
        proxy.postInit(event);
        BookHandler.runLater();
        Meta_GT_Proxy.postInit();
        Core_Manager.postInit();
        Logger.INFO("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        Logger.INFO("| Recipes succesfully Loaded: " + RegistrationHandler.recipesSuccess + " | Failed: " + RegistrationHandler.recipesFailed + " |");
        Logger.INFO("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        Logger.INFO("Finally, we are finished. Have some cripsy bacon as a reward.");
        if (CORE.DEVENV) {
            int i;
            for (i = 750; i < 1000; ++i) {
                if (GregTech_API.METATILEENTITIES[i] != null) continue;
                Logger.INFO("MetaID " + i + " is free.");
            }
            for (i = 30000; i < 32000; ++i) {
                if (GregTech_API.METATILEENTITIES[i] != null) continue;
                Logger.INFO("MetaID " + i + " is free.");
            }
        }
    }

    @Mod.EventHandler
    public synchronized void serverStarting(FMLServerStartingEvent event) {
        INIT_PHASE.SERVER_START.setPhaseActive(true);
        event.registerServerCommand((ICommand)new CommandMath());
        event.registerServerCommand((ICommand)new CommandEnableDebugWhileRunning());
        event.registerServerCommand((ICommand)new CommandDebugChunks());
        if (Mods.Thaumcraft.isModLoaded()) {
            event.registerServerCommand((ICommand)new CommandDumpAspects());
        }
        Core_Manager.serverStart();
        INIT_PHASE.STARTED.setPhaseActive(true);
    }

    @Mod.EventHandler
    public synchronized void serverStopping(FMLServerStoppingEvent event) {
        Core_Manager.serverStop();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
    }

    @Mod.EventHandler
    public void onLoadComplete(FMLLoadCompleteEvent event) {
        proxy.onLoadComplete(event);
        this.generateGregtechRecipeMaps();
    }

    protected void generateGregtechRecipeMaps() {
        int[] mValidCount = new int[]{0, 0, 0};
        int[] mInvalidCount = new int[]{0, 0, 0, 0, 0, 0, 0};
        int[] mOriginalCount = new int[]{0, 0, 0};
        RecipeGen_BlastSmelterGT_GTNH.generateGTNHBlastSmelterRecipesFromEBFList();
        FishPondFakeRecipe.generateFishPondRecipes();
        SemiFluidFuelHandler.generateFuels();
        mInvalidCount[0] = RecipeGen_MultisUsingFluidInsteadOfCells.generateRecipesNotUsingCells(GT_Recipe.GT_Recipe_Map.sCentrifugeRecipes, GTPP_Recipe.GTPP_Recipe_Map.sMultiblockCentrifugeRecipes_GT);
        mInvalidCount[1] = RecipeGen_MultisUsingFluidInsteadOfCells.generateRecipesNotUsingCells(GT_Recipe.GT_Recipe_Map.sElectrolyzerRecipes, GTPP_Recipe.GTPP_Recipe_Map.sMultiblockElectrolyzerRecipes_GT);
        mInvalidCount[2] = RecipeGen_MultisUsingFluidInsteadOfCells.generateRecipesNotUsingCells(GT_Recipe.GT_Recipe_Map.sVacuumRecipes, GTPP_Recipe.GTPP_Recipe_Map.sAdvFreezerRecipes_GT);
        mInvalidCount[3] = RecipeGen_MultisUsingFluidInsteadOfCells.generateRecipesNotUsingCells(GT_Recipe.GT_Recipe_Map.sMixerRecipes, GTPP_Recipe.GTPP_Recipe_Map.sMultiblockMixerRecipes_GT);
        mInvalidCount[4] = RecipeGen_MultisUsingFluidInsteadOfCells.generateRecipesNotUsingCells(GTPP_Recipe.GTPP_Recipe_Map.sChemicalDehydratorRecipes, GTPP_Recipe.GTPP_Recipe_Map.sMultiblockChemicalDehydratorRecipes);
        mInvalidCount[5] = RecipeGen_MultisUsingFluidInsteadOfCells.generateRecipesNotUsingCells(GTPP_Recipe.GTPP_Recipe_Map.sColdTrapRecipes, GTPP_Recipe.GTPP_Recipe_Map.sNuclearSaltProcessingPlantRecipes);
        mInvalidCount[6] = RecipeGen_MultisUsingFluidInsteadOfCells.generateRecipesNotUsingCells(GTPP_Recipe.GTPP_Recipe_Map.sReactorProcessingUnitRecipes, GTPP_Recipe.GTPP_Recipe_Map.sNuclearSaltProcessingPlantRecipes);
    }

    protected void dumpGtRecipeMap(GT_Recipe.GT_Recipe_Map r) {
        Collection x = r.mRecipeList;
        Logger.INFO("Dumping " + r.mUnlocalizedName + " Recipes for Debug.");
        for (GT_Recipe newBo : x) {
            Logger.INFO("========================");
            Logger.INFO("Dumping Input: " + ItemUtils.getArrayStackNames(newBo.mInputs));
            Logger.INFO("Dumping Inputs " + ItemUtils.getFluidArrayStackNames(newBo.mFluidInputs));
            Logger.INFO("Dumping Duration: " + newBo.mDuration);
            Logger.INFO("Dumping EU/t: " + newBo.mEUt);
            Logger.INFO("Dumping Output: " + ItemUtils.getArrayStackNames(newBo.mOutputs));
            Logger.INFO("Dumping Output: " + ItemUtils.getFluidArrayStackNames(newBo.mFluidOutputs));
            Logger.INFO("========================");
        }
    }

    private static final boolean setupMaterialBlacklist() {
        Material.invalidMaterials.put(Materials._NULL);
        Material.invalidMaterials.put(Materials.Clay);
        Material.invalidMaterials.put(Materials.Phosphorus);
        Material.invalidMaterials.put(Materials.Steel);
        Material.invalidMaterials.put(Materials.Bronze);
        Material.invalidMaterials.put(Materials.Hydrogen);
        Material.invalidMaterials.put(Materials.InfusedAir);
        Material.invalidMaterials.put(Materials.InfusedEarth);
        Material.invalidMaterials.put(Materials.InfusedFire);
        Material.invalidMaterials.put(Materials.InfusedWater);
        Material.invalidMaterials.put(Materials.SoulSand);
        Material.invalidMaterials.put(Materials.EnderPearl);
        Material.invalidMaterials.put(Materials.EnderEye);
        Material.invalidMaterials.put(Materials.Redstone);
        Material.invalidMaterials.put(Materials.Glowstone);
        Material.invalidMaterials.put(Materials.Soularium);
        Material.invalidMaterials.put(Materials.PhasedIron);
        return Material.invalidMaterials.size() > 0;
    }

    private static void processMissingMappings() {
        sMissingItemMappings.put("miscutils:Ammonium", GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)"itemCellAmmonium"));
        sMissingItemMappings.put("miscutils:Hydroxide", GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)"itemCellHydroxide"));
        sMissingItemMappings.put("miscutils:BerylliumHydroxide", GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)"itemCellmiscutils:BerylliumHydroxide"));
        sMissingItemMappings.put("miscutils:Bromine", GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)"itemCellBromine"));
        sMissingItemMappings.put("miscutils:Krypton", GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)"itemCellKrypton"));
        sMissingItemMappings.put("miscutils:itemCellZirconiumTetrafluoride", GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)"ZirconiumTetrafluoride"));
        sMissingItemMappings.put("miscutils:Li2BeF4", GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)"itemCellLithiumTetrafluoroberyllate"));
        sMissingBlockMappings.put("miscutils:oreCryolite", GameRegistry.findBlock((String)Mods.GTPlusPlus.ID, (String)"oreCryoliteF"));
        sMissingItemMappings.put("miscutils:itemDustTinyCryolite", GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)"itemDustTinyCryoliteF"));
        sMissingItemMappings.put("miscutils:itemDustSmallCryolite", GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)"itemDustSmallCryoliteF"));
        sMissingItemMappings.put("miscutils:itemDustCryolite", GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)"itemDustCryoliteF"));
        sMissingItemMappings.put("miscutils:dustPureCryolite", GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)"dustPureCryoliteF"));
        sMissingItemMappings.put("miscutils:dustImpureCryolite", GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)"dustImpureCryoliteF"));
        sMissingItemMappings.put("miscutils:crushedCryolite", GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)"crushedCryoliteF"));
        sMissingItemMappings.put("miscutils:crushedPurifiedCryolite", GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)"crushedPurifiedCryoliteF"));
        sMissingItemMappings.put("miscutils:crushedCentrifugedCryolite", GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)"crushedCentrifugedCryoliteF"));
        sMissingItemMappings.put("miscutils:oreCryolite", GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)"oreCryoliteF"));
        sMissingBlockMappings.put("miscutils:oreFluorite", GameRegistry.findBlock((String)Mods.GTPlusPlus.ID, (String)"oreFluoriteF"));
        sMissingItemMappings.put("miscutils:itemDustTinyFluorite", GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)"itemDustTinyFluoriteF"));
        sMissingItemMappings.put("miscutils:itemDustSmallFluorite", GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)"itemDustSmallFluoriteF"));
        sMissingItemMappings.put("miscutils:itemDustFluorite", GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)"itemDustFluoriteF"));
        sMissingItemMappings.put("miscutils:dustPureFluorite", GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)"dustPureFluoriteF"));
        sMissingItemMappings.put("miscutils:dustImpureFluorite", GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)"dustImpureFluoriteF"));
        sMissingItemMappings.put("miscutils:crushedFluorite", GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)"crushedFluoriteF"));
        sMissingItemMappings.put("miscutils:crushedPurifiedFluorite", GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)"crushedPurifiedFluoriteF"));
        sMissingItemMappings.put("miscutils:crushedCentrifugedFluorite", GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)"crushedCentrifugedFluoriteF"));
        sMissingItemMappings.put("miscutils:oreFluorite", GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)"oreFluoriteF"));
    }

    @Mod.EventHandler
    public void missingMapping(FMLMissingMappingsEvent event) {
        GTplusplus.processMissingMappings();
        for (FMLMissingMappingsEvent.MissingMapping mapping : event.getAll()) {
            Item aReplacement;
            if (mapping.name.startsWith("Australia:")) {
                mapping.ignore();
                continue;
            }
            if (mapping.type == GameRegistry.Type.ITEM) {
                aReplacement = sMissingItemMappings.get(mapping.name);
                if (aReplacement == null) continue;
                GTplusplus.remap(aReplacement, mapping);
                continue;
            }
            if (mapping.type != GameRegistry.Type.BLOCK || (aReplacement = sMissingBlockMappings.get(mapping.name)) == null) continue;
            GTplusplus.remap((Block)aReplacement, mapping);
        }
    }

    private static void remap(Item item, FMLMissingMappingsEvent.MissingMapping mapping) {
        mapping.remap(item);
        Logger.INFO("Remapping item " + mapping.name + " to " + Mods.GTPlusPlus.ID + ":" + item.func_77658_a());
    }

    private static void remap(Block block, FMLMissingMappingsEvent.MissingMapping mapping) {
        mapping.remap(block);
        Logger.INFO("Remapping block " + mapping.name + " to " + Mods.GTPlusPlus.ID + ":" + block.func_149739_a());
    }

    static {
        sMissingItemMappings = new HashMap();
        sMissingBlockMappings = new HashMap();
    }

    public static enum INIT_PHASE {
        SUPER(null),
        PRE_INIT(SUPER),
        INIT(PRE_INIT),
        POST_INIT(INIT),
        SERVER_START(POST_INIT),
        STARTED(SERVER_START);

        protected boolean mIsPhaseActive = false;
        private final INIT_PHASE mPrev;

        private INIT_PHASE(INIT_PHASE aPreviousPhase) {
            this.mPrev = aPreviousPhase;
        }

        public final synchronized boolean isPhaseActive() {
            return this.mIsPhaseActive;
        }

        public final synchronized void setPhaseActive(boolean aIsPhaseActive) {
            if (this.mPrev != null && this.mPrev.isPhaseActive()) {
                this.mPrev.setPhaseActive(false);
            }
            this.mIsPhaseActive = aIsPhaseActive;
            if (CURRENT_LOAD_PHASE != this) {
                CURRENT_LOAD_PHASE = this;
            }
        }
    }
}

