/*
 * Decompiled with CFR 0.152.
 */
package com.kuba6000.mobsinfo.nei;

import atomicstryker.infernalmobs.common.InfernalMobsCore;
import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.IRecipeHandler;
import codechicken.nei.recipe.IUsageHandler;
import codechicken.nei.recipe.RecipeCatalysts;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.kuba6000.mobsinfo.MobsInfo;
import com.kuba6000.mobsinfo.api.helper.TranslationHelper;
import com.kuba6000.mobsinfo.api.utils.FastRandom;
import com.kuba6000.mobsinfo.config.Config;
import com.kuba6000.mobsinfo.mixin.InfernalMobs.InfernalMobsCoreAccessor;
import com.kuba6000.mobsinfo.nei.MobHandler;
import com.kuba6000.mobsinfo.nei.NEI_Config;
import cpw.mods.fml.common.event.FMLInterModComms;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;

public class MobHandlerInfernal
extends TemplateRecipeHandler {
    private static final Logger LOG = LogManager.getLogger((String)"mobsinfo[Mob Handler - Infernal drops]");
    private static InfernalRecipe recipe = null;
    private static final int itemsPerRow = 8;
    private static final int itemXShift = 18;
    private static final int itemYShift = 18;
    private static final int nextRowYShift = 35;
    private static final int itemsYStart = 80;
    public static int cycleTicksStatic = Math.abs((int)System.currentTimeMillis());

    public MobHandlerInfernal() {
        if (!NEI_Config.isAdded) {
            FMLInterModComms.sendRuntimeMessage((Object)MobsInfo.instance, (String)"NEIPlugins", (String)"register-crafting-handler", (String)("MobsInfo@" + this.getRecipeName() + "@" + this.getOverlayIdentifier()));
            GuiCraftingRecipe.craftinghandlers.add(this);
            GuiUsageRecipe.usagehandlers.add(this);
        }
        if (recipe == null) {
            recipe = new InfernalRecipe();
        }
    }

    public TemplateRecipeHandler newInstance() {
        return new MobHandlerInfernal();
    }

    public String getOverlayIdentifier() {
        return "mobsinfo.mobhandlerinfernal";
    }

    public String getGuiTexture() {
        return "mobsinfo:textures/gui/MobHandlerInfernal.png";
    }

    public String getRecipeName() {
        return "Infernal Drops";
    }

    public IUsageHandler getUsageAndCatalystHandler(String inputId, Object ... ingredients) {
        ItemStack candidate;
        TemplateRecipeHandler handler;
        if (!Config.Compatibility.enableMobHandlerInfernal) {
            return this.newInstance();
        }
        if (inputId.equals("item") && RecipeCatalysts.containsCatalyst((IRecipeHandler)(handler = this.newInstance()), (ItemStack)(candidate = (ItemStack)ingredients[0]))) {
            handler.loadCraftingRecipes(this.getOverlayIdentifier(), new Object[]{null});
            return handler;
        }
        return this.getUsageHandler(inputId, ingredients);
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (!Config.Compatibility.enableMobHandlerInfernal) {
            return;
        }
        if (outputId.equals(this.getOverlayIdentifier())) {
            this.arecipes.add(recipe);
            return;
        }
        super.loadCraftingRecipes(outputId, results);
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (!Config.Compatibility.enableMobHandlerInfernal) {
            return;
        }
        if (recipe.contains(MobHandlerInfernal.recipe.all, result)) {
            this.arecipes.add(recipe);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        if (!Config.Compatibility.enableMobHandlerInfernal) {
            return;
        }
        if (MobHandler.isUsageInfernalMob(ingredient)) {
            this.arecipes.add(recipe);
        }
    }

    public void onUpdate() {
        ++cycleTicksStatic;
    }

    public void drawBackground(int recipeID) {
        int i;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)0, (int)0, (int)168, (int)192);
        int x = 6;
        int y = 91;
        int yshift = 35;
        if (MobHandlerInfernal.recipe.eliteCount > 0) {
            for (i = 0; i < (MobHandlerInfernal.recipe.eliteCount - 1) / 8 + 1; ++i) {
                GuiDraw.drawTexturedModalRect((int)x, (int)(y + 18 * i), (int)0, (int)192, (int)144, (int)18);
                if (i <= 0) continue;
                GuiDraw.drawTexturedModalRect((int)x, (int)(y + (18 * i - 1)), (int)0, (int)193, (int)144, (int)2);
            }
            y += yshift + (MobHandlerInfernal.recipe.eliteCount - 1) / 8 * 18;
        }
        if (MobHandlerInfernal.recipe.ultraCount > 0) {
            for (i = 0; i < (MobHandlerInfernal.recipe.ultraCount - 1) / 8 + 1; ++i) {
                GuiDraw.drawTexturedModalRect((int)x, (int)(y + 18 * i), (int)0, (int)192, (int)144, (int)18);
                if (i <= 0) continue;
                GuiDraw.drawTexturedModalRect((int)x, (int)(y + (18 * i - 1)), (int)0, (int)193, (int)144, (int)2);
            }
            y += yshift + (MobHandlerInfernal.recipe.ultraCount - 1) / 8 * 18;
        }
        if (MobHandlerInfernal.recipe.infernoCount > 0) {
            for (i = 0; i < (MobHandlerInfernal.recipe.infernoCount - 1) / 8 + 1; ++i) {
                GuiDraw.drawTexturedModalRect((int)x, (int)(y + 18 * i), (int)0, (int)192, (int)144, (int)18);
                if (i <= 0) continue;
                GuiDraw.drawTexturedModalRect((int)x, (int)(y + (18 * i - 1)), (int)0, (int)193, (int)144, (int)2);
            }
        }
    }

    public void drawForeground(int recipeID) {
        int y = 0;
        int yshift = 10;
        int x = 7;
        GuiDraw.drawString((String)Translations.TITLE.get(), (int)x, (int)(y += yshift), (int)-11184811, (boolean)false);
        GuiDraw.drawString((String)Translations.FORMAT.get(), (int)x, (int)(y += yshift), (int)-11184811, (boolean)false);
        GuiDraw.drawString((String)Translations.FORMAT_1.get(), (int)x, (int)(y += yshift), (int)-11184811, (boolean)false);
        GuiDraw.drawString((String)Translations.FORMAT_2.get(), (int)x, (int)(y += yshift), (int)-11184811, (boolean)false);
        GuiDraw.drawString((String)Translations.FORMAT_3.get(), (int)x, (int)(y += yshift), (int)-11184811, (boolean)false);
        GuiDraw.drawString((String)Translations.FORMAT_4.get(), (int)(x + 20), (int)(y += yshift), (int)-11184811, (boolean)false);
        x = 6;
        y = 80;
        yshift = 35;
        if (MobHandlerInfernal.recipe.eliteCount > 0) {
            GuiDraw.drawString((String)Translations.ELITE.get(MobHandlerInfernal.recipe.eliteChance * 100.0, 100.0), (int)x, (int)y, (int)-11184811, (boolean)false);
            y += yshift + (MobHandlerInfernal.recipe.eliteCount - 1) / 8 * 18;
        }
        if (MobHandlerInfernal.recipe.ultraCount > 0) {
            GuiDraw.drawString((String)Translations.ULTRA.get(MobHandlerInfernal.recipe.ultraChance * MobHandlerInfernal.recipe.eliteChance * 100.0, MobHandlerInfernal.recipe.ultraChance * 100.0), (int)x, (int)y, (int)-11184811, (boolean)false);
            y += yshift + (MobHandlerInfernal.recipe.ultraCount - 1) / 8 * 18;
        }
        if (MobHandlerInfernal.recipe.infernoCount > 0) {
            GuiDraw.drawString((String)Translations.INFERNO.get(MobHandlerInfernal.recipe.infernoChance * MobHandlerInfernal.recipe.ultraChance * MobHandlerInfernal.recipe.eliteChance * 100.0, MobHandlerInfernal.recipe.infernoChance * MobHandlerInfernal.recipe.ultraChance * 100.0), (int)x, (int)y, (int)-11184811, (boolean)false);
        }
    }

    public List<String> handleItemTooltip(GuiRecipe<?> gui, ItemStack stack, List<String> currenttip, int recipeID) {
        InfernalPositionedStack pstack = MobHandlerInfernal.recipe.all.stream().filter(f -> f.item == stack).findFirst().orElse(null);
        if (pstack != null) {
            pstack.handleTooltip(currenttip);
        }
        return currenttip;
    }

    private class InfernalRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public final int eliteCount;
        public final int ultraCount;
        public final int infernoCount;
        public final double eliteChance;
        public final double ultraChance;
        public final double infernoChance;
        final List<PositionedStack> all;
        final List<PositionedStack> elite;
        final List<PositionedStack> ultra;
        final List<PositionedStack> inferno;

        public InfernalRecipe() {
            int xorigin;
            super((TemplateRecipeHandler)MobHandlerInfernal.this);
            InfernalMobsCoreAccessor infernalMobsCore = (InfernalMobsCoreAccessor)InfernalMobsCore.instance();
            this.eliteChance = 1.0 / (double)infernalMobsCore.getEliteRarity();
            this.ultraChance = 1.0 / (double)infernalMobsCore.getUltraRarity();
            this.infernoChance = 1.0 / (double)infernalMobsCore.getInfernoRarity();
            int xoffset = xorigin = 7;
            int yoffset = 92;
            ArrayList<ItemStack> eliteStacks = infernalMobsCore.getDropIdListElite();
            this.eliteCount = eliteStacks.size();
            this.elite = new ArrayList<PositionedStack>();
            Iterator iterator = eliteStacks.iterator();
            while (iterator.hasNext()) {
                ItemStack eliteStack = (ItemStack)iterator.next();
                this.elite.add(new InfernalPositionedStack(eliteStack.func_77946_l(), xoffset, yoffset, this.eliteChance / (double)this.eliteCount, 1.0 / (double)this.eliteCount));
                if ((xoffset += 18) < xorigin + 144 || !iterator.hasNext()) continue;
                xoffset = xorigin;
                yoffset += 18;
            }
            xoffset = xorigin;
            yoffset += 35;
            ArrayList<ItemStack> ultraStacks = infernalMobsCore.getDropIdListUltra();
            this.ultraCount = ultraStacks.size();
            this.ultra = new ArrayList<PositionedStack>();
            Iterator iterator2 = ultraStacks.iterator();
            while (iterator2.hasNext()) {
                ItemStack ultraStack = (ItemStack)iterator2.next();
                this.ultra.add(new InfernalPositionedStack(ultraStack.func_77946_l(), xoffset, yoffset, this.ultraChance * this.eliteChance / (double)this.ultraCount, this.ultraChance / (double)this.ultraCount));
                if ((xoffset += 18) < xorigin + 144 || !iterator2.hasNext()) continue;
                xoffset = xorigin;
                yoffset += 18;
            }
            xoffset = xorigin;
            yoffset += 35;
            ArrayList<ItemStack> infernoStacks = infernalMobsCore.getDropIdListInfernal();
            this.infernoCount = infernoStacks.size();
            this.inferno = new ArrayList<PositionedStack>();
            Iterator iterator3 = infernoStacks.iterator();
            while (iterator3.hasNext()) {
                ItemStack infernoStack = (ItemStack)iterator3.next();
                this.inferno.add(new InfernalPositionedStack(infernoStack.func_77946_l(), xoffset, yoffset, this.infernoChance * this.ultraChance * this.eliteChance / (double)this.infernoCount, this.infernoChance * this.ultraChance / (double)this.infernoCount));
                if ((xoffset += 18) < xorigin + 144 || !iterator3.hasNext()) continue;
                xoffset = xorigin;
                yoffset += 18;
            }
            this.all = new ArrayList<PositionedStack>();
            this.all.addAll(this.elite);
            this.all.addAll(this.ultra);
            this.all.addAll(this.inferno);
        }

        public PositionedStack getResult() {
            return null;
        }

        public List<PositionedStack> getOtherStacks() {
            if (cycleTicksStatic % 10 == 0) {
                this.all.forEach(p -> p.setPermutationToRender(0));
            }
            return this.all;
        }
    }

    private static class InfernalPositionedStack
    extends PositionedStack {
        private final Random rand;
        private final double chance;
        private final double chanceAlways;

        public InfernalPositionedStack(ItemStack stack, int x, int y, double chance, double chanceAlways) {
            super((Object)stack, x, y, false);
            this.chance = chance;
            this.chanceAlways = chanceAlways;
            this.rand = new FastRandom();
            this.setPermutationToRender(0);
        }

        public void handleTooltip(List<String> currenttip) {
            currenttip.addAll(Arrays.asList(Translations.TOOLTIP_CHANCE.get(this.chance * 100.0), Translations.TOOLTIP_CHANCE_ALWAYS.get(this.chanceAlways * 100.0)));
        }

        public void setPermutationToRender(int index) {
            if (this.rand == null) {
                return;
            }
            if (this.item == null) {
                this.item = this.items[0].func_77946_l();
            }
            if (this.item.func_77973_b() instanceof ItemEnchantedBook) {
                this.item = ((ItemEnchantedBook)this.item.func_77973_b()).func_92114_b((Random)this.rand).field_76297_b;
            }
            if (this.item.func_77942_o()) {
                this.item.func_77978_p().func_82580_o("ench");
            }
            ((InfernalMobsCoreAccessor)InfernalMobsCore.instance()).callEnchantRandomly(this.rand, this.item, this.item.func_77973_b().func_77619_b(), 5);
        }
    }

    static enum Translations {
        TITLE,
        FORMAT,
        FORMAT_1,
        FORMAT_2,
        FORMAT_3,
        FORMAT_4,
        ELITE,
        ULTRA,
        INFERNO,
        TOOLTIP_CHANCE,
        TOOLTIP_CHANCE_ALWAYS;

        final String key = "mobsinfo.mobhandlerinfernal." + this.name().toLowerCase();

        public String get() {
            return StatCollector.func_74838_a((String)this.key);
        }

        public String get(Object ... args) {
            return TranslationHelper.translateFormattedFixed(this.key, args);
        }

        public String getKey() {
            return this.key;
        }

        public String toString() {
            return this.get();
        }
    }
}

