/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.util;

import com.github.bartimaeusnek.bartworks.API.BioVatLogicAdder;
import com.github.bartimaeusnek.bartworks.API.BorosilicateGlass;
import com.github.bartimaeusnek.bartworks.MainMod;
import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.structure.AutoPlaceEnvironment;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OreDictNames;
import gregtech.api.enums.ToolDictNames;
import gregtech.api.interfaces.IItemContainer;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.ItemData;
import gregtech.api.objects.MaterialStack;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Shaped_Recipe;
import gregtech.api.util.GT_Utility;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.apache.commons.lang3.reflect.FieldUtils;

public class BW_Util {
    public static final int STANDART = 0;
    public static final int LOWGRAVITY = -100;
    public static final int CLEANROOM = -200;
    private static Field sBufferedRecipeList;

    public static String translateGTItemStack(ItemStack itemStack) {
        if (!GT_Utility.isStackValid((Object)itemStack)) {
            return "Not a Valid ItemStack:" + itemStack;
        }
        String ret = GT_LanguageManager.getTranslation((String)GT_LanguageManager.getTranslateableItemStackName((ItemStack)itemStack));
        if (!ret.contains("%material")) {
            return ret;
        }
        String matname = "";
        if (BW_Util.checkStackAndPrefix(itemStack)) {
            matname = GT_OreDictUnificator.getAssociation((ItemStack)itemStack).mMaterial.mMaterial.mDefaultLocalName;
        }
        return ret.replace("%material", matname);
    }

    public static void set2DCoordTo1DArray(int indexX, int indexY, int sizeY, Object value, Object[] array) {
        int index = indexX * sizeY + indexY;
        array[index] = value;
    }

    public static Object get2DCoordFrom1DArray(int indexX, int indexY, int sizeY, Object[] array) {
        int index = indexX * sizeY + indexY;
        return array[index];
    }

    public static GT_Recipe copyAndSetTierToNewRecipe(GT_Recipe recipe, byte tier) {
        byte oldTier = GT_Utility.getTier((long)recipe.mEUt);
        int newTime = recipe.mDuration;
        int newVoltage = recipe.mEUt;
        if (tier < oldTier) {
            newTime <<= oldTier - tier;
            newVoltage >>= 2 * (oldTier - tier);
        } else {
            newTime >>= tier - oldTier;
            newVoltage <<= 2 * (tier - oldTier);
        }
        recipe.mEUt = newVoltage;
        recipe.mDuration = newTime;
        return recipe;
    }

    public static String subscriptNumbers(String b) {
        char[] chars = b.toCharArray();
        char[] nu = new char[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            int n;
            switch (chars[i]) {
                case '0': {
                    n = 8320;
                    break;
                }
                case '1': {
                    n = 8321;
                    break;
                }
                case '2': {
                    n = 8322;
                    break;
                }
                case '3': {
                    n = 8323;
                    break;
                }
                case '4': {
                    n = 8324;
                    break;
                }
                case '5': {
                    n = 8325;
                    break;
                }
                case '6': {
                    n = 8326;
                    break;
                }
                case '7': {
                    n = 8327;
                    break;
                }
                case '8': {
                    n = 8328;
                    break;
                }
                case '9': {
                    n = 8329;
                    break;
                }
                default: {
                    n = chars[i];
                }
            }
            nu[i] = n;
        }
        return new String(nu);
    }

    public static String subscriptNumber(Number b) {
        char[] chars = Long.toString(b.longValue()).toCharArray();
        char[] nu = new char[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            int n;
            switch (chars[i]) {
                case '0': {
                    n = 8320;
                    break;
                }
                case '1': {
                    n = 8321;
                    break;
                }
                case '2': {
                    n = 8322;
                    break;
                }
                case '3': {
                    n = 8323;
                    break;
                }
                case '4': {
                    n = 8324;
                    break;
                }
                case '5': {
                    n = 8325;
                    break;
                }
                case '6': {
                    n = 8326;
                    break;
                }
                case '7': {
                    n = 8327;
                    break;
                }
                case '8': {
                    n = 8328;
                    break;
                }
                case '9': {
                    n = 8329;
                    break;
                }
                default: {
                    n = chars[i];
                }
            }
            nu[i] = n;
        }
        return new String(nu);
    }

    public static String superscriptNumbers(String b) {
        char[] chars = b.toCharArray();
        char[] nu = new char[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            int n;
            switch (chars[i]) {
                case '0': {
                    n = 8304;
                    break;
                }
                case '1': {
                    n = 8305;
                    break;
                }
                case '2': {
                    n = 178;
                    break;
                }
                case '3': {
                    n = 179;
                    break;
                }
                case '4': {
                    n = 8308;
                    break;
                }
                case '5': {
                    n = 8309;
                    break;
                }
                case '6': {
                    n = 8310;
                    break;
                }
                case '7': {
                    n = 8311;
                    break;
                }
                case '8': {
                    n = 8312;
                    break;
                }
                case '9': {
                    n = 8313;
                    break;
                }
                default: {
                    n = chars[i];
                }
            }
            nu[i] = n;
        }
        return new String(nu);
    }

    public static String superscriptNumber(Number b) {
        char[] chars = Long.toString(b.longValue()).toCharArray();
        char[] nu = new char[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            int n;
            switch (chars[i]) {
                case '0': {
                    n = 8304;
                    break;
                }
                case '1': {
                    n = 8305;
                    break;
                }
                case '2': {
                    n = 178;
                    break;
                }
                case '3': {
                    n = 179;
                    break;
                }
                case '4': {
                    n = 8308;
                    break;
                }
                case '5': {
                    n = 8309;
                    break;
                }
                case '6': {
                    n = 8310;
                    break;
                }
                case '7': {
                    n = 8311;
                    break;
                }
                case '8': {
                    n = 8312;
                    break;
                }
                case '9': {
                    n = 8313;
                    break;
                }
                default: {
                    n = chars[i];
                }
            }
            nu[i] = n;
        }
        return new String(nu);
    }

    public static byte specialToByte(int aSpecialValue) {
        byte special = 0;
        switch (aSpecialValue) {
            case -100: {
                special = 1;
                break;
            }
            case -200: {
                special = 2;
                break;
            }
            case -68: {
                special = 3;
                break;
            }
        }
        return special;
    }

    public static boolean addBlockToMachine(int x, int y, int z, int offsetsize, IGregTechTileEntity aBaseMetaTileEntity, Block block) {
        int xDir = aBaseMetaTileEntity.getBackFacing().offsetX * offsetsize;
        int zDir = aBaseMetaTileEntity.getBackFacing().offsetZ * offsetsize;
        return block == Blocks.field_150350_a ? aBaseMetaTileEntity.getAirOffset(xDir + x, y, zDir + z) : aBaseMetaTileEntity.getBlockOffset(xDir + x, y, zDir + z).equals(block);
    }

    public static boolean addBlockToMachine(int x, int y, int z, int offsetsize, IGregTechTileEntity aBaseMetaTileEntity, Block block, int damage) {
        byte dmg = (byte)damage;
        int xDir = aBaseMetaTileEntity.getBackFacing().offsetX * offsetsize;
        int zDir = aBaseMetaTileEntity.getBackFacing().offsetZ * offsetsize;
        return block == Blocks.field_150350_a ? aBaseMetaTileEntity.getAirOffset(xDir + x, y, zDir + z) : aBaseMetaTileEntity.getBlockOffset(xDir + x, y, zDir + z).equals(block) && aBaseMetaTileEntity.getMetaIDOffset(xDir + x, y, zDir + z) == dmg;
    }

    public static int calculateSv(Materials materials) {
        for (BioVatLogicAdder.MaterialSvPair pair : BioVatLogicAdder.RadioHatch.getMaSv()) {
            if (!pair.getMaterials().equals(materials)) continue;
            return pair.getSievert();
        }
        return (int)(materials.getProtons() == 43L ? (materials.equals(Materials.NaquadahEnriched) ? 140L : (materials.equals(Materials.Naquadria) ? 150L : (materials.equals(Materials.Naquadah) ? 130L : 43L))) : materials.getProtons());
    }

    public static ItemStack setStackSize(ItemStack stack, int size) {
        if (stack != null) {
            stack.field_77994_a = size;
        }
        return stack;
    }

    public static boolean checkStackAndPrefix(ItemStack itemStack) {
        return itemStack != null && GT_OreDictUnificator.getAssociation((ItemStack)itemStack) != null && GT_OreDictUnificator.getAssociation((ItemStack)itemStack).mPrefix != null && GT_OreDictUnificator.getAssociation((ItemStack)itemStack).mMaterial != null && GT_OreDictUnificator.getAssociation((ItemStack)itemStack).mMaterial.mMaterial != null;
    }

    public static Map<ItemStack, ItemStack[]> getInputsFromOutput(Collection<GT_Recipe> gt_recipes, ItemStack ... inputs) {
        return gt_recipes.stream().filter(ar -> Arrays.stream(inputs).anyMatch(st -> GT_Utility.areStacksEqual((ItemStack)st, (ItemStack)ar.mOutputs[0]))).collect(Collectors.toMap(k -> k.mOutputs[0], k -> k.mInputs));
    }

    public static Map<ItemStack, ItemStack[]> getAsslineInputsFromOutputs(ItemStack ... inputs) {
        return GT_Recipe.GT_Recipe_AssemblyLine.sAssemblylineRecipes.stream().filter(ar -> Arrays.stream(inputs).anyMatch(st -> GT_Utility.areStacksEqual((ItemStack)st, (ItemStack)ar.mOutput))).collect(Collectors.toMap(k -> k.mOutput, k -> k.mInputs));
    }

    public static int abstractHashGTRecipe(GT_Recipe recipe) {
        int hash = 31;
        hash += recipe.mDuration / 20 * 31;
        hash += GT_Utility.getTier((long)recipe.mEUt) * 31;
        hash += BW_Util.specialToByte(recipe.mSpecialValue) * 31;
        hash += recipe.mInputs.length * 31;
        for (ItemStack itemStack : recipe.mInputs) {
            if (itemStack == null) continue;
            hash += itemStack.field_77994_a * 31;
            hash += Item.func_150891_b((Item)itemStack.func_77973_b()) * 31;
        }
        hash += recipe.mOutputs.length * 31;
        for (ItemStack itemStack : recipe.mOutputs) {
            if (itemStack == null) continue;
            hash += itemStack.field_77994_a * 31;
            hash += Item.func_150891_b((Item)itemStack.func_77973_b()) * 31;
        }
        hash += recipe.mFluidInputs.length * 31;
        for (ItemStack itemStack : recipe.mFluidInputs) {
            if (itemStack == null) continue;
            hash += itemStack.amount * 31;
            hash += itemStack.getFluidID() * 31;
        }
        hash += recipe.mFluidOutputs.length * 31;
        for (ItemStack itemStack : recipe.mFluidOutputs) {
            if (itemStack == null) continue;
            hash += itemStack.amount * 31;
            hash += itemStack.getFluidID() * 31;
        }
        return hash;
    }

    public static <T> T[] copyAndRemoveNulls(T[] input, Class<T> clazz) {
        List ret = Arrays.stream(input).filter(Objects::nonNull).collect(Collectors.toList());
        if (ret.size() <= 0) {
            return (Object[])Array.newInstance(clazz, 0);
        }
        Object[] retArr = (Object[])Array.newInstance(clazz, ret.size());
        for (int i = 0; i < ret.size(); ++i) {
            retArr[i] = ret.get(i);
        }
        return retArr;
    }

    @Deprecated
    public static int getMachineVoltageFromTier(int tier) {
        return (int)(30.0 * Math.pow(4.0, tier - 1));
    }

    public static long getTierVoltage(int tier) {
        return BW_Util.getTierVoltage((byte)tier);
    }

    public static long getTierVoltage(byte tier) {
        return 8L << 2 * tier;
    }

    public static byte getTier(long voltage) {
        if (voltage <= 0x7FFFFFF8L) {
            return GT_Utility.getTier((long)voltage);
        }
        byte t = 0;
        while (voltage > 8L) {
            voltage >>= 2;
            t = (byte)(t + 1);
        }
        return t;
    }

    public static String getTierName(byte tier) {
        if (GT_Values.VN.length - 1 <= tier) {
            return "MAX+";
        }
        return GT_Values.VN[tier];
    }

    public static String getTierNameFromVoltage(long voltage) {
        return BW_Util.getTierName(BW_Util.getTier(voltage));
    }

    public static boolean areStacksEqualOrNull(ItemStack aStack1, ItemStack aStack2) {
        return aStack1 == null && aStack2 == null || GT_Utility.areStacksEqual((ItemStack)aStack1, (ItemStack)aStack2);
    }

    public static boolean areStacksEqualOrEachNull(ItemStack aStack1, ItemStack aStack2) {
        return aStack1 == null || aStack2 == null || GT_Utility.areStacksEqual((ItemStack)aStack1, (ItemStack)aStack2);
    }

    public static byte getByteFromRarity(EnumRarity rarity) {
        if (EnumRarity.uncommon.equals((Object)rarity)) {
            return 1;
        }
        if (EnumRarity.epic.equals((Object)rarity)) {
            return 2;
        }
        if (EnumRarity.rare.equals((Object)rarity)) {
            return 3;
        }
        return 0;
    }

    @Deprecated
    public static byte getTierFromGlasMeta(int meta) {
        byte by;
        switch (meta) {
            case 1: {
                by = 4;
                break;
            }
            case 2: 
            case 12: {
                by = 5;
                break;
            }
            case 3: {
                by = 6;
                break;
            }
            case 4: {
                by = 7;
                break;
            }
            case 5: {
                by = 8;
                break;
            }
            case 13: {
                by = 9;
                break;
            }
            case 14: {
                by = 10;
                break;
            }
            default: {
                by = 3;
            }
        }
        return by;
    }

    public static void calculateOverclockedNessMulti(@Nonnegative int aEUt, @Nonnegative int aDuration, @Nonnegative int mAmperage, @Nonnegative long maxInputVoltage, @Nonnull GT_MetaTileEntity_MultiBlockBase base) {
        BW_Util.calculateOverclockednessMultiInternal(aEUt, aDuration, mAmperage, maxInputVoltage, base, false);
    }

    public static void calculatePerfectOverclockedNessMulti(@Nonnegative int aEUt, @Nonnegative int aDuration, @Nonnegative int mAmperage, @Nonnegative long maxInputVoltage, @Nonnull GT_MetaTileEntity_MultiBlockBase base) {
        BW_Util.calculateOverclockednessMultiInternal(aEUt, aDuration, mAmperage, maxInputVoltage, base, true);
    }

    private static void calculateOverclockednessMultiInternal(@Nonnegative int aEUt, @Nonnegative int aDuration, @Nonnegative int mAmperage, @Nonnegative long maxInputVoltage, @Nonnull GT_MetaTileEntity_MultiBlockBase base, @Nonnull boolean perfectOC) {
        byte mTier = (byte)Math.max(0, GT_Utility.getTier((long)maxInputVoltage));
        if (mTier == 0) {
            long xMaxProgresstime = (long)aDuration << 1;
            if (xMaxProgresstime > 0x7FFFFFFEL) {
                base.mEUt = 0x7FFFFFFE;
                base.mMaxProgresstime = 0x7FFFFFFE;
            } else {
                base.mEUt = aEUt >> 2;
                base.mMaxProgresstime = (int)xMaxProgresstime;
            }
        } else {
            long xEUt = aEUt;
            base.mMaxProgresstime = aDuration;
            for (long tempEUt = Math.max(xEUt, GT_Values.V[1]); tempEUt <= GT_Values.V[mTier - 1] * (long)mAmperage; tempEUt <<= 2) {
                base.mMaxProgresstime = base.mMaxProgresstime >> (perfectOC ? 2 : 1);
                xEUt = base.mMaxProgresstime <= 0 ? xEUt >> 1 : xEUt << 2;
            }
            while (xEUt > maxInputVoltage && xEUt >= (long)aEUt) {
                xEUt >>= 2;
                base.mMaxProgresstime = base.mMaxProgresstime << (perfectOC ? 2 : 1);
            }
            if (xEUt < (long)aEUt) {
                xEUt <<= 2;
                base.mMaxProgresstime = base.mMaxProgresstime >> (perfectOC ? 2 : 1);
            }
            if (xEUt > 0x7FFFFFFEL) {
                base.mEUt = 0x7FFFFFFE;
                base.mMaxProgresstime = 0x7FFFFFFE;
            } else {
                base.mEUt = (int)xEUt;
                if (base.mEUt == 0) {
                    base.mEUt = 1;
                }
                if (base.mMaxProgresstime <= 0) {
                    base.mMaxProgresstime = 1;
                }
            }
        }
    }

    public static long getnominalVoltage(GT_MetaTileEntity_MultiBlockBase base) {
        long rVoltage = 0L;
        long rAmperage = 0L;
        for (GT_MetaTileEntity_Hatch_Energy tHatch : base.mEnergyHatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            rVoltage = Math.max(tHatch.getBaseMetaTileEntity().getInputVoltage(), rVoltage);
            rAmperage += tHatch.getBaseMetaTileEntity().getInputAmperage();
        }
        return rVoltage * rAmperage;
    }

    public static FluidStack[] getFluidsFromInputHatches(GT_MetaTileEntity_MultiBlockBase aBaseMetaTileEntity) {
        ArrayList<FluidStack> tmp = new ArrayList<FluidStack>();
        for (GT_MetaTileEntity_Hatch_Input fip : aBaseMetaTileEntity.mInputHatches) {
            tmp.add(fip.getFluid());
        }
        return tmp.toArray(new FluidStack[0]);
    }

    public static ItemStack[] getItemsFromInputBusses(GT_MetaTileEntity_MultiBlockBase aBaseMetaTileEntity) {
        ArrayList<ItemStack> tmp = new ArrayList<ItemStack>();
        for (GT_MetaTileEntity_Hatch_InputBus fip : aBaseMetaTileEntity.mInputBusses) {
            tmp.addAll(Arrays.asList(fip.mInventory));
        }
        return tmp.toArray(new ItemStack[0]);
    }

    public static EnumRarity getRarityFromByte(byte b) {
        EnumRarity enumRarity;
        switch (b) {
            case 1: {
                enumRarity = EnumRarity.uncommon;
                break;
            }
            case 2: {
                enumRarity = EnumRarity.rare;
                break;
            }
            case 3: {
                enumRarity = EnumRarity.epic;
                break;
            }
            default: {
                enumRarity = EnumRarity.common;
            }
        }
        return enumRarity;
    }

    public static List<Byte> getMetasFromLayer(IGregTechTileEntity aBaseMetaTileEntity, int radius, int yLevel, int height, int offset, boolean controllerLayer, boolean freeCorners, boolean insideCheck) {
        ArrayList<Byte> ret = new ArrayList<Byte>();
        int xDir = aBaseMetaTileEntity.getBackFacing().offsetX * offset;
        int zDir = aBaseMetaTileEntity.getBackFacing().offsetZ * offset;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = yLevel; y < height; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    boolean inside;
                    if (freeCorners && Math.abs(x) == radius && Math.abs(z) == radius || controllerLayer && xDir + x == 0 && zDir + z == 0) continue;
                    boolean bl = inside = Math.abs(x) < radius && Math.abs(z) != radius;
                    if (insideCheck && inside) {
                        ret.add(aBaseMetaTileEntity.getMetaIDOffset(xDir + x, y, zDir + z));
                    }
                    if (inside) continue;
                    ret.add(aBaseMetaTileEntity.getMetaIDOffset(xDir + x, y, zDir + z));
                }
            }
        }
        return ret;
    }

    public static byte getCircuitTierFromOreDictName(String name) {
        byte by;
        switch (name) {
            case "circuitPrimitive": {
                by = 0;
                break;
            }
            case "circuitBasic": {
                by = 1;
                break;
            }
            case "circuitGood": {
                by = 2;
                break;
            }
            case "circuitAdvanced": {
                by = 3;
                break;
            }
            case "circuitData": {
                by = 4;
                break;
            }
            case "circuitElite": {
                by = 5;
                break;
            }
            case "circuitMaster": {
                by = 6;
                break;
            }
            case "circuitUltimate": {
                by = 7;
                break;
            }
            case "circuitSuperconductor": {
                by = 8;
                break;
            }
            case "circuitInfinite": {
                by = 9;
                break;
            }
            case "circuitBio": {
                by = 10;
                break;
            }
            case "circuitNano": 
            case "circuitOptical": {
                by = 11;
                break;
            }
            case "circuitPiko": 
            case "circuitExotic": {
                by = 12;
                break;
            }
            case "circuitQuantum": 
            case "circuitCosmic": {
                by = 13;
                break;
            }
            case "circuitTranscendent": {
                by = 14;
                break;
            }
            default: {
                by = -1;
            }
        }
        return by;
    }

    public static byte getCircuitTierFromItemStack(ItemStack stack) {
        for (String oreName : BW_Util.getOreNames(stack)) {
            byte tier = BW_Util.getCircuitTierFromOreDictName(oreName);
            if (tier == -1) continue;
            return tier;
        }
        return -1;
    }

    public static boolean isTieredCircuit(ItemStack stack) {
        return BW_Util.getCircuitTierFromItemStack(stack) != -1;
    }

    public static List<String> getOreNames(ItemStack stack) {
        ArrayList<String> ret = new ArrayList<String>();
        for (int oreID : OreDictionary.getOreIDs((ItemStack)stack)) {
            ret.add(OreDictionary.getOreName((int)oreID));
        }
        return ret;
    }

    public static byte calculateGlassTier(@Nonnull Block block, @Nonnegative byte meta) {
        byte boroTier = BorosilicateGlass.getTier(block, meta);
        if (boroTier != -1) {
            return boroTier;
        }
        if ("blockAlloyGlass".equals(block.func_149739_a())) {
            return 4;
        }
        if (block.equals(Blocks.field_150359_w)) {
            return 3;
        }
        for (BioVatLogicAdder.BlockMetaPair B : BioVatLogicAdder.BioVatGlass.getGlassMap().keySet()) {
            if (!B.getBlock().equals(block) || !B.getaByte().equals(meta)) continue;
            return BioVatLogicAdder.BioVatGlass.getGlassMap().get(B);
        }
        if (block.func_149688_o().equals(Material.field_151592_s)) {
            return 3;
        }
        return 0;
    }

    public static <T> IStructureElement<T> ofGlassTiered(final byte mintier, final byte maxtier, final byte notset, final BiConsumer<T, Byte> setter, final Function<T, Byte> getter, final int aDots) {
        return new IStructureElement<T>(){
            private final IStructureElement<T> placementDelegate;
            {
                this.placementDelegate = BorosilicateGlass.ofBoroGlass(notset, mintier, maxtier, setter, getter);
            }

            public boolean check(T te, World world, int x, int y, int z) {
                if (world.func_147437_c(x, y, z)) {
                    return false;
                }
                byte glasstier = BW_Util.calculateGlassTier(world.func_147439_a(x, y, z), (byte)world.func_72805_g(x, y, z));
                if (glasstier == 0 || glasstier == notset || glasstier < mintier || glasstier > maxtier) {
                    return false;
                }
                if ((Byte)getter.apply(te) == notset) {
                    setter.accept(te, glasstier);
                }
                return (Byte)getter.apply(te) == glasstier;
            }

            public boolean spawnHint(T te, World world, int x, int y, int z, ItemStack itemStack) {
                StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)StructureLibAPI.getBlockHint(), (int)(aDots - 1));
                return true;
            }

            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                return this.placementDelegate.placeBlock(t, world, x, y, z, trigger);
            }

            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return this.placementDelegate.survivalPlaceBlock(t, world, x, y, z, trigger, env);
            }
        };
    }

    public static <T> IStructureElement<T> ofGlassTieredMixed(final byte mintier, final byte maxtier, final int aDots) {
        return new IStructureElement<T>(){
            private final IStructureElement<T> placementDelegate;
            {
                this.placementDelegate = BorosilicateGlass.ofBoroGlass((byte)0, mintier, maxtier, (v1, v2) -> {}, v1 -> (byte)0);
            }

            public boolean check(T te, World world, int x, int y, int z) {
                if (world.func_147437_c(x, y, z)) {
                    return false;
                }
                byte glasstier = BW_Util.calculateGlassTier(world.func_147439_a(x, y, z), (byte)world.func_72805_g(x, y, z));
                if (glasstier == 0) {
                    return false;
                }
                return glasstier >= mintier && glasstier <= maxtier;
            }

            public boolean spawnHint(T te, World world, int x, int y, int z, ItemStack itemStack) {
                StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)StructureLibAPI.getBlockHint(), (int)(aDots - 1));
                return true;
            }

            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                return this.placementDelegate.placeBlock(t, world, x, y, z, trigger);
            }

            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return this.placementDelegate.survivalPlaceBlock(t, world, x, y, z, trigger, env);
            }
        };
    }

    public static List<IRecipe> getGTBufferedRecipeList() throws SecurityException, IllegalArgumentException, IllegalAccessException {
        if (sBufferedRecipeList == null) {
            sBufferedRecipeList = FieldUtils.getDeclaredField(GT_ModHandler.class, (String)"sBufferRecipeList", (boolean)true);
        }
        if (sBufferedRecipeList == null) {
            sBufferedRecipeList = FieldUtils.getField(GT_ModHandler.class, (String)"sBufferRecipeList", (boolean)true);
        }
        return (List)sBufferedRecipeList.get(null);
    }

    public static ShapedOreRecipe createGTCraftingRecipe(ItemStack aResult, long aBitMask, Object[] aRecipe) {
        return BW_Util.createGTCraftingRecipe(aResult, new Enchantment[]{}, new int[]{}, (aBitMask & GT_ModHandler.RecipeBits.MIRRORED) != 0L, (aBitMask & GT_ModHandler.RecipeBits.BUFFERED) != 0L, (aBitMask & GT_ModHandler.RecipeBits.KEEPNBT) != 0L, (aBitMask & GT_ModHandler.RecipeBits.DISMANTLEABLE) != 0L, (aBitMask & GT_ModHandler.RecipeBits.NOT_REMOVABLE) == 0L, (aBitMask & GT_ModHandler.RecipeBits.REVERSIBLE) != 0L, (aBitMask & GT_ModHandler.RecipeBits.DELETE_ALL_OTHER_RECIPES) != 0L, (aBitMask & GT_ModHandler.RecipeBits.DELETE_ALL_OTHER_RECIPES_IF_SAME_NBT) != 0L, (aBitMask & GT_ModHandler.RecipeBits.DELETE_ALL_OTHER_SHAPED_RECIPES) != 0L, (aBitMask & GT_ModHandler.RecipeBits.DELETE_ALL_OTHER_NATIVE_RECIPES) != 0L, (aBitMask & GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS) == 0L, (aBitMask & GT_ModHandler.RecipeBits.ONLY_ADD_IF_THERE_IS_ANOTHER_RECIPE_FOR_IT) != 0L, (aBitMask & GT_ModHandler.RecipeBits.ONLY_ADD_IF_RESULT_IS_NOT_NULL) != 0L, aRecipe);
    }

    public static ShapedOreRecipe createGTCraftingRecipe(ItemStack aResult, Enchantment[] aEnchantmentsAdded, int[] aEnchantmentLevelsAdded, boolean aMirrored, boolean aBuffered, boolean aKeepNBT, boolean aDismantleable, boolean aRemovable, boolean aReversible, boolean aRemoveAllOthersWithSameOutput, boolean aRemoveAllOthersWithSameOutputIfTheyHaveSameNBT, boolean aRemoveAllOtherShapedsWithSameOutput, boolean aRemoveAllOtherNativeRecipes, boolean aCheckForCollisions, boolean aOnlyAddIfThereIsAnyRecipeOutputtingThis, boolean aOnlyAddIfResultIsNotNull, Object[] aRecipe) {
        aResult = GT_OreDictUnificator.get((boolean)true, (ItemStack)aResult);
        if (aOnlyAddIfResultIsNotNull && aResult == null) {
            return null;
        }
        if (aResult != null && Items.field_151008_G.getDamage(aResult) == Short.MAX_VALUE) {
            Items.field_151008_G.setDamage(aResult, 0);
        }
        if (aRecipe == null || aRecipe.length <= 0) {
            return null;
        }
        boolean tThereWasARecipe = false;
        for (int i = 0; i < aRecipe.length; i = (int)((byte)(i + 1))) {
            Object object = aRecipe[i];
            if (object instanceof IItemContainer) {
                IItemContainer itemContainer = (IItemContainer)object;
                aRecipe[i] = itemContainer.get(1L, new Object[0]);
                continue;
            }
            object = aRecipe[i];
            if (object instanceof Enum) {
                Enum enum_ = (Enum)object;
                aRecipe[i] = enum_.name();
                continue;
            }
            if (aRecipe[i] == null || aRecipe[i] instanceof ItemStack || aRecipe[i] instanceof ItemData || aRecipe[i] instanceof String || aRecipe[i] instanceof Character) continue;
            aRecipe[i] = aRecipe[i].toString();
        }
        try {
            int n;
            Object object;
            StringBuilder shape = new StringBuilder("");
            int idx = 0;
            if (aRecipe[idx] instanceof Boolean) {
                throw new IllegalArgumentException();
            }
            ArrayList<Object> tRecipeList = new ArrayList<Object>(Arrays.asList(aRecipe));
            while ((object = aRecipe[idx]) instanceof String) {
                String string = (String)object;
                StringBuilder s = new StringBuilder(string);
                ++idx;
                shape.append((CharSequence)s);
                while (s.length() < 3) {
                    s.append(" ");
                }
                if (s.length() > 3) {
                    throw new IllegalArgumentException();
                }
                block33: for (char c : s.toString().toCharArray()) {
                    switch (c) {
                        case 'b': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolBlade.name());
                            continue block33;
                        }
                        case 'c': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolCrowbar.name());
                            continue block33;
                        }
                        case 'd': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolScrewdriver.name());
                            continue block33;
                        }
                        case 'f': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolFile.name());
                            continue block33;
                        }
                        case 'h': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolHardHammer.name());
                            continue block33;
                        }
                        case 'i': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolSolderingIron.name());
                            continue block33;
                        }
                        case 'j': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolSolderingMetal.name());
                            continue block33;
                        }
                        case 'k': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolKnife.name());
                            continue block33;
                        }
                        case 'm': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolMortar.name());
                            continue block33;
                        }
                        case 'p': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolDrawplate.name());
                            continue block33;
                        }
                        case 'r': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolSoftHammer.name());
                            continue block33;
                        }
                        case 's': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolSaw.name());
                            continue block33;
                        }
                        case 'w': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolWrench.name());
                            continue block33;
                        }
                        case 'x': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolWireCutter.name());
                        }
                    }
                }
            }
            aRecipe = tRecipeList.toArray();
            if (aRecipe[idx] instanceof Boolean) {
                ++idx;
            }
            HashMap<Character, ItemStack> tItemStackMap = new HashMap<Character, ItemStack>();
            HashMap<Character, ItemData> tItemDataMap = new HashMap<Character, ItemData>();
            tItemStackMap.put(Character.valueOf(' '), null);
            boolean tRemoveRecipe = true;
            while (idx < aRecipe.length) {
                if (aRecipe[idx] == null || aRecipe[idx + 1] == null) {
                    if (GT_Values.D1) {
                        GT_Log.err.println("WARNING: Missing Item for shaped Recipe: " + (aResult == null ? "null" : aResult.func_82833_r()));
                        for (Object tContent : aRecipe) {
                            GT_Log.err.println(tContent);
                        }
                    }
                    return null;
                }
                Character chr = (Character)aRecipe[idx];
                Object in = aRecipe[idx + 1];
                if (in instanceof ItemStack) {
                    tItemStackMap.put(chr, GT_Utility.copy((Object[])new Object[]{in}));
                    tItemDataMap.put(chr, GT_OreDictUnificator.getItemData((ItemStack)((ItemStack)in)));
                } else if (in instanceof ItemData) {
                    Object tContent;
                    String tString = in.toString();
                    tContent = tString;
                    n = -1;
                    switch (((String)tContent).hashCode()) {
                        case 2112754735: {
                            if (!((String)tContent).equals("plankWood")) break;
                            n = 0;
                            break;
                        }
                        case 1563779444: {
                            if (!((String)tContent).equals("stoneNetherrack")) break;
                            n = 1;
                            break;
                        }
                        case -1075426848: {
                            if (!((String)tContent).equals("stoneObsidian")) break;
                            n = 2;
                            break;
                        }
                        case 316729327: {
                            if (!((String)tContent).equals("stoneEndstone")) break;
                            n = 3;
                        }
                    }
                    switch (n) {
                        case 0: {
                            tItemDataMap.put(chr, new ItemData(Materials.Wood, 3628800L, new MaterialStack[0]));
                            break;
                        }
                        case 1: {
                            tItemDataMap.put(chr, new ItemData(Materials.Netherrack, 3628800L, new MaterialStack[0]));
                            break;
                        }
                        case 2: {
                            tItemDataMap.put(chr, new ItemData(Materials.Obsidian, 3628800L, new MaterialStack[0]));
                            break;
                        }
                        case 3: {
                            tItemDataMap.put(chr, new ItemData(Materials.Endstone, 3628800L, new MaterialStack[0]));
                            break;
                        }
                        default: {
                            tItemDataMap.put(chr, (ItemData)in);
                        }
                    }
                    ItemStack tStack = GT_OreDictUnificator.getFirstOre((Object)in, (long)1L);
                    if (tStack == null) {
                        tRemoveRecipe = false;
                    } else {
                        tItemStackMap.put(chr, tStack);
                    }
                    aRecipe[idx + 1] = in.toString();
                } else if (in instanceof String) {
                    if (in.equals(OreDictNames.craftingChest.toString())) {
                        tItemDataMap.put(chr, new ItemData(Materials.Wood, 29030400L, new MaterialStack[0]));
                    } else if (in.equals(OreDictNames.craftingBook.toString())) {
                        tItemDataMap.put(chr, new ItemData(Materials.Paper, 10886400L, new MaterialStack[0]));
                    } else if (in.equals(OreDictNames.craftingPiston.toString())) {
                        tItemDataMap.put(chr, new ItemData(Materials.Stone, 14515200L, Materials.Wood, 10886400L));
                    } else if (in.equals(OreDictNames.craftingFurnace.toString())) {
                        tItemDataMap.put(chr, new ItemData(Materials.Stone, 29030400L, new MaterialStack[0]));
                    } else if (in.equals(OreDictNames.craftingIndustrialDiamond.toString())) {
                        tItemDataMap.put(chr, new ItemData(Materials.Diamond, 3628800L, new MaterialStack[0]));
                    } else if (in.equals(OreDictNames.craftingAnvil.toString())) {
                        tItemDataMap.put(chr, new ItemData(Materials.Iron, 36288000L, new MaterialStack[0]));
                    }
                    ItemStack tStack = GT_OreDictUnificator.getFirstOre((Object)in, (long)1L);
                    if (tStack == null) {
                        tRemoveRecipe = false;
                    } else {
                        tItemStackMap.put(chr, tStack);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
                idx += 2;
            }
            if (aReversible && aResult != null) {
                Object[] tData = new ItemData[9];
                int x = -1;
                char[] cArray = shape.toString().toCharArray();
                int n2 = cArray.length;
                for (n = 0; n < n2; ++n) {
                    char chr = cArray[n];
                    tData[++x] = (ItemData)tItemDataMap.get(Character.valueOf(chr));
                }
                if (GT_Utility.arrayContainsNonNull((Object[])tData)) {
                    GT_OreDictUnificator.addItemData((ItemStack)aResult, (ItemData)new ItemData((ItemData[])tData));
                }
            }
            if (aCheckForCollisions && tRemoveRecipe) {
                ItemStack[] tRecipe = new ItemStack[9];
                int x = -1;
                for (char chr : shape.toString().toCharArray()) {
                    tRecipe[++x] = (ItemStack)tItemStackMap.get(Character.valueOf(chr));
                    if (tRecipe[x] == null || Items.field_151008_G.getDamage(tRecipe[x]) != Short.MAX_VALUE) continue;
                    Items.field_151008_G.setDamage(tRecipe[x], 0);
                }
                tThereWasARecipe = GT_ModHandler.removeRecipe((ItemStack[])tRecipe) != null;
            }
        }
        catch (Throwable e) {
            e.printStackTrace(GT_Log.err);
        }
        if (aResult == null || aResult.field_77994_a <= 0) {
            return null;
        }
        if (aRemoveAllOthersWithSameOutput || aRemoveAllOthersWithSameOutputIfTheyHaveSameNBT || aRemoveAllOtherShapedsWithSameOutput || aRemoveAllOtherNativeRecipes) {
            boolean bl = tThereWasARecipe = GT_ModHandler.removeRecipeByOutput((ItemStack)aResult, (!aRemoveAllOthersWithSameOutputIfTheyHaveSameNBT ? 1 : 0) != 0, (boolean)aRemoveAllOtherShapedsWithSameOutput, (boolean)aRemoveAllOtherNativeRecipes) || tThereWasARecipe;
        }
        if (aOnlyAddIfThereIsAnyRecipeOutputtingThis && !tThereWasARecipe) {
            ArrayList tList = (ArrayList)CraftingManager.func_77594_a().func_77592_b();
            int tList_sS = tList.size();
            for (int i = 0; i < tList_sS && !tThereWasARecipe; ++i) {
                IRecipe tRecipe = (IRecipe)tList.get(i);
                if (GT_ModHandler.sSpecialRecipeClasses.contains(tRecipe.getClass().getName()) || !GT_Utility.areStacksEqual((ItemStack)GT_OreDictUnificator.get((ItemStack)tRecipe.func_77571_b()), (ItemStack)aResult, (boolean)true)) continue;
                tList.remove(i);
                --i;
                tList_sS = tList.size();
                tThereWasARecipe = true;
            }
        }
        if (Items.field_151008_G.getDamage(aResult) == Short.MAX_VALUE || Items.field_151008_G.getDamage(aResult) < 0) {
            Items.field_151008_G.setDamage(aResult, 0);
        }
        GT_Utility.updateItemStack((ItemStack)aResult);
        return new GT_Shaped_Recipe(GT_Utility.copy((Object[])new Object[]{aResult}), aDismantleable, aRemovable, aKeepNBT, aEnchantmentsAdded, aEnchantmentLevelsAdded, aRecipe).setMirrored(aMirrored);
    }

    public static void shortSleep(long nanos) {
        try {
            long end;
            long start = System.nanoTime();
            while (start + nanos >= (end = System.nanoTime())) {
            }
        }
        catch (Exception e) {
            MainMod.LOGGER.catching((Throwable)e);
        }
    }
}

