/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.system.oregen;

import com.github.bartimaeusnek.bartworks.system.material.BW_MetaGeneratedOreTE;
import com.github.bartimaeusnek.bartworks.system.material.BW_MetaGenerated_Ores;
import com.github.bartimaeusnek.bartworks.system.material.BW_MetaGenerated_SmallOres;
import com.github.bartimaeusnek.bartworks.system.material.Werkstoff;
import com.github.bartimaeusnek.bartworks.system.material.WerkstoffLoader;
import com.github.bartimaeusnek.bartworks.util.MurmurHash3;
import com.github.bartimaeusnek.bartworks.util.Pair;
import com.google.common.collect.ArrayListMultimap;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Materials;
import gregtech.api.interfaces.ISubTagContainer;
import gregtech.api.world.GT_Worldgen;
import gregtech.common.blocks.GT_TileEntity_Ores;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public abstract class BW_OreLayer
extends GT_Worldgen {
    public static final List<BW_OreLayer> sList = new ArrayList<BW_OreLayer>();
    public static final ArrayListMultimap<Short, BW_OreLayer> NEIMAP = ArrayListMultimap.create();
    private static final boolean logOregenRoss128 = false;
    public static int sWeight;
    public byte bwOres;
    public int mMinY;
    public int mWeight;
    public int mDensity;
    public int mSize;
    public int mMaxY;
    public int mPrimaryMeta;
    public int mSecondaryMeta;
    public int mBetweenMeta;
    public int mSporadicMeta;

    public abstract Block getDefaultBlockToReplace();

    public abstract int[] getDefaultDamageToReplace();

    public abstract String getDimName();

    public BW_OreLayer(String aName, boolean aDefault, int aMinY, int aMaxY, int aWeight, int aDensity, int aSize, ISubTagContainer top, ISubTagContainer bottom, ISubTagContainer between, ISubTagContainer sprinkled) {
        super(aName, sList, aDefault);
        short aBetween;
        short aSecondary;
        short aPrimary;
        this.mMinY = (short)aMinY;
        this.mMaxY = (short)aMaxY;
        this.mWeight = (short)aWeight;
        this.mDensity = (short)aDensity;
        this.mSize = (short)Math.max(1, aSize);
        if (this.mEnabled) {
            sWeight += this.mWeight;
        }
        if (top instanceof Werkstoff) {
            this.bwOres = (byte)(this.bwOres | 8);
        }
        if (bottom instanceof Werkstoff) {
            this.bwOres = (byte)(this.bwOres | 4);
        }
        if (between instanceof Werkstoff) {
            this.bwOres = (byte)(this.bwOres | 2);
        }
        if (sprinkled instanceof Werkstoff) {
            this.bwOres = (byte)(this.bwOres | 1);
        }
        short s = top instanceof Materials ? (short)((Materials)top).mMetaItemSubID : (aPrimary = top instanceof Werkstoff ? ((Werkstoff)top).getmID() : (short)0);
        short s2 = bottom instanceof Materials ? (short)((Materials)bottom).mMetaItemSubID : (aSecondary = bottom instanceof Werkstoff ? ((Werkstoff)bottom).getmID() : (short)0);
        short s3 = between instanceof Materials ? (short)((Materials)between).mMetaItemSubID : (aBetween = between instanceof Werkstoff ? ((Werkstoff)between).getmID() : (short)0);
        short aSporadic = sprinkled instanceof Materials ? (short)((Materials)sprinkled).mMetaItemSubID : (sprinkled instanceof Werkstoff ? ((Werkstoff)sprinkled).getmID() : (short)0);
        this.mPrimaryMeta = aPrimary;
        this.mSecondaryMeta = aSecondary;
        this.mBetweenMeta = aBetween;
        this.mSporadicMeta = aSporadic;
        NEIMAP.put((Object)((short)this.mPrimaryMeta), (Object)this);
        NEIMAP.put((Object)((short)this.mSecondaryMeta), (Object)this);
        NEIMAP.put((Object)((short)this.mBetweenMeta), (Object)this);
        NEIMAP.put((Object)((short)this.mSporadicMeta), (Object)this);
    }

    public List<ItemStack> getStacks() {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add((this.bwOres & 8) != 0 ? new ItemStack(WerkstoffLoader.BWOres, 1, this.mPrimaryMeta) : new ItemStack(GregTech_API.sBlockOres1, 1, this.mPrimaryMeta));
        ret.add((this.bwOres & 4) != 0 ? new ItemStack(WerkstoffLoader.BWOres, 1, this.mSecondaryMeta) : new ItemStack(GregTech_API.sBlockOres1, 1, this.mSecondaryMeta));
        ret.add((this.bwOres & 2) != 0 ? new ItemStack(WerkstoffLoader.BWOres, 1, this.mBetweenMeta) : new ItemStack(GregTech_API.sBlockOres1, 1, this.mBetweenMeta));
        ret.add((this.bwOres & 1) != 0 ? new ItemStack(WerkstoffLoader.BWOres, 1, this.mSporadicMeta) : new ItemStack(GregTech_API.sBlockOres1, 1, this.mSporadicMeta));
        return ret;
    }

    public List<Pair<Integer, Boolean>> getStacksRawData() {
        ArrayList<Pair<Integer, Boolean>> ret = new ArrayList<Pair<Integer, Boolean>>();
        ret.add(new Pair<Integer, Boolean>(this.mPrimaryMeta, (this.bwOres & 8) != 0));
        ret.add(new Pair<Integer, Boolean>(this.mSecondaryMeta, (this.bwOres & 4) != 0));
        ret.add(new Pair<Integer, Boolean>(this.mBetweenMeta, (this.bwOres & 2) != 0));
        ret.add(new Pair<Integer, Boolean>(this.mSporadicMeta, (this.bwOres & 1) != 0));
        return ret;
    }

    public boolean executeWorldgen(World aWorld, Random aRandom, String aBiome, int aDimensionType, int aChunkX, int aChunkZ, IChunkProvider aChunkGenerator, IChunkProvider aChunkProvider) {
        int tMinY = this.mMinY + aRandom.nextInt(this.mMaxY - this.mMinY - 5);
        int cX = aChunkX - aRandom.nextInt(this.mSize);
        int eX = aChunkX + 16 + aRandom.nextInt(this.mSize);
        boolean wasPlaced = false;
        for (int tX = cX; tX <= eX; ++tX) {
            int cZ = aChunkZ - aRandom.nextInt(this.mSize);
            int eZ = aChunkZ + 16 + aRandom.nextInt(this.mSize);
            for (int tZ = cZ; tZ <= eZ; ++tZ) {
                int i;
                if (this.mSecondaryMeta > 0) {
                    for (i = tMinY - 1; i < tMinY + 2; ++i) {
                        if (!this.shouldPlace(aRandom, cX, eX, tX, cZ, eZ, tZ)) continue;
                        wasPlaced = this.setOreBlock(aWorld, tX, i, tZ, this.mSecondaryMeta, false);
                    }
                }
                if (this.mBetweenMeta > 0 && this.shouldPlace(aRandom, cX, eX, tX, cZ, eZ, tZ)) {
                    wasPlaced = this.setOreBlock(aWorld, tX, tMinY + 2 + aRandom.nextInt(2), tZ, this.mBetweenMeta, false);
                }
                if (this.mPrimaryMeta > 0) {
                    for (i = tMinY + 3; i < tMinY + 6; ++i) {
                        if (!this.shouldPlace(aRandom, cX, eX, tX, cZ, eZ, tZ)) continue;
                        wasPlaced = this.setOreBlock(aWorld, tX, i, tZ, this.mPrimaryMeta, false);
                    }
                }
                if (this.mSporadicMeta <= 0 || !this.shouldPlace(aRandom, cX, eX, tX, cZ, eZ, tZ)) continue;
                wasPlaced = this.setOreBlock(aWorld, tX, tMinY - 1 + aRandom.nextInt(7), tZ, this.mSporadicMeta, false);
            }
        }
        return wasPlaced;
    }

    private boolean shouldPlace(Random aRandom, int cX, int eX, int tX, int cZ, int eZ, int tZ) {
        return aRandom.nextInt(Math.max(1, Math.max(MathHelper.func_76130_a((int)(cZ - tZ)), MathHelper.func_76130_a((int)(eZ - tZ))) / this.mDensity)) == 0 || aRandom.nextInt(Math.max(1, Math.max(MathHelper.func_76130_a((int)(cX - tX)), MathHelper.func_76130_a((int)(eX - tX))) / this.mDensity)) == 0;
    }

    public boolean setOreBlock(World aWorld, int aX, int aY, int aZ, int aMetaData, boolean isSmallOre) {
        TileEntity te = aWorld.func_147438_o(aX, aY, aZ);
        if (te instanceof BW_MetaGeneratedOreTE || te instanceof GT_TileEntity_Ores) {
            return true;
        }
        if (aMetaData == this.mSporadicMeta && (this.bwOres & 1) != 0 || aMetaData == this.mBetweenMeta && (this.bwOres & 2) != 0 || aMetaData == this.mPrimaryMeta && (this.bwOres & 8) != 0 || aMetaData == this.mSecondaryMeta && (this.bwOres & 4) != 0) {
            return isSmallOre ? BW_MetaGenerated_SmallOres.setOreBlock(aWorld, aX, aY, aZ, aMetaData, false, this.getDefaultBlockToReplace(), this.getDefaultDamageToReplace()) : BW_MetaGenerated_Ores.setOreBlock(aWorld, aX, aY, aZ, aMetaData, false, this.getDefaultBlockToReplace(), this.getDefaultDamageToReplace());
        }
        return this.setGTOreBlockSpace(aWorld, aX, aY, aZ, aMetaData, this.getDefaultBlockToReplace());
    }

    public boolean setGTOreBlockSpace(World aWorld, int aX, int aY, int aZ, int aMetaData, Block block) {
        if (GT_TileEntity_Ores.setOreBlock((World)aWorld, (int)aX, (int)aY, (int)aZ, (int)aMetaData, (boolean)false, (boolean)false)) {
            return true;
        }
        aY = Math.min(aWorld.func_72940_L(), Math.max(aY, 1));
        Block tBlock = aWorld.func_147439_a(aX, aY, aZ);
        Block tOreBlock = GregTech_API.sBlockOres1;
        if (aMetaData < 0 || tBlock == Blocks.field_150350_a) {
            return false;
        }
        if (!tBlock.isReplaceableOreGen(aWorld, aX, aY, aZ, block)) {
            return false;
        }
        aWorld.func_147465_d(aX, aY, aZ, tOreBlock, aMetaData += 5000, 0);
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof GT_TileEntity_Ores) {
            GT_TileEntity_Ores ore = (GT_TileEntity_Ores)tTileEntity;
            ore.mMetaData = (short)aMetaData;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BW_OreLayer)) {
            return false;
        }
        BW_OreLayer that = (BW_OreLayer)((Object)o);
        if (this.bwOres != that.bwOres || this.mMinY != that.mMinY || this.mWeight != that.mWeight || this.mDensity != that.mDensity) {
            return false;
        }
        if (this.mSize != that.mSize) {
            return false;
        }
        if (this.mMaxY != that.mMaxY) {
            return false;
        }
        if (this.mPrimaryMeta != that.mPrimaryMeta) {
            return false;
        }
        if (this.mSecondaryMeta != that.mSecondaryMeta) {
            return false;
        }
        if (this.mBetweenMeta != that.mBetweenMeta) {
            return false;
        }
        return this.mSporadicMeta == that.mSporadicMeta;
    }

    public int hashCode() {
        return MurmurHash3.murmurhash3_x86_32(ByteBuffer.allocate(37).put(this.bwOres).putInt(this.mMinY).putInt(this.mWeight).putInt(this.mDensity).putInt(this.mSize).putInt(this.mMaxY).putInt(this.mPrimaryMeta).putInt(this.mSecondaryMeta).putInt(this.mBetweenMeta).putInt(this.mSporadicMeta).array(), 0, 37, 31);
    }
}

