/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.net;

import com.github.bartimaeusnek.bartworks.API.SideReference;
import com.github.bartimaeusnek.bartworks.MainMod;
import com.github.bartimaeusnek.bartworks.common.tileentities.multis.GT_TileEntity_BioVat;
import com.github.bartimaeusnek.bartworks.util.BW_ColorUtil;
import com.github.bartimaeusnek.bartworks.util.Coords;
import com.google.common.io.ByteArrayDataInput;
import gregtech.api.net.GT_Packet_New;
import io.netty.buffer.ByteBuf;
import net.minecraft.world.IBlockAccess;

public class RendererPacket
extends GT_Packet_New {
    private Coords coords;
    private int integer;
    private byte removal;

    public RendererPacket() {
        super(true);
    }

    public RendererPacket(Coords coords, int integer, boolean removal) {
        super(false);
        this.coords = coords;
        this.integer = integer;
        this.removal = (byte)(removal ? 1 : 0);
    }

    public byte getPacketID() {
        return 0;
    }

    public void encode(ByteBuf aOut) {
        byte r = (byte)((this.integer >> 16 & 0xFF) + -128);
        byte g = (byte)((this.integer >> 8 & 0xFF) + -128);
        byte b = (byte)((this.integer & 0xFF) + -128);
        byte checksum = (byte)(this.coords.x % 25 + this.coords.y % 25 + this.coords.z % 25 + this.coords.wID % 25 + this.integer % 25 + this.removal);
        aOut.writeInt(this.coords.x).writeShort((int)this.coords.y).writeInt(this.coords.z).writeInt(this.coords.wID).writeByte((int)r).writeByte((int)g).writeByte((int)b).writeByte((int)this.removal).writeByte((int)checksum);
    }

    public GT_Packet_New decode(ByteArrayDataInput dataInput) {
        this.coords = new Coords(dataInput.readInt(), dataInput.readShort(), dataInput.readInt(), dataInput.readInt());
        this.integer = BW_ColorUtil.getColorFromRGBArray(new int[]{dataInput.readUnsignedByte(), dataInput.readUnsignedByte(), dataInput.readUnsignedByte()});
        this.removal = dataInput.readByte();
        byte checksum = (byte)(this.coords.x % 25 + this.coords.y % 25 + this.coords.z % 25 + this.coords.wID % 25 + this.integer % 25 + this.removal);
        if (checksum != dataInput.readByte()) {
            MainMod.LOGGER.error("BW Packet was corrupted or modified!");
            return null;
        }
        return new RendererPacket(this.coords, this.integer, this.removal == 1);
    }

    public void process(IBlockAccess iBlockAccess) {
        if (SideReference.Side.Client) {
            if (this.removal == 0) {
                GT_TileEntity_BioVat.staticColorMap.put(this.coords, this.integer);
            } else {
                GT_TileEntity_BioVat.staticColorMap.remove(this.coords);
            }
        }
    }
}

