/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.loaders;

import com.github.bartimaeusnek.bartworks.common.loaders.ElectricImplosionCompressorRecipes;
import com.github.bartimaeusnek.bartworks.system.material.Werkstoff;
import com.github.bartimaeusnek.bartworks.system.material.WerkstoffLoader;
import com.github.bartimaeusnek.bartworks.util.BWRecipes;
import com.github.bartimaeusnek.bartworks.util.BW_Util;
import com.github.bartimaeusnek.bartworks.util.StreamUtils;
import com.github.bartimaeusnek.bartworks.util.log.DebugLog;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.registry.GameRegistry;
import gnu.trove.map.hash.TObjectDoubleHashMap;
import gregtech.api.enums.Element;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.enums.TierEU;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.StringUtils;

public class StaticRecipeChangeLoaders {
    private static TObjectDoubleHashMap<Materials> gtEbfGasRecipeTimeMultipliers = null;
    private static TObjectDoubleHashMap<Materials> gtEbfGasRecipeConsumptionMultipliers = null;
    public static final List<ItemStack> whitelistForEBFNoGasRecipeDontCheckItemData = Arrays.asList(GT_ModHandler.getModItem((String)Mods.TinkerConstruct.ID, (String)"materials", (long)1L, (int)12));

    private StaticRecipeChangeLoaders() {
    }

    public static void addEBFGasRecipes() {
        if (gtEbfGasRecipeTimeMultipliers == null) {
            gtEbfGasRecipeTimeMultipliers = new TObjectDoubleHashMap(10, 0.5f, -1.0);
            gtEbfGasRecipeTimeMultipliers.put((Object)Materials.Nitrogen, 1.0);
            gtEbfGasRecipeTimeMultipliers.put((Object)Materials.Helium, 0.9);
            gtEbfGasRecipeTimeMultipliers.put((Object)Materials.Argon, 0.8);
            gtEbfGasRecipeTimeMultipliers.put((Object)Materials.Radon, 0.7);
        }
        if (gtEbfGasRecipeConsumptionMultipliers == null) {
            gtEbfGasRecipeConsumptionMultipliers = new TObjectDoubleHashMap(10, 0.5f, 1.0);
            gtEbfGasRecipeConsumptionMultipliers.put((Object)Materials.Nitrogen, 1.0);
            gtEbfGasRecipeConsumptionMultipliers.put((Object)Materials.Helium, 1.0);
            gtEbfGasRecipeConsumptionMultipliers.put((Object)Materials.Argon, 0.85);
            gtEbfGasRecipeConsumptionMultipliers.put((Object)Materials.Radon, 0.7);
        }
        ArrayListMultimap<SubTag, GT_Recipe> toChange = StaticRecipeChangeLoaders.getRecipesToChange(WerkstoffLoader.NOBLE_GAS, WerkstoffLoader.ANAEROBE_GAS);
        StaticRecipeChangeLoaders.editRecipes(toChange, StaticRecipeChangeLoaders.getNoGasItems(toChange));
    }

    public static void fixEnergyRequirements() {
        GT_Recipe.GT_Recipe_Map.sMappings.stream().filter(StreamUtils::filterVisualMaps).forEach(gt_recipe_map -> gt_recipe_map.mRecipeList.parallelStream().forEach(gt_recipe -> {
            for (int i = 0; i < GT_Values.VN.length - 1; ++i) {
                if (gt_recipe.mEUt <= BW_Util.getMachineVoltageFromTier(i) || (long)gt_recipe.mEUt > BW_Util.getTierVoltage(i)) continue;
                gt_recipe.mEUt = BW_Util.getMachineVoltageFromTier(i);
            }
        }));
    }

    private static void replaceWrongFluidOutput(Werkstoff werkstoff, GT_Recipe recipe, FluidStack wrongNamedFluid) {
        for (int i = 0; i < recipe.mFluidOutputs.length; ++i) {
            if (!GT_Utility.areFluidsEqual((FluidStack)recipe.mFluidOutputs[i], (FluidStack)wrongNamedFluid)) continue;
            recipe.mFluidOutputs[i] = werkstoff.getFluidOrGas(recipe.mFluidOutputs[i].amount);
        }
    }

    private static void replaceWrongFluidInput(Werkstoff werkstoff, GT_Recipe.GT_Recipe_Map map, GT_Recipe recipe, FluidStack wrongNamedFluid) {
        for (int i = 0; i < recipe.mFluidInputs.length; ++i) {
            if (!GT_Utility.areFluidsEqual((FluidStack)recipe.mFluidInputs[i], (FluidStack)wrongNamedFluid)) continue;
            Collection col = (Collection)map.mRecipeFluidMap.get(wrongNamedFluid.getFluid().getName());
            map.mRecipeFluidMap.remove(wrongNamedFluid.getFluid().getName());
            map.mRecipeFluidMap.put(werkstoff.getFluidOrGas(1).getFluid().getName(), col);
            recipe.mFluidInputs[i] = werkstoff.getFluidOrGas(recipe.mFluidInputs[i].amount);
            map.mRecipeFluidNameMap.add(werkstoff.getFluidOrGas(1).getFluid().getName());
        }
    }

    private static void addConversionRecipe(Werkstoff werkstoff, FluidStack wrongNamedFluid) {
        GT_Recipe.GT_Recipe_Map.sCentrifugeRecipes.add((GT_Recipe)new BWRecipes.DynamicGTRecipe(false, null, null, null, null, new FluidStack[]{wrongNamedFluid}, new FluidStack[]{werkstoff.getFluidOrGas(1)}, 1, 1, 0));
    }

    private static FluidStack getWrongNameFluid(Werkstoff werkstoff) {
        String name = werkstoff.getFluidOrGas(1).getFluid().getName();
        String wrongname = "molten." + name;
        return FluidRegistry.getFluidStack((String)wrongname, (int)1);
    }

    private static void enforceNobleGas(Werkstoff werkstoff) {
        FluidStack wrongNamedFluid = StaticRecipeChangeLoaders.getWrongNameFluid(werkstoff);
        if (wrongNamedFluid != null) {
            GT_Recipe.GT_Recipe_Map.sMappings.forEach(map -> map.mRecipeList.forEach(recipe -> {
                StaticRecipeChangeLoaders.replaceWrongFluidInput(werkstoff, map, recipe, wrongNamedFluid);
                StaticRecipeChangeLoaders.replaceWrongFluidOutput(werkstoff, recipe, wrongNamedFluid);
            }));
            StaticRecipeChangeLoaders.addConversionRecipe(werkstoff, wrongNamedFluid);
        }
    }

    public static void unificationRecipeEnforcer() {
        for (Werkstoff werkstoff : Werkstoff.werkstoffHashSet) {
            StaticRecipeChangeLoaders.runMaterialLinker(werkstoff);
            if (!werkstoff.getGenerationFeatures().enforceUnification) continue;
            if (werkstoff.contains(WerkstoffLoader.NOBLE_GAS)) {
                StaticRecipeChangeLoaders.enforceNobleGas(werkstoff);
            }
            HashSet<String> oreDictNames = new HashSet<String>(werkstoff.getADDITIONAL_OREDICT());
            oreDictNames.add(werkstoff.getVarName());
            StaticRecipeChangeLoaders.runMoltenUnificationEnfocement(werkstoff);
            StaticRecipeChangeLoaders.runUnficationDeleter(werkstoff);
            for (String s : oreDictNames) {
                for (OrePrefixes prefixes : OrePrefixes.values()) {
                    String fullOreName;
                    List ores;
                    if (!werkstoff.hasItemType(prefixes) || (ores = OreDictionary.getOres((String)(fullOreName = prefixes + s), (boolean)false)).size() <= 1) continue;
                    for (ItemStack toReplace : ores) {
                        ItemStack replacement = werkstoff.get(prefixes);
                        if (toReplace == null || GT_Utility.areStacksEqual((ItemStack)toReplace, (ItemStack)replacement) || replacement == null || replacement.func_77973_b() == null) continue;
                        for (GT_Recipe.GT_Recipe_Map map : GT_Recipe.GT_Recipe_Map.sMappings) {
                            Iterator iterator = map.mRecipeList.iterator();
                            block5: while (iterator.hasNext()) {
                                ItemStack specialItemStack;
                                int i;
                                GT_Recipe recipe = (GT_Recipe)iterator.next();
                                boolean removal = map.equals(GT_Recipe.GT_Recipe_Map.sFluidExtractionRecipes) || map.equals(GT_Recipe.GT_Recipe_Map.sFluidSolidficationRecipes);
                                for (i = 0; i < recipe.mInputs.length; ++i) {
                                    if (!GT_Utility.areStacksEqual((ItemStack)recipe.mInputs[i], (ItemStack)toReplace)) continue;
                                    if (removal) {
                                        iterator.remove();
                                        continue block5;
                                    }
                                    recipe.mInputs[i] = GT_Utility.copyAmount((long)recipe.mInputs[i].field_77994_a, (Object[])new Object[]{replacement});
                                }
                                for (i = 0; i < recipe.mOutputs.length; ++i) {
                                    if (!GT_Utility.areStacksEqual((ItemStack)recipe.mOutputs[i], (ItemStack)toReplace)) continue;
                                    if (removal) {
                                        iterator.remove();
                                        continue block5;
                                    }
                                    recipe.mOutputs[i] = GT_Utility.copyAmount((long)recipe.mOutputs[i].field_77994_a, (Object[])new Object[]{replacement});
                                }
                                Object object = recipe.mSpecialItems;
                                if (!(object instanceof ItemStack) || !GT_Utility.areStacksEqual((ItemStack)(specialItemStack = (ItemStack)object), (ItemStack)toReplace)) continue;
                                if (removal) {
                                    iterator.remove();
                                    continue;
                                }
                                recipe.mSpecialItems = GT_Utility.copyAmount((long)specialItemStack.field_77994_a, (Object[])new Object[]{replacement});
                            }
                        }
                    }
                }
            }
        }
    }

    private static void runMoltenUnificationEnfocement(Werkstoff werkstoff) {
        if (werkstoff.getGenerationFeatures().enforceUnification && werkstoff.hasItemType(OrePrefixes.cellMolten)) {
            try {
                FluidContainerRegistry.FluidContainerData data = new FluidContainerRegistry.FluidContainerData(new FluidStack(Objects.requireNonNull((Fluid)WerkstoffLoader.molten.get((Object)werkstoff)), 144), werkstoff.get(OrePrefixes.cellMolten), Materials.Empty.getCells(1));
                Field f = GT_Utility.class.getDeclaredField("sFilledContainerToData");
                f.setAccessible(true);
                Map sFilledContainerToData = (Map)f.get(null);
                HashSet toremFilledContainerToData = new HashSet();
                ItemStack toReplace = null;
                for (Map.Entry entry : sFilledContainerToData.entrySet()) {
                    String MODID = GameRegistry.findUniqueIdentifierFor((Item)data.filledContainer.func_77973_b()).modId;
                    if ("bartworks".equals(MODID) || "bartworkscrossmod".equals(MODID) || !((FluidContainerRegistry.FluidContainerData)entry.getValue()).fluid.equals((Object)data.fluid) || ((FluidContainerRegistry.FluidContainerData)entry.getValue()).filledContainer.equals(data.filledContainer)) continue;
                    toReplace = ((FluidContainerRegistry.FluidContainerData)entry.getValue()).filledContainer;
                    toremFilledContainerToData.add(entry);
                }
                sFilledContainerToData.entrySet().removeAll(toremFilledContainerToData);
                HashSet<GT_Recipe> toremRecipeList = new HashSet<GT_Recipe>();
                if (toReplace != null) {
                    for (GT_Recipe.GT_Recipe_Map map : GT_Recipe.GT_Recipe_Map.sMappings) {
                        toremRecipeList.clear();
                        for (GT_Recipe recipe : map.mRecipeList) {
                            for (ItemStack mInput : recipe.mInputs) {
                                if (!GT_Utility.areStacksEqual((ItemStack)mInput, (ItemStack)toReplace)) continue;
                                toremRecipeList.add(recipe);
                            }
                            for (ItemStack mOutput : recipe.mOutputs) {
                                if (!GT_Utility.areStacksEqual((ItemStack)mOutput, (ItemStack)toReplace)) continue;
                                toremRecipeList.add(recipe);
                                if (map != GT_Recipe.GT_Recipe_Map.sFluidCannerRecipes || !GT_Utility.areStacksEqual((ItemStack)mOutput, (ItemStack)data.filledContainer) || recipe.mFluidInputs[0].equals((Object)data.fluid)) continue;
                                toremRecipeList.add(recipe);
                            }
                            if (!(recipe.mSpecialItems instanceof ItemStack) || !GT_Utility.areStacksEqual((ItemStack)((ItemStack)recipe.mSpecialItems), (ItemStack)toReplace)) continue;
                            toremRecipeList.add(recipe);
                        }
                        map.mRecipeList.removeAll(toremRecipeList);
                    }
                }
                GT_Utility.addFluidContainerData((FluidContainerRegistry.FluidContainerData)data);
            }
            catch (ClassCastException | IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
    }

    private static void runUnficationDeleter(Werkstoff werkstoff) {
        if (werkstoff.getType() == Werkstoff.Types.ELEMENT && werkstoff.getBridgeMaterial() != null && Element.get((String)werkstoff.getToolTip()) != Element._NULL) {
            werkstoff.getBridgeMaterial().mElement = Element.get((String)werkstoff.getToolTip());
            Element.get((String)werkstoff.getToolTip()).mLinkedMaterials = new ArrayList();
            Element.get((String)werkstoff.getToolTip()).mLinkedMaterials.add(werkstoff.getBridgeMaterial());
        }
        for (OrePrefixes prefixes : OrePrefixes.values()) {
            if (!werkstoff.hasItemType(prefixes)) continue;
            GT_OreDictUnificator.set((OrePrefixes)prefixes, (Materials)werkstoff.getBridgeMaterial(), (ItemStack)werkstoff.get(prefixes), (boolean)true, (boolean)true);
            for (ItemStack stack : OreDictionary.getOres((String)(prefixes + werkstoff.getVarName()))) {
                GT_OreDictUnificator.addAssociation((OrePrefixes)prefixes, (Materials)werkstoff.getBridgeMaterial(), (ItemStack)stack, (boolean)false);
                GT_OreDictUnificator.getAssociation((ItemStack)stack).mUnificationTarget = werkstoff.get(prefixes);
            }
        }
    }

    private static void runMaterialLinker(Werkstoff werkstoff) {
        if (werkstoff.getType() == Werkstoff.Types.ELEMENT && werkstoff.getBridgeMaterial() != null && Element.get((String)werkstoff.getToolTip()) != Element._NULL) {
            werkstoff.getBridgeMaterial().mElement = Element.get((String)werkstoff.getToolTip());
            Element.get((String)werkstoff.getToolTip()).mLinkedMaterials = new ArrayList();
            Element.get((String)werkstoff.getToolTip()).mLinkedMaterials.add(werkstoff.getBridgeMaterial());
        }
        for (OrePrefixes prefixes : OrePrefixes.values()) {
            if (!werkstoff.hasItemType(prefixes) || werkstoff.getBridgeMaterial() == null) continue;
            GT_OreDictUnificator.set((OrePrefixes)prefixes, (Materials)werkstoff.getBridgeMaterial(), (ItemStack)werkstoff.get(prefixes), (boolean)true, (boolean)true);
            for (ItemStack stack : OreDictionary.getOres((String)(prefixes + werkstoff.getVarName()))) {
                GT_OreDictUnificator.addAssociation((OrePrefixes)prefixes, (Materials)werkstoff.getBridgeMaterial(), (ItemStack)stack, (boolean)false);
            }
        }
    }

    private static ArrayListMultimap<SubTag, GT_Recipe> getRecipesToChange(SubTag ... GasTags) {
        ArrayListMultimap toAdd = ArrayListMultimap.create();
        for (GT_Recipe recipe : GT_Recipe.GT_Recipe_Map.sBlastRecipes.mRecipeList) {
            Materials mat;
            if (recipe.mFluidInputs == null || recipe.mFluidInputs.length <= 0 || (mat = StaticRecipeChangeLoaders.getMaterialFromInputFluid(recipe)) == Materials._NULL) continue;
            for (SubTag tag : GasTags) {
                if (!mat.contains(tag)) continue;
                DebugLog.log("Found EBF Recipe to change, Output:" + BW_Util.translateGTItemStack(recipe.mOutputs[0]));
                toAdd.put((Object)tag, (Object)recipe);
            }
        }
        return toAdd;
    }

    private static HashSet<ItemStack> getNoGasItems(ArrayListMultimap<SubTag, GT_Recipe> base) {
        HashSet<ItemStack> toAdd = new HashSet<ItemStack>();
        ArrayListMultimap repToAdd = ArrayListMultimap.create();
        for (GT_Recipe recipe : GT_Recipe.GT_Recipe_Map.sBlastRecipes.mRecipeList) {
            for (SubTag tag : base.keySet()) {
                block2: for (GT_Recipe baseRe : base.get((Object)tag)) {
                    if (recipe.mInputs.length != baseRe.mInputs.length || recipe.mOutputs.length != baseRe.mOutputs.length) continue;
                    for (int i = 0; i < recipe.mInputs.length; ++i) {
                        ItemStack tmpInput = recipe.mInputs[i];
                        if (recipe.mFluidInputs != null && recipe.mFluidInputs.length != 0 || !whitelistForEBFNoGasRecipeDontCheckItemData.stream().anyMatch(s -> GT_Utility.areStacksEqual((ItemStack)s, (ItemStack)tmpInput)) && (!BW_Util.checkStackAndPrefix(recipe.mInputs[i]) || !BW_Util.checkStackAndPrefix(baseRe.mInputs[i]) || !GT_OreDictUnificator.getAssociation((ItemStack)recipe.mInputs[i]).mMaterial.mMaterial.equals(GT_OreDictUnificator.getAssociation((ItemStack)baseRe.mInputs[i]).mMaterial.mMaterial) || !GT_Utility.areStacksEqual((ItemStack)recipe.mOutputs[0], (ItemStack)baseRe.mOutputs[0]))) continue;
                        toAdd.add(recipe.mOutputs[0]);
                        repToAdd.put((Object)tag, (Object)recipe);
                        continue block2;
                    }
                }
            }
        }
        base.putAll((Multimap)repToAdd);
        return toAdd;
    }

    private static int transformEBFGasRecipeTime(int originalDuration, long originalGasProtons, long newGasProtons) {
        double protonTerm = (double)originalGasProtons * (newGasProtons >= originalGasProtons ? 1.0 : 2.75) - (double)newGasProtons;
        return Math.max(1, (int)((double)originalDuration / 200.0 * Math.max(200.0 + protonTerm, 1.0)));
    }

    private static int transformEBFGasRecipeTime(GT_Recipe recipe, Materials originalGas, Materials newGas) {
        double newEbfMul = gtEbfGasRecipeTimeMultipliers.get((Object)newGas);
        double originalEbfMul = gtEbfGasRecipeTimeMultipliers.get((Object)originalGas);
        if (newEbfMul < 0.0 || originalEbfMul < 0.0) {
            return StaticRecipeChangeLoaders.transformEBFGasRecipeTime(recipe.mDuration, originalGas.getProtons(), newGas.getProtons());
        }
        return Math.max(1, (int)((double)recipe.mDuration * newEbfMul / originalEbfMul));
    }

    private static int transformEBFGasRecipeTime(GT_Recipe recipe, Materials originalGas, Werkstoff newGas) {
        double newEbfMul = newGas.getStats().getEbfGasRecipeTimeMultiplier();
        double originalEbfMul = gtEbfGasRecipeTimeMultipliers.get((Object)originalGas);
        if (newEbfMul < 0.0 || originalEbfMul < 0.0) {
            return StaticRecipeChangeLoaders.transformEBFGasRecipeTime(recipe.mDuration, originalGas.getProtons(), newGas.getStats().getProtons());
        }
        return Math.max(1, (int)((double)recipe.mDuration * newEbfMul / originalEbfMul));
    }

    private static int transformEBFNoGasRecipeTime(GT_Recipe recipe, Materials originalGas) {
        return StaticRecipeChangeLoaders.transformEBFGasRecipeTime(recipe.mDuration, originalGas.getProtons(), 0L);
    }

    private static void editEBFMaterialRecipes(SubTag GasTag, GT_Recipe recipe, Materials originalGas, HashSet<GT_Recipe> toAdd) {
        for (Materials newGas : Materials.values()) {
            if (!newGas.contains(GasTag)) continue;
            int time = StaticRecipeChangeLoaders.transformEBFGasRecipeTime(recipe, originalGas, newGas);
            int gasAmount = Math.max(1, (int)Math.round((double)recipe.mFluidInputs[0].amount * gtEbfGasRecipeConsumptionMultipliers.get((Object)newGas)));
            if (recipe.mFluidInputs != null && recipe.mFluidInputs.length == 1 && recipe.mFluidInputs[0].isFluidEqual(newGas.getGas(0L))) {
                toAdd.add(new BWRecipes.DynamicGTRecipe(false, recipe.mInputs, recipe.mOutputs, recipe.mSpecialItems, recipe.mChances, new FluidStack[]{newGas.getGas((long)gasAmount)}, recipe.mFluidOutputs, time, recipe.mEUt, recipe.mSpecialValue, recipe));
                continue;
            }
            toAdd.add(new BWRecipes.DynamicGTRecipe(false, recipe.mInputs, recipe.mOutputs, recipe.mSpecialItems, recipe.mChances, new FluidStack[]{newGas.getGas((long)gasAmount)}, recipe.mFluidOutputs, time, recipe.mEUt, recipe.mSpecialValue));
        }
    }

    private static void editEBFWerkstoffRecipes(SubTag GasTag, GT_Recipe recipe, Materials originalGas, HashSet<GT_Recipe> toAdd) {
        for (Werkstoff newGas : Werkstoff.werkstoffHashMap.values()) {
            if (!newGas.contains(GasTag)) continue;
            int time = StaticRecipeChangeLoaders.transformEBFGasRecipeTime(recipe, originalGas, newGas);
            int gasAmount = Math.max(1, (int)Math.round((double)recipe.mFluidInputs[0].amount * newGas.getStats().getEbfGasRecipeConsumedAmountMultiplier()));
            if (recipe.mFluidInputs != null && recipe.mFluidInputs.length == 1 && recipe.mFluidInputs[0].isFluidEqual(new FluidStack(Objects.requireNonNull((Fluid)WerkstoffLoader.fluids.get((Object)newGas)), 0))) {
                toAdd.add(new BWRecipes.DynamicGTRecipe(false, recipe.mInputs, recipe.mOutputs, recipe.mSpecialItems, recipe.mChances, new FluidStack[]{new FluidStack(Objects.requireNonNull((Fluid)WerkstoffLoader.fluids.get((Object)newGas)), gasAmount)}, recipe.mFluidOutputs, time, recipe.mEUt, recipe.mSpecialValue, recipe));
                continue;
            }
            toAdd.add(new BWRecipes.DynamicGTRecipe(false, recipe.mInputs, recipe.mOutputs, recipe.mSpecialItems, recipe.mChances, new FluidStack[]{new FluidStack(Objects.requireNonNull((Fluid)WerkstoffLoader.fluids.get((Object)newGas)), gasAmount)}, recipe.mFluidOutputs, time, recipe.mEUt, recipe.mSpecialValue));
        }
    }

    private static void editEBFNoGasRecipes(GT_Recipe recipe, Materials originalGas, HashSet<GT_Recipe> toAdd, HashSet<ItemStack> noGas) {
        for (ItemStack is : noGas) {
            int circuitConfiguration = 1;
            if (!GT_Utility.areStacksEqual((ItemStack)is, (ItemStack)recipe.mOutputs[0])) continue;
            ArrayList<ItemStack> inputs = new ArrayList<ItemStack>(recipe.mInputs.length);
            for (ItemStack stack : recipe.mInputs) {
                if (GT_Utility.areStacksEqual((ItemStack)GT_Utility.getIntegratedCircuit((int)11), (ItemStack)stack) || GT_Utility.areStacksEqual((ItemStack)GT_Utility.getIntegratedCircuit((int)14), (ItemStack)stack) || GT_Utility.areStacksEqual((ItemStack)GT_Utility.getIntegratedCircuit((int)19), (ItemStack)stack)) continue;
                if (BW_Util.checkStackAndPrefix(stack)) {
                    circuitConfiguration = (byte)(OrePrefixes.dustSmall.equals((Object)GT_OreDictUnificator.getAssociation((ItemStack)stack).mPrefix) ? 4 : (OrePrefixes.dustTiny.equals((Object)GT_OreDictUnificator.getAssociation((ItemStack)stack).mPrefix) ? 9 : 1));
                }
                inputs.add(stack);
            }
            inputs.add(GT_Utility.getIntegratedCircuit((int)circuitConfiguration));
            toAdd.add(new BWRecipes.DynamicGTRecipe(false, inputs.toArray(new ItemStack[0]), recipe.mOutputs, recipe.mSpecialItems, recipe.mChances, null, recipe.mFluidOutputs, StaticRecipeChangeLoaders.transformEBFNoGasRecipeTime(recipe, originalGas), recipe.mEUt, recipe.mSpecialValue, recipe));
            break;
        }
    }

    private static void removeDuplicateGasRecipes(HashSet<GT_Recipe> toAdd) {
        HashSet<GT_Recipe> duplicates = new HashSet<GT_Recipe>();
        for (GT_Recipe recipe : toAdd) {
            for (GT_Recipe recipe2 : toAdd) {
                int i;
                if (recipe.mEUt != recipe2.mEUt || recipe.mDuration != recipe2.mDuration || recipe.mSpecialValue != recipe2.mSpecialValue || recipe == recipe2 || recipe.mInputs.length != recipe2.mInputs.length || recipe.mFluidInputs.length != recipe2.mFluidInputs.length) continue;
                boolean isSame = true;
                for (i = 0; i < recipe.mInputs.length; ++i) {
                    if (GT_Utility.areStacksEqual((ItemStack)recipe.mInputs[i], (ItemStack)recipe2.mInputs[i])) continue;
                    isSame = false;
                }
                for (i = 0; i < recipe.mFluidInputs.length; ++i) {
                    if (GT_Utility.areFluidsEqual((FluidStack)recipe.mFluidInputs[i], (FluidStack)recipe2.mFluidInputs[i])) continue;
                    isSame = false;
                }
                if (!isSame) continue;
                duplicates.add(recipe2);
            }
        }
        toAdd.removeAll(duplicates);
    }

    private static Materials getMaterialFromInputFluid(GT_Recipe recipe) {
        String materialString = recipe.mFluidInputs[0].getFluid().getName();
        materialString = StringUtils.removeStart((String)materialString, (String)"molten");
        materialString = StringUtils.removeStart((String)materialString, (String)"fluid");
        materialString = StringUtils.capitalize((String)materialString);
        return Materials.get((String)materialString);
    }

    private static void editRecipes(ArrayListMultimap<SubTag, GT_Recipe> base, HashSet<ItemStack> noGas) {
        if (GT_Recipe.GT_Recipe_Map.sBlastRecipes.mRecipeFluidNameMap.contains(Objects.requireNonNull((Fluid)WerkstoffLoader.fluids.get((Object)WerkstoffLoader.Oganesson)).getName())) {
            return;
        }
        HashSet<GT_Recipe> toAdd = new HashSet<GT_Recipe>();
        for (SubTag gasTag : base.keySet()) {
            for (GT_Recipe recipe : base.get((Object)gasTag)) {
                Materials originalGas;
                if (recipe.mFluidInputs == null || recipe.mFluidInputs.length <= 0 || (originalGas = StaticRecipeChangeLoaders.getMaterialFromInputFluid(recipe)) == Materials._NULL) continue;
                StaticRecipeChangeLoaders.editEBFWerkstoffRecipes(gasTag, recipe, originalGas, toAdd);
                StaticRecipeChangeLoaders.editEBFMaterialRecipes(gasTag, recipe, originalGas, toAdd);
                StaticRecipeChangeLoaders.editEBFNoGasRecipes(recipe, originalGas, toAdd, noGas);
            }
            GT_Recipe.GT_Recipe_Map.sBlastRecipes.mRecipeList.removeAll(base.get((Object)gasTag));
        }
        StaticRecipeChangeLoaders.removeDuplicateGasRecipes(toAdd);
        toAdd.forEach(arg_0 -> ((GT_Recipe.GT_Recipe_Map)GT_Recipe.GT_Recipe_Map.sBlastRecipes).add(arg_0));
    }

    public static void addElectricImplosionCompressorRecipes() {
        GT_Recipe.GT_Recipe_Map.sImplosionRecipes.mRecipeList.stream().filter(e -> e.mInputs != null).forEach(recipe -> BWRecipes.instance.eicMap.addRecipe(true, (ItemStack[])Arrays.stream(recipe.mInputs).filter(e -> !StaticRecipeChangeLoaders.checkForExplosives(e)).distinct().toArray(ItemStack[]::new), recipe.mOutputs, null, null, null, 1, (int)TierEU.RECIPE_UEV, 0));
        new ElectricImplosionCompressorRecipes().run();
    }

    private static boolean checkForExplosives(ItemStack input) {
        return GT_Utility.areStacksEqual((ItemStack)input, (ItemStack)new ItemStack(Blocks.field_150335_W)) || GT_Utility.areStacksEqual((ItemStack)input, (ItemStack)GT_ModHandler.getIC2Item((String)"industrialTnt", (long)1L)) || GT_Utility.areStacksEqual((ItemStack)input, (ItemStack)GT_ModHandler.getIC2Item((String)"dynamite", (long)1L)) || GT_Utility.areStacksEqual((ItemStack)input, (ItemStack)ItemList.Block_Powderbarrel.get(1L, new Object[0]));
    }
}

