/*
 * Decompiled with CFR 0.152.
 */
package com.encraft.dz.items;

import com.encraft.dz.DayNMod;
import com.encraft.dz.ExtendedPlayer;
import com.encraft.dz.handlers.ConfigHandler;
import com.sinthoras.visualprospecting.VisualProspecting_API;
import com.sinthoras.visualprospecting.database.OreVeinPosition;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.objects.ItemData;
import gregtech.api.util.GT_OreDictUnificator;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemOreFinderTool
extends Item {
    private static Long lastUpdate = 0L;
    private static Long millisPerUpdate = 250L;
    private static int MAX_DAMAGE = 10;
    private static IIcon[] iconIndexes;
    private static int found;

    public ItemOreFinderTool() {
        this.func_77655_b("ifu_buildingKitItem");
        this.func_77625_d(1);
        this.func_111206_d("ifu:meter0");
        this.func_77627_a(true);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister p_94581_1_) {
        super.func_94581_a(p_94581_1_);
        iconIndexes = new IIcon[5];
        for (int i = 0; i <= 4; ++i) {
            ItemOreFinderTool.iconIndexes[i] = p_94581_1_.func_94245_a("ifu:meter" + i);
        }
    }

    public boolean func_82788_x() {
        return false;
    }

    public void func_77622_d(ItemStack itemStack, World world, EntityPlayer player) {
        itemStack.field_77990_d = new NBTTagCompound();
    }

    public static ItemStack inventoryContainsAAD(InventoryPlayer inventory) {
        ItemStack itemstack = null;
        for (ItemStack s : inventory.field_70462_a) {
            if (s == null || !(s.func_77973_b() instanceof ItemOreFinderTool)) continue;
            itemstack = s;
            break;
        }
        return itemstack;
    }

    public void func_77663_a(ItemStack itemstack, World world, Entity entity, int par4, boolean par5) {
        if (entity == null || world == null) {
            return;
        }
        if (new Date().getTime() <= lastUpdate) {
            return;
        }
        lastUpdate = Long.valueOf(new Date().getTime()) + millisPerUpdate;
        if (world.field_72995_K) {
            found = MAX_DAMAGE - itemstack.func_77960_j();
            if (found < 0) {
                found = 0;
            }
            switch (found) {
                case 0: {
                    this.field_77791_bV = iconIndexes[0];
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    this.field_77791_bV = iconIndexes[1];
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    this.field_77791_bV = iconIndexes[2];
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    this.field_77791_bV = iconIndexes[3];
                    break;
                }
                default: {
                    this.field_77791_bV = iconIndexes[4];
                }
            }
            if (found >= MAX_DAMAGE / 2 && ConfigHandler.wandSound) {
                world.func_72980_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, "ic2:tools.Treetap", 0.6f, 0.8f, true);
            }
        } else {
            if (!ConfigHandler.aEnableEverywhere && world.field_73011_w.field_76574_g != 0 && world.field_73011_w.field_76574_g != -1 && !world.field_73011_w.func_80007_l().equals("Twilight Forest")) {
                return;
            }
            if (!(entity instanceof EntityPlayer)) {
                return;
            }
            ItemStack searchItem = ExtendedPlayer.get((EntityPlayer)((EntityPlayer)entity)).inventorybk.func_70301_a(0);
            if (searchItem == null) {
                itemstack.func_77964_b(MAX_DAMAGE);
                return;
            }
            if (ItemOreFinderTool.inventoryContainsAAD(((EntityPlayer)entity).field_71071_by) == null) {
                itemstack.func_77964_b(MAX_DAMAGE);
                return;
            }
            for (String ss : ConfigHandler.blacklist) {
                if (ss == null || !ss.equals(searchItem.func_77977_a())) continue;
                itemstack.func_77964_b(MAX_DAMAGE);
                return;
            }
            ItemData data = GT_OreDictUnificator.getAssociation((ItemStack)searchItem);
            boolean vanilla = data == null || data.mMaterial == null || data.mMaterial.mMaterial == null;
            int id = vanilla ? Item.func_150891_b((Item)searchItem.func_77973_b()) : 0;
            double cur_x = entity.field_70165_t;
            double cur_y = entity.field_70163_u;
            double cur_z = entity.field_70161_v;
            int min_x = (int)cur_x - ConfigHandler.xzAreaRadius - 1;
            int min_y = (int)cur_y - ConfigHandler.yAreaRadius;
            int min_z = (int)cur_z - ConfigHandler.xzAreaRadius;
            int max_x = (int)cur_x + ConfigHandler.xzAreaRadius;
            int max_y = (int)cur_y + ConfigHandler.yAreaRadius;
            int max_z = (int)cur_z + ConfigHandler.xzAreaRadius + 1;
            boolean keepLooking = true;
            found = 0;
            for (int z1 = min_z; z1 < max_z && keepLooking; ++z1) {
                for (int x1 = min_x; x1 < max_x && keepLooking; ++x1) {
                    for (int y1 = min_y; y1 < max_y && keepLooking; ++y1) {
                        Block tBlock = world.func_147439_a(x1, y1, z1);
                        int meta = tBlock.func_149643_k(world, x1, y1, z1);
                        ItemStack inWorld = new ItemStack(tBlock, 1, meta);
                        if (!vanilla) {
                            ItemData dataInWorld = GT_OreDictUnificator.getAssociation((ItemStack)inWorld);
                            if (dataInWorld == null || dataInWorld.mPrefix == null || dataInWorld.mMaterial == null || dataInWorld.mMaterial.mMaterial == null) continue;
                            List<OrePrefixes> oreTypes = Arrays.asList(OrePrefixes.ore, OrePrefixes.oreBasalt, OrePrefixes.oreBlackgranite, OrePrefixes.oreEnd, OrePrefixes.oreEndstone, OrePrefixes.oreMarble, OrePrefixes.oreNether, OrePrefixes.oreNetherrack, OrePrefixes.oreRedgranite, OrePrefixes.oreRich, OrePrefixes.oreDense, OrePrefixes.oreGem, OrePrefixes.denseore);
                            if (dataInWorld.mMaterial.mMaterial != data.mMaterial.mMaterial || !oreTypes.contains(dataInWorld.mPrefix)) continue;
                            ++found;
                            keepLooking = this.shouldKeepLooking();
                            this.checkGtOreFound(world, entity, vanilla, keepLooking, z1, x1, dataInWorld);
                            continue;
                        }
                        if (Item.func_150891_b((Item)inWorld.func_77973_b()) != id || inWorld.func_77960_j() != searchItem.func_77960_j()) continue;
                        ++found;
                        keepLooking = this.shouldKeepLooking();
                    }
                }
            }
            itemstack.func_77964_b(MAX_DAMAGE - found);
        }
    }

    private List<OreVeinPosition> listVeinsInProximityContaining(short foundMaterialMetaId, int blocX, int blockZ, World world) {
        return VisualProspecting_API.LogicalServer.prospectOreVeinsWithinRadius((int)world.field_73011_w.field_76574_g, (int)blocX, (int)blockZ, (int)48).stream().filter(it -> it.veinType.containsOre(foundMaterialMetaId)).collect(Collectors.toList());
    }

    private void checkGtOreFound(World world, Entity entity, boolean vanilla, boolean keepLooking, int z1, int x1, ItemData dataInWorld) {
        if (!vanilla && !world.field_72995_K && !keepLooking && entity instanceof EntityPlayer) {
            short foundMaterialMetaId = (short)dataInWorld.mMaterial.mMaterial.mMetaItemSubID;
            List<OreVeinPosition> discoveredOreVeins = this.listVeinsInProximityContaining(foundMaterialMetaId, x1, z1, world);
            VisualProspecting_API.LogicalServer.sendProspectionResultsToClient((EntityPlayerMP)((EntityPlayerMP)entity), discoveredOreVeins, Collections.emptyList());
        }
    }

    private boolean shouldKeepLooking() {
        return found < MAX_DAMAGE;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean par4) {
        if (itemStack.field_77990_d != null) {
            String toFindStr2 = "";
            String toFindStr3 = "";
            if (ExtendedPlayer.get((EntityPlayer)Minecraft.func_71410_x().field_71439_g).inventorybk.func_70301_a(0) != null) {
                toFindStr2 = ExtendedPlayer.get((EntityPlayer)Minecraft.func_71410_x().field_71439_g).inventorybk.func_70301_a(0).func_82833_r();
                toFindStr3 = ExtendedPlayer.get((EntityPlayer)Minecraft.func_71410_x().field_71439_g).inventorybk.func_70301_a(0).func_77977_a();
                String[] splitFind = toFindStr3.split("\\.");
                if (splitFind[1].equals("blockores")) {
                    short tMetaID = (short)(Integer.parseInt(splitFind[2]) % 1000);
                    toFindStr3 = splitFind[0] + "." + splitFind[1] + "." + tMetaID;
                }
            }
            if (!toFindStr2.isEmpty()) {
                list.add("I want to find: " + toFindStr2);
            }
            if (!toFindStr3.isEmpty()) {
                list.add(toFindStr3);
            }
            list.add("Put ore block you want to find in item inventory -");
            list.add("SHIFT+RIGHT CLICK on ground to open inventory");
            list.add("You can only use 1 finder at a time");
            list.add("Search radius X, Z: " + ConfigHandler.xzAreaRadius + " Y: " + ConfigHandler.yAreaRadius);
            if (!ConfigHandler.aEnableEverywhere) {
                list.add("** DOES NOT WORK IN SPACE! **");
                list.add("Overworld, Nether, Twilight Forest only");
            }
        }
    }

    public boolean func_77648_a(ItemStack itemstack, EntityPlayer entityPlayer, World world, int x, int y, int z, int sciankaKliknieta, float objetosc_x, float pbjetosc_y, float objetosc_z) {
        if (entityPlayer.func_70093_af() && !world.field_72995_K) {
            entityPlayer.openGui((Object)DayNMod.instance, DayNMod.GUI_CUSTOM_INV1, entityPlayer.field_70170_p, (int)entityPlayer.field_70165_t, (int)entityPlayer.field_70163_u, (int)entityPlayer.field_70161_v);
        }
        return true;
    }

    static {
        found = 0;
    }
}

