/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.render;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import java.util.HashMap;
import java.util.Map;
import mods.railcraft.client.render.IBlockRenderer;
import mods.railcraft.client.render.ICombinedRenderer;
import mods.railcraft.client.render.IInvRenderer;
import mods.railcraft.client.render.ItemRenderer;
import mods.railcraft.client.render.RenderTools;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;

public class BlockRenderer
implements ISimpleBlockRenderingHandler,
IInvRenderer {
    private final Map<Integer, IBlockRenderer> blockRenderers = new HashMap<Integer, IBlockRenderer>();
    private final Map<Integer, IInvRenderer> itemRenderers = new HashMap<Integer, IInvRenderer>();
    private ICombinedRenderer defaultRenderer = new DefaultRenderer();
    private final ItemRenderer itemRenderer;
    private final Block block;

    public BlockRenderer(Block block) {
        this.block = block;
        this.itemRenderer = new ItemRenderer(this);
    }

    public void addCombinedRenderer(int meta, ICombinedRenderer renderer) {
        this.blockRenderers.put(meta, renderer);
        this.itemRenderers.put(meta, renderer);
    }

    public void addBlockRenderer(int meta, IBlockRenderer renderer) {
        this.blockRenderers.put(meta, renderer);
    }

    public void addItemRenderer(int meta, IInvRenderer renderer) {
        this.itemRenderers.put(meta, renderer);
    }

    public void setDefaultRenderer(ICombinedRenderer renderer) {
        this.defaultRenderer = renderer;
    }

    public IItemRenderer getItemRenderer() {
        return this.itemRenderer;
    }

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderblocks) {
        int meta;
        IBlockRenderer renderer;
        if (!this.blockRenderers.isEmpty() && (renderer = this.blockRenderers.get(meta = world.func_72805_g(x, y, z))) != null) {
            renderer.renderBlock(renderblocks, world, x, y, z, block);
            return true;
        }
        this.defaultRenderer.renderBlock(renderblocks, world, x, y, z, block);
        return true;
    }

    @Override
    public void renderItem(RenderBlocks renderBlocks, ItemStack item, IItemRenderer.ItemRenderType renderType) {
        IInvRenderer renderer = this.itemRenderers.get(item.func_77960_j());
        if (renderer != null) {
            renderer.renderItem(renderBlocks, item, renderType);
            return;
        }
        this.defaultRenderer.renderItem(renderBlocks, item, renderType);
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }

    public int getRenderId() {
        return this.block.func_149645_b();
    }

    public Block getBlock() {
        return this.block;
    }

    public class DefaultRenderer
    implements ICombinedRenderer {
        @Override
        public void renderItem(RenderBlocks renderblocks, ItemStack item, IItemRenderer.ItemRenderType renderType) {
            int meta = item.func_77960_j();
            BlockRenderer.this.block.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            RenderTools.renderBlockOnInventory(renderblocks, BlockRenderer.this.block, meta, 1.0f);
        }

        @Override
        public void renderBlock(RenderBlocks renderblocks, IBlockAccess world, int x, int y, int z, Block block) {
            block.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            RenderTools.renderStandardBlock(renderblocks, block, x, y, z);
        }
    }

    protected class DoNothingRenderer
    implements IBlockRenderer {
        protected DoNothingRenderer() {
        }

        @Override
        public void renderBlock(RenderBlocks renderblocks, IBlockAccess world, int i, int j, int k, Block block) {
        }
    }
}

