/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.lighting;

import codechicken.lib.lighting.PlanarLightModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.vec.BlockCoord;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;

public class PlanarLightMatrix
extends PlanarLightModel {
    public static final int operationIndex = CCRenderState.registerOperation();
    public static PlanarLightMatrix instance = new PlanarLightMatrix();
    public IBlockAccess access;
    public BlockCoord pos = new BlockCoord();
    private int sampled = 0;
    public int[] brightness = new int[6];

    public PlanarLightMatrix() {
        super(PlanarLightModel.standardLightModel.colours);
    }

    public PlanarLightMatrix locate(IBlockAccess a, int x, int y, int z) {
        this.access = a;
        this.pos.set(x, y, z);
        this.sampled = 0;
        return this;
    }

    public int brightness(int side) {
        if ((this.sampled & 1 << side) == 0) {
            Block b = this.access.func_147439_a(this.pos.x, this.pos.y, this.pos.z);
            this.brightness[side] = this.access.func_72802_i(this.pos.x, this.pos.y, this.pos.z, b.getLightValue(this.access, this.pos.x, this.pos.y, this.pos.z));
            this.sampled |= 1 << side;
        }
        return this.brightness[side];
    }

    @Override
    public boolean load() {
        CCRenderState.pipeline.addDependency(CCRenderState.sideAttrib);
        return true;
    }

    @Override
    public void operate() {
        super.operate();
        CCRenderState.setBrightness(this.brightness(CCRenderState.side));
    }

    @Override
    public int operationID() {
        return operationIndex;
    }
}

