/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.api.spell;

import WayofTime.alchemicalWizardry.api.spell.ComplexSpellEffect;
import WayofTime.alchemicalWizardry.api.spell.ComplexSpellModifier;
import WayofTime.alchemicalWizardry.api.spell.ComplexSpellType;
import WayofTime.alchemicalWizardry.api.spell.SpellEffectRegistry;
import WayofTime.alchemicalWizardry.api.spell.SpellEnhancement;
import WayofTime.alchemicalWizardry.api.spell.SpellParadigm;
import net.minecraft.nbt.NBTTagCompound;

public class SpellEffect {
    public ComplexSpellType type;
    public ComplexSpellModifier modifier;
    protected int powerEnhancement;
    protected int costEnhancement;
    protected int potencyEnhancement;

    public SpellEffect() {
        this(ComplexSpellType.FIRE);
    }

    public SpellEffect(ComplexSpellType type) {
        this(type, ComplexSpellModifier.DEFAULT);
    }

    public SpellEffect(ComplexSpellType type, ComplexSpellModifier modifier) {
        this.type = type;
        this.modifier = modifier;
        this.powerEnhancement = 0;
        this.potencyEnhancement = 0;
        this.costEnhancement = 0;
    }

    public void enhanceEffect(SpellEnhancement enh) {
        if (enh != null) {
            switch (enh.getState()) {
                case 0: {
                    ++this.powerEnhancement;
                    break;
                }
                case 1: {
                    ++this.costEnhancement;
                    break;
                }
                case 2: {
                    ++this.potencyEnhancement;
                }
            }
        }
    }

    public void modifyEffect(ComplexSpellModifier mod) {
        if (mod != null) {
            this.modifier = mod;
        }
    }

    public void modifyParadigm(SpellParadigm parad) {
        if (parad == null) {
            return;
        }
        Class<?> paraClass = parad.getClass();
        ComplexSpellEffect effect = SpellEffectRegistry.getSpellEffect(paraClass, this.type, this.modifier, this.powerEnhancement, this.potencyEnhancement, this.costEnhancement);
        if (effect != null) {
            effect.modifyParadigm(parad);
        }
    }

    public int getCostOfEffect(SpellParadigm parad) {
        if (parad == null) {
            return 0;
        }
        Class<?> paraClass = parad.getClass();
        ComplexSpellEffect effect = SpellEffectRegistry.getSpellEffect(paraClass, this.type, this.modifier, this.powerEnhancement, this.potencyEnhancement, this.costEnhancement);
        if (effect == null) {
            return 0;
        }
        return effect.getCostOfEffect();
    }

    public NBTTagCompound getTag() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("Class", this.getClass().getName());
        tag.func_74778_a("type", SpellEffectRegistry.getKeyForType(this.type));
        tag.func_74778_a("modifier", SpellEffectRegistry.getKeyForModifier(this.modifier));
        tag.func_74768_a("power", this.powerEnhancement);
        tag.func_74768_a("cost", this.costEnhancement);
        tag.func_74768_a("potency", this.potencyEnhancement);
        return tag;
    }

    public static SpellEffect getEffectFromTag(NBTTagCompound tag) {
        block6: {
            try {
                Class<?> clazz = Class.forName(tag.func_74779_i("Class"));
                if (clazz == null) break block6;
                try {
                    Object obj = clazz.newInstance();
                    if (obj instanceof SpellEffect) {
                        SpellEffect eff = (SpellEffect)obj;
                        eff.type = SpellEffectRegistry.getTypeForKey(tag.func_74779_i("type"));
                        eff.modifier = SpellEffectRegistry.getModifierForKey(tag.func_74779_i("modifier"));
                        eff.powerEnhancement = tag.func_74762_e("power");
                        eff.costEnhancement = tag.func_74762_e("cost");
                        eff.potencyEnhancement = tag.func_74762_e("potency");
                        return eff;
                    }
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public int getPowerEnhancements() {
        return this.powerEnhancement;
    }

    public int getPotencyEnhancements() {
        return this.potencyEnhancement;
    }

    public int getCostEnhancements() {
        return this.costEnhancement;
    }
}

