/*
 * Decompiled with CFR 0.152.
 */
package kubatech.api.helpers;

import com.kuba6000.mobsinfo.api.utils.ItemID;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import java.io.IOException;
import java.util.ArrayList;
import kubatech.api.Variables;
import kubatech.api.implementations.KubaTechGTMultiBlockBase;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;

public class GTHelper {
    public static long getMaxInputEU(GT_MetaTileEntity_MultiBlockBase mte) {
        if (mte instanceof KubaTechGTMultiBlockBase) {
            return ((KubaTechGTMultiBlockBase)mte).getMaxInputEu();
        }
        long rEU = 0L;
        for (GT_MetaTileEntity_Hatch_Energy tHatch : mte.mEnergyHatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            rEU += tHatch.maxEUInput() * tHatch.maxAmperesIn();
        }
        return rEU;
    }

    public static double getVoltageTierD(long voltage) {
        return Math.log((double)voltage / 8.0) / Variables.ln4;
    }

    public static double getVoltageTierD(GT_MetaTileEntity_MultiBlockBase mte) {
        return Math.log((double)GTHelper.getMaxInputEU(mte) / 8.0) / Variables.ln4;
    }

    public static int getVoltageTier(long voltage) {
        return (int)GTHelper.getVoltageTierD(voltage);
    }

    public static int getVoltageTier(GT_MetaTileEntity_MultiBlockBase mte) {
        return (int)GTHelper.getVoltageTierD(mte);
    }

    public static class StackableItemSlot {
        public final int count;
        public final ItemStack stack;
        public final ArrayList<Integer> realSlots;

        public StackableItemSlot(int count, ItemStack stack, ArrayList<Integer> realSlots) {
            this.count = count;
            this.stack = stack;
            this.realSlots = realSlots;
        }

        public void write(PacketBuffer buffer) throws IOException {
            buffer.func_150787_b(this.count);
            buffer.func_150788_a(this.stack);
        }

        public static StackableItemSlot read(PacketBuffer buffer) throws IOException {
            return new StackableItemSlot(buffer.func_150792_a(), buffer.func_150791_c(), new ArrayList<Integer>());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof StackableItemSlot)) {
                return false;
            }
            StackableItemSlot other = (StackableItemSlot)obj;
            return this.count == other.count && ItemID.createNoCopy((ItemStack)this.stack, (boolean)false).hashCode() == ItemID.createNoCopy((ItemStack)other.stack, (boolean)false).hashCode() && this.realSlots.equals(other.realSlots);
        }
    }
}

