/*
 * Decompiled with CFR 0.152.
 */
package kubatech.api.enums;

import gregtech.api.enums.GT_Values;
import gregtech.api.interfaces.IItemContainer;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public enum ItemList implements IItemContainer
{
    ExtremeExterminationChamber,
    ExtremeIndustrialApiary,
    ExtremeIndustrialGreenhouse,
    LegendaryBlackTea,
    LegendaryButterflyTea,
    LegendaryEarlGrayTea,
    LegendaryGreenTea,
    LegendaryLemonTea,
    LegendaryMilkTea,
    LegendaryOolongTea,
    LegendaryPeppermintTea,
    LegendaryPuerhTea,
    LegendaryRedTea,
    LegendaryWhiteTea,
    LegendaryYellowTea,
    LegendaryUltimateTea,
    BlackTea,
    EarlGrayTea,
    GreenTea,
    LemonTea,
    MilkTea,
    OolongTea,
    PeppermintTea,
    PuerhTea,
    WhiteTea,
    YellowTea,
    BlackTeaLeaf,
    GreenTeaLeaf,
    OolongTeaLeaf,
    PuerhTeaLeaf,
    WhiteTeaLeaf,
    YellowTeaLeaf,
    TeaLeafDehydrated,
    SteamedTeaLeaf,
    RolledTeaLeaf,
    OxidizedTeaLeaf,
    FermentedTeaLeaf,
    BruisedTeaLeaf,
    PartiallyOxidizedTeaLeaf,
    TeaAcceptorResearchNote,
    TeaAcceptor,
    TeaStorage,
    Beeeeee;

    private ItemStack mStack;
    private boolean mHasNotBeenSet = true;

    public IItemContainer set(Item aItem) {
        this.mHasNotBeenSet = false;
        if (aItem == null) {
            return this;
        }
        ItemStack aStack = new ItemStack(aItem, 1, 0);
        this.mStack = GT_Utility.copyAmount((long)1L, (Object[])new Object[]{aStack});
        return this;
    }

    public IItemContainer set(ItemStack aStack) {
        this.mHasNotBeenSet = false;
        this.mStack = GT_Utility.copyAmount((long)1L, (Object[])new Object[]{aStack});
        return this;
    }

    public Item getItem() {
        if (this.mHasNotBeenSet) {
            throw new IllegalAccessError("The Enum '" + this.name() + "' has not been set to an Item at this time!");
        }
        if (GT_Utility.isStackInvalid((Object)this.mStack)) {
            return null;
        }
        return this.mStack.func_77973_b();
    }

    public Block getBlock() {
        if (this.mHasNotBeenSet) {
            throw new IllegalAccessError("The Enum '" + this.name() + "' has not been set to an Item at this time!");
        }
        return GT_Utility.getBlockFromItem((Item)this.getItem());
    }

    public final boolean hasBeenSet() {
        return !this.mHasNotBeenSet;
    }

    public boolean isStackEqual(Object aStack) {
        return this.isStackEqual(aStack, false, false);
    }

    public boolean isStackEqual(Object aStack, boolean aWildcard, boolean aIgnoreNBT) {
        if (GT_Utility.isStackInvalid((Object)aStack)) {
            return false;
        }
        return GT_Utility.areUnificationsEqual((ItemStack)((ItemStack)aStack), (ItemStack)(aWildcard ? this.getWildcard(1L, new Object[0]) : this.get(1L, new Object[0])), (boolean)aIgnoreNBT);
    }

    public ItemStack get(long aAmount, Object ... aReplacements) {
        if (this.mHasNotBeenSet) {
            throw new IllegalAccessError("The Enum '" + this.name() + "' has not been set to an Item at this time!");
        }
        if (GT_Utility.isStackInvalid((Object)this.mStack)) {
            return GT_Utility.copyAmount((long)aAmount, (Object[])aReplacements);
        }
        return GT_Utility.copyAmount((long)aAmount, (Object[])new Object[]{GT_OreDictUnificator.get((ItemStack)this.mStack)});
    }

    public ItemStack getWildcard(long aAmount, Object ... aReplacements) {
        if (this.mHasNotBeenSet) {
            throw new IllegalAccessError("The Enum '" + this.name() + "' has not been set to an Item at this time!");
        }
        if (GT_Utility.isStackInvalid((Object)this.mStack)) {
            return GT_Utility.copyAmount((long)aAmount, (Object[])aReplacements);
        }
        return GT_Utility.copyAmountAndMetaData((long)aAmount, (long)32767L, (Object[])new Object[]{GT_OreDictUnificator.get((ItemStack)this.mStack)});
    }

    public ItemStack getUndamaged(long aAmount, Object ... aReplacements) {
        if (this.mHasNotBeenSet) {
            throw new IllegalAccessError("The Enum '" + this.name() + "' has not been set to an Item at this time!");
        }
        if (GT_Utility.isStackInvalid((Object)this.mStack)) {
            return GT_Utility.copyAmount((long)aAmount, (Object[])aReplacements);
        }
        return GT_Utility.copyAmountAndMetaData((long)aAmount, (long)0L, (Object[])new Object[]{GT_OreDictUnificator.get((ItemStack)this.mStack)});
    }

    public ItemStack getAlmostBroken(long aAmount, Object ... aReplacements) {
        if (this.mHasNotBeenSet) {
            throw new IllegalAccessError("The Enum '" + this.name() + "' has not been set to an Item at this time!");
        }
        if (GT_Utility.isStackInvalid((Object)this.mStack)) {
            return GT_Utility.copyAmount((long)aAmount, (Object[])aReplacements);
        }
        return GT_Utility.copyAmountAndMetaData((long)aAmount, (long)(this.mStack.func_77958_k() - 1), (Object[])new Object[]{GT_OreDictUnificator.get((ItemStack)this.mStack)});
    }

    public ItemStack getWithName(long aAmount, String aDisplayName, Object ... aReplacements) {
        String[] tDisplayNameWords;
        ItemStack rStack = this.get(1L, aReplacements);
        if (GT_Utility.isStackInvalid((Object)rStack)) {
            return GT_Values.NI;
        }
        StringBuilder tCamelCasedDisplayNameBuilder = new StringBuilder();
        for (String tWord : tDisplayNameWords = aDisplayName.split("\\W")) {
            if (tWord.length() > 0) {
                tCamelCasedDisplayNameBuilder.append(tWord.substring(0, 1).toUpperCase(Locale.US));
            }
            if (tWord.length() <= 1) continue;
            tCamelCasedDisplayNameBuilder.append(tWord.substring(1).toLowerCase(Locale.US));
        }
        if (tCamelCasedDisplayNameBuilder.length() == 0) {
            tCamelCasedDisplayNameBuilder.append((Object)aDisplayName.hashCode());
        }
        String tKey = rStack.func_77977_a() + ".with." + tCamelCasedDisplayNameBuilder + ".name";
        rStack.func_151001_c(GT_LanguageManager.addStringLocalization((String)tKey, (String)aDisplayName));
        return GT_Utility.copyAmount((long)aAmount, (Object[])new Object[]{rStack});
    }

    public ItemStack getWithCharge(long aAmount, int aEnergy, Object ... aReplacements) {
        ItemStack rStack = this.get(1L, aReplacements);
        if (GT_Utility.isStackInvalid((Object)rStack)) {
            return null;
        }
        GT_ModHandler.chargeElectricItem((ItemStack)rStack, (int)aEnergy, (int)Integer.MAX_VALUE, (boolean)true, (boolean)false);
        return GT_Utility.copyAmount((long)aAmount, (Object[])new Object[]{rStack});
    }

    public ItemStack getWithDamage(long aAmount, long aMetaValue, Object ... aReplacements) {
        if (this.mHasNotBeenSet) {
            throw new IllegalAccessError("The Enum '" + this.name() + "' has not been set to an Item at this time!");
        }
        if (GT_Utility.isStackInvalid((Object)this.mStack)) {
            return GT_Utility.copyAmount((long)aAmount, (Object[])aReplacements);
        }
        return GT_Utility.copyAmountAndMetaData((long)aAmount, (long)aMetaValue, (Object[])new Object[]{GT_OreDictUnificator.get((ItemStack)this.mStack)});
    }

    public IItemContainer registerOre(Object ... aOreNames) {
        if (this.mHasNotBeenSet) {
            throw new IllegalAccessError("The Enum '" + this.name() + "' has not been set to an Item at this time!");
        }
        for (Object tOreName : aOreNames) {
            GT_OreDictUnificator.registerOre((Object)tOreName, (ItemStack)this.get(1L, new Object[0]));
        }
        return this;
    }

    public IItemContainer registerWildcardAsOre(Object ... aOreNames) {
        if (this.mHasNotBeenSet) {
            throw new IllegalAccessError("The Enum '" + this.name() + "' has not been set to an Item at this time!");
        }
        for (Object tOreName : aOreNames) {
            GT_OreDictUnificator.registerOre((Object)tOreName, (ItemStack)this.getWildcard(1L, new Object[0]));
        }
        return this;
    }

    public ItemStack getInternalStack_unsafe() {
        return this.mStack;
    }
}

