/*
 * Decompiled with CFR 0.152.
 */
package me.eigenraven.lwjgl3ify.core;

import com.gtnewhorizon.gtnhmixins.IEarlyMixinLoader;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.eigenraven.lwjgl3ify.core.Config;
import me.eigenraven.lwjgl3ify.core.LwjglRedirectTransformer;
import me.eigenraven.lwjgl3ify.core.PostMixinTransformInjector;
import me.eigenraven.lwjgl3ify.core.UnfinalizeObjectHoldersTransformer;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.Platform;
import org.lwjglx.Sys;
import org.spongepowered.asm.launch.GlobalProperties;
import org.spongepowered.asm.service.mojang.MixinServiceLaunchWrapper;

@IFMLLoadingPlugin.MCVersion(value="1.7.10")
@IFMLLoadingPlugin.TransformerExclusions(value={"org.lwjglx", "org.lwjgl", "org.lwjgl.input", "org.lwjglx.input"})
@IFMLLoadingPlugin.SortingIndex(value=0x7FFFFFFD)
public class Lwjgl3ifyCoremod
implements IFMLLoadingPlugin,
IEarlyMixinLoader {
    public static final Logger LOGGER = LogManager.getLogger((String)"lwjgl3ify");

    public Lwjgl3ifyCoremod() {
        Config.loadConfig();
        try {
            LaunchClassLoader launchLoader = (LaunchClassLoader)this.getClass().getClassLoader();
            launchLoader.addClassLoaderExclusion("com.sun");
            launchLoader.addClassLoaderExclusion("com.oracle");
            launchLoader.addClassLoaderExclusion("javax");
            launchLoader.addClassLoaderExclusion("jdk");
            launchLoader.addClassLoaderExclusion("org.ietf.jgss");
            launchLoader.addClassLoaderExclusion("org.jcp.xml.dsig.internal");
            launchLoader.addClassLoaderExclusion("org.omg");
            launchLoader.addClassLoaderExclusion("org.w3c.dom");
            launchLoader.addClassLoaderExclusion("org.xml.sax");
            launchLoader.addClassLoaderExclusion("org.hotswap.agent");
            launchLoader.addClassLoaderExclusion("org.lwjglx.debug");
        }
        catch (ClassCastException e) {
            LOGGER.warn("Unsupported launch class loader type " + this.getClass().getClassLoader().getClass(), (Throwable)e);
        }
        try {
            Class.forName("javax.script.ScriptEngineManager");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        if (FMLLaunchHandler.side().isClient()) {
            this.clientMacOsFix();
            Sys.initialize();
        }
    }

    private void clientMacOsFix() {
        if (Platform.get() == Platform.MACOSX) {
            Configuration.GLFW_LIBRARY_NAME.set((Object)"glfw_async");
            Configuration.GLFW_CHECK_THREAD0.set((Object)false);
            Toolkit.getDefaultToolkit();
        }
    }

    public String[] getASMTransformerClass() {
        LOGGER.info("Registering lwjgl3ify redirect transformer");
        List tweakClasses = (List)GlobalProperties.get((GlobalProperties.Keys)MixinServiceLaunchWrapper.BLACKBOARD_KEY_TWEAKCLASSES);
        if (tweakClasses != null) {
            tweakClasses.add(PostMixinTransformInjector.class.getName());
        }
        return new String[]{LwjglRedirectTransformer.class.getName(), UnfinalizeObjectHoldersTransformer.class.getName()};
    }

    public String getModContainerClass() {
        return null;
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
    }

    public String getAccessTransformerClass() {
        return null;
    }

    public String getMixinConfig() {
        return "mixins.lwjgl3ify.early.json";
    }

    public List<String> getMixins(Set<String> loadedCoreMods) {
        boolean hasFastcraft = loadedCoreMods.contains("fastcraft.Tweaker");
        boolean hasOptifine = loadedCoreMods.contains("optifine.OptiFineForgeTweaker");
        ArrayList<String> mixins = new ArrayList<String>(8);
        mixins.add("fml.ItemStackHolderRef");
        mixins.add("fml.JarDiscoverer");
        mixins.add("fml.ModVisitorAsmVersion");
        mixins.add("fml.ObjectHolderRef");
        mixins.add("fml.ObjectHolderRegistry");
        if (FMLLaunchHandler.side().isClient()) {
            boolean fcBugTriggered;
            if (Config.MIXIN_STBI_TEXTURE_LOADING) {
                LOGGER.info("Enabling STB texture loading mixin");
                mixins.add("game.MixinTextureAtlasSprite");
                mixins.add("game.MixinTextureMap");
            } else {
                LOGGER.info("Disabling STB texture loading mixin");
            }
            boolean bl = fcBugTriggered = hasFastcraft && !hasOptifine;
            if (fcBugTriggered && !Config.MIXIN_STBI_IGNORE_FASTCRAFT) {
                LOGGER.error("Not using STB stiching mixins because FastCraft is installed to prevent rapidly flashing screen. Remove FastCraft or add OptiFine to enable these performance-improving patches.");
            } else if (Config.MIXIN_STBI_TEXTURE_STICHING) {
                LOGGER.info("Enabling STB texture stitching mixin");
                mixins.add("game.MixinStitcher");
            } else {
                LOGGER.info("Disabling STB texture stitching mixin");
            }
        }
        return mixins;
    }
}

