/*
 * Decompiled with CFR 0.152.
 */
package me.eigenraven.lwjgl3ify.core;

import java.util.concurrent.atomic.AtomicBoolean;
import me.eigenraven.lwjgl3ify.Lwjgl3ify;
import org.objectweb.asm.Handle;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class FixConstantPoolInterfaceMethodRefHelper {
    public boolean transform(ClassNode node) {
        if (System.getProperty("java.specification.version", "1.8").trim().startsWith("1.8")) {
            return false;
        }
        boolean iAmAnInterface = (node.access & 0x200) != 0;
        boolean changesMade = false;
        String internalClassName = node.name;
        if (node.methods != null) {
            for (MethodNode method : node.methods) {
                if (method.instructions == null) continue;
                for (AbstractInsnNode insn : method.instructions) {
                    changesMade |= this.validateInstruction(internalClassName, iAmAnInterface, insn);
                }
            }
        }
        return changesMade;
    }

    private boolean validateInstruction(String internalClassName, boolean iAmAnInterface, AbstractInsnNode rawInsn) {
        AtomicBoolean changed = new AtomicBoolean(false);
        switch (rawInsn.getType()) {
            case 6: {
                InvokeDynamicInsnNode insn = (InvokeDynamicInsnNode)rawInsn;
                insn.bsm = this.fixHandle(internalClassName, iAmAnInterface, insn.bsm, changed);
                if (insn.bsmArgs == null) break;
                for (int i = 0; i < insn.bsmArgs.length; ++i) {
                    Object arg = insn.bsmArgs[i];
                    if (!(arg instanceof Handle)) continue;
                    Handle handle = (Handle)arg;
                    insn.bsmArgs[i] = this.fixHandle(internalClassName, iAmAnInterface, handle, changed);
                }
                break;
            }
        }
        return changed.get();
    }

    private Handle fixHandle(String internalClassName, boolean iAmAnInterface, Handle handle, AtomicBoolean changed) {
        if (!handle.isInterface()) {
            boolean fixSelfReference = handle.getOwner().equals(internalClassName) && iAmAnInterface;
            boolean fixJavaReference = false;
            if (!fixSelfReference && handle.getOwner().startsWith("java/")) {
                String regularName = handle.getOwner().replace('/', '.');
                try {
                    Class<?> javaClass = Class.forName(regularName);
                    if (javaClass.isInterface()) {
                        fixJavaReference = true;
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    Lwjgl3ify.LOG.warn("Reference to non-existing java class {} found.", new Object[]{regularName, cnfe});
                }
            }
            if (fixSelfReference || fixJavaReference) {
                changed.set(true);
                return new Handle(handle.getTag(), handle.getOwner(), handle.getName(), handle.getDesc(), true);
            }
        }
        return handle;
    }
}

