/*
 * Decompiled with CFR 0.152.
 */
package me.eigenraven.lwjgl3ify;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ICrashCallable;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.lang.reflect.Field;
import java.util.List;
import me.eigenraven.lwjgl3ify.CommonProxy;
import me.eigenraven.lwjgl3ify.Lwjgl3ify;
import me.eigenraven.lwjgl3ify.client.GLInfoCrashCallable;
import me.eigenraven.lwjgl3ify.core.Config;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.Version;

public class ClientProxy
extends CommonProxy {
    static final String javaVersion;
    static final String lwjglVersion;

    @Override
    public void runCompatHooks() {
        super.runCompatHooks();
        this.replaceOpenGLCrashHandler();
    }

    @Override
    public void registerF3Handler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void replaceOpenGLCrashHandler() {
        try {
            Field callablesField = FMLCommonHandler.class.getDeclaredField("crashCallables");
            callablesField.setAccessible(true);
            List crashCallables = (List)callablesField.get(FMLCommonHandler.instance());
            for (int i = 0; i < crashCallables.size(); ++i) {
                ICrashCallable original = (ICrashCallable)crashCallables.get(i);
                if (!"GL info".equals(original.getLabel()) || original instanceof GLInfoCrashCallable) continue;
                crashCallables.set(i, new GLInfoCrashCallable());
            }
        }
        catch (ReflectiveOperationException e) {
            Lwjgl3ify.LOG.error("Could not access crash callables to make them OpenGL thread-safe", (Throwable)e);
        }
    }

    @SubscribeEvent
    public void onRenderGameOverlayTextEvent(RenderGameOverlayEvent.Text event) {
        if (Minecraft.func_71410_x().field_71474_y.field_74330_P && event.type == RenderGameOverlayEvent.ElementType.TEXT) {
            if (Config.SHOW_LWJGL_VERSION) {
                event.right.add(Math.min(3, event.right.size()), lwjglVersion);
            }
            if (Config.SHOW_JAVA_VERSION) {
                event.right.add(Math.min(3, event.right.size()), javaVersion);
            }
        }
    }

    static {
        lwjglVersion = "LWJGL: " + Version.getVersion();
        String javaVersionRaw = "Java: " + System.getProperty("java.version");
        if (javaVersionRaw.length() > 32) {
            javaVersionRaw = javaVersionRaw.substring(0, 29) + "...";
        }
        javaVersion = javaVersionRaw;
    }
}

