/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.render;

import com.cricketcraft.chisel.api.carving.CarvingUtils;
import com.cricketcraft.chisel.api.rendering.TextureType;
import com.cricketcraft.chisel.shadow.team.chisel.ctmlib.RenderBlocksCTM;
import com.cricketcraft.chisel.shadow.team.chisel.ctmlib.TextureSubmap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.Triple;
import team.chisel.client.render.SubmapManagerBase;

public class SubmapManagerCombinedCTM
extends SubmapManagerBase {
    @SideOnly(value=Side.CLIENT)
    private RenderBlocksCTM rb;
    private TextureSubmap submap;
    private TextureSubmap smallSubmap;
    private int size;
    private String texturePath;
    private int meta;
    private IIcon defaultIcon;
    private TextureType rType;

    public SubmapManagerCombinedCTM(int meta, String texturePath, TextureType rType) {
        assert (rType == TextureType.R16 || rType == TextureType.R9 || rType == TextureType.R4 || rType == TextureType.V4 || rType == TextureType.V9) : "Not a valid random type!";
        this.meta = meta;
        this.texturePath = texturePath;
        this.size = Integer.parseInt(rType.name().substring(1, rType.name().length()));
        this.rType = rType;
    }

    @Override
    public IIcon getIcon(int side, int meta) {
        return this.defaultIcon;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public RenderBlocks createRenderContext(RenderBlocks rendererOld, Block block, IBlockAccess world) {
        if (this.rb == null) {
            this.rb = new RenderBlocksCombinedCTM();
        }
        this.rb.func_147775_a(block);
        return this.rb;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(String modName, Block block, IIconRegister register) {
        IIcon base = register.func_94245_a(modName + ":" + this.texturePath);
        int wh = (int)Math.sqrt(this.size);
        TextureSubmap[][] submaps = new TextureSubmap[wh][wh];
        TextureSubmap[][] submapsSmall = new TextureSubmap[wh][wh];
        for (int i = 0; i < this.size; ++i) {
            TextureType.AbstractSubmapManager manager = (TextureType.AbstractSubmapManager)TextureType.CTMX.createManagerFor(CarvingUtils.getDefaultVariationFor(block, this.meta, 0), this.texturePath + "-" + i);
            manager.registerIcons(modName, block, register);
            Object cached = manager.getCachedObject();
            Triple triple = (Triple)cached;
            submaps[i % wh][i / wh] = (TextureSubmap)triple.getMiddle();
            submapsSmall[i % wh][i / wh] = (TextureSubmap)triple.getRight();
            if (i != 0) continue;
            this.defaultIcon = ((TextureSubmap)triple.getRight()).getBaseIcon();
        }
        this.submap = new Submap(base, wh, submaps);
        this.smallSubmap = new Submap(base, wh, submapsSmall);
    }

    private class Submap
    extends TextureSubmap {
        private TextureSubmap[][] submap;

        public Submap(IIcon base, int wh, TextureSubmap[][] submap) {
            super(base, wh, wh);
            this.submap = submap;
        }

        @Override
        public void texturesStitched() {
            for (int i = 0; i < this.icons.length; ++i) {
                for (int j = 0; j < this.icons[i].length; ++j) {
                    this.icons[i][j] = this.submap[i][j];
                    this.submap[i][j].texturesStitched();
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private class RenderBlocksCombinedCTM
    extends RenderBlocksCTM {
        private RenderBlocksCombinedCTM() {
        }

        @Override
        public void func_147798_e(Block block, double x, double y, double z, IIcon icon) {
            this.setIcons(SubmapManagerCombinedCTM.this.rType, x, y, z, ForgeDirection.WEST);
            super.func_147798_e(block, x, y, z, this.inWorld ? this.submapSmall.getSubIcon(0, 0) : icon);
        }

        @Override
        public void func_147764_f(Block block, double x, double y, double z, IIcon icon) {
            this.setIcons(SubmapManagerCombinedCTM.this.rType, x, y, z, ForgeDirection.EAST);
            super.func_147764_f(block, x, y, z, this.inWorld ? this.submapSmall.getSubIcon(0, 0) : icon);
        }

        @Override
        public void func_147768_a(Block block, double x, double y, double z, IIcon icon) {
            this.setIcons(SubmapManagerCombinedCTM.this.rType, x, y, z, ForgeDirection.DOWN);
            super.func_147768_a(block, x, y, z, this.inWorld ? this.submapSmall.getSubIcon(0, 0) : icon);
        }

        @Override
        public void func_147806_b(Block block, double x, double y, double z, IIcon icon) {
            this.setIcons(SubmapManagerCombinedCTM.this.rType, x, y, z, ForgeDirection.UP);
            super.func_147806_b(block, x, y, z, this.inWorld ? this.submapSmall.getSubIcon(0, 0) : icon);
        }

        @Override
        public void func_147761_c(Block block, double x, double y, double z, IIcon icon) {
            this.setIcons(SubmapManagerCombinedCTM.this.rType, x, y, z, ForgeDirection.NORTH);
            super.func_147761_c(block, x, y, z, this.inWorld ? this.submapSmall.getSubIcon(0, 0) : icon);
        }

        @Override
        public void func_147734_d(Block block, double x, double y, double z, IIcon icon) {
            this.setIcons(SubmapManagerCombinedCTM.this.rType, x, y, z, ForgeDirection.SOUTH);
            super.func_147734_d(block, x, y, z, this.inWorld ? this.submapSmall.getSubIcon(0, 0) : icon);
        }

        private void setIcons(TextureType type, double x, double y, double z, ForgeDirection side) {
            int ix = MathHelper.func_76128_c((double)x);
            int iy = MathHelper.func_76128_c((double)y);
            int iz = MathHelper.func_76128_c((double)z);
            if (type == TextureType.V4 || type == TextureType.V9) {
                this.submap = (TextureSubmap)TextureType.getVIcon(SubmapManagerCombinedCTM.this.rType, SubmapManagerCombinedCTM.this.submap, ix, iy, iz, side.ordinal());
                this.submapSmall = (TextureSubmap)TextureType.getVIcon(SubmapManagerCombinedCTM.this.rType, SubmapManagerCombinedCTM.this.smallSubmap, ix, iy, iz, side.ordinal());
            } else {
                this.submap = (TextureSubmap)TextureType.getRIcon(SubmapManagerCombinedCTM.this.rType, SubmapManagerCombinedCTM.this.submap, ix, iy, iz, side.ordinal());
                this.submapSmall = (TextureSubmap)TextureType.getRIcon(SubmapManagerCombinedCTM.this.rType, SubmapManagerCombinedCTM.this.smallSubmap, ix, iy, iz, side.ordinal());
            }
        }
    }
}

