/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.gui;

import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.client.gui.widgets.IScrollSource;
import appeng.core.localization.GuiText;
import appeng.util.item.AEItemStack;
import com.glodblock.github.client.gui.base.FCGuiMonitor;
import com.glodblock.github.client.gui.container.ContainerFluidMonitor;
import com.glodblock.github.client.me.FluidRepo;
import com.glodblock.github.common.item.ItemFluidDrop;
import com.glodblock.github.util.Util;
import java.util.List;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;

public class GuiFluidMonitor
extends FCGuiMonitor<IAEFluidStack> {
    public GuiFluidMonitor(InventoryPlayer inventoryPlayer, ITerminalHost te, ContainerFluidMonitor c) {
        super(inventoryPlayer, te, c);
        this.repo = new FluidRepo((IScrollSource)this.getScrollBar(), this);
        this.setScrollBar();
    }

    @Override
    public void postUpdate(List<IAEFluidStack> list, boolean resort) {
        for (IAEFluidStack is : list) {
            AEItemStack stack = AEItemStack.create((ItemStack)ItemFluidDrop.newDisplayStack(is.getFluidStack()));
            stack.setStackSize(is.getStackSize());
            this.repo.postUpdate((IAEItemStack)stack);
        }
        if (resort) {
            this.repo.updateView();
        }
        this.setScrollBar();
    }

    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.getGuiDisplayName(GuiText.Terminal.getLocal()), 8, 6, 0x404040);
        this.field_146289_q.func_78276_b(GuiText.inventory.getLocal(), 8, this.field_147000_g - 96 + 3, 0x404040);
    }

    @Override
    protected IAEItemStack transformItem(IAEItemStack stack) {
        if (stack.getItem() instanceof ItemFluidDrop) {
            return ItemFluidDrop.newAeStack(ItemFluidDrop.getAeFluidStack(stack));
        }
        return stack;
    }

    public void setTextFieldValue(String displayName, int mousex, int mousey, ItemStack stack) {
        if (Util.getFluidFromItem(stack) != null) {
            this.setSearchString(Util.getFluidFromItem(stack).getLocalizedName(), true);
        }
    }
}

