/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.AEApi;
import appeng.api.config.TunnelType;
import appeng.api.definitions.IParts;
import appeng.api.implementations.items.IMemoryCard;
import appeng.api.implementations.items.MemoryCardMessages;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartItem;
import appeng.me.GridAccessException;
import appeng.me.cache.P2PCache;
import appeng.parts.p2p.PartP2PTunnel;
import appeng.util.Platform;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;

public class PartP2PTunnelNormal<T extends PartP2PTunnelNormal>
extends PartP2PTunnel<T> {
    public PartP2PTunnelNormal(ItemStack is) {
        super(is);
    }

    @Override
    public boolean onPartActivate(EntityPlayer player, Vec3 pos) {
        Item item;
        ItemStack is = player.field_71071_by.func_70448_g();
        TunnelType tt = AEApi.instance().registries().p2pTunnel().getTunnelTypeByItem(is);
        if (is != null && (item = is.func_77973_b()) instanceof IMemoryCard) {
            IPart testPart;
            IMemoryCard mc = (IMemoryCard)item;
            if (ForgeEventFactory.onItemUseStart((EntityPlayer)player, (ItemStack)is, (int)1) <= 0) {
                return false;
            }
            NBTTagCompound data = mc.getData(is);
            ItemStack newType = ItemStack.func_77949_a((NBTTagCompound)data);
            long freq = data.func_74763_f("freq");
            if (newType != null && newType.func_77973_b() instanceof IPartItem && (testPart = ((IPartItem)newType.func_77973_b()).createPartFromItemStack(newType)) instanceof PartP2PTunnelNormal) {
                this.getHost().removePart(this.getSide(), true);
                ForgeDirection dir = this.getHost().addPart(newType, this.getSide(), player);
                IPart newBus = this.getHost().getPart(dir);
                if (newBus instanceof PartP2PTunnel) {
                    PartP2PTunnel newTunnel = (PartP2PTunnel)newBus;
                    newTunnel.setOutput(true);
                    try {
                        P2PCache p2p = newTunnel.getProxy().getP2P();
                        p2p.updateFreq(newTunnel, freq);
                        PartP2PTunnel input = p2p.getInput(freq);
                        if (input != null) {
                            newTunnel.setCustomNameInternal(input.getCustomName());
                        }
                    }
                    catch (GridAccessException p2p) {
                        // empty catch block
                    }
                    newTunnel.onTunnelNetworkChange();
                }
                mc.notifyUser(player, MemoryCardMessages.SETTINGS_LOADED);
                return true;
            }
            mc.notifyUser(player, MemoryCardMessages.INVALID_MACHINE);
        } else if (!player.func_70093_af() && Platform.isWrench(player, is, (int)pos.field_72450_a, (int)pos.field_72448_b, (int)pos.field_72449_c) && !Platform.isClient()) {
            this.printConnectionInfo(player);
        } else if (tt != null) {
            ItemStack newType = null;
            IParts parts = AEApi.instance().definitions().parts();
            switch (tt) {
                case LIGHT: {
                    ItemStack stack;
                    Iterator freq = parts.p2PTunnelLight().maybeStack(1).asSet().iterator();
                    while (freq.hasNext()) {
                        newType = stack = (ItemStack)freq.next();
                    }
                    break;
                }
                case RF_POWER: {
                    ItemStack stack;
                    Iterator freq = parts.p2PTunnelRF().maybeStack(1).asSet().iterator();
                    while (freq.hasNext()) {
                        newType = stack = (ItemStack)freq.next();
                    }
                    break;
                }
                case FLUID: {
                    ItemStack stack;
                    Iterator freq = parts.p2PTunnelLiquids().maybeStack(1).asSet().iterator();
                    while (freq.hasNext()) {
                        newType = stack = (ItemStack)freq.next();
                    }
                    break;
                }
                case IC2_POWER: {
                    ItemStack stack;
                    Iterator freq = parts.p2PTunnelEU().maybeStack(1).asSet().iterator();
                    while (freq.hasNext()) {
                        newType = stack = (ItemStack)freq.next();
                    }
                    break;
                }
                case ITEM: {
                    ItemStack stack;
                    Iterator freq = parts.p2PTunnelItems().maybeStack(1).asSet().iterator();
                    while (freq.hasNext()) {
                        newType = stack = (ItemStack)freq.next();
                    }
                    break;
                }
                case ME: {
                    ItemStack stack;
                    Iterator freq = parts.p2PTunnelME().maybeStack(1).asSet().iterator();
                    while (freq.hasNext()) {
                        newType = stack = (ItemStack)freq.next();
                    }
                    break;
                }
                case REDSTONE: {
                    ItemStack stack;
                    Iterator freq = parts.p2PTunnelRedstone().maybeStack(1).asSet().iterator();
                    while (freq.hasNext()) {
                        newType = stack = (ItemStack)freq.next();
                    }
                    break;
                }
                case COMPUTER_MESSAGE: {
                    ItemStack stack;
                    Iterator freq = parts.p2PTunnelOpenComputers().maybeStack(1).asSet().iterator();
                    while (freq.hasNext()) {
                        newType = stack = (ItemStack)freq.next();
                    }
                    break;
                }
                case PRESSURE: {
                    ItemStack stack;
                    Iterator freq = parts.p2PTunnelPneumaticCraft().maybeStack(1).asSet().iterator();
                    while (freq.hasNext()) {
                        newType = stack = (ItemStack)freq.next();
                    }
                    break;
                }
                case GT_POWER: {
                    ItemStack stack;
                    Iterator freq = parts.p2PTunnelGregtech().maybeStack(1).asSet().iterator();
                    while (freq.hasNext()) {
                        newType = stack = (ItemStack)freq.next();
                    }
                    break;
                }
            }
            if (newType != null && !Platform.isSameItem(newType, this.getItemStack())) {
                if (new Throwable().getStackTrace()[2].getMethodName().equals("place")) {
                    return true;
                }
                boolean oldOutput = this.isOutput();
                long myFreq = this.getFrequency();
                this.getHost().removePart(this.getSide(), false);
                ForgeDirection dir = this.getHost().addPart(newType, this.getSide(), player);
                IPart newBus = this.getHost().getPart(dir);
                if (newBus instanceof PartP2PTunnel) {
                    PartP2PTunnel newTunnel = (PartP2PTunnel)newBus;
                    newTunnel.setOutput(oldOutput);
                    newTunnel.onTunnelNetworkChange();
                    try {
                        P2PCache p2p = newTunnel.getProxy().getP2P();
                        p2p.updateFreq(newTunnel, myFreq);
                    }
                    catch (GridAccessException gridAccessException) {
                        // empty catch block
                    }
                }
                Platform.notifyBlocksOfNeighbors(this.getTile().func_145831_w(), this.getTile().field_145851_c, this.getTile().field_145848_d, this.getTile().field_145849_e);
                return true;
            }
        }
        return false;
    }
}

