/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules;

import appeng.client.gui.AEBaseMEGui;
import appeng.client.gui.implementations.GuiCraftConfirm;
import appeng.client.gui.implementations.GuiCraftingCPU;
import appeng.client.gui.implementations.GuiCraftingTerm;
import appeng.client.gui.implementations.GuiMEMonitorable;
import appeng.client.gui.implementations.GuiMEPortableCell;
import appeng.client.gui.implementations.GuiPatternTerm;
import appeng.client.gui.implementations.GuiPatternTermEx;
import appeng.client.gui.implementations.GuiSkyChest;
import appeng.client.gui.implementations.GuiWirelessTerm;
import appeng.core.AEConfig;
import appeng.core.features.AEFeature;
import appeng.integration.IIntegrationModule;
import appeng.integration.IntegrationHelper;
import appeng.integration.abstraction.INEI;
import appeng.integration.modules.NEIHelpers.NEIAEBookmarkContainerHandler;
import appeng.integration.modules.NEIHelpers.NEIAEShapedRecipeHandler;
import appeng.integration.modules.NEIHelpers.NEIAEShapelessRecipeHandler;
import appeng.integration.modules.NEIHelpers.NEIAETerminalBookmarkContainerHandler;
import appeng.integration.modules.NEIHelpers.NEICraftingHandler;
import appeng.integration.modules.NEIHelpers.NEIFacadeRecipeHandler;
import appeng.integration.modules.NEIHelpers.NEIGrinderRecipeHandler;
import appeng.integration.modules.NEIHelpers.NEIGuiHandler;
import appeng.integration.modules.NEIHelpers.NEIInscriberRecipeHandler;
import appeng.integration.modules.NEIHelpers.NEIOreDictionaryFilter;
import appeng.integration.modules.NEIHelpers.NEIWorldCraftingHandler;
import appeng.integration.modules.NEIHelpers.TerminalCraftingSlotFinder;
import codechicken.nei.ItemsGrid;
import codechicken.nei.LayoutManager;
import codechicken.nei.SearchField;
import codechicken.nei.api.API;
import codechicken.nei.api.IBookmarkContainerHandler;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.api.IStackPositioner;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.guihook.IContainerObjectHandler;
import codechicken.nei.guihook.IContainerTooltipHandler;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class NEI
implements INEI,
IContainerTooltipHandler,
IIntegrationModule,
IContainerObjectHandler {
    public static NEI instance;
    private final Class<?> apiClass;
    private Method registerRecipeHandler;
    private Method registerUsageHandler;
    private Method registerNEIGuiHandler;
    private Method registerItemFilter;
    private Method registerBookmarkContainerHandler;

    public NEI() throws ClassNotFoundException {
        IntegrationHelper.testClassExistence(this, API.class);
        IntegrationHelper.testClassExistence(this, IStackPositioner.class);
        IntegrationHelper.testClassExistence(this, GuiContainerManager.class);
        IntegrationHelper.testClassExistence(this, IContainerTooltipHandler.class);
        IntegrationHelper.testClassExistence(this, ICraftingHandler.class);
        IntegrationHelper.testClassExistence(this, IUsageHandler.class);
        IntegrationHelper.testClassExistence(this, IBookmarkContainerHandler.class);
        this.apiClass = Class.forName("codechicken.nei.api.API");
    }

    @Override
    public void init() throws Throwable {
        this.registerRecipeHandler = this.apiClass.getDeclaredMethod("registerRecipeHandler", ICraftingHandler.class);
        this.registerUsageHandler = this.apiClass.getDeclaredMethod("registerUsageHandler", IUsageHandler.class);
        this.registerNEIGuiHandler = this.apiClass.getDeclaredMethod("registerNEIGuiHandler", INEIGuiHandler.class);
        this.registerNEIGuiHandler.invoke(this.apiClass, new Object[]{new NEIGuiHandler()});
        this.registerItemFilter = this.apiClass.getDeclaredMethod("addSearchProvider", SearchField.ISearchProvider.class);
        this.registerItemFilter.invoke(this.apiClass, new NEIOreDictionaryFilter());
        this.registerRecipeHandler((Object)new NEIAEShapedRecipeHandler());
        this.registerRecipeHandler((Object)new NEIAEShapelessRecipeHandler());
        this.registerRecipeHandler((Object)new NEIInscriberRecipeHandler());
        this.registerRecipeHandler(new NEIWorldCraftingHandler());
        if (AEConfig.instance.isFeatureEnabled(AEFeature.GrindStone)) {
            this.registerRecipeHandler((Object)new NEIGrinderRecipeHandler());
        }
        if (AEConfig.instance.isFeatureEnabled(AEFeature.Facades) && AEConfig.instance.isFeatureEnabled(AEFeature.EnableFacadeCrafting)) {
            this.registerRecipeHandler((Object)new NEIFacadeRecipeHandler());
        }
        this.registerBookmarkContainerHandler = this.apiClass.getDeclaredMethod("registerBookmarkContainerHandler", Class.class, IBookmarkContainerHandler.class);
        this.registerBookmarkContainerHandler.invoke(this.apiClass, GuiSkyChest.class, new NEIAEBookmarkContainerHandler());
        this.registerBookmarkContainerHandler.invoke(this.apiClass, GuiCraftingTerm.class, new NEIAETerminalBookmarkContainerHandler());
        this.registerBookmarkContainerHandler.invoke(this.apiClass, GuiMEMonitorable.class, new NEIAETerminalBookmarkContainerHandler());
        this.registerBookmarkContainerHandler.invoke(this.apiClass, GuiWirelessTerm.class, new NEIAETerminalBookmarkContainerHandler());
        this.registerBookmarkContainerHandler.invoke(this.apiClass, GuiPatternTerm.class, new NEIAETerminalBookmarkContainerHandler());
        this.registerBookmarkContainerHandler.invoke(this.apiClass, GuiPatternTermEx.class, new NEIAETerminalBookmarkContainerHandler());
        this.registerBookmarkContainerHandler.invoke(this.apiClass, GuiMEPortableCell.class, new NEIAETerminalBookmarkContainerHandler());
        GuiContainerManager.addTooltipHandler((IContainerTooltipHandler)this);
        GuiContainerManager.addObjectHandler((IContainerObjectHandler)this);
        Method registerGuiOverlay = this.apiClass.getDeclaredMethod("registerGuiOverlay", Class.class, String.class, IStackPositioner.class);
        Class<?> overlayHandler = Class.forName("codechicken.nei.api.IOverlayHandler");
        Method registrar = this.apiClass.getDeclaredMethod("registerGuiOverlayHandler", Class.class, overlayHandler, String.class);
        registerGuiOverlay.invoke(this.apiClass, GuiCraftingTerm.class, "crafting", new TerminalCraftingSlotFinder());
        registerGuiOverlay.invoke(this.apiClass, GuiPatternTerm.class, "crafting", new TerminalCraftingSlotFinder());
        Class<NEICraftingHandler> defaultHandler = NEICraftingHandler.class;
        Constructor defaultConstructor = defaultHandler.getConstructor(Integer.TYPE, Integer.TYPE);
        registrar.invoke(this.apiClass, GuiCraftingTerm.class, defaultConstructor.newInstance(6, 75), "crafting");
        registrar.invoke(this.apiClass, GuiPatternTerm.class, defaultConstructor.newInstance(6, 75), "crafting");
    }

    public void registerRecipeHandler(Object o) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.registerRecipeHandler.invoke(this.apiClass, o);
        this.registerUsageHandler.invoke(this.apiClass, o);
    }

    @Override
    public void postInit() {
    }

    @Override
    public void drawSlot(Slot s) {
        if (s == null) {
            return;
        }
        ItemStack stack = s.func_75211_c();
        if (stack == null) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer fontRenderer = mc.field_71466_p;
        int x = s.field_75223_e;
        int y = s.field_75221_f;
        GuiContainerManager.drawItems.func_82406_b(fontRenderer, mc.func_110434_K(), stack, x, y);
        GuiContainerManager.drawItems.func_94148_a(fontRenderer, mc.func_110434_K(), stack, x, y, String.valueOf(stack.field_77994_a));
    }

    @Override
    public RenderItem setItemRender(RenderItem renderItem) {
        try {
            RenderItem ri = GuiContainerManager.drawItems;
            GuiContainerManager.drawItems = renderItem;
            return ri;
        }
        catch (Throwable t) {
            throw new IllegalStateException("Invalid version of NEI, please update", t);
        }
    }

    public List<String> handleTooltip(GuiContainer arg0, int arg1, int arg2, List<String> current) {
        return current;
    }

    public List<String> handleItemDisplayName(GuiContainer arg0, ItemStack arg1, List<String> current) {
        return current;
    }

    public List<String> handleItemTooltip(GuiContainer guiScreen, ItemStack stack, int mouseX, int mouseY, List<String> currentToolTip) {
        if (guiScreen instanceof AEBaseMEGui) {
            return ((AEBaseMEGui)guiScreen).handleItemTooltip(stack, mouseX, mouseY, currentToolTip);
        }
        return currentToolTip;
    }

    public void guiTick(GuiContainer gui) {
    }

    public void refresh(GuiContainer gui) {
    }

    public void load(GuiContainer gui) {
    }

    public ItemStack getStackUnderMouse(GuiContainer gui, int mousex, int mousey) {
        if (gui instanceof GuiCraftConfirm) {
            return ((GuiCraftConfirm)gui).getHoveredStack();
        }
        if (gui instanceof GuiCraftingCPU) {
            return ((GuiCraftingCPU)gui).getHoveredStack();
        }
        return null;
    }

    public boolean objectUnderMouse(GuiContainer gui, int mousex, int mousey) {
        return false;
    }

    public boolean shouldShowTooltip(GuiContainer gui) {
        if (gui instanceof GuiCraftConfirm) {
            return ((GuiCraftConfirm)gui).getHoveredStack() == null;
        }
        if (gui instanceof GuiCraftingCPU) {
            return ((GuiCraftingCPU)gui).getHoveredStack() == null;
        }
        return true;
    }

    public void addItemToBookMark(ItemStack itemStack) {
        ItemsGrid grid = LayoutManager.bookmarkPanel.getGrid();
        grid.setPage(grid.getNumPages() - 1);
        LayoutManager.bookmarkPanel.addItem(itemStack);
    }
}

