/*
 * Decompiled with CFR 0.152.
 */
package appeng.block;

import appeng.api.implementations.items.IMemoryCard;
import appeng.api.implementations.items.MemoryCardMessages;
import appeng.api.implementations.tiles.IColorableTile;
import appeng.api.util.AEColor;
import appeng.api.util.IOrientable;
import appeng.block.AEBaseBlock;
import appeng.block.networking.BlockCableBus;
import appeng.core.features.AEFeature;
import appeng.core.features.AETileBlockFeatureHandler;
import appeng.core.features.IAEFeature;
import appeng.core.sync.GuiBridge;
import appeng.helpers.ICustomCollision;
import appeng.items.tools.quartz.ToolQuartzCuttingKnife;
import appeng.tile.AEBaseTile;
import appeng.tile.networking.TileCableBus;
import appeng.tile.storage.TileSkyChest;
import appeng.util.Platform;
import appeng.util.SettingsFrom;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.ArrayList;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;

public abstract class AEBaseTileBlock
extends AEBaseBlock
implements IAEFeature,
ITileEntityProvider {
    @Nonnull
    private Class<? extends TileEntity> tileEntityType;

    public AEBaseTileBlock(Material mat) {
        super(mat);
    }

    protected AEBaseTileBlock(Material mat, Optional<String> subName) {
        super(mat, subName);
    }

    @Override
    protected void setFeature(EnumSet<AEFeature> f) {
        AETileBlockFeatureHandler featureHandler = new AETileBlockFeatureHandler(f, this, (Optional<String>)this.featureSubName);
        this.setHandler(featureHandler);
    }

    protected void setTileEntity(Class<? extends TileEntity> c) {
        this.tileEntityType = c;
        this.isInventory = IInventory.class.isAssignableFrom(c);
        this.setTileProvider(this.hasBlockTileEntity());
    }

    private void setTileProvider(boolean b) {
        ReflectionHelper.setPrivateValue(Block.class, (Object)this, (Object)b, (String[])new String[]{"isTileProvider"});
    }

    private boolean hasBlockTileEntity() {
        return this.tileEntityType != null;
    }

    public Class<? extends TileEntity> getTileEntityClass() {
        return this.tileEntityType;
    }

    @Nullable
    public <T extends AEBaseTile> T getTileEntity(IBlockAccess w, int x, int y, int z) {
        if (!this.hasBlockTileEntity()) {
            return null;
        }
        TileEntity te = w.func_147438_o(x, y, z);
        if (this.tileEntityType.isInstance(te)) {
            return (T)((AEBaseTile)te);
        }
        return null;
    }

    public final TileEntity func_149915_a(World var1, int var2) {
        if (this.hasBlockTileEntity()) {
            try {
                return this.tileEntityType.newInstance();
            }
            catch (InstantiationException e) {
                throw new IllegalStateException("Failed to create a new instance of an illegal class " + this.tileEntityType, e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Failed to create a new instance of " + this.tileEntityType + ", because lack of permissions", e);
            }
        }
        return null;
    }

    public void func_149749_a(World w, int x, int y, int z, Block a, int b) {
        Object te = this.getTileEntity((IBlockAccess)w, x, y, z);
        if (te != null) {
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            if (((AEBaseTile)te).dropItems()) {
                ((AEBaseTile)te).getDrops(w, x, y, z, drops);
            } else {
                ((AEBaseTile)te).getNoDrops(w, x, y, z, drops);
            }
            Platform.spawnDrops(w, x, y, z, drops);
        }
        super.func_149749_a(w, x, y, z, a, b);
    }

    @Override
    public final ForgeDirection[] getValidRotations(World w, int x, int y, int z) {
        Object obj = this.getTileEntity((IBlockAccess)w, x, y, z);
        if (obj != null && ((AEBaseTile)obj).canBeRotated()) {
            return ForgeDirection.VALID_DIRECTIONS;
        }
        return super.getValidRotations(w, x, y, z);
    }

    public boolean recolourBlock(World world, int x, int y, int z, ForgeDirection side, int colour) {
        Object te = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (te instanceof IColorableTile) {
            AEColor newColor;
            IColorableTile ct = (IColorableTile)te;
            AEColor c = ct.getColor();
            if (c != (newColor = AEColor.values()[colour])) {
                ct.recolourBlock(side, newColor, null);
                return true;
            }
            return false;
        }
        return super.recolourBlock(world, x, y, z, side, colour);
    }

    @Override
    public int func_149736_g(World w, int x, int y, int z, int s) {
        Object te = this.getTileEntity((IBlockAccess)w, x, y, z);
        if (te instanceof IInventory) {
            return Container.func_94526_b((IInventory)((IInventory)te));
        }
        return 0;
    }

    public boolean func_149696_a(World p_149696_1_, int p_149696_2_, int p_149696_3_, int p_149696_4_, int p_149696_5_, int p_149696_6_) {
        super.func_149696_a(p_149696_1_, p_149696_2_, p_149696_3_, p_149696_4_, p_149696_5_, p_149696_6_);
        TileEntity tileentity = p_149696_1_.func_147438_o(p_149696_2_, p_149696_3_, p_149696_4_);
        return tileentity != null && tileentity.func_145842_c(p_149696_5_, p_149696_6_);
    }

    public void func_149689_a(World w, int x, int y, int z, EntityLivingBase player, ItemStack is) {
        Object te;
        if (is.func_82837_s() && (te = this.getTileEntity((IBlockAccess)w, x, y, z)) instanceof AEBaseTile) {
            ((AEBaseTile)w.func_147438_o(x, y, z)).setName(is.func_82833_r());
        }
    }

    public boolean func_149727_a(World w, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        ItemStack is;
        if (player != null && (is = player.field_71071_by.func_70448_g()) != null) {
            if (Platform.isWrench(player, is, x, y, z) && player.func_70093_af()) {
                Block id = w.func_147439_a(x, y, z);
                if (id != null) {
                    Object tile = this.getTileEntity((IBlockAccess)w, x, y, z);
                    Object[] drops = Platform.getBlockDrops(w, x, y, z);
                    if (tile == null) {
                        return false;
                    }
                    if (tile instanceof TileCableBus || tile instanceof TileSkyChest) {
                        return false;
                    }
                    BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(x, y, z, w, (Block)this, 0, player);
                    MinecraftForge.EVENT_BUS.post((Event)event);
                    if (event.isCanceled()) {
                        return false;
                    }
                    ItemStack op = new ItemStack((Block)this);
                    for (ItemStack itemStack : drops) {
                        NBTTagCompound tag;
                        if (!Platform.isSameItemType(itemStack, op) || (tag = ((AEBaseTile)tile).downloadSettings(SettingsFrom.DISMANTLE_ITEM)) == null) continue;
                        itemStack.func_77982_d(tag);
                    }
                    if (id.removedByPlayer(w, player, x, y, z, false)) {
                        ArrayList l = Lists.newArrayList((Object[])drops);
                        Platform.spawnDrops(w, x, y, z, l);
                        w.func_147468_f(x, y, z);
                    }
                }
                return false;
            }
            Item tile = is.func_77973_b();
            if (tile instanceof IMemoryCard) {
                IMemoryCard memoryCard = (IMemoryCard)tile;
                if (!(this instanceof BlockCableBus)) {
                    if (player.func_70093_af()) {
                        Object t = this.getTileEntity((IBlockAccess)w, x, y, z);
                        if (t != null) {
                            String name = this.func_149739_a();
                            NBTTagCompound data = ((AEBaseTile)t).downloadSettings(SettingsFrom.MEMORY_CARD);
                            if (data != null) {
                                memoryCard.setMemoryCardContents(is, name, data);
                                memoryCard.notifyUser(player, MemoryCardMessages.SETTINGS_SAVED);
                                return true;
                            }
                        }
                    } else {
                        String name = memoryCard.getSettingsName(is);
                        NBTTagCompound data = memoryCard.getData(is);
                        if (this.func_149739_a().equals(name)) {
                            Object t = this.getTileEntity((IBlockAccess)w, x, y, z);
                            ((AEBaseTile)t).uploadSettings(SettingsFrom.MEMORY_CARD, data);
                            memoryCard.notifyUser(player, MemoryCardMessages.SETTINGS_LOADED);
                        } else {
                            memoryCard.notifyUser(player, MemoryCardMessages.INVALID_MACHINE);
                        }
                        return false;
                    }
                }
            }
            if (is.func_77973_b() instanceof ToolQuartzCuttingKnife && !(this instanceof BlockCableBus)) {
                if (ForgeEventFactory.onItemUseStart((EntityPlayer)player, (ItemStack)is, (int)1) <= 0) {
                    return false;
                }
                Object tile2 = this.getTileEntity((IBlockAccess)w, x, y, z);
                if (tile2 == null) {
                    return false;
                }
                Platform.openGUI(player, tile2, ForgeDirection.getOrientation((int)side), GuiBridge.GUI_RENAMER);
                return true;
            }
        }
        return this.onActivated(w, x, y, z, player, side, hitX, hitY, hitZ);
    }

    @Override
    public IOrientable getOrientable(IBlockAccess w, int x, int y, int z) {
        return this.getTileEntity(w, x, y, z);
    }

    @Override
    public ICustomCollision getCustomCollision(World w, int x, int y, int z) {
        Object te = this.getTileEntity((IBlockAccess)w, x, y, z);
        if (te instanceof ICustomCollision) {
            return (ICustomCollision)te;
        }
        return super.getCustomCollision(w, x, y, z);
    }
}

