/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.oreprocessing;

import gregtech.api.GregTech_API;
import gregtech.api.enums.ConfigCategories;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.enums.TierEU;
import gregtech.api.enums.ToolDictNames;
import gregtech.api.interfaces.IOreRecipeRegistrator;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_RecipeConstants;
import gregtech.api.util.GT_RecipeRegistrator;
import gregtech.api.util.GT_Utility;
import gregtech.common.GT_Proxy;
import net.minecraft.item.ItemStack;

public class ProcessingIngot
implements IOreRecipeRegistrator {
    public ProcessingIngot() {
        OrePrefixes.ingot.add(this);
        OrePrefixes.ingotDouble.add(this);
        OrePrefixes.ingotTriple.add(this);
        OrePrefixes.ingotQuadruple.add(this);
        OrePrefixes.ingotQuintuple.add(this);
        OrePrefixes.ingotHot.add(this);
    }

    @Override
    public void registerOre(OrePrefixes aPrefix, Materials aMaterial, String aOreDictName, String aModName, ItemStack aStack) {
        boolean aNoSmashing = aMaterial.contains(SubTag.NO_SMASHING);
        boolean aStretchy = aMaterial.contains(SubTag.STRETCHY);
        boolean aNoSmelting = aMaterial.contains(SubTag.NO_SMELTING);
        long aMaterialMass = aMaterial.getMass();
        boolean aSpecialRecipeReq = aMaterial.mUnificatable && aMaterial.mMaterialInto == aMaterial && !aMaterial.contains(SubTag.NO_SMASHING);
        switch (aPrefix) {
            case ingot: {
                ItemStack tStack;
                if (aMaterial.mFuelPower > 0) {
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack)).metadata(GT_RecipeConstants.FUEL_VALUE, aMaterial.mFuelPower).metadata(GT_RecipeConstants.FUEL_TYPE, aMaterial.mFuelType).duration(0).eut(0).addTo(GT_RecipeConstants.Fuel);
                }
                if (aMaterial.mStandardMoltenFluid != null && aMaterial != Materials.AnnealedCopper && aMaterial != Materials.WroughtIron) {
                    GT_Values.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Ingot.get(0L, new Object[0])).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.ingot, aMaterial, 1L)).fluidInputs(aMaterial.getMolten(144L)).duration(32).eut(GT_Utility.calculateRecipeEU(aMaterial, 8)).addTo(GT_Recipe.GT_Recipe_Map.sFluidSolidficationRecipes);
                }
                GT_RecipeRegistrator.registerReverseFluidSmelting(aStack, aMaterial, aPrefix.mMaterialAmount, null);
                GT_RecipeRegistrator.registerReverseMacerating(aStack, aMaterial, aPrefix.mMaterialAmount, null, null, null, false);
                if (aMaterial.mSmeltInto.mArcSmeltInto != aMaterial) {
                    GT_RecipeRegistrator.registerReverseArcSmelting(GT_Utility.copyAmount(1L, aStack), aMaterial, aPrefix.mMaterialAmount, null, null, null);
                }
                if ((tStack = GT_OreDictUnificator.get(OrePrefixes.dust, aMaterial.mMacerateInto, 1L)) != null && (aMaterial.mBlastFurnaceRequired || aNoSmelting)) {
                    GT_ModHandler.removeFurnaceSmelting(tStack);
                }
                if (aMaterial.mUnificatable && aMaterial.mMaterialInto == aMaterial && !aMaterial.contains(SubTag.NO_WORKING) && !aMaterial.contains(SubTag.SMELTING_TO_GEM) && aMaterial.contains(SubTag.MORTAR_GRINDABLE) && GregTech_API.sRecipeFile.get((Object)ConfigCategories.Tools.mortar, aMaterial.mName, true)) {
                    GT_ModHandler.addShapelessCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.dust, aMaterial, 1L), GT_Proxy.tBits, new Object[]{ToolDictNames.craftingToolMortar, OrePrefixes.ingot.get(aMaterial)});
                }
                if (aNoSmashing && !aStretchy) break;
                if ((long)aMaterial.getProcessingMaterialTierEU() < TierEU.IV && GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L) != null) {
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(3L, aStack)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 2L)).duration(Math.max(aMaterialMass, 1L)).eut(GT_Utility.calculateRecipeEU(aMaterial, 16)).addTo(GT_Recipe.GT_Recipe_Map.sHammerRecipes);
                }
                if (GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L) != null) {
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack), GT_Utility.getIntegratedCircuit(1)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L)).duration(Math.max(aMaterialMass, 1L)).eut(GT_Utility.calculateRecipeEU(aMaterial, 24)).addTo(GT_Recipe.GT_Recipe_Map.sBenderRecipes);
                }
                if (GT_OreDictUnificator.get(OrePrefixes.plateDouble, aMaterial, 1L) != null) {
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(2L, aStack), GT_Utility.getIntegratedCircuit(2)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.plateDouble, aMaterial, 1L)).duration(Math.max(aMaterialMass * 2L, 1L)).eut(GT_Utility.calculateRecipeEU(aMaterial, 96)).addTo(GT_Recipe.GT_Recipe_Map.sBenderRecipes);
                }
                if (GT_OreDictUnificator.get(OrePrefixes.plateTriple, aMaterial, 1L) != null) {
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(3L, aStack), GT_Utility.getIntegratedCircuit(3)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.plateTriple, aMaterial, 1L)).duration(Math.max(aMaterialMass * 3L, 1L)).eut(GT_Utility.calculateRecipeEU(aMaterial, 96)).addTo(GT_Recipe.GT_Recipe_Map.sBenderRecipes);
                }
                if (GT_OreDictUnificator.get(OrePrefixes.plateQuadruple, aMaterial, 1L) != null) {
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(4L, aStack), GT_Utility.getIntegratedCircuit(4)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.plateQuadruple, aMaterial, 1L)).duration(Math.max(aMaterialMass * 4L, 1L)).eut(GT_Utility.calculateRecipeEU(aMaterial, 96)).addTo(GT_Recipe.GT_Recipe_Map.sBenderRecipes);
                }
                if (GT_OreDictUnificator.get(OrePrefixes.plateQuintuple, aMaterial, 1L) != null) {
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(5L, aStack), GT_Utility.getIntegratedCircuit(5)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.plateQuintuple, aMaterial, 1L)).duration(Math.max(aMaterialMass * 5L, 1L)).eut(GT_Utility.calculateRecipeEU(aMaterial, 96)).addTo(GT_Recipe.GT_Recipe_Map.sBenderRecipes);
                }
                if (GT_OreDictUnificator.get(OrePrefixes.plateDense, aMaterial, 1L) != null) {
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(9L, aStack), GT_Utility.getIntegratedCircuit(9)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.plateDense, aMaterial, 1L)).duration(Math.max(aMaterialMass * 9L, 1L)).eut(GT_Utility.calculateRecipeEU(aMaterial, 96)).addTo(GT_Recipe.GT_Recipe_Map.sBenderRecipes);
                }
                if (GT_OreDictUnificator.get(OrePrefixes.foil, aMaterial, 1L) == null) break;
                GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack), GT_Utility.getIntegratedCircuit(10)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.foil, aMaterial, 4L)).duration(Math.max(aMaterialMass * 2L, 1L)).eut(GT_Utility.calculateRecipeEU(aMaterial, 24)).addTo(GT_Recipe.GT_Recipe_Map.sBenderRecipes);
                break;
            }
            case ingotDouble: {
                if (aNoSmashing && !aStretchy) break;
                GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack), GT_Utility.getIntegratedCircuit(1)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.plateDouble, aMaterial, 1L)).duration(Math.max(aMaterialMass, 1L)).eut(GT_Utility.calculateRecipeEU(aMaterial, 96)).addTo(GT_Recipe.GT_Recipe_Map.sBenderRecipes);
                GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(2L, aStack), GT_Utility.getIntegratedCircuit(2)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.plateQuadruple, aMaterial, 1L)).duration(Math.max(aMaterialMass * 2L, 1L)).eut(GT_Utility.calculateRecipeEU(aMaterial, 96)).addTo(GT_Recipe.GT_Recipe_Map.sBenderRecipes);
                if ((long)aMaterial.getProcessingMaterialTierEU() >= TierEU.IV || !aSpecialRecipeReq || !GregTech_API.sRecipeFile.get((Object)ConfigCategories.Tools.hammermultiingot, aMaterial.toString(), true)) break;
                GT_ModHandler.addCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.ingotDouble, aMaterial, 1L), GT_Proxy.tBits, new Object[]{"I", "I", "h", Character.valueOf('I'), OrePrefixes.ingot.get(aMaterial)});
                break;
            }
            case ingotTriple: {
                if (aNoSmashing && !aStretchy) break;
                GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack), GT_Utility.getIntegratedCircuit(1)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.plateTriple, aMaterial, 1L)).duration(Math.max(aMaterialMass, 1L)).eut(GT_Utility.calculateRecipeEU(aMaterial, 96)).addTo(GT_Recipe.GT_Recipe_Map.sBenderRecipes);
                GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(3L, aStack), GT_Utility.getIntegratedCircuit(3)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.plateDense, aMaterial, 1L)).duration(Math.max(aMaterialMass * 3L, 1L)).eut(GT_Utility.calculateRecipeEU(aMaterial, 96)).addTo(GT_Recipe.GT_Recipe_Map.sBenderRecipes);
                if ((long)aMaterial.getProcessingMaterialTierEU() >= TierEU.IV || !aSpecialRecipeReq || !GregTech_API.sRecipeFile.get((Object)ConfigCategories.Tools.hammermultiingot, aMaterial.toString(), true)) break;
                GT_ModHandler.addCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.ingotTriple, aMaterial, 1L), GT_Proxy.tBits, new Object[]{"I", "B", "h", Character.valueOf('I'), OrePrefixes.ingotDouble.get(aMaterial), Character.valueOf('B'), OrePrefixes.ingot.get(aMaterial)});
                break;
            }
            case ingotQuadruple: {
                if (aNoSmashing && !aStretchy) break;
                GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack), GT_Utility.getIntegratedCircuit(1)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.plateQuadruple, aMaterial, 1L)).duration(Math.max(aMaterialMass, 1L)).eut(GT_Utility.calculateRecipeEU(aMaterial, 96)).addTo(GT_Recipe.GT_Recipe_Map.sBenderRecipes);
                if ((long)aMaterial.getProcessingMaterialTierEU() >= TierEU.IV || !aSpecialRecipeReq || !GregTech_API.sRecipeFile.get((Object)ConfigCategories.Tools.hammermultiingot, aMaterial.toString(), true)) break;
                GT_ModHandler.addCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.ingotQuadruple, aMaterial, 1L), GT_Proxy.tBits, new Object[]{"I", "B", "h", Character.valueOf('I'), OrePrefixes.ingotTriple.get(aMaterial), Character.valueOf('B'), OrePrefixes.ingot.get(aMaterial)});
                break;
            }
            case ingotQuintuple: {
                if (aNoSmashing && !aStretchy) break;
                GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack), GT_Utility.getIntegratedCircuit(1)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.plateQuintuple, aMaterial, 1L)).duration(Math.max(aMaterialMass, 1L)).eut(GT_Utility.calculateRecipeEU(aMaterial, 96)).addTo(GT_Recipe.GT_Recipe_Map.sBenderRecipes);
                if ((long)aMaterial.getProcessingMaterialTierEU() >= TierEU.IV || !aSpecialRecipeReq || !GregTech_API.sRecipeFile.get((Object)ConfigCategories.Tools.hammermultiingot, aMaterial.toString(), true)) break;
                GT_ModHandler.addCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.ingotQuintuple, aMaterial, 1L), GT_Proxy.tBits, new Object[]{"I", "B", "h", Character.valueOf('I'), OrePrefixes.ingotQuadruple.get(aMaterial), Character.valueOf('B'), OrePrefixes.ingot.get(aMaterial)});
                break;
            }
            case ingotHot: {
                if (!aMaterial.mAutoGenerateVacuumFreezerRecipes || GT_OreDictUnificator.get(OrePrefixes.ingot, aMaterial, 1L) == null) break;
                GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1L, aStack)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.ingot, aMaterial, 1L)).duration((int)Math.max(aMaterialMass * 3L, 1L) * 1).eut(TierEU.RECIPE_MV).addTo(GT_Recipe.GT_Recipe_Map.sVacuumRecipes);
                break;
            }
        }
    }
}

