/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.steam;

import gregtech.api.enums.ParticleFX;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine_Steel;
import gregtech.api.objects.XSTR;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.WorldSpawnedEventBuilder;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_Macerator_Steel
extends GT_MetaTileEntity_BasicMachine_Steel {
    public GT_MetaTileEntity_Macerator_Steel(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, "Macerating your Ores", 1, 1, true);
    }

    public GT_MetaTileEntity_Macerator_Steel(String aName, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aDescription, aTextures, 1, 1, true);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Macerator_Steel(this.mName, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isClientSide() && aBaseMetaTileEntity.isActive() && aBaseMetaTileEntity.getFrontFacing() != ForgeDirection.UP && aBaseMetaTileEntity.getCoverIDAtSide(ForgeDirection.UP) == 0 && !aBaseMetaTileEntity.getOpacityAtSide(ForgeDirection.UP)) {
            ((WorldSpawnedEventBuilder.ParticleEventBuilder)new WorldSpawnedEventBuilder.ParticleEventBuilder().setMotion(0.0, 0.0, 0.0).setIdentifier((Enum)ParticleFX.SMOKE)).setPosition((float)aBaseMetaTileEntity.getXCoord() + 0.8f - XSTR.XSTR_INSTANCE.nextFloat() * 0.6f, (float)aBaseMetaTileEntity.getYCoord() + 0.9f + XSTR.XSTR_INSTANCE.nextFloat() * 0.2f, (float)aBaseMetaTileEntity.getZCoord() + 0.8f - XSTR.XSTR_INSTANCE.nextFloat() * 0.6f).setWorld(this.getBaseMetaTileEntity().getWorld()).run();
        }
    }

    @Override
    public GT_Recipe.GT_Recipe_Map getRecipeList() {
        return GT_Recipe.GT_Recipe_Map.sMaceratorRecipes;
    }

    @Override
    public int checkRecipe() {
        GT_Recipe tRecipe = this.getRecipeList().findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), this.mLastRecipe, false, TierEU.LV, (FluidStack[])null, (ItemStack)null, this.getAllInputs());
        if (tRecipe == null) {
            return 0;
        }
        if (tRecipe.mCanBeBuffered) {
            this.mLastRecipe = tRecipe;
        }
        if (!this.canOutput(tRecipe)) {
            ++this.mOutputBlocked;
            return 1;
        }
        if (!tRecipe.isRecipeInputEqual(true, new FluidStack[]{this.getFillableStack()}, this.getAllInputs())) {
            return 1;
        }
        if (tRecipe.getOutput(0) != null) {
            this.mOutputItems[0] = tRecipe.getOutput(0);
        }
        this.calculateOverclockedNess(tRecipe);
        return 2;
    }

    @Override
    public boolean allowPutStackValidated(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return super.allowPutStackValidated(aBaseMetaTileEntity, aIndex, side, aStack) && GT_Recipe.GT_Recipe_Map.sMaceratorRecipes.containsInput(GT_Utility.copyAmount(64L, aStack));
    }

    @Override
    public void startSoundLoop(byte aIndex, double aX, double aY, double aZ) {
        super.startSoundLoop(aIndex, aX, aY, aZ);
        if (aIndex == 1) {
            GT_Utility.doSoundAtClient(SoundResource.IC2_MACHINES_MACERATOR_OP, 10, 1.0f, aX, aY, aZ);
        }
    }

    @Override
    public void startProcess() {
        this.sendLoopStart((byte)1);
    }

    @Override
    public ITexture[] getSideFacingActive(byte aColor) {
        return new ITexture[]{super.getSideFacingActive(aColor)[0], TextureFactory.of(Textures.BlockIcons.OVERLAY_SIDE_STEAM_MACERATOR_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_SIDE_STEAM_MACERATOR_ACTIVE_GLOW).glow().build()};
    }

    @Override
    public ITexture[] getSideFacingInactive(byte aColor) {
        return new ITexture[]{super.getSideFacingInactive(aColor)[0], TextureFactory.of(Textures.BlockIcons.OVERLAY_SIDE_STEAM_MACERATOR), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_SIDE_STEAM_MACERATOR_GLOW).glow().build()};
    }

    @Override
    public ITexture[] getFrontFacingActive(byte aColor) {
        return new ITexture[]{super.getFrontFacingActive(aColor)[0], TextureFactory.of(Textures.BlockIcons.OVERLAY_FRONT_STEAM_MACERATOR_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_STEAM_MACERATOR_ACTIVE_GLOW).glow().build()};
    }

    @Override
    public ITexture[] getFrontFacingInactive(byte aColor) {
        return new ITexture[]{super.getFrontFacingInactive(aColor)[0], TextureFactory.of(Textures.BlockIcons.OVERLAY_FRONT_STEAM_MACERATOR), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_STEAM_MACERATOR_GLOW).glow().build()};
    }

    @Override
    public ITexture[] getTopFacingActive(byte aColor) {
        return new ITexture[]{super.getTopFacingActive(aColor)[0], TextureFactory.of(Textures.BlockIcons.OVERLAY_TOP_STEAM_MACERATOR_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_TOP_STEAM_MACERATOR_ACTIVE_GLOW).glow().build()};
    }

    @Override
    public ITexture[] getTopFacingInactive(byte aColor) {
        return new ITexture[]{super.getTopFacingInactive(aColor)[0], TextureFactory.of(Textures.BlockIcons.OVERLAY_TOP_STEAM_MACERATOR), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_TOP_STEAM_MACERATOR_GLOW).glow().build()};
    }

    @Override
    public ITexture[] getBottomFacingActive(byte aColor) {
        return new ITexture[]{super.getBottomFacingActive(aColor)[0], TextureFactory.of(Textures.BlockIcons.OVERLAY_BOTTOM_STEAM_MACERATOR_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_BOTTOM_STEAM_MACERATOR_ACTIVE_GLOW).glow().build()};
    }

    @Override
    public ITexture[] getBottomFacingInactive(byte aColor) {
        return new ITexture[]{super.getBottomFacingInactive(aColor)[0], TextureFactory.of(Textures.BlockIcons.OVERLAY_BOTTOM_STEAM_MACERATOR), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_BOTTOM_STEAM_MACERATOR_GLOW).glow().build()};
    }
}

