/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_EnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_MultiInput;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_OilCracker
extends GT_MetaTileEntity_EnhancedMultiBlockBase<GT_MetaTileEntity_OilCracker>
implements ISurvivalConstructable {
    private static final byte CASING_INDEX = 49;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<GT_MetaTileEntity_OilCracker> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"lcmcr", "lcmcr", "lcmcr"}, {"lc~cr", "l---r", "lcmcr"}, {"lcmcr", "lcmcr", "lcmcr"}})).addElement('c', GT_StructureUtility.ofCoil(GT_MetaTileEntity_OilCracker::setCoilLevel, GT_MetaTileEntity_OilCracker::getCoilLevel)).addElement('l', GT_StructureUtility.buildHatchAdder(GT_MetaTileEntity_OilCracker.class).atLeast(GT_HatchElement.InputHatch.withAdder(GT_MetaTileEntity_OilCracker::addLeftHatchToMachineList), GT_HatchElement.Energy, GT_HatchElement.Maintenance).dot(2).casingIndex(49).buildAndChain(StructureUtility.onElementPass(GT_MetaTileEntity_OilCracker::onCasingAdded, (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings4, (int)1)))).addElement('r', GT_StructureUtility.buildHatchAdder(GT_MetaTileEntity_OilCracker.class).atLeast(GT_HatchElement.OutputHatch.withAdder(GT_MetaTileEntity_OilCracker::addRightHatchToMachineList), GT_HatchElement.Energy, GT_HatchElement.Maintenance).dot(3).casingIndex(49).buildAndChain(StructureUtility.onElementPass(GT_MetaTileEntity_OilCracker::onCasingAdded, (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings4, (int)1)))).addElement('m', GT_StructureUtility.buildHatchAdder(GT_MetaTileEntity_OilCracker.class).atLeast(GT_HatchElement.InputHatch.withAdder(GT_MetaTileEntity_OilCracker::addMiddleInputToMachineList).withCount(t -> t.mMiddleInputHatches.size()), GT_HatchElement.Energy, GT_HatchElement.Maintenance).dot(1).casingIndex(49).buildAndChain(StructureUtility.onElementPass(GT_MetaTileEntity_OilCracker::onCasingAdded, (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings4, (int)1)))).build();
    private HeatingCoilLevel heatLevel;
    protected final List<GT_MetaTileEntity_Hatch_Input> mMiddleInputHatches = new ArrayList<GT_MetaTileEntity_Hatch_Input>();
    protected int mInputOnSide;
    protected int mOutputOnSide;
    protected int mCasingAmount;

    public GT_MetaTileEntity_OilCracker(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_OilCracker(String aName) {
        super(aName);
    }

    @Override
    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Cracker").addInfo("Controller block for the Oil Cracking Unit").addInfo("Thermally cracks heavy hydrocarbons into lighter fractions").addInfo("More efficient than the Chemical Reactor").addInfo("Gives different benefits whether it hydro or steam-cracks:").addInfo("Hydro - Consumes 20% less Hydrogen and outputs 25% more cracked fluid").addInfo("Steam - Outputs 50% more cracked fluid").addInfo("(Values compared to cracking in the Chemical Reactor)").addInfo("Place the appropriate circuit in the controller").addSeparator().beginStructureBlock(5, 3, 3, true).addController("Front center").addCasingInfoRange("Clean Stainless Steel Machine Casing", 18, 21, false).addOtherStructurePart("2 Rings of 8 Coils", "Each side of the controller").addInfo("Gets 10% EU/t reduction per coil tier, up to a maximum of 50%").addEnergyHatch("Any casing", 1, 2, 3).addMaintenanceHatch("Any casing", 1, 2, 3).addInputHatch("For cracking fluid (Steam/Hydrogen/etc.) ONLY, Any middle ring casing", 1).addInputHatch("Any left/right side casing", 2, 3).addOutputHatch("Any right/left side casing", 2, 3).addStructureInfo("Input/Output Hatches must be on opposite sides!").addStructureHint("GT5U.cracker.io_side").toolTipFinisher("Gregtech");
        return tt;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection sideDirection, ForgeDirection facingDirection, int colorIndex, boolean active, boolean redstoneLevel) {
        if (sideDirection == facingDirection) {
            if (active) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][49], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][49], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][49]};
    }

    @Override
    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return GT_Recipe.GT_Recipe_Map.sCrackingRecipes;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @Nonnull
            public CheckRecipeResult process() {
                this.setEuModifier(1.0f - Math.min(0.1f * (float)(GT_MetaTileEntity_OilCracker.this.heatLevel.getTier() + 1), 0.5f));
                return super.process();
            }
        };
    }

    @Override
    public IStructureDefinition<GT_MetaTileEntity_OilCracker> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    public HeatingCoilLevel getCoilLevel() {
        return this.heatLevel;
    }

    public void setCoilLevel(HeatingCoilLevel aCoilLevel) {
        this.heatLevel = aCoilLevel;
    }

    private boolean addMiddleInputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            GT_MetaTileEntity_Hatch_Input tHatch = (GT_MetaTileEntity_Hatch_Input)aMetaTileEntity;
            tHatch.updateTexture(aBaseCasingIndex);
            tHatch.mRecipeMap = this.getRecipeMap();
            return this.mMiddleInputHatches.add(tHatch);
        }
        return false;
    }

    private boolean addLeftHatchToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            GT_MetaTileEntity_Hatch_Input tHatch = (GT_MetaTileEntity_Hatch_Input)aMetaTileEntity;
            if (this.mInputOnSide == 1) {
                return false;
            }
            this.mInputOnSide = 0;
            this.mOutputOnSide = 1;
            tHatch.updateTexture(aBaseCasingIndex);
            tHatch.mRecipeMap = this.getRecipeMap();
            return this.mInputHatches.add(tHatch);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Output) {
            GT_MetaTileEntity_Hatch_Output tHatch = (GT_MetaTileEntity_Hatch_Output)aMetaTileEntity;
            if (this.mOutputOnSide == 1) {
                return false;
            }
            this.mInputOnSide = 1;
            this.mOutputOnSide = 0;
            tHatch.updateTexture(aBaseCasingIndex);
            return this.mOutputHatches.add(tHatch);
        }
        return false;
    }

    private boolean addRightHatchToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            GT_MetaTileEntity_Hatch_Input tHatch = (GT_MetaTileEntity_Hatch_Input)aMetaTileEntity;
            if (this.mInputOnSide == 0) {
                return false;
            }
            this.mInputOnSide = 1;
            this.mOutputOnSide = 0;
            tHatch.updateTexture(aBaseCasingIndex);
            tHatch.mRecipeMap = this.getRecipeMap();
            return this.mInputHatches.add(tHatch);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Output) {
            GT_MetaTileEntity_Hatch_Output tHatch = (GT_MetaTileEntity_Hatch_Output)aMetaTileEntity;
            if (this.mOutputOnSide == 0) {
                return false;
            }
            this.mInputOnSide = 0;
            this.mOutputOnSide = 1;
            tHatch.updateTexture(aBaseCasingIndex);
            return this.mOutputHatches.add(tHatch);
        }
        return false;
    }

    private void onCasingAdded() {
        ++this.mCasingAmount;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.setCoilLevel(HeatingCoilLevel.None);
        this.mCasingAmount = 0;
        this.mMiddleInputHatches.clear();
        this.mInputOnSide = -1;
        this.mOutputOnSide = -1;
        this.replaceDeprecatedCoils(aBaseMetaTileEntity);
        return this.checkPiece(STRUCTURE_PIECE_MAIN, 2, 1, 0) && this.mInputOnSide != -1 && this.mOutputOnSide != -1 && this.mCasingAmount >= 18 && this.mMaintenanceHatches.size() == 1 && !this.mMiddleInputHatches.isEmpty();
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_OilCracker(this.mName);
    }

    private void replaceDeprecatedCoils(IGregTechTileEntity aBaseMetaTileEntity) {
        int xDir = aBaseMetaTileEntity.getBackFacing().offsetX;
        int zDir = aBaseMetaTileEntity.getBackFacing().offsetZ;
        int tX = aBaseMetaTileEntity.getXCoord() + xDir;
        short tY = aBaseMetaTileEntity.getYCoord();
        int tZ = aBaseMetaTileEntity.getZCoord() + zDir;
        for (int xPos = tX - 1; xPos <= tX + 1; xPos += xDir != 0 ? 1 : 2) {
            for (int yPos = tY - 1; yPos <= tY + 1; ++yPos) {
                for (int zPos = tZ - 1; zPos <= tZ + 1; zPos += xDir != 0 ? 2 : 1) {
                    byte tUsedMeta;
                    if (yPos == tY && (xPos == tX || zPos == tZ) || (tUsedMeta = aBaseMetaTileEntity.getMetaID(xPos, yPos, zPos)) < 12 || tUsedMeta > 14 || aBaseMetaTileEntity.getBlock(xPos, yPos, zPos) != GregTech_API.sBlockCasings1) continue;
                    aBaseMetaTileEntity.getWorld().func_147465_d(xPos, yPos, zPos, GregTech_API.sBlockCasings5, tUsedMeta - 12, 3);
                }
            }
        }
    }

    @Override
    public ArrayList<FluidStack> getStoredFluids() {
        ArrayList<FluidStack> rList = new ArrayList<FluidStack>();
        for (GT_MetaTileEntity_Hatch_Input tHatch : GT_Utility.filterValidMTEs(this.mInputHatches)) {
            tHatch.mRecipeMap = this.getRecipeMap();
            if (tHatch instanceof GT_MetaTileEntity_Hatch_MultiInput) {
                for (FluidStack tFluid : ((GT_MetaTileEntity_Hatch_MultiInput)tHatch).getStoredFluid()) {
                    if (tFluid == null || GT_Recipe.GT_Recipe_Map.sCrackingRecipes.isValidCatalystFluid(tFluid)) continue;
                    rList.add(tFluid);
                }
                continue;
            }
            if (tHatch.getFillableStack() == null || GT_Recipe.GT_Recipe_Map.sCrackingRecipes.isValidCatalystFluid(tHatch.getFillableStack())) continue;
            rList.add(tHatch.getFillableStack());
        }
        for (GT_MetaTileEntity_Hatch_Input tHatch : GT_Utility.filterValidMTEs(this.mMiddleInputHatches)) {
            FluidStack tStack;
            tHatch.mRecipeMap = this.getRecipeMap();
            if (tHatch instanceof GT_MetaTileEntity_Hatch_MultiInput) {
                for (FluidStack tFluid : ((GT_MetaTileEntity_Hatch_MultiInput)tHatch).getStoredFluid()) {
                    if (tFluid == null || !GT_Recipe.GT_Recipe_Map.sCrackingRecipes.isValidCatalystFluid(tFluid)) continue;
                    rList.add(tFluid);
                }
                continue;
            }
            if (tHatch.getFillableStack() == null || !GT_Recipe.GT_Recipe_Map.sCrackingRecipes.isValidCatalystFluid(tStack = tHatch.getFillableStack())) continue;
            rList.add(tStack);
        }
        return rList;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 2, 1, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 2, 1, 0, elementBudget, env, false, true);
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }
}

