/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Textures;
import gregtech.api.enums.VoidingMode;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_EnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_DataAccess;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_MultiInput;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.multitileentity.multiblock.casing.Glasses;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_AssemblyLineUtils;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.IGT_HatchAdder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class GT_MetaTileEntity_AssemblyLine
extends GT_MetaTileEntity_EnhancedMultiBlockBase<GT_MetaTileEntity_AssemblyLine>
implements ISurvivalConstructable {
    public ArrayList<GT_MetaTileEntity_Hatch_DataAccess> mDataAccessHatches = new ArrayList();
    private static final String STRUCTURE_PIECE_FIRST = "first";
    private static final String STRUCTURE_PIECE_LATER = "later";
    private static final String STRUCTURE_PIECE_LAST = "last";
    private static final IStructureDefinition<GT_MetaTileEntity_AssemblyLine> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("first", StructureUtility.transpose((String[][])new String[][]{{" ", "e", " "}, {"~", "l", "G"}, {"g", "m", "g"}, {"b", "i", "b"}})).addShape("later", StructureUtility.transpose((String[][])new String[][]{{" ", "e", " "}, {"d", "l", "d"}, {"g", "m", "g"}, {"b", "I", "b"}})).addShape("last", StructureUtility.transpose((String[][])new String[][]{{" ", "e", " "}, {"d", "l", "d"}, {"g", "m", "g"}, {"o", "i", "b"}})).addElement('G', StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings3, (int)10)).addElement('l', StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings2, (int)9)).addElement('m', StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings2, (int)5)).addElement('g', Glasses.chainAllGlasses()).addElement('e', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_HatchElement.Energy.newAny(16, 1, ForgeDirection.UP, ForgeDirection.NORTH, ForgeDirection.SOUTH), StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings2, (int)0)})).addElement('d', GT_StructureUtility.buildHatchAdder(GT_MetaTileEntity_AssemblyLine.class).atLeast(DataHatchElement.DataAccess).dot(2).casingIndex(42).allowOnly(ForgeDirection.NORTH).buildAndChain(GregTech_API.sBlockCasings3, 10)).addElement('b', GT_StructureUtility.buildHatchAdder(GT_MetaTileEntity_AssemblyLine.class).atLeast(GT_HatchElement.InputHatch, GT_HatchElement.InputHatch, GT_HatchElement.InputHatch, GT_HatchElement.InputHatch, GT_HatchElement.Maintenance).casingIndex(16).dot(3).allowOnly(ForgeDirection.DOWN).buildAndChain(new IStructureElement[]{StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings2, (int)0), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addOutputToMachineList, 16, 4)})).addElement('I', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_HatchElement.InputBus.newAny(16, 5, ForgeDirection.DOWN), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addOutputToMachineList, 16, 4)})).addElement('i', GT_HatchElement.InputBus.newAny(16, 5, ForgeDirection.DOWN)).addElement('o', GT_HatchElement.OutputBus.newAny(16, 4, ForgeDirection.DOWN)).build();

    public GT_MetaTileEntity_AssemblyLine(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_AssemblyLine(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_AssemblyLine(this.mName);
    }

    @Override
    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Assembling Line").addInfo("Controller block for the Assembling Line").addInfo("Used to make complex machine parts (LuV+)").addInfo("Does not make Assembler items").addSeparator().beginVariableStructureBlock(5, 16, 4, 4, 3, 3, false).addStructureInfo("From Bottom to Top, Left to Right").addStructureInfo("Layer 1 - Solid Steel Machine Casing, Input Bus (last can be Output Bus), Solid Steel Machine Casing").addStructureInfo("Layer 2 - Borosilicate Glass(any)/Warded Glass/Reinforced Glass, Assembling Line Casing, Reinforced Glass").addStructureInfo("Layer 3 - Grate Machine Casing, Assembler Machine Casing, Grate Machine Casing").addStructureInfo("Layer 4 - Empty, Solid Steel Machine Casing, Empty").addStructureInfo("Up to 16 repeating slices, each one allows for 1 more item in recipes").addController("Either Grate on layer 3 of the first slice").addEnergyHatch("Any layer 4 casing", 1).addMaintenanceHatch("Any layer 1 casing", 3).addInputBus("As specified on layer 1", 4, 5).addInputHatch("Any layer 1 casing", 3).addOutputBus("Replaces Input Bus on final slice or on any solid steel casing on layer 1", 4).addOtherStructurePart("Data Access Hatch", "Optional, next to controller", 2).toolTipFinisher("Gregtech");
        return tt;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection sideDirection, ForgeDirection facingDirection, int colorIndex, boolean active, boolean redstoneLevel) {
        if (sideDirection == facingDirection) {
            if (active) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][16], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][16], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][16]};
    }

    @Override
    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return null;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing() {
        int i;
        ArrayList<ItemStack> tDataStickList;
        if (GT_Values.D1) {
            GT_Mod.GT_FML_LOGGER.info("Start ALine recipe check");
        }
        if ((tDataStickList = this.getDataItems(2)).isEmpty()) {
            return CheckRecipeResultRegistry.NO_DATA_STICKS;
        }
        if (GT_Values.D1) {
            GT_Mod.GT_FML_LOGGER.info("Stick accepted, " + tDataStickList.size() + " Data Sticks found");
        }
        int[] tStack = null;
        int[] tFluids = null;
        int[] tFluidSlot = null;
        boolean foundRecipe = false;
        block0: for (ItemStack tDataStick : tDataStickList) {
            GT_AssemblyLineUtils.LookupResult tLookupResult = GT_AssemblyLineUtils.findAssemblyLineRecipeFromDataStick(tDataStick, false);
            if (tLookupResult.getType() == GT_AssemblyLineUtils.LookupResultType.INVALID_STICK) continue;
            GT_Recipe.GT_Recipe_AssemblyLine tRecipe = tLookupResult.getRecipe();
            if (tLookupResult.getType() != GT_AssemblyLineUtils.LookupResultType.VALID_STACK_AND_VALID_HASH && (tRecipe = GT_AssemblyLineUtils.processDataStick(tDataStick)) == null || !this.canOutputAll(new ItemStack[]{tRecipe.mOutput})) continue;
            if (this.mInputBusses.size() < tRecipe.mInputs.length || this.mInputHatches.size() < tRecipe.mFluidInputs.length) {
                if (!GT_Values.D1) continue;
                GT_Mod.GT_FML_LOGGER.info("Not enough sources: Need ({}, {}), has ({}, {})", new Object[]{this.mInputBusses.size(), tRecipe.mInputs.length, this.mInputHatches.size(), tRecipe.mFluidInputs.length});
                continue;
            }
            int aItemCount = tRecipe.mInputs.length;
            tStack = new int[aItemCount];
            for (int i2 = 0; i2 < aItemCount; ++i2) {
                ItemStack tSlotStack;
                int tRequiredStackSize;
                GT_MetaTileEntity_Hatch_InputBus tInputBus = (GT_MetaTileEntity_Hatch_InputBus)this.mInputBusses.get(i2);
                if (!tInputBus.isValid() || (tRequiredStackSize = GT_MetaTileEntity_AssemblyLine.isStackValidIngredient(tSlotStack = tInputBus.func_70301_a(0), tRecipe.mInputs[i2], tRecipe.mOreDictAlt[i2])) < 0) continue block0;
                tStack[i2] = tRequiredStackSize;
                if (!GT_Values.D1) continue;
                GT_Mod.GT_FML_LOGGER.info("Item: " + i2 + " accepted");
            }
            int aFluidCount = tRecipe.mFluidInputs.length;
            tFluids = new int[aFluidCount];
            tFluidSlot = new int[aFluidCount];
            for (int i3 = 0; i3 < aFluidCount; ++i3) {
                if (!((GT_MetaTileEntity_Hatch_Input)this.mInputHatches.get(i3)).isValid()) continue block0;
                Object tRequiredStackSize = this.mInputHatches.get(i3);
                if (tRequiredStackSize instanceof GT_MetaTileEntity_Hatch_MultiInput) {
                    GT_MetaTileEntity_Hatch_MultiInput tMultiHatch = (GT_MetaTileEntity_Hatch_MultiInput)tRequiredStackSize;
                    if (!tMultiHatch.hasFluid(tRecipe.mFluidInputs[i3]) || tMultiHatch.getFluidAmount(tRecipe.mFluidInputs[i3]) < tRecipe.mFluidInputs[i3].amount) continue block0;
                    tFluids[i3] = tRecipe.mFluidInputs[i3].amount;
                    tFluidSlot[i3] = tMultiHatch.getFluidSlot(tRecipe.mFluidInputs[i3]);
                } else {
                    FluidStack fluidInHatch = ((GT_MetaTileEntity_Hatch_Input)this.mInputHatches.get((int)i3)).mFluid;
                    if (!GT_Utility.areFluidsEqual(fluidInHatch, tRecipe.mFluidInputs[i3], true) || fluidInHatch.amount < tRecipe.mFluidInputs[i3].amount) continue block0;
                    tFluids[i3] = tRecipe.mFluidInputs[i3].amount;
                }
                if (!GT_Values.D1) continue;
                GT_Mod.GT_FML_LOGGER.info("Fluid:" + i3 + " accepted");
            }
            if (GT_Values.D1) {
                GT_Mod.GT_FML_LOGGER.info("Check overclock");
            }
            this.calculateOverclockedNessMultiInternal(tRecipe.mEUt, tRecipe.mDuration, 1, this.getMaxInputVoltage(), false);
            if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                if (!GT_Values.D1) continue;
                GT_Mod.GT_FML_LOGGER.info("Recipe too OP");
                continue;
            }
            if (GT_Values.D1) {
                GT_Mod.GT_FML_LOGGER.info("Find available recipe");
            }
            this.mOutputItems = new ItemStack[]{tRecipe.mOutput};
            foundRecipe = true;
            break;
        }
        if (!foundRecipe || tStack.length == 0) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        if (GT_Values.D1) {
            GT_Mod.GT_FML_LOGGER.info("All checked start consuming inputs");
        }
        for (i = 0; i < tStack.length; ++i) {
            ItemStack stackInSlot = ((GT_MetaTileEntity_Hatch_InputBus)this.mInputBusses.get(i)).func_70301_a(0);
            stackInSlot.field_77994_a -= tStack[i];
        }
        for (i = 0; i < tFluids.length; ++i) {
            Object e = this.mInputHatches.get(i);
            if (e instanceof GT_MetaTileEntity_Hatch_MultiInput) {
                GT_MetaTileEntity_Hatch_MultiInput tMultiHatch = (GT_MetaTileEntity_Hatch_MultiInput)e;
                tMultiHatch.getFluid((int)tFluidSlot[i]).amount -= tFluids[i];
                if (tMultiHatch.getFluid((int)tFluidSlot[i]).amount > 0) continue;
                tMultiHatch.setFluid(null, (int)tFluidSlot[i]);
                continue;
            }
            ((GT_MetaTileEntity_Hatch_Input)this.mInputHatches.get((int)i)).mFluid.amount -= tFluids[i];
            if (((GT_MetaTileEntity_Hatch_Input)this.mInputHatches.get((int)i)).mFluid.amount > 0) continue;
            ((GT_MetaTileEntity_Hatch_Input)this.mInputHatches.get((int)i)).mFluid = null;
        }
        if (this.mEUt > 0) {
            this.mEUt = -this.mEUt;
        }
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        this.updateSlots();
        if (GT_Values.D1) {
            GT_Mod.GT_FML_LOGGER.info("Recipe successful");
        }
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    private static int isStackValidIngredient(ItemStack aSlotStack, ItemStack aIngredient, ItemStack[] alts) {
        if (alts == null || alts.length == 0) {
            return GT_MetaTileEntity_AssemblyLine.isStackValidIngredient(aSlotStack, aIngredient);
        }
        for (ItemStack tAltStack : alts) {
            int i = GT_MetaTileEntity_AssemblyLine.isStackValidIngredient(aSlotStack, tAltStack);
            if (i < 0) continue;
            return i;
        }
        return -1;
    }

    private static int isStackValidIngredient(ItemStack aSlotStack, ItemStack aIngredient) {
        if (GT_Utility.areStacksEqual(aSlotStack, aIngredient, true) && aIngredient.field_77994_a <= aSlotStack.field_77994_a) {
            return aIngredient.field_77994_a;
        }
        return -1;
    }

    @Override
    public boolean onRunningTick(ItemStack aStack) {
        for (GT_MetaTileEntity_Hatch_DataAccess hatch_dataAccess : this.mDataAccessHatches) {
            hatch_dataAccess.setActive(true);
        }
        return super.onRunningTick(aStack);
    }

    @Override
    public IStructureDefinition<GT_MetaTileEntity_AssemblyLine> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mDataAccessHatches.clear();
        if (!this.checkPiece(STRUCTURE_PIECE_FIRST, 0, 1, 0)) {
            return false;
        }
        return this.checkMachine(true) || this.checkMachine(false);
    }

    private boolean checkMachine(boolean leftToRight) {
        for (int i = 1; i < 16; ++i) {
            if (!this.checkPiece(STRUCTURE_PIECE_LATER, leftToRight ? -i : i, 1, 0)) {
                return false;
            }
            if (this.mOutputBusses.isEmpty()) continue;
            return !this.mEnergyHatches.isEmpty() && this.mMaintenanceHatches.size() == 1 && this.mDataAccessHatches.size() <= 1;
        }
        return false;
    }

    private boolean isCorrectDataItem(ItemStack aStack, int state) {
        if ((state & 1) != 0 && ItemList.Circuit_Integrated.isStackEqual(aStack, true, true)) {
            return true;
        }
        if ((state & 2) != 0 && ItemList.Tool_DataStick.isStackEqual(aStack, false, true)) {
            return true;
        }
        return (state & 4) != 0 && ItemList.Tool_DataOrb.isStackEqual(aStack, false, true);
    }

    public ArrayList<ItemStack> getDataItems(int state) {
        ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
        if (GT_Utility.isStackValid(this.mInventory[1]) && this.isCorrectDataItem(this.mInventory[1], state)) {
            rList.add(this.mInventory[1]);
        }
        for (GT_MetaTileEntity_Hatch_DataAccess tHatch : GT_Utility.filterValidMTEs(this.mDataAccessHatches)) {
            for (int i = 0; i < tHatch.getBaseMetaTileEntity().func_70302_i_(); ++i) {
                if (tHatch.getBaseMetaTileEntity().func_70301_a(i) == null || !this.isCorrectDataItem(tHatch.getBaseMetaTileEntity().func_70301_a(i), state)) continue;
                rList.add(tHatch.getBaseMetaTileEntity().func_70301_a(i));
            }
        }
        return rList;
    }

    public boolean addDataAccessToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_DataAccess) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mDataAccessHatches.add((GT_MetaTileEntity_Hatch_DataAccess)aMetaTileEntity);
        }
        return false;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_FIRST, stackSize, hintsOnly, 0, 1, 0);
        int tLength = Math.min(stackSize.field_77994_a + 1, 16);
        for (int i = 1; i < tLength; ++i) {
            this.buildPiece(STRUCTURE_PIECE_LATER, stackSize, hintsOnly, -i, 1, 0);
        }
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        int build = this.survivialBuildPiece(STRUCTURE_PIECE_FIRST, stackSize, 0, 1, 0, elementBudget, env, false, true);
        if (build >= 0) {
            return build;
        }
        int tLength = Math.min(stackSize.field_77994_a + 1, 16);
        for (int i = 1; i < tLength - 1; ++i) {
            build = this.survivialBuildPiece(STRUCTURE_PIECE_LATER, stackSize, -i, 1, 0, elementBudget, env, false, true);
            if (build < 0) continue;
            return build;
        }
        return this.survivialBuildPiece(STRUCTURE_PIECE_LAST, stackSize, 1 - tLength, 1, 0, elementBudget, env, false, true);
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    public Set<VoidingMode> getAllowedVoidingModes() {
        return VoidingMode.ITEM_ONLY_MODES;
    }

    private static enum DataHatchElement implements IHatchElement<GT_MetaTileEntity_AssemblyLine>
    {
        DataAccess;


        @Override
        public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
            return Collections.singletonList(GT_MetaTileEntity_Hatch_DataAccess.class);
        }

        @Override
        public IGT_HatchAdder<GT_MetaTileEntity_AssemblyLine> adder() {
            return GT_MetaTileEntity_AssemblyLine::addDataAccessToMachineList;
        }

        @Override
        public long count(GT_MetaTileEntity_AssemblyLine t) {
            return t.mDataAccessHatches.size();
        }
    }
}

