/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.power;

import gregtech.api.enums.GT_Values;
import gregtech.common.power.BasicMachineEUPower;
import gregtech.nei.FusionSpecialValueFormatter;
import net.minecraft.util.EnumChatFormatting;

public class FusionPower
extends BasicMachineEUPower {
    public FusionPower(byte tier, int startupPower) {
        super(tier, 1, startupPower);
    }

    @Override
    public void computePowerUsageAndDuration(int euPerTick, int duration, int specialValue) {
        this.originalVoltage = this.computeVoltageForEuRate(euPerTick);
        this.recipeEuPerTick = euPerTick;
        this.recipeDuration = duration;
        if (this.tier > 0) {
            int maxPossibleOverclocks = FusionSpecialValueFormatter.getFusionTier(this.specialValue, GT_Values.V[this.tier - 1]) - FusionSpecialValueFormatter.getFusionTier(specialValue, euPerTick);
            long tempEUt = Math.max((long)euPerTick, GT_Values.V[1]);
            this.recipeDuration = duration;
            while (tempEUt <= GT_Values.V[this.tier - 1] * (long)this.amperage && maxPossibleOverclocks-- > 0) {
                tempEUt <<= 1;
                this.recipeDuration >>= 1;
            }
            if (tempEUt > 0x7FFFFFFEL) {
                this.recipeEuPerTick = 0x7FFFFFFE;
                this.recipeDuration = 0x7FFFFFFE;
            } else {
                this.recipeEuPerTick = (int)tempEUt;
                if (this.recipeEuPerTick == 0) {
                    this.recipeEuPerTick = 1;
                }
                if (this.recipeDuration == 0) {
                    this.recipeDuration = 1;
                }
            }
        }
        this.wasOverclocked = this.checkIfOverclocked();
    }

    @Override
    public String getTierString() {
        return GT_Values.TIER_COLORS[this.tier] + "MK " + (this.tier - 5) + EnumChatFormatting.RESET;
    }
}

