/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipe.check;

import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.util.GT_OverclockCalculator;
import gregtech.api.util.GT_ParallelHelper;
import gregtech.api.util.GT_Recipe;
import java.util.function.Function;
import java.util.function.Predicate;

public class RecipeValidator
implements Predicate<GT_Recipe> {
    private CheckRecipeResult firstCheckResult;
    private CheckRecipeResult lastCheckResult;
    private GT_ParallelHelper lastParallelHelper;
    private GT_OverclockCalculator lastOverclockCalculator;
    private boolean wasExecutedAtLeastOnce = false;
    private final Function<GT_Recipe, CheckRecipeResult> recipeValidator;
    private final Function<GT_Recipe, GT_ParallelHelper> parallelHelperFactory;
    private final Function<GT_Recipe, GT_OverclockCalculator> overclockCalculatorFactory;

    public RecipeValidator(Function<GT_Recipe, CheckRecipeResult> recipeValidator, Function<GT_Recipe, GT_ParallelHelper> parallelHelperFactory, Function<GT_Recipe, GT_OverclockCalculator> overclockCalculatorFactory) {
        this.recipeValidator = recipeValidator;
        this.parallelHelperFactory = parallelHelperFactory;
        this.overclockCalculatorFactory = overclockCalculatorFactory;
    }

    @Override
    public boolean test(GT_Recipe recipe) {
        this.wasExecutedAtLeastOnce = true;
        CheckRecipeResult checkRecipeResult = this.checkRecipe(recipe);
        if (this.firstCheckResult == null) {
            this.firstCheckResult = checkRecipeResult;
        }
        return checkRecipeResult.wasSuccessful();
    }

    private CheckRecipeResult checkRecipe(GT_Recipe recipe) {
        this.lastCheckResult = this.recipeValidator.apply(recipe);
        if (!this.lastCheckResult.wasSuccessful()) {
            return this.lastCheckResult;
        }
        this.lastParallelHelper = this.parallelHelperFactory.apply(recipe);
        this.lastOverclockCalculator = this.overclockCalculatorFactory.apply(recipe);
        this.lastParallelHelper.setCalculator(this.lastOverclockCalculator);
        this.lastParallelHelper.build();
        return this.lastParallelHelper.getResult();
    }

    public Boolean isExecutedAtLeastOnce() {
        return this.wasExecutedAtLeastOnce;
    }

    public CheckRecipeResult getFirstCheckResult() {
        return this.firstCheckResult;
    }

    public CheckRecipeResult getLastCheckResult() {
        return this.lastCheckResult;
    }

    public GT_ParallelHelper getLastParallelHelper() {
        return this.lastParallelHelper;
    }

    public GT_OverclockCalculator getLastOverclockCalculator() {
        return this.lastOverclockCalculator;
    }
}

