/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.multitileentity.multiblock.base;

import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.alignment.IAlignment;
import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.IAlignmentProvider;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.alignment.enumerable.ExtendedFacing;
import com.gtnewhorizon.structurelib.alignment.enumerable.Flip;
import com.gtnewhorizon.structurelib.alignment.enumerable.Rotation;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.IStructureElementChain;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizon.structurelib.util.Vec3Impl;
import com.gtnewhorizons.modularui.api.ModularUITextures;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.ItemDrawable;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.forge.ItemStackHandler;
import com.gtnewhorizons.modularui.api.forge.ListItemHandler;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.FluidSlotWidget;
import com.gtnewhorizons.modularui.common.widget.MultiChildWidget;
import com.gtnewhorizons.modularui.common.widget.Scrollable;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TabButton;
import com.gtnewhorizons.modularui.common.widget.TabContainer;
import cpw.mods.fml.common.network.NetworkRegistry;
import gnu.trove.list.array.TIntArrayList;
import gregtech.GT_Mod;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TextureSet;
import gregtech.api.enums.VoidingMode;
import gregtech.api.fluid.FluidTankGT;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.IDescribable;
import gregtech.api.interfaces.fluid.IFluidStore;
import gregtech.api.interfaces.modularui.ControllerWithOptionalFeatures;
import gregtech.api.logic.PowerLogic;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.logic.interfaces.PowerLogicHost;
import gregtech.api.logic.interfaces.ProcessingLogicHost;
import gregtech.api.multitileentity.MultiTileEntityContainer;
import gregtech.api.multitileentity.MultiTileEntityRegistry;
import gregtech.api.multitileentity.enums.GT_MultiTileComponentCasing;
import gregtech.api.multitileentity.interfaces.IMultiBlockController;
import gregtech.api.multitileentity.interfaces.IMultiBlockPart;
import gregtech.api.multitileentity.interfaces.IMultiTileEntity;
import gregtech.api.multitileentity.machine.MultiTileBasicMachine;
import gregtech.api.multitileentity.multiblock.base.MultiBlockPart;
import gregtech.api.multitileentity.multiblock.casing.FunctionalCasing;
import gregtech.api.multitileentity.multiblock.casing.UpgradeCasing;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.GT_Waila;
import gregtech.common.tileentities.casings.upgrade.Inventory;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.SpecialChars;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.input.Keyboard;

public abstract class Controller<T extends Controller<T>>
extends MultiTileBasicMachine
implements IAlignment,
IConstructable,
IMultiBlockController,
IDescribable,
IMultiTileEntity.IMTE_AddToolTips,
ISurvivalConstructable,
ControllerWithOptionalFeatures {
    public static final String ALL_INVENTORIES_NAME = "all";
    private static final Map<Integer, GT_Multiblock_Tooltip_Builder> tooltip = new ConcurrentHashMap<Integer, GT_Multiblock_Tooltip_Builder>();
    private final List<UpgradeCasing> upgradeCasings = new ArrayList<UpgradeCasing>();
    private final List<FunctionalCasing> functionalCasings = new ArrayList<FunctionalCasing>();
    protected BuildState buildState = new BuildState();
    protected Map<String, String> multiBlockInputInventoryNames = new LinkedHashMap<String, String>();
    protected Map<String, String> multiBlockOutputInventoryNames = new LinkedHashMap<String, String>();
    protected Map<String, String> multiBlockInputInventoryToTankLink = new LinkedHashMap<String, String>();
    protected Map<String, IItemHandlerModifiable> multiBlockInputInventory = new LinkedHashMap<String, IItemHandlerModifiable>();
    protected Map<String, IItemHandlerModifiable> multiBlockOutputInventory = new LinkedHashMap<String, IItemHandlerModifiable>();
    protected Map<String, String> multiBlockInputTankNames = new LinkedHashMap<String, String>();
    protected Map<String, String> multiBlockOutputTankNames = new LinkedHashMap<String, String>();
    protected Map<String, FluidTankGT[]> multiBlockInputTank = new LinkedHashMap<String, FluidTankGT[]>();
    protected Map<String, FluidTankGT[]> multiBlockOutputTank = new LinkedHashMap<String, FluidTankGT[]>();
    private boolean structureOkay = false;
    private boolean structureChanged = false;
    private ExtendedFacing extendedFacing = ExtendedFacing.DEFAULT;
    private IAlignmentLimits limits = this.getInitialAlignmentLimits();
    private String inventoryName;
    private String tankName;
    protected boolean separateInputs = this.getDefaultInputSeparationMode();
    protected VoidingMode voidingMode = this.getDefaultVoidingMode();
    protected boolean batchMode = this.getDefaultBatchMode();
    protected boolean recipeLock = this.getDefaultRecipeLockingMode();
    protected boolean isSimpleMachine = true;
    protected List<LinkedList<WeakReference<IMultiBlockPart>>> registeredCoveredParts = Arrays.asList(new LinkedList(), new LinkedList(), new LinkedList(), new LinkedList(), new LinkedList(), new LinkedList());

    public abstract short getCasingRegistryID();

    public abstract int getCasingMeta();

    protected abstract GT_Multiblock_Tooltip_Builder createTooltip();

    public abstract Vec3Impl getStartingStructureOffset();

    public abstract IStructureDefinition<T> getStructureDefinition();

    public boolean checkMachine() {
        double sum = 0.0;
        if (this.functionalCasings == null || this.functionalCasings.size() == 0) {
            return false;
        }
        for (FunctionalCasing casing : this.functionalCasings) {
            sum += (double)((float)casing.getPartTier() * casing.getPartModifier());
        }
        this.tier = (int)Math.floor(sum / (double)this.functionalCasings.size());
        return this.tier > 0;
    }

    @Override
    public void writeMultiTileNBT(NBTTagCompound nbt) {
        super.writeMultiTileNBT(nbt);
        nbt.func_74757_a("gt.structure.ok", this.structureOkay);
        nbt.func_74774_a("gt.eRotation", (byte)this.extendedFacing.getRotation().getIndex());
        nbt.func_74774_a("gt.eFlip", (byte)this.extendedFacing.getFlip().getIndex());
        this.saveUpgradeInventoriesToNBT(nbt);
        this.saveUpgradeTanksToNBT(nbt);
        nbt.func_74778_a("gt.voiding.mode", this.voidingMode.name);
        nbt.func_74757_a("gt.separate.inputs", this.separateInputs);
        nbt.func_74757_a("gt.recipe.lock", this.recipeLock);
        nbt.func_74757_a("gt.batch.mode", this.batchMode);
    }

    private void saveUpgradeInventoriesToNBT(NBTTagCompound nbt) {
        NBTTagList inputInvList = new NBTTagList();
        this.multiBlockInputInventory.forEach((id, inv) -> {
            if (!id.equals("controller")) {
                NBTTagCompound tTag = new NBTTagCompound();
                tTag.func_74778_a("gt.invuuid.upg", id);
                tTag.func_74778_a("gt.invname.upg", this.multiBlockInputInventoryNames.get(id));
                tTag.func_74768_a("gt.invsize.upg", inv.getSlots());
                this.writeInventory(tTag, (IItemHandlerModifiable)inv, "gt.invlist.in");
                inputInvList.func_74742_a((NBTBase)tTag);
            }
        });
        NBTTagList outputInvList = new NBTTagList();
        this.multiBlockOutputInventory.forEach((id, inv) -> {
            if (!id.equals("controller")) {
                NBTTagCompound tTag = new NBTTagCompound();
                tTag.func_74778_a("gt.invuuid.upg", id);
                tTag.func_74778_a("gt.invname.upg", this.multiBlockOutputInventoryNames.get(id));
                tTag.func_74768_a("gt.invsize.upg", inv.getSlots());
                this.writeInventory(tTag, (IItemHandlerModifiable)inv, "gt.invlist.out");
                outputInvList.func_74742_a((NBTBase)tTag);
            }
        });
        nbt.func_74782_a("gt.invlist.upg.in", (NBTBase)inputInvList);
        nbt.func_74782_a("gt.invlist.upg.out", (NBTBase)outputInvList);
    }

    private void saveUpgradeTanksToNBT(NBTTagCompound nbt) {
        NBTTagList inputTankList = new NBTTagList();
        this.multiBlockInputTank.forEach((id, tanks) -> {
            if (!id.equals("controller") && tanks != null && ((FluidTankGT[])tanks).length > 0) {
                NBTTagCompound tTag = new NBTTagCompound();
                tTag.func_74778_a("gt.tankuuid.upg", id);
                tTag.func_74778_a("gt.tankname.upg", this.multiBlockInputTankNames.get(id));
                tTag.func_74772_a("gt.tank.cap.upg", tanks[0].capacity());
                tTag.func_74772_a("gt.tank.cap.mult.upg", tanks[0].getCapacityMultiplier());
                tTag.func_74768_a("gt.tankcount.upg", ((FluidTankGT[])tanks).length);
                for (int i = 0; i < ((FluidTankGT[])tanks).length; ++i) {
                    tanks[i].writeToNBT(tTag, "gt.tank.upg" + i);
                }
                inputTankList.func_74742_a((NBTBase)tTag);
            }
        });
        NBTTagList outputTankList = new NBTTagList();
        this.multiBlockOutputTank.forEach((id, tanks) -> {
            if (!id.equals("controller") && tanks != null && ((FluidTankGT[])tanks).length > 0) {
                NBTTagCompound tTag = new NBTTagCompound();
                tTag.func_74778_a("gt.tankuuid.upg", id);
                tTag.func_74778_a("gt.tankname.upg", this.multiBlockInputTankNames.get(id));
                tTag.func_74772_a("gt.tank.cap.upg", tanks[0].capacity());
                tTag.func_74772_a("gt.tank.cap.mult.upg", tanks[0].getCapacityMultiplier());
                tTag.func_74768_a("gt.tankcount.upg", ((FluidTankGT[])tanks).length);
                for (int i = 0; i < ((FluidTankGT[])tanks).length; ++i) {
                    tanks[i].writeToNBT(tTag, "gt.tank.upg" + i);
                }
                outputTankList.func_74742_a((NBTBase)tTag);
            }
        });
        nbt.func_74782_a("gt.tanklist.upg.in", (NBTBase)inputTankList);
        nbt.func_74782_a("gt.tanklist.upg.out", (NBTBase)outputTankList);
    }

    @Override
    public void readMultiTileNBT(NBTTagCompound nbt) {
        super.readMultiTileNBT(nbt);
        if (this.inputInventory != null) {
            this.registerInventory("controller", "controller", this.inputInventory, 0);
        }
        if (this.outputInventory != null) {
            this.registerInventory("controller", "controller", this.outputInventory, 1);
        }
        if (this.inputTanks != null) {
            this.registerFluidInventory("controller", "controller", this.inputTanks, 0);
        }
        if (this.outputTanks != null) {
            this.registerFluidInventory("controller", "controller", this.outputTanks, 1);
        }
        this.structureOkay = nbt.func_74767_n("gt.structure.ok");
        this.extendedFacing = ExtendedFacing.of((ForgeDirection)this.getFrontFacing(), (Rotation)Rotation.byIndex((int)nbt.func_74771_c("gt.eRotation")), (Flip)Flip.byIndex((int)nbt.func_74771_c("gt.eFlip")));
        this.loadUpgradeInventoriesFromNBT(nbt);
        this.loadUpgradeTanksFromNBT(nbt);
        this.voidingMode = VoidingMode.fromName(nbt.func_74779_i("gt.voiding.mode"));
        this.separateInputs = nbt.func_74767_n("gt.separate.inputs");
        this.recipeLock = nbt.func_74767_n("gt.recipe.lock");
        this.batchMode = nbt.func_74767_n("gt.batch.mode");
    }

    private void loadUpgradeInventoriesFromNBT(NBTTagCompound nbt) {
        NBTTagList listInputInventories = nbt.func_150295_c("gt.invlist.upg.in", 10);
        for (int i = 0; i < listInputInventories.func_74745_c(); ++i) {
            NBTTagCompound nbtInv = listInputInventories.func_150305_b(i);
            String invUUID = nbtInv.func_74779_i("gt.invuuid.upg");
            String invName = nbtInv.func_74779_i("gt.invname.upg");
            int invSize = nbtInv.func_74762_e("gt.invsize.upg");
            ItemStackHandler inv = new ItemStackHandler(invSize);
            this.loadInventory(nbtInv, (IItemHandlerModifiable)inv, "gt.invlist.in");
            this.registerInventory(invName, invUUID, invSize, 0);
        }
        NBTTagList listOutputInventories = nbt.func_150295_c("gt.invlist.upg.out", 10);
        for (int i = 0; i < listOutputInventories.func_74745_c(); ++i) {
            NBTTagCompound nbtInv = listOutputInventories.func_150305_b(i);
            String invUUID = nbtInv.func_74779_i("gt.invuuid.upg");
            String invName = nbtInv.func_74779_i("gt.invname.upg");
            int invSize = nbtInv.func_74762_e("gt.invsize.upg");
            ItemStackHandler inv = new ItemStackHandler(invSize);
            this.loadInventory(nbtInv, (IItemHandlerModifiable)inv, "gt.invlist.out");
            this.registerInventory(invName, invUUID, invSize, 1);
        }
    }

    private void loadUpgradeTanksFromNBT(NBTTagCompound nbt) {
        NBTTagList listInputTanks = nbt.func_150295_c("gt.tanklist.upg.in", 10);
        for (int i = 0; i < listInputTanks.func_74745_c(); ++i) {
            NBTTagCompound nbtTank = listInputTanks.func_150305_b(i);
            String tankUUID = nbtTank.func_74779_i("gt.tankuuid.upg");
            String tankName = nbtTank.func_74779_i("gt.tankname.upg");
            long capacity = nbtTank.func_74763_f("gt.tank.cap.upg");
            long capacityMultiplier = nbtTank.func_74763_f("gt.tank.cap.mult.upg");
            int count = nbtTank.func_74762_e("gt.tankcount.upg");
            FluidTankGT[] tanks = new FluidTankGT[count];
            for (int j = 0; j < count; ++j) {
                tanks[j] = new FluidTankGT(capacity).setCapacityMultiplier(capacityMultiplier).readFromNBT(nbtTank, "gt.tank.upg" + j);
            }
            this.registerFluidInventory(tankName, tankUUID, count, capacity, capacityMultiplier, 0);
        }
        NBTTagList listOutputTanks = nbt.func_150295_c("gt.tanklist.upg.out", 10);
        for (int i = 0; i < listOutputTanks.func_74745_c(); ++i) {
            NBTTagCompound nbtTank = listOutputTanks.func_150305_b(i);
            String tankUUID = nbtTank.func_74779_i("gt.tankuuid.upg");
            String tankName = nbtTank.func_74779_i("gt.tankname.upg");
            long capacity = nbtTank.func_74763_f("gt.tank.cap.upg");
            long capacityMultiplier = nbtTank.func_74763_f("gt.tank.cap.mult.upg");
            int count = nbtTank.func_74762_e("gt.tankcount.upg");
            FluidTankGT[] tanks = new FluidTankGT[count];
            for (int j = 0; j < count; ++j) {
                tanks[j] = new FluidTankGT(capacity).setCapacityMultiplier(capacityMultiplier).readFromNBT(nbtTank, "gt.tank.upg" + j);
            }
            this.registerFluidInventory(tankName, tankUUID, count, capacity, capacityMultiplier, 1);
        }
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.addAll(Arrays.asList(this.getDescription()));
    }

    @Override
    public String[] getDescription() {
        if (Keyboard.isKeyDown((int)42)) {
            return this.getTooltip().getStructureInformation();
        }
        return this.getTooltip().getInformation();
    }

    @Override
    protected void addDebugInfo(EntityPlayer aPlayer, int aLogLevel, ArrayList<String> tList) {
        super.addDebugInfo(aPlayer, aLogLevel, tList);
        tList.add("Structure ok: " + this.checkStructure(false));
    }

    protected int getToolTipID() {
        return this.getMultiTileEntityRegistryID() << 16 + this.getMultiTileEntityID();
    }

    protected GT_Multiblock_Tooltip_Builder getTooltip() {
        GT_Multiblock_Tooltip_Builder builder = tooltip.get(this.getToolTipID());
        if (builder == null) {
            builder = this.createTooltip();
            tooltip.put(this.getToolTipID(), builder);
        }
        return builder;
    }

    @Override
    public boolean checkStructure(boolean aForceReset) {
        if (!this.isServerSide()) {
            return this.structureOkay;
        }
        if (this.structureChanged || aForceReset) {
            this.structureOkay = this.checkMachine();
        }
        this.structureChanged = false;
        return this.structureOkay;
    }

    @Override
    public void onStructureChange() {
        this.structureChanged = true;
    }

    public final boolean checkPiece(String piece, Vec3Impl offset) {
        this.functionalCasings.clear();
        this.upgradeCasings.clear();
        return this.checkPiece(piece, offset.get0(), offset.get1(), offset.get2());
    }

    protected final boolean checkPiece(String piece, int horizontalOffset, int verticalOffset, int depthOffset) {
        return this.getCastedStructureDefinition().check((Object)this, piece, this.getWorld(), this.getExtendedFacing(), this.getXCoord(), (int)this.getYCoord(), this.getZCoord(), horizontalOffset, verticalOffset, depthOffset, !this.structureOkay);
    }

    public final boolean buildPiece(String piece, ItemStack trigger, boolean hintsOnly, Vec3Impl offset) {
        return this.buildPiece(piece, trigger, hintsOnly, offset.get0(), offset.get1(), offset.get2());
    }

    protected final boolean buildPiece(String piece, ItemStack trigger, boolean hintOnly, int horizontalOffset, int verticalOffset, int depthOffset) {
        return this.getCastedStructureDefinition().buildOrHints((Object)this, trigger, piece, this.getWorld(), this.getExtendedFacing(), this.getXCoord(), (int)this.getYCoord(), this.getZCoord(), horizontalOffset, verticalOffset, depthOffset, hintOnly);
    }

    protected final int survivalBuildPiece(String piece, ItemStack trigger, Vec3Impl offset, int elementBudget, ISurvivalBuildEnvironment env, boolean check) {
        return this.survivalBuildPiece(piece, trigger, offset.get0(), offset.get1(), offset.get2(), elementBudget, env, check);
    }

    protected final Integer survivalBuildPiece(String piece, ItemStack trigger, int horizontalOffset, int verticalOffset, int depthOffset, int elementBudget, ISurvivalBuildEnvironment env, boolean check) {
        return this.getCastedStructureDefinition().survivalBuild((Object)this, trigger, piece, this.getWorld(), this.getExtendedFacing(), this.getXCoord(), (int)this.getYCoord(), this.getZCoord(), horizontalOffset, verticalOffset, depthOffset, elementBudget, env, check);
    }

    private IStructureDefinition<Controller<T>> getCastedStructureDefinition() {
        return this.getStructureDefinition();
    }

    public ExtendedFacing getExtendedFacing() {
        return this.extendedFacing;
    }

    public void setExtendedFacing(ExtendedFacing newExtendedFacing) {
        if (this.extendedFacing != newExtendedFacing) {
            this.onStructureChange();
            if (this.structureOkay) {
                this.stopMachine(false);
            }
            this.extendedFacing = newExtendedFacing;
            this.structureOkay = false;
            if (this.isServerSide()) {
                StructureLibAPI.sendAlignment((IAlignmentProvider)this, (NetworkRegistry.TargetPoint)new NetworkRegistry.TargetPoint(this.getWorld().field_73011_w.field_76574_g, (double)this.getXCoord(), (double)this.getYCoord(), (double)this.getZCoord(), 512.0));
            } else {
                this.issueTextureUpdate();
            }
        }
    }

    @Override
    public boolean onWrenchRightClick(EntityPlayer aPlayer, ItemStack tCurrentItem, ForgeDirection wrenchSide, float aX, float aY, float aZ) {
        if (wrenchSide != this.getFrontFacing()) {
            return super.onWrenchRightClick(aPlayer, tCurrentItem, wrenchSide, aX, aY, aZ);
        }
        if (aPlayer.func_70093_af()) {
            this.toolSetFlip(this.getFlip().isHorizontallyFlipped() ? Flip.NONE : Flip.HORIZONTAL);
        } else {
            this.toolSetRotation(null);
        }
        return true;
    }

    @Override
    public void registerCoveredPartOnSide(ForgeDirection side, IMultiBlockPart part) {
        if (side == ForgeDirection.UNKNOWN) {
            return;
        }
        LinkedList<WeakReference<IMultiBlockPart>> registeredCovers = this.registeredCoveredParts.get(side.ordinal());
        registeredCovers.add(new WeakReference<IMultiBlockPart>(part));
    }

    @Override
    public void unregisterCoveredPartOnSide(ForgeDirection side, IMultiBlockPart aPart) {
        if (side == ForgeDirection.UNKNOWN) {
            return;
        }
        LinkedList<WeakReference<IMultiBlockPart>> coveredParts = this.registeredCoveredParts.get(side.ordinal());
        Iterator it = coveredParts.iterator();
        while (it.hasNext()) {
            IMultiBlockPart part = (IMultiBlockPart)((WeakReference)it.next()).get();
            if (part != null && part != aPart) continue;
            it.remove();
        }
    }

    @Override
    public void onFirstTick(boolean isServerSide) {
        super.onFirstTick(isServerSide);
        if (isServerSide) {
            this.checkStructure(true);
        } else {
            StructureLibAPI.queryAlignment((IAlignmentProvider)this);
        }
    }

    private boolean tickCovers() {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            LinkedList<WeakReference<IMultiBlockPart>> coveredParts = this.registeredCoveredParts.get(side.ordinal());
            Iterator it = coveredParts.iterator();
            while (it.hasNext()) {
                IMultiBlockPart part = (IMultiBlockPart)((WeakReference)it.next()).get();
                if (part == null) {
                    it.remove();
                    continue;
                }
                if (part.tickCoverAtSide(side, this.mTickTimer)) continue;
                it.remove();
            }
        }
        return true;
    }

    @Override
    public void onTick(long timer, boolean isServerSide) {
        if (!this.tickCovers()) {
            return;
        }
    }

    @Override
    public void onPostTick(long tick, boolean isServerSide) {
        if (isServerSide) {
            if (tick % 600L == 5L) {
                this.clearSpecialLists();
                if (!this.checkStructure(false)) {
                    this.checkStructure(true);
                }
            }
            if (this.checkStructure(false)) {
                this.runMachine(tick);
            } else {
                this.stopMachine(false);
            }
        } else {
            this.doActivitySound(this.getActivitySoundLoop());
        }
    }

    protected void clearSpecialLists() {
        this.upgradeCasings.clear();
    }

    @Override
    public final boolean isFacingValid(ForgeDirection facing) {
        return this.canSetToDirectionAny(facing);
    }

    @Override
    public void onFacingChange() {
        this.toolSetDirection(this.getFrontFacing());
        this.onStructureChange();
    }

    @Override
    public boolean allowCoverOnSide(ForgeDirection side, GT_ItemStack aCoverID) {
        return side != this.facing;
    }

    public String[] getStructureDescription(ItemStack stackSize) {
        return this.getTooltip().getStructureHint();
    }

    public IAlignmentLimits getAlignmentLimits() {
        return this.limits;
    }

    protected void setAlignmentLimits(IAlignmentLimits mLimits) {
        this.limits = mLimits;
    }

    @Override
    public long getProgress() {
        return this.progressTime;
    }

    @Override
    public long getMaxProgress() {
        return this.maxProgressTime;
    }

    @Override
    public boolean increaseProgress(int aProgressAmountInTicks) {
        return this.increaseProgressGetOverflow(aProgressAmountInTicks) != aProgressAmountInTicks;
    }

    @Override
    public FluidStack getDrainableFluid(ForgeDirection side) {
        return this.getDrainableFluid(side, null);
    }

    @Override
    public FluidStack getDrainableFluid(ForgeDirection side, Fluid fluidToDrain) {
        IFluidTank tank = this.getFluidTankDrainable(side, fluidToDrain == null ? null : new FluidStack(fluidToDrain, 0));
        return tank == null ? null : tank.getFluid();
    }

    public int increaseProgressGetOverflow(int aProgress) {
        return 0;
    }

    @Override
    public boolean hasThingsToDo() {
        return this.getMaxProgress() > 0L;
    }

    public boolean isSeparateInputs() {
        return this.separateInputs;
    }

    public void setSeparateInputs(boolean aSeparateInputs) {
        this.separateInputs = aSeparateInputs;
    }

    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> !f.isVerticallyFliped();
    }

    public <S> IStructureElement<S> addMultiTileCasing(String registryName, int meta, int modes) {
        MultiTileEntityRegistry registry = MultiTileEntityRegistry.getRegistry(registryName);
        int registryID = Block.func_149682_b((Block)registry.mBlock);
        return this.addMultiTileCasing(registryID, meta, modes);
    }

    public <S> IStructureElement<S> addMultiTileCasing(final int registryID, final int meta, final int modes) {
        return new IStructureElement<S>(){
            private final short[] DEFAULT = new short[]{255, 255, 255, 0};
            private IIcon[] mIcons = null;

            public boolean check(S t, World world, int x, int y, int z) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (!(tileEntity instanceof MultiBlockPart)) {
                    return false;
                }
                MultiBlockPart part = (MultiBlockPart)tileEntity;
                if (registryID != part.getMultiTileEntityRegistryID() || meta != part.getMultiTileEntityID()) {
                    return false;
                }
                IMultiBlockController tTarget = part.getTarget(false);
                if (tTarget != null && tTarget != t) {
                    return false;
                }
                part.setTarget((IMultiBlockController)t, modes);
                ((Controller)t).registerSpecialCasings(part);
                return true;
            }

            public boolean spawnHint(S t, World world, int x, int y, int z, ItemStack trigger) {
                if (this.mIcons == null) {
                    this.mIcons = new IIcon[6];
                    Arrays.fill(this.mIcons, TextureSet.SET_NONE.mTextures[OrePrefixes.block.mTextureIndex].getIcon());
                }
                short[] RGBA = this.DEFAULT;
                StructureLibAPI.hintParticleTinted((World)world, (int)x, (int)y, (int)z, (IIcon[])this.mIcons, (short[])RGBA);
                return true;
            }

            public boolean placeBlock(S t, World world, int x, int y, int z, ItemStack trigger) {
                MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry(registryID);
                MultiTileEntityContainer tContainer = tRegistry.getNewTileEntityContainer(world, x, y, z, meta, null);
                if (tContainer == null) {
                    GT_Mod.GT_FML_LOGGER.error("NULL CONTAINER");
                    return false;
                }
                IMultiTileEntity te = (IMultiTileEntity)tContainer.mTileEntity;
                if (!(te instanceof MultiBlockPart)) {
                    GT_Mod.GT_FML_LOGGER.error("Not a multiblock part");
                    return false;
                }
                if (world.func_147465_d(x, y, z, (Block)tContainer.mBlock, 15 - tContainer.mBlockMetaData, 2)) {
                    tContainer.setMultiTile(world, x, y, z);
                    ((MultiBlockPart)te).setTarget(Controller.this, modes);
                    ((Controller)t).registerSpecialCasings((MultiBlockPart)te);
                }
                return false;
            }

            public IIcon getTexture(OrePrefixes aBlock) {
                return TextureSet.SET_NONE.mTextures[OrePrefixes.block.mTextureIndex].getIcon();
            }
        };
    }

    protected <S> IStructureElementChain<S> addMotorCasings(int modes) {
        return StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.LV_Motor.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.MV_Motor.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.HV_Motor.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.EV_Motor.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.IV_Motor.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.LuV_Motor.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.ZPM_Motor.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.UV_Motor.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.UHV_Motor.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.UEV_Motor.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.UIV_Motor.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.UMV_Motor.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.UXV_Motor.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.MAX_Motor.getId(), modes)});
    }

    protected <S> IStructureElementChain<S> addPumpCasings(int modes) {
        return StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.LV_Pump.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.MV_Pump.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.HV_Pump.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.EV_Pump.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.IV_Pump.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.LuV_Pump.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.ZPM_Pump.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.UV_Pump.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.UHV_Pump.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.UEV_Pump.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.UIV_Pump.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.UMV_Pump.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.UXV_Pump.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.MAX_Pump.getId(), modes)});
    }

    protected <S> IStructureElementChain<S> addPistonCasings(int modes) {
        return StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.LV_Piston.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.MV_Piston.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.HV_Piston.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.EV_Piston.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.IV_Piston.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.LuV_Piston.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.ZPM_Piston.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.UV_Piston.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.UHV_Piston.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.UEV_Piston.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.UIV_Piston.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.UMV_Piston.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.UXV_Piston.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.MAX_Piston.getId(), modes)});
    }

    protected <S> IStructureElementChain<S> addConveyorCasings(int modes) {
        return StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.LV_Conveyor.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.MV_Conveyor.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.HV_Conveyor.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.EV_Conveyor.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.IV_Conveyor.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.LuV_Conveyor.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.ZPM_Conveyor.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.UV_Conveyor.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.UHV_Conveyor.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.UEV_Conveyor.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.UIV_Conveyor.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.UMV_Conveyor.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.UXV_Conveyor.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.MAX_Conveyor.getId(), modes)});
    }

    protected <S> IStructureElementChain<S> addRobotArmCasings(int modes) {
        return StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.LV_RobotArm.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.MV_RobotArm.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.HV_RobotArm.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.EV_RobotArm.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.IV_RobotArm.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.LuV_RobotArm.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.ZPM_RobotArm.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.UV_RobotArm.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.UHV_RobotArm.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.UEV_RobotArm.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.UIV_RobotArm.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.UMV_RobotArm.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.UXV_RobotArm.getId(), modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.MAX_RobotArm.getId(), modes)});
    }

    protected <S> IStructureElementChain<S> addSensorCasings(int Modes) {
        return StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.LV_Sensor.getId(), Modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.MV_Sensor.getId(), Modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.HV_Sensor.getId(), Modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.EV_Sensor.getId(), Modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.IV_Sensor.getId(), Modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.LuV_Sensor.getId(), Modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.ZPM_Sensor.getId(), Modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.UV_Sensor.getId(), Modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.UHV_Sensor.getId(), Modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.UEV_Sensor.getId(), Modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.UIV_Sensor.getId(), Modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.UMV_Sensor.getId(), Modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.UXV_Sensor.getId(), Modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.MAX_Sensor.getId(), Modes)});
    }

    protected <S> IStructureElementChain<S> addEmitterCasings(int Modes) {
        return StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.LV_Emitter.getId(), Modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.MV_Emitter.getId(), Modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.HV_Emitter.getId(), Modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.EV_Emitter.getId(), Modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.IV_Emitter.getId(), Modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.LuV_Emitter.getId(), Modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.ZPM_Emitter.getId(), Modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.UV_Emitter.getId(), Modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.UHV_Emitter.getId(), Modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.UEV_Emitter.getId(), Modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.UIV_Emitter.getId(), Modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.UMV_Emitter.getId(), Modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.UXV_Emitter.getId(), Modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.MAX_Emitter.getId(), Modes)});
    }

    protected <S> IStructureElementChain<S> addFieldGeneratorCasings(int Modes) {
        return StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.LV_FieldGenerator.getId(), Modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.MV_FieldGenerator.getId(), Modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.HV_FieldGenerator.getId(), Modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.EV_FieldGenerator.getId(), Modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.IV_FieldGenerator.getId(), Modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.LuV_FieldGenerator.getId(), Modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.ZPM_FieldGenerator.getId(), Modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.UV_FieldGenerator.getId(), Modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.UHV_FieldGenerator.getId(), Modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.UEV_FieldGenerator.getId(), Modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.UIV_FieldGenerator.getId(), Modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.UMV_FieldGenerator.getId(), Modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.UXV_FieldGenerator.getId(), Modes), this.addMultiTileCasing("gt.multitileentity.component.casings", GT_MultiTileComponentCasing.MAX_FieldGenerator.getId(), Modes)});
    }

    protected void registerSpecialCasings(MultiBlockPart part) {
        if (part instanceof UpgradeCasing) {
            this.upgradeCasings.add((UpgradeCasing)part);
        }
        if (part instanceof FunctionalCasing) {
            this.functionalCasings.add((FunctionalCasing)part);
        }
    }

    public void registerFluidInventory(String name, String id, int numberOfSlots, long capacity, long capacityMultiplier, int type) {
        if (name == null || name.equals("") || id == null || id.equals("") || numberOfSlots < 0 || capacity < 0L || capacityMultiplier < 0L) {
            return;
        }
        FluidTankGT[] tanks = new FluidTankGT[numberOfSlots];
        for (int i = 0; i < numberOfSlots; ++i) {
            tanks[i] = new FluidTankGT(capacity).setCapacityMultiplier(capacityMultiplier);
        }
        this.registerFluidInventory(name, id, tanks, type);
    }

    public void registerFluidInventory(String name, String id, FluidTankGT[] fluidInventory, int type) {
        if (name == null || name.equals("") || id == null || id.equals("") || fluidInventory == null || fluidInventory.length == 0) {
            return;
        }
        if (type == 0 || type == 2) {
            if (this.multiBlockInputTank.containsKey(id)) {
                return;
            }
            this.multiBlockInputTank.put(id, fluidInventory);
            this.multiBlockInputTankNames.put(id, name);
        }
        if (type == 1 || type == 2) {
            if (this.multiBlockOutputTank.containsKey(id)) {
                return;
            }
            this.multiBlockOutputTank.put(id, fluidInventory);
            this.multiBlockOutputTankNames.put(id, name);
        }
    }

    public void unregisterFluidInventory(String aName, String aID, int aType) {
        if ((aType == 0 || aType == 2) && this.multiBlockInputTank.containsKey(aID)) {
            this.multiBlockInputTank.remove(aID, this.multiBlockInputTank.get(aID));
            this.multiBlockInputTankNames.remove(aID, aName);
        }
        if ((aType == 1 || aType == 2) && this.multiBlockOutputTank.containsKey(aID)) {
            this.multiBlockOutputTank.remove(aID, this.multiBlockOutputTank.get(aID));
            this.multiBlockOutputTankNames.remove(aID, aName);
        }
    }

    protected FluidTankGT[] getTanksForInput() {
        ArrayList<FluidTankGT> tanks = new ArrayList<FluidTankGT>();
        for (FluidTankGT[] inputTanks : this.multiBlockInputTank.values()) {
            tanks.addAll(Arrays.asList(inputTanks));
        }
        return tanks.toArray(new FluidTankGT[0]);
    }

    protected FluidTankGT[] getTanksForOutput() {
        ArrayList<FluidTankGT> tanks = new ArrayList<FluidTankGT>();
        for (FluidTankGT[] outputTanks : this.multiBlockOutputTank.values()) {
            tanks.addAll(Arrays.asList(outputTanks));
        }
        return tanks.toArray(new FluidTankGT[0]);
    }

    protected IFluidTank getFluidTankFillable(MultiBlockPart aPart, ForgeDirection side, FluidStack aFluidToFill) {
        return this.getFluidTankFillable(side, aFluidToFill);
    }

    protected IFluidTank getFluidTankDrainable(MultiBlockPart aPart, ForgeDirection side, FluidStack aFluidToDrain) {
        return this.getFluidTankDrainable(side, aFluidToDrain);
    }

    protected IFluidTank[] getFluidTanks(MultiBlockPart aPart, ForgeDirection side) {
        return this.getFluidTanks(side);
    }

    @Override
    public int fill(MultiBlockPart aPart, ForgeDirection aDirection, FluidStack aFluid, boolean aDoFill) {
        if (aFluid == null || aFluid.amount <= 0) {
            return 0;
        }
        IFluidTank tTank = this.getFluidTankFillable(aPart, aDirection, aFluid);
        if (tTank == null) {
            return 0;
        }
        int rFilledAmount = tTank.fill(aFluid, aDoFill);
        if (rFilledAmount > 0 && aDoFill) {
            this.hasInventoryChanged = true;
        }
        return rFilledAmount;
    }

    @Override
    public FluidStack drain(MultiBlockPart aPart, ForgeDirection aDirection, FluidStack aFluid, boolean aDoDrain) {
        if (aFluid == null || aFluid.amount <= 0) {
            return null;
        }
        IFluidTank tTank = this.getFluidTankDrainable(aPart, aDirection, aFluid);
        if (tTank == null || tTank.getFluid() == null || tTank.getFluidAmount() == 0 || !tTank.getFluid().isFluidEqual(aFluid)) {
            return null;
        }
        FluidStack rDrained = tTank.drain(aFluid.amount, aDoDrain);
        if (rDrained != null && aDoDrain) {
            this.markInventoryBeenModified();
        }
        return rDrained;
    }

    @Override
    public FluidStack drain(MultiBlockPart aPart, ForgeDirection aDirection, int aAmountToDrain, boolean aDoDrain) {
        if (aAmountToDrain <= 0) {
            return null;
        }
        IFluidTank tTank = this.getFluidTankDrainable(aPart, aDirection, null);
        if (tTank == null || tTank.getFluid() == null || tTank.getFluidAmount() == 0) {
            return null;
        }
        FluidStack rDrained = tTank.drain(aAmountToDrain, aDoDrain);
        if (rDrained != null && aDoDrain) {
            this.markInventoryBeenModified();
        }
        return rDrained;
    }

    @Override
    public boolean canFill(MultiBlockPart aPart, ForgeDirection aDirection, Fluid aFluid) {
        if (aFluid == null) {
            return false;
        }
        IFluidTank tTank = this.getFluidTankFillable(aPart, aDirection, new FluidStack(aFluid, 0));
        return tTank != null && (tTank.getFluid() == null || tTank.getFluid().getFluid() == aFluid);
    }

    @Override
    public boolean canDrain(MultiBlockPart aPart, ForgeDirection aDirection, Fluid aFluid) {
        if (aFluid == null) {
            return false;
        }
        IFluidTank tTank = this.getFluidTankDrainable(aPart, aDirection, new FluidStack(aFluid, 0));
        return tTank != null && tTank.getFluid() != null && tTank.getFluid().getFluid() == aFluid;
    }

    @Override
    public FluidTankInfo[] getTankInfo(MultiBlockPart aPart, ForgeDirection aDirection) {
        IFluidTank[] tTanks = this.getFluidTanks(aPart, aDirection);
        if (tTanks == null || tTanks.length <= 0) {
            return GT_Values.emptyFluidTankInfo;
        }
        FluidTankInfo[] rInfo = new FluidTankInfo[tTanks.length];
        for (int i = 0; i < tTanks.length; ++i) {
            rInfo[i] = new FluidTankInfo(tTanks[i]);
        }
        return rInfo;
    }

    @Override
    public IFluidTank[] getFluidTanksForGUI(MultiBlockPart aPart) {
        String lockedInventory = aPart.getLockedInventory();
        if (lockedInventory == null) {
            if (aPart.modeSelected(MultiBlockPart.FLUID_IN)) {
                return this.getTanksForInput();
            }
            if (aPart.modeSelected(MultiBlockPart.FLUID_OUT)) {
                return this.getTanksForOutput();
            }
        } else {
            Map<String, FluidTankGT[]> tankMap = this.getMultiBlockTankArray(aPart);
            if (tankMap == null) {
                return GT_Values.emptyFluidTank;
            }
            IFluidTank[] tanks = tankMap.get(lockedInventory);
            return tanks != null ? tanks : GT_Values.emptyFluidTank;
        }
        return GT_Values.emptyFluidTank;
    }

    @Override
    public PowerLogic getPowerLogic(IMultiBlockPart part, ForgeDirection side) {
        Controller controller = this;
        if (!(controller instanceof PowerLogicHost)) {
            return null;
        }
        PowerLogicHost powerLogicHost = (PowerLogicHost)((Object)controller);
        if (part.getFrontFacing() != side) {
            return null;
        }
        return powerLogicHost.getPowerLogic(side);
    }

    @Override
    public void registerInventory(String aName, String aID, int aInventorySize, int aType) {
        this.registerInventory(aName, aID, (IItemHandlerModifiable)new ItemStackHandler(aInventorySize), aType);
    }

    public void registerInventory(String name, String id, IItemHandlerModifiable inventory, int type) {
        if (name == null || name.equals("") || id == null || id.equals("") || inventory == null) {
            return;
        }
        if (type == 0 || type == 2) {
            if (this.multiBlockInputInventory.containsKey(id)) {
                return;
            }
            this.multiBlockInputInventory.put(id, inventory);
            this.multiBlockInputInventoryNames.put(id, name);
        }
        if (type == 1 || type == 2) {
            if (this.multiBlockOutputInventory.containsKey(id)) {
                return;
            }
            this.multiBlockOutputInventory.put(id, inventory);
            this.multiBlockOutputInventoryNames.put(id, name);
        }
    }

    @Override
    public void unregisterInventory(String aName, String aID, int aType) {
        if ((aType == 0 || aType == 2) && this.multiBlockInputInventory.containsKey(aID)) {
            this.multiBlockInputInventory.remove(aID, this.multiBlockInputInventory.get(aID));
            this.multiBlockInputInventoryNames.remove(aID, aName);
        }
        if ((aType == 1 || aType == 2) && this.multiBlockOutputInventory.containsKey(aID)) {
            this.multiBlockOutputInventory.remove(aID, this.multiBlockOutputInventory.get(aID));
            this.multiBlockOutputInventoryNames.remove(aID, aName);
        }
    }

    @Override
    public void changeInventoryName(String aName, String aID, int aType) {
        if ((aType == 0 || aType == 2) && this.multiBlockInputInventoryNames.containsKey(aID)) {
            this.multiBlockInputInventoryNames.put(aID, aName);
        }
        if ((aType == 1 || aType == 2) && this.multiBlockOutputInventoryNames.containsKey(aID)) {
            this.multiBlockOutputInventoryNames.put(aID, aName);
        }
    }

    @Override
    public boolean hasInventoryBeenModified(MultiBlockPart aPart) {
        if (aPart.modeSelected(MultiBlockPart.ITEM_IN)) {
            return this.hasInventoryBeenModified();
        }
        if (aPart.modeSelected(MultiBlockPart.ITEM_OUT)) {
            return this.hasOutputInventoryBeenModified();
        }
        return false;
    }

    @Override
    public boolean isValidSlot(MultiBlockPart aPart, int aIndex) {
        return false;
    }

    @Override
    public void enableWorking() {
        super.enableWorking();
        if (!this.structureOkay) {
            this.checkStructure(true);
        }
    }

    @Override
    public IItemHandlerModifiable getInventoryForGUI(MultiBlockPart aPart) {
        Map<String, IItemHandlerModifiable> multiBlockInventory;
        if (this.isServerSide()) {
            for (UpgradeCasing tPart : this.upgradeCasings) {
                if (!(tPart instanceof Inventory)) continue;
                tPart.issueClientUpdate();
            }
        }
        if ((multiBlockInventory = this.getMultiBlockInventory(aPart)) == null) {
            return null;
        }
        String lockedInventory = aPart.getLockedInventory();
        if (lockedInventory == null) {
            return new ListItemHandler(multiBlockInventory.values());
        }
        IItemHandlerModifiable inv = multiBlockInventory.get(lockedInventory);
        return inv;
    }

    @Override
    public boolean addStackToSlot(MultiBlockPart aPart, int aIndex, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean addStackToSlot(MultiBlockPart aPart, int aIndex, ItemStack aStack, int aAmount) {
        return false;
    }

    protected Map<String, FluidTankGT[]> getMultiBlockTankArray(MultiBlockPart aPart) {
        if (aPart.modeSelected(MultiBlockPart.FLUID_IN)) {
            return this.multiBlockInputTank;
        }
        if (aPart.modeSelected(MultiBlockPart.FLUID_OUT)) {
            return this.multiBlockOutputTank;
        }
        return null;
    }

    protected Map<String, String> getMultiBlockTankArrayNames(MultiBlockPart aPart) {
        if (aPart.modeSelected(MultiBlockPart.FLUID_IN)) {
            return this.multiBlockInputTankNames;
        }
        if (aPart.modeSelected(MultiBlockPart.FLUID_OUT)) {
            return this.multiBlockOutputTankNames;
        }
        return null;
    }

    protected Map<String, IItemHandlerModifiable> getMultiBlockInventory(MultiBlockPart aPart) {
        if (aPart.modeSelected(MultiBlockPart.ITEM_IN)) {
            return this.multiBlockInputInventory;
        }
        if (aPart.modeSelected(MultiBlockPart.ITEM_OUT)) {
            return this.multiBlockOutputInventory;
        }
        return null;
    }

    protected Map<String, String> getMultiBlockInventoryNames(MultiBlockPart aPart) {
        if (aPart.modeSelected(MultiBlockPart.ITEM_IN)) {
            return this.multiBlockInputInventoryNames;
        }
        if (aPart.modeSelected(MultiBlockPart.ITEM_OUT)) {
            return this.multiBlockOutputInventoryNames;
        }
        return null;
    }

    protected Pair<IItemHandlerModifiable, Integer> getInventory(MultiBlockPart aPart, int aSlot) {
        Map<String, IItemHandlerModifiable> multiBlockInventory = this.getMultiBlockInventory(aPart);
        if (multiBlockInventory == null) {
            return null;
        }
        String invName = aPart.getLockedInventory();
        if (invName != null && !invName.isEmpty()) {
            return new ImmutablePair((Object)multiBlockInventory.get(invName), (Object)aSlot);
        }
        int start = 0;
        for (IItemHandlerModifiable inv : multiBlockInventory.values()) {
            if (aSlot >= start && aSlot < start + inv.getSlots()) {
                return new ImmutablePair((Object)inv, (Object)(aSlot - start));
            }
            start += inv.getSlots();
        }
        return null;
    }

    @Override
    public int[] getAccessibleSlotsFromSide(MultiBlockPart aPart, ForgeDirection side) {
        TIntArrayList tList = new TIntArrayList();
        Map<String, IItemHandlerModifiable> multiBlockInventory = this.getMultiBlockInventory(aPart);
        if (multiBlockInventory == null) {
            return tList.toArray();
        }
        String lockedInventory = aPart.getLockedInventory();
        int start = 0;
        if (lockedInventory == null) {
            for (IItemHandlerModifiable inv : multiBlockInventory.values()) {
                for (int i = start; i < inv.getSlots() + start; ++i) {
                    tList.add(i);
                }
                start += inv.getSlots();
            }
        } else {
            IItemHandlerModifiable inv = multiBlockInventory.get(lockedInventory);
            int len = inv != null ? inv.getSlots() : 0;
            for (int i = 0; i < len; ++i) {
                tList.add(i);
            }
        }
        return tList.toArray();
    }

    @Override
    public boolean canInsertItem(MultiBlockPart aPart, int aSlot, ItemStack aStack, ForgeDirection side) {
        Pair<IItemHandlerModifiable, Integer> tInv = this.getInventory(aPart, aSlot);
        if (tInv == null) {
            return false;
        }
        int tSlot = (Integer)tInv.getRight();
        IItemHandlerModifiable inv = (IItemHandlerModifiable)tInv.getLeft();
        return inv.getStackInSlot(tSlot) == null || GT_Utility.areStacksEqual(aStack, inv.getStackInSlot(tSlot));
    }

    @Override
    public boolean canExtractItem(MultiBlockPart aPart, int aSlot, ItemStack aStack, ForgeDirection side) {
        Pair<IItemHandlerModifiable, Integer> tInv = this.getInventory(aPart, aSlot);
        if (tInv == null) {
            return false;
        }
        int tSlot = (Integer)tInv.getRight();
        IItemHandlerModifiable inv = (IItemHandlerModifiable)tInv.getLeft();
        return inv.getStackInSlot(tSlot) != null;
    }

    @Override
    public int getSizeInventory(MultiBlockPart aPart) {
        Map<String, IItemHandlerModifiable> multiBlockInventory = this.getMultiBlockInventory(aPart);
        if (multiBlockInventory == null) {
            return 0;
        }
        String lockedInventory = aPart.getLockedInventory();
        if (lockedInventory == null) {
            int len = 0;
            for (IItemHandlerModifiable inv : multiBlockInventory.values()) {
                len += inv.getSlots();
            }
            return len;
        }
        IItemHandlerModifiable inv = multiBlockInventory.get(lockedInventory);
        return inv != null ? inv.getSlots() : 0;
    }

    @Override
    public ItemStack getStackInSlot(MultiBlockPart aPart, int aSlot) {
        Pair<IItemHandlerModifiable, Integer> tInv = this.getInventory(aPart, aSlot);
        if (tInv == null) {
            return null;
        }
        int tSlot = (Integer)tInv.getRight();
        IItemHandlerModifiable inv = (IItemHandlerModifiable)tInv.getLeft();
        if (inv == null) {
            return null;
        }
        return inv.getStackInSlot(tSlot);
    }

    @Override
    public ItemStack decrStackSize(MultiBlockPart aPart, int aSlot, int aDecrement) {
        ItemStack tStack = this.getStackInSlot(aPart, aSlot);
        ItemStack rStack = GT_Utility.copyOrNull(tStack);
        if (tStack != null) {
            if (tStack.field_77994_a <= aDecrement) {
                this.setInventorySlotContents(aPart, aSlot, null);
            } else {
                rStack = tStack.func_77979_a(aDecrement);
                if (tStack.field_77994_a == 0) {
                    this.setInventorySlotContents(aPart, aSlot, null);
                }
            }
        }
        return rStack;
    }

    @Override
    public ItemStack getStackInSlotOnClosing(MultiBlockPart aPart, int aSlot) {
        Pair<IItemHandlerModifiable, Integer> tInv = this.getInventory(aPart, aSlot);
        if (tInv == null) {
            return null;
        }
        IItemHandlerModifiable inv = (IItemHandlerModifiable)tInv.getLeft();
        int tSlot = (Integer)tInv.getRight();
        ItemStack rStack = inv.getStackInSlot(tSlot);
        inv.setStackInSlot(tSlot, null);
        return rStack;
    }

    @Override
    public void setInventorySlotContents(MultiBlockPart aPart, int aSlot, ItemStack aStack) {
        Pair<IItemHandlerModifiable, Integer> tInv = this.getInventory(aPart, aSlot);
        if (tInv == null) {
            return;
        }
        IItemHandlerModifiable inv = (IItemHandlerModifiable)tInv.getLeft();
        int tSlot = (Integer)tInv.getRight();
        inv.setStackInSlot(tSlot, aStack);
    }

    @Override
    public List<String> getInventoryNames(MultiBlockPart aPart) {
        ArrayList<String> inventoryNames = new ArrayList<String>();
        inventoryNames.add(ALL_INVENTORIES_NAME);
        inventoryNames.addAll(this.getMultiBlockInventoryNames(aPart).values());
        return inventoryNames;
    }

    @Override
    public List<String> getInventoryIDs(MultiBlockPart aPart) {
        ArrayList<String> tInventoryIDs = new ArrayList<String>();
        tInventoryIDs.add(ALL_INVENTORIES_NAME);
        tInventoryIDs.addAll(this.getMultiBlockInventory(aPart).keySet());
        return tInventoryIDs;
    }

    @Override
    public String getInventoryName(MultiBlockPart aPart) {
        StringBuilder str = new StringBuilder();
        str.append(this.func_145825_b());
        if (aPart.modeSelected(MultiBlockPart.ITEM_IN)) {
            str.append(" Input");
        } else if (aPart.modeSelected(MultiBlockPart.ITEM_OUT)) {
            str.append(" Output");
        } else {
            str.append(" Unknown");
        }
        String lockedInventory = aPart.getLockedInventory();
        if (lockedInventory != null && !lockedInventory.equals("")) {
            str.append(" [Locked: ").append(lockedInventory).append("]");
        }
        return str.toString();
    }

    @Override
    public List<String> getTankArrayNames(MultiBlockPart aPart) {
        ArrayList<String> inventoryNames = new ArrayList<String>();
        inventoryNames.add(ALL_INVENTORIES_NAME);
        inventoryNames.addAll(this.getMultiBlockTankArrayNames(aPart).values());
        return inventoryNames;
    }

    @Override
    public List<String> getTankArrayIDs(MultiBlockPart aPart) {
        ArrayList<String> inventoryIDs = new ArrayList<String>();
        inventoryIDs.add(ALL_INVENTORIES_NAME);
        inventoryIDs.addAll(this.getMultiBlockTankArray(aPart).keySet());
        return inventoryIDs;
    }

    @Override
    public boolean hasCustomInventoryName(MultiBlockPart aPart) {
        return this.func_145818_k_();
    }

    @Override
    public int getInventoryStackLimit(MultiBlockPart aPart) {
        return this.func_70297_j_();
    }

    @Override
    public void markDirty(MultiBlockPart aPart) {
        this.func_70296_d();
        if (aPart.modeSelected(MultiBlockPart.ITEM_OUT)) {
            this.markOutputInventoryBeenModified();
        } else {
            this.markInventoryBeenModified();
        }
    }

    @Override
    public boolean isUseableByPlayer(MultiBlockPart aPart, EntityPlayer aPlayer) {
        return this.func_70300_a(aPlayer);
    }

    @Override
    public void openInventory(MultiBlockPart aPart) {
        this.func_70295_k_();
    }

    @Override
    public void closeInventory(MultiBlockPart aPart) {
        this.func_70305_f();
    }

    @Override
    public boolean isItemValidForSlot(MultiBlockPart aPart, int aSlot, ItemStack aStack) {
        return this.func_94041_b(aSlot, aStack);
    }

    @Override
    protected ItemStack[] getInputItems() {
        return this.getInventoriesForInput().getStacks().toArray(new ItemStack[0]);
    }

    protected ItemStack[] getOutputItems() {
        return this.getInventoriesForOutput().getStacks().toArray(new ItemStack[0]);
    }

    protected Iterable<Pair<ItemStack[], String>> getItemInputsForEachInventory() {
        return this.multiBlockInputInventory.entrySet().stream().map(entry -> Pair.of((Object)((IItemHandlerModifiable)entry.getValue()).getStacks().toArray(new ItemStack[0]), (Object)((String)entry.getKey()))).collect(Collectors.toList());
    }

    protected ItemStack[] getItemInputsForInventory(String id) {
        IItemHandlerModifiable inventory = this.multiBlockInputInventory.get(id);
        if (inventory != null) {
            return inventory.getStacks().toArray(new ItemStack[0]);
        }
        return null;
    }

    @Override
    protected FluidStack[] getInputFluids() {
        ArrayList<FluidStack> fluidStacks = new ArrayList<FluidStack>();
        for (FluidTankGT[] inputTanks : this.multiBlockInputTank.values()) {
            for (FluidTankGT inputTank : inputTanks) {
                FluidStack fluidStack = inputTank.get();
                if (fluidStack == null) continue;
                fluidStacks.add(fluidStack);
            }
        }
        return fluidStacks.toArray(new FluidStack[0]);
    }

    protected FluidStack[] getOutputFluids() {
        ArrayList<FluidStack> fluidStacks = new ArrayList<FluidStack>();
        for (FluidTankGT[] inputTanks : this.multiBlockInputTank.values()) {
            for (FluidTankGT inputTank : inputTanks) {
                FluidStack fluidStack = inputTank.getFluid();
                if (fluidStack == null) continue;
                fluidStacks.add(fluidStack);
            }
        }
        return fluidStacks.toArray(new FluidStack[0]);
    }

    protected Iterable<Pair<FluidStack[], String>> getFluidInputsForEachTankArray() {
        return this.multiBlockInputTank.entrySet().stream().map(entry -> Pair.of((Object)FluidTankGT.getFluidsFromTanks((FluidTankGT[])entry.getValue()), (Object)((String)entry.getKey()))).collect(Collectors.toList());
    }

    protected FluidStack[] getFluidInputsForTankArray(String id) {
        return FluidTankGT.getFluidsFromTanks(this.multiBlockInputTank.get(id));
    }

    protected void setItemOutputs(String inventory, ItemStack ... itemOutputs) {
        this.itemsToOutput = itemOutputs;
        this.inventoryName = inventory;
    }

    @Override
    protected void setItemOutputs(ItemStack ... outputs) {
        super.setItemOutputs(outputs);
        this.inventoryName = null;
    }

    @Override
    protected void outputItems() {
        if (this.itemsToOutput == null) {
            return;
        }
        IItemHandlerModifiable inv = this.inventoryName != null ? this.multiBlockOutputInventory.getOrDefault(this.inventoryName, this.getInventoriesForOutput()) : this.getInventoriesForOutput();
        for (ItemStack item : this.itemsToOutput) {
            int index = 0;
            while (item != null && item.field_77994_a > 0 && index < inv.getSlots()) {
                item = inv.insertItem(index++, item.func_77946_l(), false);
            }
        }
        this.itemsToOutput = null;
    }

    protected void setFluidOutputs(String tank, FluidStack ... fluidOuputs) {
        this.fluidsToOutput = fluidOuputs;
        this.tankName = tank;
    }

    @Override
    protected void setFluidOutputs(FluidStack ... outputs) {
        super.setFluidOutputs(outputs);
        this.tankName = null;
    }

    @Override
    protected void outputFluids() {
        if (this.fluidsToOutput == null) {
            return;
        }
        List<FluidTankGT> tanks = Arrays.asList(this.outputTanks);
        for (FluidStack fluid : this.fluidsToOutput) {
            int index = 0;
            while (fluid != null && fluid.amount > 0 && index < tanks.size()) {
                int filled = tanks.get(index++).fill(fluid, true);
                fluid.amount -= filled;
            }
        }
    }

    @Override
    protected void updateSlots() {
        IItemHandlerModifiable inv = this.getInventoriesForInput();
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (inv.getStackInSlot(i) == null || inv.getStackInSlot((int)i).field_77994_a > 0) continue;
            inv.setStackInSlot(i, null);
        }
        for (FluidTankGT inputTank : this.getTanksForInput()) {
            if (inputTank == null) continue;
            if (inputTank.get() != null && inputTank.get().amount <= 0) {
                inputTank.setEmpty();
                continue;
            }
            FluidStack afterRecipe = inputTank.get();
            FluidStack beforeRecipe = inputTank.get(Integer.MAX_VALUE);
            if (afterRecipe == null || beforeRecipe == null) continue;
            int difference = beforeRecipe.amount - afterRecipe.amount;
            inputTank.remove(difference);
        }
    }

    @Override
    protected boolean checkRecipe() {
        if (!(this instanceof ProcessingLogicHost)) {
            return false;
        }
        ProcessingLogic logic = ((ProcessingLogicHost)((Object)this)).getProcessingLogic();
        logic.clear();
        CheckRecipeResult result = CheckRecipeResultRegistry.NO_RECIPE;
        if (this.isSeparateInputs()) {
            for (Pair<ItemStack[], String> inventory : this.getItemInputsForEachInventory()) {
                IItemHandlerModifiable outputInventory = this.multiBlockOutputInventory.getOrDefault(inventory.getLeft(), null);
                result = logic.setInputItems((ItemStack[])inventory.getLeft()).setCurrentOutputItems(this.getOutputItems()).process();
                if (result.wasSuccessful()) {
                    this.inventoryName = (String)inventory.getRight();
                    break;
                }
                logic.clear();
            }
        } else {
            result = logic.setInputItems(this.getInputItems()).setCurrentOutputItems(this.getOutputItems()).setInputFluids(this.getInputFluids()).setCurrentOutputFluids(this.getOutputFluids()).process();
        }
        this.setDuration(logic.getDuration());
        this.setEut(logic.getCalculatedEut());
        this.setItemOutputs(logic.getOutputItems());
        this.setFluidOutputs(logic.getOutputFluids());
        return result.wasSuccessful();
    }

    public IItemHandlerModifiable getOutputInventory() {
        return this.outputInventory;
    }

    public FluidTankGT[] getOutputTanks() {
        return this.outputTanks;
    }

    @Override
    public boolean useModularUI() {
        return true;
    }

    @Override
    public ModularWindow createWindow(UIBuildContext buildContext) {
        System.out.println("MultiBlockController::createWindow");
        if (!this.useModularUI()) {
            return null;
        }
        buildContext.setValidator(this.getValidator());
        ModularWindow.Builder builder = ModularWindow.builder((int)this.getGUIWidth(), (int)this.getGUIHeight());
        builder.setBackground(new IDrawable[]{this.getGUITextureSet().getMainBackground()});
        builder.setGuiTint(this.getGUIColorization());
        if (this.doesBindPlayerInventory()) {
            this.bindPlayerInventoryUI(builder, buildContext);
        }
        this.addUIWidgets(builder, buildContext);
        this.addTitleToUI(builder);
        this.addCoverTabs(builder, buildContext);
        return builder.build();
    }

    @Override
    public boolean hasGui(ForgeDirection side) {
        return true;
    }

    @Override
    protected void addTitleTextStyle(ModularWindow.Builder builder, String title) {
    }

    @Override
    public int getGUIHeight() {
        return 192;
    }

    protected Widget getGregTechLogo() {
        return new DrawableWidget().setDrawable((IDrawable)this.getGUITextureSet().getGregTechLogo()).setSize(17, 17);
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        if (this.isServerSide()) {
            for (UpgradeCasing tPart : this.upgradeCasings) {
                if (!(tPart instanceof Inventory)) continue;
                tPart.issueClientUpdate();
            }
        }
        int page = 0;
        TabContainer tabs = new TabContainer().setButtonSize(20, 24);
        tabs.addTabButton(new TabButton(page++).setBackground(false, new IDrawable[]{ModularUITextures.VANILLA_TAB_TOP_START.getSubArea(0.0f, 0.0f, 1.0f, 0.5f), new ItemDrawable(this.getStackForm(1L)).withFixedSize(16.0f, 16.0f).withOffset(2.0f, 4.0f)}).setBackground(true, new IDrawable[]{ModularUITextures.VANILLA_TAB_TOP_START.getSubArea(0.0f, 0.5f, 1.0f, 1.0f), new ItemDrawable(this.getStackForm(1L)).withFixedSize(16.0f, 16.0f).withOffset(2.0f, 4.0f)}).addTooltip(this.getLocalName()).setPos(20 * (page - 1), -20)).addPage(this.createMainPage((IWidgetBuilder<?>)builder).setSize(this.getGUIWidth(), this.getGUIHeight()));
        if (this.hasItemInput()) {
            tabs.addTabButton(new TabButton(page++).setBackground(false, new IDrawable[]{ModularUITextures.VANILLA_TAB_TOP_MIDDLE.getSubArea(0.0f, 0.0f, 1.0f, 0.5f), GT_UITextures.PICTURE_ITEM_IN.withFixedSize(16.0f, 16.0f).withOffset(2.0f, 4.0f)}).setBackground(true, new IDrawable[]{ModularUITextures.VANILLA_TAB_TOP_MIDDLE.getSubArea(0.0f, 0.5f, 1.0f, 1.0f), GT_UITextures.PICTURE_ITEM_IN.withFixedSize(16.0f, 16.0f).withOffset(2.0f, 4.0f)}).setPos(20 * (page - 1), -20)).addPage(new MultiChildWidget().addChild(this.getItemInventoryInputGUI()).addChild(this.getGregTechLogo().setPos(147, 86)).setSize(this.getGUIWidth(), this.getGUIHeight()));
        }
        if (this.hasItemOutput()) {
            tabs.addTabButton(new TabButton(page++).setBackground(false, new IDrawable[]{ModularUITextures.VANILLA_TAB_TOP_MIDDLE.getSubArea(0.0f, 0.0f, 1.0f, 0.5f), GT_UITextures.PICTURE_ITEM_OUT.withFixedSize(16.0f, 16.0f).withOffset(2.0f, 4.0f)}).setBackground(true, new IDrawable[]{ModularUITextures.VANILLA_TAB_TOP_MIDDLE.getSubArea(0.0f, 0.5f, 1.0f, 1.0f), GT_UITextures.PICTURE_ITEM_OUT.withFixedSize(16.0f, 16.0f).withOffset(2.0f, 4.0f)}).setPos(20 * (page - 1), -20)).addPage(new MultiChildWidget().addChild(this.getItemInventoryOutputGUI()).addChild(this.getGregTechLogo().setPos(147, 86)).setSize(this.getGUIWidth(), this.getGUIHeight()));
        }
        if (this.hasFluidInput()) {
            tabs.addTabButton(new TabButton(page++).setBackground(false, new IDrawable[]{ModularUITextures.VANILLA_TAB_TOP_MIDDLE.getSubArea(0.0f, 0.0f, 1.0f, 0.5f), GT_UITextures.PICTURE_FLUID_IN.withFixedSize(16.0f, 16.0f).withOffset(2.0f, 4.0f)}).setBackground(true, new IDrawable[]{ModularUITextures.VANILLA_TAB_TOP_MIDDLE.getSubArea(0.0f, 0.5f, 1.0f, 1.0f), GT_UITextures.PICTURE_FLUID_IN.withFixedSize(16.0f, 16.0f).withOffset(2.0f, 4.0f)}).setPos(20 * (page - 1), -20)).addPage(new MultiChildWidget().addChild(this.getFluidInventoryInputGUI()).addChild(this.getGregTechLogo().setPos(147, 86)).setSize(this.getGUIWidth(), this.getGUIHeight()));
        }
        if (this.hasFluidOutput()) {
            tabs.addTabButton(new TabButton(page++).setBackground(false, new IDrawable[]{ModularUITextures.VANILLA_TAB_TOP_MIDDLE.getSubArea(0.0f, 0.0f, 1.0f, 0.5f), GT_UITextures.PICTURE_FLUID_OUT.withFixedSize(16.0f, 16.0f).withOffset(2.0f, 4.0f)}).setBackground(true, new IDrawable[]{ModularUITextures.VANILLA_TAB_TOP_MIDDLE.getSubArea(0.0f, 0.5f, 1.0f, 1.0f), GT_UITextures.PICTURE_FLUID_OUT.withFixedSize(16.0f, 16.0f).withOffset(2.0f, 4.0f)}).setPos(20 * (page - 1), -20)).addPage(new MultiChildWidget().addChild(this.getFluidInventoryOutputGUI()).addChild(this.getGregTechLogo().setPos(147, 86)).setSize(this.getGUIWidth(), this.getGUIHeight()));
        }
        builder.widget((Widget)tabs);
    }

    protected MultiChildWidget createMainPage(IWidgetBuilder<?> builder) {
        MultiChildWidget page = new MultiChildWidget();
        page.addChild(new DrawableWidget().setDrawable((IDrawable)GT_UITextures.PICTURE_SCREEN_BLACK).setPos(7, 4).setSize(160, 75)).addChild((Widget)this.createButtons(builder));
        return page;
    }

    protected MultiChildWidget createButtons(IWidgetBuilder<?> builder) {
        MultiChildWidget buttons = new MultiChildWidget();
        buttons.setSize(16, 167).setPos(7, 86);
        buttons.addChild((Widget)this.createPowerSwitchButton(builder)).addChild((Widget)this.createVoidExcessButton(builder)).addChild((Widget)this.createInputSeparationButton(builder)).addChild((Widget)this.createBatchModeButton(builder)).addChild((Widget)this.createLockToSingleRecipeButton(builder));
        return buttons;
    }

    protected Widget getItemInventoryInputGUI() {
        IItemHandlerModifiable inv = this.getInventoriesForInput();
        Scrollable scrollable = new Scrollable().setVerticalScroll();
        int rows = 0;
        while (rows * 4 < Math.min(inv.getSlots(), 128)) {
            int columnsToMake = Math.min(Math.min(inv.getSlots(), 128) - rows * 4, 4);
            for (int column = 0; column < columnsToMake; ++column) {
                scrollable.widget(new SlotWidget(inv, rows * 4 + column).setPos(column * 18, rows * 18).setSize(18, 18));
            }
            ++rows;
        }
        return scrollable.setSize(76, 90).setPos(52, 7);
    }

    protected Widget getItemInventoryOutputGUI() {
        IItemHandlerModifiable inv = this.getInventoriesForOutput();
        Scrollable scrollable = new Scrollable().setVerticalScroll();
        int rows = 0;
        while (rows * 4 < Math.min(inv.getSlots(), 128)) {
            int columnsToMake = Math.min(Math.min(inv.getSlots(), 128) - rows * 4, 4);
            for (int column = 0; column < columnsToMake; ++column) {
                scrollable.widget(new SlotWidget(inv, rows * 4 + column).setPos(column * 18, rows * 18).setSize(18, 18));
            }
            ++rows;
        }
        return scrollable.setSize(76, 90).setPos(52, 7);
    }

    protected IItemHandlerModifiable getInventoriesForInput() {
        return new ListItemHandler(this.multiBlockInputInventory.values());
    }

    protected IItemHandlerModifiable getInventoriesForOutput() {
        return new ListItemHandler(this.multiBlockOutputInventory.values());
    }

    protected Widget getFluidInventoryInputGUI() {
        FluidTankGT[] tanks = this.getTanksForInput();
        Scrollable scrollable = new Scrollable().setVerticalScroll();
        int rows = 0;
        while (rows * 4 < tanks.length) {
            int columnsToMake = Math.min(tanks.length - rows * 4, 4);
            for (int column = 0; column < columnsToMake; ++column) {
                FluidSlotWidget fluidSlot = new FluidSlotWidget((IFluidTank)tanks[rows * 4 + column]);
                scrollable.widget(fluidSlot.setPos(column * 18, rows * 18).setSize(18, 18));
            }
            ++rows;
        }
        return scrollable.setSize(76, 90).setPos(52, 7);
    }

    protected Widget getFluidInventoryOutputGUI() {
        FluidTankGT[] tanks = this.getTanksForOutput();
        Scrollable scrollable = new Scrollable().setVerticalScroll();
        int rows = 0;
        while (rows * 4 < tanks.length) {
            int columnsToMake = Math.min(tanks.length - rows * 4, 4);
            for (int column = 0; column < columnsToMake; ++column) {
                FluidSlotWidget fluidSlot = new FluidSlotWidget((IFluidTank)tanks[rows * 4 + column]);
                fluidSlot.setInteraction(true, false);
                scrollable.widget(fluidSlot.setPos(column * 18, rows * 18).setSize(18, 18));
            }
            ++rows;
        }
        return scrollable.setSize(76, 90).setPos(52, 7);
    }

    @Override
    public Pos2d getPowerSwitchButtonPos() {
        return new Pos2d(144, 0);
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    public VoidingMode getVoidingMode() {
        return this.voidingMode;
    }

    @Override
    public void setVoidingMode(VoidingMode mode) {
        this.voidingMode = mode;
    }

    @Override
    public List<ItemStack> getItemOutputSlots(ItemStack[] toOutput) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        IItemHandlerModifiable inv = this.getOutputInventory();
        if (inv != null && inv.getSlots() > 0) {
            for (int i = 0; i < inv.getSlots(); ++i) {
                ret.add(inv.getStackInSlot(i));
            }
        }
        return ret;
    }

    @Override
    public List<? extends IFluidStore> getFluidOutputSlots(FluidStack[] toOutput) {
        return Arrays.asList(this.getOutputTanks());
    }

    @Override
    public boolean canDumpItemToME() {
        return false;
    }

    @Override
    public boolean canDumpFluidToME() {
        return false;
    }

    @Override
    public Pos2d getVoidingModeButtonPos() {
        return new Pos2d(54, 0);
    }

    @Override
    public boolean supportsInputSeparation() {
        return true;
    }

    @Override
    public boolean isInputSeparationEnabled() {
        return this.separateInputs;
    }

    @Override
    public void setInputSeparation(boolean enabled) {
        this.separateInputs = enabled;
    }

    @Override
    public Pos2d getInputSeparationButtonPos() {
        return new Pos2d(36, 0);
    }

    @Override
    public boolean supportsBatchMode() {
        return true;
    }

    @Override
    public boolean isBatchModeEnabled() {
        return this.batchMode;
    }

    @Override
    public void setBatchMode(boolean mode) {
        this.batchMode = mode;
    }

    @Override
    public Pos2d getBatchModeButtonPos() {
        return new Pos2d(18, 0);
    }

    @Override
    public boolean supportsSingleRecipeLocking() {
        return false;
    }

    @Override
    public boolean isRecipeLockingEnabled() {
        return this.recipeLock;
    }

    @Override
    public void setRecipeLocking(boolean enabled) {
        this.recipeLock = enabled;
    }

    @Override
    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return null;
    }

    @Override
    public Pos2d getRecipeLockingButtonPos() {
        return new Pos2d(0, 0);
    }

    @Override
    public ModularWindow createWindowGUI(UIBuildContext buildContext) {
        return this.createWindow(buildContext);
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74772_a("progress", this.progressTime);
        tag.func_74772_a("maxProgress", this.maxProgressTime);
        tag.func_74757_a("structureOkay", this.structureOkay);
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currentTip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        if (!tag.func_74767_n("structureOkay")) {
            currentTip.add(SpecialChars.RED + "** INCOMPLETE STRUCTURE **" + SpecialChars.RESET);
        } else {
            currentTip.add(SpecialChars.GREEN + "Running Fine" + SpecialChars.RESET);
        }
        if (this.isSimpleMachine) {
            boolean isActive = tag.func_74767_n("isActive");
            currentTip.add(GT_Waila.getMachineProgressString(isActive, tag.func_74763_f("maxProgress"), tag.func_74763_f("progress")));
        }
    }

    public static class BuildState {
        boolean building = false;
        Vec3Impl currentOffset;

        public void startBuilding(Vec3Impl structureOffset) {
            if (this.building) {
                throw new IllegalStateException("Already building!");
            }
            this.building = true;
            this.setCurrentOffset(structureOffset);
        }

        public Vec3Impl setCurrentOffset(Vec3Impl structureOffset) {
            this.verifyBuilding();
            this.currentOffset = structureOffset;
            return this.currentOffset;
        }

        private void verifyBuilding() {
            if (!this.building) {
                throw new IllegalStateException("Not building!");
            }
        }

        public boolean failBuilding() {
            this.building = false;
            this.currentOffset = null;
            return false;
        }

        public Vec3Impl stopBuilding() {
            Vec3Impl toReturn = this.getCurrentOffset();
            this.building = false;
            this.currentOffset = null;
            return toReturn;
        }

        public Vec3Impl getCurrentOffset() {
            this.verifyBuilding();
            return this.currentOffset;
        }

        public Vec3Impl addOffset(Vec3Impl offset) {
            this.verifyBuilding();
            return this.setCurrentOffset(this.currentOffset.add(offset));
        }
    }
}

