/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.multitileentity.multiblock.base;

import gregtech.api.enums.GT_Values;
import gregtech.api.logic.ComplexParallelProcessingLogic;
import gregtech.api.logic.interfaces.PollutionLogicHost;
import gregtech.api.multitileentity.multiblock.base.PowerController;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.GT_Waila;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.LongStream;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public abstract class ComplexParallelController<T extends ComplexParallelController<T>>
extends PowerController<T> {
    protected ComplexParallelProcessingLogic processingLogic;
    protected int maxComplexParallels = 0;
    protected int currentComplexParallels = 0;
    protected long[] maxProgressTimes = new long[0];
    protected long[] progressTimes = new long[0];

    public ComplexParallelController() {
        this.isSimpleMachine = false;
    }

    protected void setMaxComplexParallels(int parallel) {
        if (parallel != this.maxComplexParallels) {
            if (this.maxComplexParallels != 0) {
                this.stopMachine(false);
            }
            this.maxProgressTimes = new long[parallel];
            this.progressTimes = new long[parallel];
        }
        this.maxComplexParallels = parallel;
    }

    @Override
    protected void runMachine(long tick) {
        if (this.acceptsFuel() && this.isActive() && !this.consumeFuel()) {
            this.stopMachine(true);
            return;
        }
        if (this.hasThingsToDo()) {
            this.func_70296_d();
            this.runningTick(tick);
        }
        if ((tick % 100L == 0L || this.hasWorkJustBeenEnabled() || this.hasInventoryBeenModified()) && this.maxComplexParallels != this.currentComplexParallels && this.isAllowedToWork() && this.maxComplexParallels > this.currentComplexParallels) {
            this.wasEnabled = false;
            boolean started = false;
            for (int i = 0; i < this.maxComplexParallels; ++i) {
                if (this.maxProgressTimes[i] > 0L || !this.checkRecipe(i)) continue;
                ++this.currentComplexParallels;
                started = true;
            }
            if (started) {
                this.setActive(true);
                this.updateSlots();
                this.func_70296_d();
                this.issueClientUpdate();
            }
        }
    }

    @Override
    protected void runningTick(long tick) {
        this.consumeEnergy();
        boolean allStopped = true;
        for (int i = 0; i < this.maxComplexParallels; ++i) {
            if (this.maxProgressTimes[i] > 0L) {
                int n = i;
                this.progressTimes[n] = this.progressTimes[n] + 1L;
                if (this.progressTimes[n] >= this.maxProgressTimes[i]) {
                    this.progressTimes[i] = 0L;
                    this.maxProgressTimes[i] = 0L;
                    this.outputItems(i);
                    this.outputFluids(i);
                    if (this.isAllowedToWork()) {
                        if (this.checkRecipe(i)) {
                            allStopped = false;
                        } else {
                            --this.currentComplexParallels;
                        }
                    }
                    this.updateSlots();
                    continue;
                }
            }
            if (this.maxProgressTimes[i] <= 0L) continue;
            allStopped = false;
        }
        if (allStopped) {
            this.setActive(false);
            this.issueClientUpdate();
        }
        if (this instanceof PollutionLogicHost && tick % 20L == 0L) {
            this.doPollution();
        }
        this.emitEnergy();
    }

    protected boolean checkRecipe(int index) {
        ComplexParallelProcessingLogic processingLogic = this.getComplexProcessingLogic();
        if (processingLogic == null || index < 0 || index >= this.maxComplexParallels) {
            return false;
        }
        processingLogic.clear(index);
        boolean result = processingLogic.setInputItems(index, this.getInputItems(index)).setInputFluids(index, this.getInputFluids(index)).setTileEntity(this).setVoidProtection(index, this.isVoidProtectionEnabledForItem(index), this.isVoidProtectionEnabledForFluid(index)).setEut(index, this.getEutForComplexParallel(index)).setPerfectOverclock(this.hasPerfectOverclock()).process(index);
        this.setDuration(index, processingLogic.getDuration(index));
        this.setEut(processingLogic.getTotalEU());
        return result;
    }

    protected void outputItems(int index) {
        ComplexParallelProcessingLogic processingLogic = this.getComplexProcessingLogic();
        if (processingLogic != null && index >= 0 && index < this.maxComplexParallels) {
            this.outputItems(processingLogic.getOutputItems(index));
        }
    }

    protected void outputFluids(int index) {
        ComplexParallelProcessingLogic processingLogic = this.getComplexProcessingLogic();
        if (processingLogic != null && index >= 0 && index < this.maxComplexParallels) {
            this.outputFluids(processingLogic.getOutputFluids(index));
        }
    }

    protected ComplexParallelProcessingLogic getComplexProcessingLogic() {
        return this.processingLogic;
    }

    @Override
    public boolean hasThingsToDo() {
        return LongStream.of(this.maxProgressTimes).sum() > 0L;
    }

    @Override
    protected void stopMachine(boolean powerShutDown) {
        super.stopMachine(powerShutDown);
        for (int i = 0; i < this.maxComplexParallels; ++i) {
            this.maxProgressTimes[i] = 0L;
        }
    }

    protected void setDuration(int index, long duration) {
        if (duration < 0L) {
            duration = -duration;
        }
        if (index >= 0 && index < this.maxComplexParallels) {
            this.maxProgressTimes[index] = duration;
        }
    }

    protected ItemStack[] getInputItems(int index) {
        return this.getInputItems();
    }

    protected FluidStack[] getInputFluids(int index) {
        return this.getInputFluids();
    }

    protected boolean isVoidProtectionEnabledForItem(int index) {
        return this.protectsExcessItem();
    }

    protected boolean isVoidProtectionEnabledForFluid(int index) {
        return this.protectsExcessFluid();
    }

    protected boolean hasPerfectOverclock() {
        return false;
    }

    protected long getEutForComplexParallel(int index) {
        return GT_Values.V[this.tier] - this.eut;
    }

    @Override
    protected void addProgressStringToScanner(EntityPlayer player, int logLevel, ArrayList<String> list) {
        for (int i = 0; i < this.maxComplexParallels; ++i) {
            list.add(StatCollector.func_74838_a((String)"GT5U.multiblock.Progress") + " " + (i + 1) + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers(this.progressTimes[i] > 20L ? this.progressTimes[i] / 20L : this.progressTimes[i]) + EnumChatFormatting.RESET + (this.progressTimes[i] > 20L ? " s / " : " ticks / ") + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(this.maxProgressTimes[i] > 20L ? this.maxProgressTimes[i] / 20L : this.maxProgressTimes[i]) + EnumChatFormatting.RESET + (this.maxProgressTimes[i] > 20L ? " s" : " ticks"));
        }
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74768_a("maxComplexParallels", this.maxComplexParallels);
        for (int i = 0; i < this.maxComplexParallels; ++i) {
            tag.func_74772_a("maxProgress" + i, this.maxProgressTimes[i]);
            tag.func_74772_a("progress" + i, this.progressTimes[i]);
        }
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currentTip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        this.maxComplexParallels = tag.func_74762_e("maxComplexParallels");
        for (int i = 0; i < this.maxComplexParallels; ++i) {
            long maxProgress = tag.func_74763_f("maxProgress" + i);
            long progress = tag.func_74763_f("progress" + i);
            currentTip.add("Process " + (i + 1) + ": " + GT_Waila.getMachineProgressString(maxProgress > 0L && maxProgress >= progress, maxProgress, progress));
        }
    }
}

