/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.multitileentity.base;

import com.gtnewhorizons.modularui.common.internal.network.NetworkUtils;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GT_UIInfos;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.metatileentity.CoverableTileEntity;
import gregtech.api.multitileentity.MultiTileEntityBlockInternal;
import gregtech.api.multitileentity.MultiTileEntityClassContainer;
import gregtech.api.multitileentity.MultiTileEntityRegistry;
import gregtech.api.multitileentity.interfaces.IMultiTileEntity;
import gregtech.api.net.GT_Packet_MultiTileEntity;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.objects.XSTR;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Util;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.ISerializableObject;
import gregtech.common.render.MultiTileBasicRender;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;

public abstract class MultiTileEntity
extends CoverableTileEntity
implements IMultiTileEntity.IMTE_BreakBlock,
MultiTileBasicRender {
    private ITexture baseTexture = null;
    private ITexture topOverlayTexture = null;
    private ITexture bottomOverlayTexture = null;
    private ITexture leftOverlayTexture = null;
    private ITexture rightOverlayTexture = null;
    private ITexture backOverlayTexture = null;
    private ITexture frontOverlayTexture = null;
    protected static final float[] PX_BOX = new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    public Materials material = Materials._NULL;
    protected final boolean isTicking;
    protected boolean shouldRefresh = true;
    protected boolean needsBlockUpdate = false;
    protected boolean forceFullSelectionBox = false;
    protected boolean needsUpdate = false;
    protected boolean hasInventoryChanged = false;
    protected boolean isPainted = false;
    protected ForgeDirection facing = ForgeDirection.WEST;
    protected byte color;
    protected int rgba = 0xFFFFFF;
    private short mteID = Short.MAX_VALUE;
    private short mteRegistry = Short.MAX_VALUE;
    private String customName = null;
    private String ownerName = "";
    private UUID ownerUUID = GT_Utility.defaultUuid;
    private boolean lockUpgrade = false;

    public MultiTileEntity(boolean isTicking) {
        this.isTicking = isTicking;
    }

    @Override
    public short getMultiTileEntityID() {
        return this.mteID;
    }

    @Override
    public short getMultiTileEntityRegistryID() {
        return this.mteRegistry;
    }

    @Override
    public void onRegistrationFirst(MultiTileEntityRegistry registry, short id) {
        GameRegistry.registerTileEntity(this.getClass(), (String)this.getTileEntityName());
    }

    @Override
    public void initFromNBT(NBTTagCompound nbt, short mteID, short mteRegistry) {
        if (this.mteID == mteID && this.mteRegistry == mteRegistry) {
            return;
        }
        this.mteID = mteID;
        this.mteRegistry = mteRegistry;
        if (nbt != null) {
            this.func_145839_a(nbt);
        }
    }

    @Override
    public void loadTextures(String folder) {
        block11: for (SidedTextureNames textureName : SidedTextureNames.TEXTURES) {
            ITexture texture;
            try {
                Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation(Mods.GregTech.ID, "textures/blocks/multitileentity/" + folder + "/" + textureName.getName() + ".png"));
                texture = TextureFactory.of(new Textures.BlockIcons.CustomIcon("multitileentity/" + folder + "/" + textureName.getName()));
            }
            catch (IOException ignored) {
                texture = TextureFactory.of(Textures.BlockIcons.VOID);
            }
            switch (textureName) {
                case Top: {
                    this.topOverlayTexture = texture;
                    continue block11;
                }
                case Bottom: {
                    this.bottomOverlayTexture = texture;
                    continue block11;
                }
                case Back: {
                    this.backOverlayTexture = texture;
                    continue block11;
                }
                case Front: {
                    this.frontOverlayTexture = texture;
                    continue block11;
                }
                case Left: {
                    this.leftOverlayTexture = texture;
                    continue block11;
                }
                case Right: {
                    this.rightOverlayTexture = texture;
                    continue block11;
                }
                case Base: {
                    this.baseTexture = texture;
                }
            }
        }
    }

    @Override
    public void copyTextures() {
        TileEntity tCanonicalTileEntity = MultiTileEntityRegistry.getCanonicalTileEntity(this.getMultiTileEntityRegistryID(), this.getMultiTileEntityID());
        if (!(tCanonicalTileEntity instanceof MultiTileEntity)) {
            return;
        }
        MultiTileEntity canonicalEntity = (MultiTileEntity)tCanonicalTileEntity;
        this.baseTexture = canonicalEntity.baseTexture;
        this.topOverlayTexture = canonicalEntity.topOverlayTexture;
        this.bottomOverlayTexture = canonicalEntity.bottomOverlayTexture;
        this.leftOverlayTexture = canonicalEntity.leftOverlayTexture;
        this.rightOverlayTexture = canonicalEntity.rightOverlayTexture;
        this.backOverlayTexture = canonicalEntity.backOverlayTexture;
        this.frontOverlayTexture = canonicalEntity.frontOverlayTexture;
    }

    @Override
    public ITexture getTexture(ForgeDirection side) {
        if (this.facing == side) {
            return TextureFactory.of(this.baseTexture, this.frontOverlayTexture);
        }
        if (this.facing.getOpposite() == side) {
            return TextureFactory.of(this.baseTexture, this.backOverlayTexture);
        }
        if (side == ForgeDirection.UP) {
            return TextureFactory.of(this.baseTexture, this.topOverlayTexture);
        }
        if (side == ForgeDirection.DOWN) {
            return TextureFactory.of(this.baseTexture, this.bottomOverlayTexture);
        }
        if (this.facing.getRotation(ForgeDirection.DOWN) == side) {
            return TextureFactory.of(this.baseTexture, this.rightOverlayTexture);
        }
        return TextureFactory.of(this.baseTexture, this.leftOverlayTexture);
    }

    @Override
    public ITexture[] getTexture(Block ignoredBlock, ForgeDirection ignoredSide) {
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        if (this.mteID == Short.MAX_VALUE || this.mteRegistry == Short.MAX_VALUE) {
            MultiTileEntityClassContainer tClass;
            this.mteID = nbt.func_74765_d("gt.mte.id");
            this.mteRegistry = nbt.func_74765_d("gt.mte.reg");
            MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry(this.mteRegistry);
            if (tRegistry != null && (tClass = tRegistry.getClassContainer(this.mteID)) != null) {
                nbt = GT_Util.fuseNBT(nbt, tClass.mParameters);
            }
        }
        if (nbt.func_74764_b("x")) {
            this.field_145851_c = nbt.func_74762_e("x");
        }
        if (nbt.func_74764_b("y")) {
            this.field_145848_d = nbt.func_74762_e("y");
        }
        if (nbt.func_74764_b("z")) {
            this.field_145849_e = nbt.func_74762_e("z");
        }
        if (nbt.func_74764_b("gt.display")) {
            this.customName = nbt.func_74775_l("gt.display").func_74779_i("name");
        }
        try {
            if (nbt.func_74764_b("gt.material")) {
                this.material = Materials.get(nbt.func_74779_i("gt.material"));
            }
            if (nbt.func_74764_b("gt.color")) {
                this.rgba = nbt.func_74762_e("gt.color");
            }
            this.ownerName = nbt.func_74779_i("gt.owner");
            try {
                this.ownerUUID = UUID.fromString(nbt.func_74779_i("gt.ownerUuid"));
            }
            catch (IllegalArgumentException e) {
                this.ownerUUID = null;
            }
            if (nbt.func_74764_b("gt.locked")) {
                this.lockUpgrade = nbt.func_74767_n("gt.locked");
            }
            if (nbt.func_74764_b("gt.facing")) {
                this.facing = ForgeDirection.getOrientation((int)nbt.func_74762_e("gt.facing"));
            }
            this.readCoverNBT(nbt);
            this.readMultiTileNBT(nbt);
            if (NetworkUtils.isDedicatedClient()) {
                if (GregTech_API.sBlockIcons == null && nbt.func_74764_b("gt.texture.folder")) {
                    this.loadTextures(nbt.func_74779_i("gt.texture.folder"));
                } else {
                    this.copyTextures();
                }
            }
            if (this.mSidedRedstone.length != 6) {
                this.mSidedRedstone = new byte[]{15, 15, 15, 15, 15, 15};
            }
            this.updateCoverBehavior();
        }
        catch (Throwable e) {
            GT_Mod.GT_FML_LOGGER.error("readFromNBT", e);
        }
    }

    public void readMultiTileNBT(NBTTagCompound aNBT) {
    }

    @Override
    public final void func_145841_b(NBTTagCompound aNBT) {
        super.func_145841_b(aNBT);
        aNBT.func_74777_a("gt.mte.id", this.mteID);
        aNBT.func_74777_a("gt.mte.reg", this.mteRegistry);
        if (GT_Utility.isStringValid(this.customName)) {
            NBTTagCompound displayNBT;
            if (aNBT.func_74764_b("gt.display")) {
                displayNBT = aNBT.func_74775_l("gt.display");
            } else {
                displayNBT = new NBTTagCompound();
                aNBT.func_74782_a("gt.display", (NBTBase)displayNBT);
            }
            displayNBT.func_74778_a("name", this.customName);
        }
        try {
            aNBT.func_74778_a("gt.owner", this.ownerName);
            aNBT.func_74778_a("gt.ownerUuid", this.ownerUUID == null ? "" : this.ownerUUID.toString());
            aNBT.func_74757_a("gt.locked", this.lockUpgrade);
            aNBT.func_74768_a("gt.facing", this.facing.ordinal());
            this.writeCoverNBT(aNBT, false);
            this.writeMultiTileNBT(aNBT);
        }
        catch (Throwable e) {
            GT_Mod.GT_FML_LOGGER.error("writeToNBT", e);
        }
    }

    public void writeMultiTileNBT(NBTTagCompound aNBT) {
    }

    @Override
    public NBTTagCompound writeItemNBT(NBTTagCompound aNBT) {
        this.writeCoverNBT(aNBT, true);
        if (this.shouldSaveNBTToItemStack()) {
            this.writeMultiTileNBT(aNBT);
        }
        return aNBT;
    }

    protected boolean shouldSaveNBTToItemStack() {
        return false;
    }

    @Override
    public boolean useModularUI() {
        return false;
    }

    @Override
    public long getTimer() {
        return 0L;
    }

    @Override
    public int getRandomNumber(int aRange) {
        return XSTR.XSTR_INSTANCE.nextInt(aRange);
    }

    @Override
    public TileEntity getTileEntity(int aX, int aY, int aZ) {
        if (this.field_145850_b == null || this.ignoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.field_145850_b.func_72899_e(aX, aY, aZ)) {
            return null;
        }
        return GT_Util.getTileEntity(this.field_145850_b, aX, aY, aZ, true);
    }

    public boolean canUpdate() {
        return this.isTicking && this.shouldRefresh;
    }

    public boolean shouldRefresh(Block aOldBlock, Block aNewBlock, int aOldMeta, int aNewMeta, World aWorld, int aX, int aY, int aZ) {
        return this.shouldRefresh || aOldBlock != aNewBlock;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.needsBlockUpdate) {
            this.doBlockUpdate();
        }
    }

    public void doBlockUpdate() {
        Block tBlock = this.getBlock(this.getCoords());
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, tBlock);
        if (this instanceof IMultiTileEntity.IMTE_IsProvidingStrongPower) {
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                if (!this.getBlockAtSide(side).isNormalCube((IBlockAccess)this.field_145850_b, this.field_145851_c + side.offsetX, this.field_145848_d + side.offsetY, this.field_145849_e + side.offsetZ)) continue;
                this.field_145850_b.func_147441_b(this.field_145851_c + side.offsetX, this.field_145848_d + side.offsetY, this.field_145849_e + side.offsetZ, tBlock, side.getOpposite().ordinal());
            }
        }
        this.needsBlockUpdate = false;
    }

    @Override
    public boolean shouldSideBeRendered(ForgeDirection side) {
        IMultiTileEntity mte;
        TileEntity tTileEntity = this.getTileEntityAtSideAndDistance(side, 1);
        return tTileEntity instanceof IMultiTileEntity ? !(mte = (IMultiTileEntity)tTileEntity).isSurfaceOpaque(side.getOpposite()) : !this.getBlockAtSide(side).func_149662_c();
    }

    @Override
    public boolean isSurfaceOpaque(ForgeDirection side) {
        return true;
    }

    @Override
    public void setCustomName(String aName) {
        this.customName = aName;
    }

    @Override
    public String getCustomName() {
        return GT_Utility.isStringValid(this.customName) ? this.customName : null;
    }

    @Override
    public byte getColorization() {
        return 0;
    }

    @Override
    public boolean unpaint() {
        return false;
    }

    @Override
    public byte setColorization(byte aColor) {
        return 0;
    }

    @Override
    public boolean isPainted() {
        return false;
    }

    @Override
    public boolean paint(int aRGB) {
        return false;
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return false;
    }

    @Override
    public ForgeDirection getFrontFacing() {
        return this.facing;
    }

    @Override
    public boolean setMainFacing(ForgeDirection side) {
        if (!this.isValidFacing(side)) {
            return false;
        }
        this.facing = side;
        this.issueClientUpdate();
        this.issueBlockUpdate();
        this.onFacingChange();
        this.checkDropCover();
        this.doEnetUpdate();
        if (this.shouldTriggerBlockUpdate()) {
            GregTech_API.causeMachineUpdate(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        } else {
            this.onMachineBlockUpdate();
        }
        return true;
    }

    @Override
    public int getPaint() {
        return this.rgba;
    }

    @Override
    public ForgeDirection getBackFacing() {
        return this.facing.getOpposite();
    }

    @Override
    public boolean isValidFacing(ForgeDirection side) {
        return side != ForgeDirection.UNKNOWN && this.getValidFacings()[side.ordinal()];
    }

    @Override
    public boolean[] getValidFacings() {
        return GT_Values.VALID_SIDES;
    }

    @Override
    public void issueCoverUpdate(ForgeDirection side) {
        super.issueCoverUpdate(side);
        this.issueClientUpdate();
    }

    public AxisAlignedBB box(double[] aBox) {
        return AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + aBox[0]), (double)((double)this.field_145848_d + aBox[1]), (double)((double)this.field_145849_e + aBox[2]), (double)((double)this.field_145851_c + aBox[3]), (double)((double)this.field_145848_d + aBox[4]), (double)((double)this.field_145849_e + aBox[5]));
    }

    public boolean box(AxisAlignedBB aAABB, List<AxisAlignedBB> aList, double aMinX, double aMinY, double aMinZ, double aMaxX, double aMaxY, double aMaxZ) {
        AxisAlignedBB tBox = this.box(aMinX, aMinY, aMinZ, aMaxX, aMaxY, aMaxZ);
        return tBox.func_72326_a(aAABB) && aList.add(tBox);
    }

    @Override
    public void onFacingChange() {
    }

    public AxisAlignedBB box(double aMinX, double aMinY, double aMinZ, double aMaxX, double aMaxY, double aMaxZ) {
        return AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + aMinX), (double)((double)this.field_145848_d + aMinY), (double)((double)this.field_145849_e + aMinZ), (double)((double)this.field_145851_c + aMaxX), (double)((double)this.field_145848_d + aMaxY), (double)((double)this.field_145849_e + aMaxZ));
    }

    @Override
    public boolean shouldTriggerBlockUpdate() {
        return false;
    }

    public boolean box(AxisAlignedBB aAABB, List<AxisAlignedBB> aList, double[] aBox) {
        AxisAlignedBB tBox = this.box(aBox[0], aBox[1], aBox[2], aBox[3], aBox[4], aBox[5]);
        return tBox.func_72326_a(aAABB) && aList.add(tBox);
    }

    @Override
    public void onMachineBlockUpdate() {
    }

    public boolean box(AxisAlignedBB aAABB, List<AxisAlignedBB> aList, float[] aBox) {
        AxisAlignedBB tBox = this.box(aBox[0], aBox[1], aBox[2], aBox[3], aBox[4], aBox[5]);
        return tBox.func_72326_a(aAABB) && aList.add(tBox);
    }

    public boolean box(AxisAlignedBB aAABB, List<AxisAlignedBB> aList) {
        AxisAlignedBB tBox = this.box(PX_BOX);
        return tBox.func_72326_a(aAABB) && aList.add(tBox);
    }

    public AxisAlignedBB box(float[] aBox) {
        return AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + aBox[0]), (double)((float)this.field_145848_d + aBox[1]), (double)((float)this.field_145849_e + aBox[2]), (double)((float)this.field_145851_c + aBox[3]), (double)((float)this.field_145848_d + aBox[4]), (double)((float)this.field_145849_e + aBox[5]));
    }

    public boolean box(Block aBlock) {
        aBlock.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return true;
    }

    @Override
    public void issueTextureUpdate() {
        if (!this.isTicking) {
            this.markBlockForUpdate();
        } else {
            this.needsUpdate = true;
        }
    }

    public boolean box(Block aBlock, double[] aBox) {
        aBlock.func_149676_a((float)aBox[0], (float)aBox[1], (float)aBox[2], (float)aBox[3], (float)aBox[4], (float)aBox[5]);
        return true;
    }

    protected void markBlockForUpdate() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.needsUpdate = false;
    }

    public boolean box(Block aBlock, float[] aBox) {
        aBlock.func_149676_a(aBox[0], aBox[1], aBox[2], aBox[3], aBox[4], aBox[5]);
        return true;
    }

    @Override
    public void onTileEntityPlaced() {
    }

    public boolean box(Block aBlock, double aMinX, double aMinY, double aMinZ, double aMaxX, double aMaxY, double aMaxZ) {
        aBlock.func_149676_a((float)aMinX, (float)aMinY, (float)aMinZ, (float)aMaxX, (float)aMaxY, (float)aMaxZ);
        return true;
    }

    @Override
    public void setShouldRefresh(boolean aShouldRefresh) {
        this.shouldRefresh = aShouldRefresh;
    }

    @Override
    public boolean shouldJoinIc2Enet() {
        return false;
    }

    @Override
    public final void addCollisionBoxesToList(AxisAlignedBB aAABB, List<AxisAlignedBB> aList, Entity aEntity) {
        this.box(this.getCollisionBoundingBoxFromPool(), aAABB, aList);
    }

    @Override
    public final void issueBlockUpdate() {
        if (this.isTicking) {
            this.needsBlockUpdate = true;
        } else {
            this.doBlockUpdate();
        }
    }

    @Override
    public boolean isStillValid() {
        return !this.func_145837_r();
    }

    @Override
    public boolean allowCoverOnSide(ForgeDirection side, GT_ItemStack aCoverID) {
        return true;
    }

    public AxisAlignedBB box() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
    }

    public boolean box(AxisAlignedBB aBox, AxisAlignedBB aAABB, List<AxisAlignedBB> aList) {
        return aBox != null && aBox.func_72326_a(aAABB) && aList.add(aBox);
    }

    public float[] shrunkBox() {
        return PX_BOX;
    }

    @Override
    public void setBlockBoundsBasedOnState(Block aBlock) {
        this.box(aBlock);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return this.box();
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        if (this.forceFullSelectionBox) {
            return this.box();
        }
        return this.box(this.shrunkBox());
    }

    @Override
    public ItemStack getPickBlock(MovingObjectPosition aTarget) {
        MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry(this.mteRegistry);
        return tRegistry == null ? null : tRegistry.getItem((int)this.mteID, this.writeItemNBT(new NBTTagCompound()));
    }

    @Override
    public void onBlockAdded() {
    }

    @Override
    public String getOwnerName() {
        if (GT_Utility.isStringInvalid(this.ownerName)) {
            return "Player";
        }
        return this.ownerName;
    }

    @Override
    public String setOwnerName(String aName) {
        if (GT_Utility.isStringInvalid(aName)) {
            this.ownerName = "Player";
            return "Player";
        }
        this.ownerName = aName;
        return this.ownerName;
    }

    @Override
    public UUID getOwnerUuid() {
        return this.ownerUUID;
    }

    @Override
    public void setOwnerUuid(UUID uuid) {
        this.ownerUUID = uuid;
    }

    @Override
    public boolean onPlaced(ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, ForgeDirection side, float aHitX, float aHitY, float aHitZ) {
        this.facing = MultiTileEntity.getSideForPlayerPlacing((Entity)aPlayer, this.facing, this.getValidFacings());
        this.onFacingChange();
        return true;
    }

    @Override
    public boolean allowInteraction(Entity aEntity) {
        return true;
    }

    public boolean allowRightclick(Entity aEntity) {
        return this.allowInteraction(aEntity);
    }

    @Override
    public boolean onBlockActivated(EntityPlayer aPlayer, ForgeDirection side, float aX, float aY, float aZ) {
        try {
            return this.allowRightclick((Entity)aPlayer) && this.onRightClick(aPlayer, side, aX, aY, aZ);
        }
        catch (Throwable e) {
            GT_Mod.GT_FML_LOGGER.error("onBlockActivated Failed", e);
            e.printStackTrace(GT_Log.err);
            return true;
        }
    }

    @Override
    public boolean onRightClick(EntityPlayer aPlayer, ForgeDirection side, float aX, float aY, float aZ) {
        if (this.isClientSide()) {
            if (aPlayer.func_70093_af()) {
                ForgeDirection tSide = this.getCoverIDAtSide(side) == 0 ? GT_Utility.determineWrenchingSide(side, aX, aY, aZ) : side;
                return this.getCoverBehaviorAtSideNew(tSide).hasCoverGUI();
            }
            if (this.getCoverBehaviorAtSideNew(side).onCoverRightclickClient(side, this, aPlayer, aX, aY, aZ)) {
                return true;
            }
            if (!this.getCoverInfoAtSide(side).isGUIClickable()) {
                return false;
            }
        }
        if (this.isServerSide() && (!this.privateAccess() || aPlayer.getDisplayName().equalsIgnoreCase(this.getOwnerName()))) {
            ItemStack tCurrentItem = aPlayer.field_71071_by.func_70448_g();
            ForgeDirection wrenchSide = GT_Utility.determineWrenchingSide(side, aX, aY, aZ);
            if (tCurrentItem != null) {
                ForgeDirection coverSide;
                if (this.getColorization() < 0 || GT_Utility.areStacksEqual(new ItemStack(Items.field_151131_as, 1), tCurrentItem)) {
                    // empty if block
                }
                if (GT_Utility.isStackInList(tCurrentItem, GregTech_API.sWrenchList)) {
                    return this.onWrenchRightClick(aPlayer, tCurrentItem, wrenchSide, aX, aY, aZ);
                }
                if (GT_Utility.isStackInList(tCurrentItem, GregTech_API.sScrewdriverList)) {
                    return this.onScrewdriverRightClick(aPlayer, tCurrentItem, wrenchSide, aX, aY, aZ);
                }
                if (GT_Utility.isStackInList(tCurrentItem, GregTech_API.sHardHammerList)) {
                    return this.onHammerRightClick(aPlayer, tCurrentItem, wrenchSide, aX, aY, aZ);
                }
                if (GT_Utility.isStackInList(tCurrentItem, GregTech_API.sSoftHammerList)) {
                    return this.onMalletRightClick(aPlayer, tCurrentItem, wrenchSide, aX, aY, aZ);
                }
                if (GT_Utility.isStackInList(tCurrentItem, GregTech_API.sSolderingToolList)) {
                    return this.onSolderingRightClick(aPlayer, tCurrentItem, wrenchSide, aX, aY, aZ);
                }
                if (GT_Utility.isStackInList(tCurrentItem, GregTech_API.sWireCutterList)) {
                    return this.onWireCutterRightClick(aPlayer, tCurrentItem, wrenchSide, aX, aY, aZ);
                }
                ForgeDirection forgeDirection = coverSide = this.getCoverIDAtSide(side) == 0 ? wrenchSide : side;
                if (this.getCoverIDAtSide(coverSide) == 0) {
                    if (GT_Utility.isStackInList(tCurrentItem, GregTech_API.sCovers.keySet())) {
                        if (GregTech_API.getCoverBehaviorNew(tCurrentItem).isCoverPlaceable(coverSide, tCurrentItem, (ICoverable)this) && this.allowCoverOnSide(coverSide, new GT_ItemStack(tCurrentItem))) {
                            this.setCoverItemAtSide(coverSide, tCurrentItem);
                            if (!aPlayer.field_71075_bZ.field_75098_d) {
                                --tCurrentItem.field_77994_a;
                            }
                            GT_Utility.sendSoundToPlayers(this.field_145850_b, SoundResource.IC2_TOOLS_WRENCH, 1.0f, -1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                            this.issueClientUpdate();
                        }
                        this.sendCoverDataIfNeeded();
                        return true;
                    }
                } else if (GT_Utility.isStackInList(tCurrentItem, GregTech_API.sCrowbarList)) {
                    if (GT_ModHandler.damageOrDechargeItem(tCurrentItem, 1, 1000, (EntityLivingBase)aPlayer)) {
                        GT_Utility.sendSoundToPlayers(this.field_145850_b, SoundResource.RANDOM_BREAK, 1.0f, -1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        this.dropCover(coverSide, side, false);
                    }
                    this.sendCoverDataIfNeeded();
                    return true;
                }
            } else if (aPlayer.func_70093_af()) {
                side = this.getCoverIDAtSide(side) == 0 ? GT_Utility.determineWrenchingSide(side, aX, aY, aZ) : side;
                return this.getCoverIDAtSide(side) > 0 && this.getCoverBehaviorAtSideNew(side).onCoverShiftRightClick(side, this.getCoverIDAtSide(side), this.getComplexCoverDataAtSide(side), this, aPlayer);
            }
            if (this.getCoverBehaviorAtSideNew(side).onCoverRightClick(side, this.getCoverIDAtSide(side), this.getComplexCoverDataAtSide(side), this, aPlayer, aX, aY, aZ)) {
                return true;
            }
            if (!this.getCoverInfoAtSide(side).isGUIClickable()) {
                return false;
            }
            return this.openModularUi(aPlayer, side);
        }
        return false;
    }

    public boolean hasGui(ForgeDirection side) {
        return false;
    }

    boolean openModularUi(EntityPlayer aPlayer, ForgeDirection side) {
        if (!this.hasGui(side) || !this.isServerSide()) {
            System.out.println("No GUI or Not Serverside");
            return false;
        }
        GT_UIInfos.openGTTileEntityUI(this, aPlayer);
        System.out.println("Trying to open a UI");
        return true;
    }

    public boolean onWrenchRightClick(EntityPlayer aPlayer, ItemStack tCurrentItem, ForgeDirection wrenchSide, float aX, float aY, float aZ) {
        if (this.setMainFacing(wrenchSide)) {
            GT_ModHandler.damageOrDechargeItem(tCurrentItem, 1, 1000, (EntityLivingBase)aPlayer);
            GT_Utility.sendSoundToPlayers(this.field_145850_b, SoundResource.IC2_TOOLS_WRENCH, 1.0f, -1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return true;
    }

    public boolean onScrewdriverRightClick(EntityPlayer aPlayer, ItemStack tCurrentItem, ForgeDirection wrenchSide, float aX, float aY, float aZ) {
        if (GT_ModHandler.damageOrDechargeItem(tCurrentItem, 1, 200, (EntityLivingBase)aPlayer)) {
            this.setCoverDataAtSide(wrenchSide, (ISerializableObject)this.getCoverBehaviorAtSideNew(wrenchSide).onCoverScrewdriverClick(wrenchSide, this.getCoverIDAtSide(wrenchSide), this.getComplexCoverDataAtSide(wrenchSide), this, aPlayer, aX, aY, aZ));
            GT_Utility.sendSoundToPlayers(this.field_145850_b, SoundResource.IC2_TOOLS_WRENCH, 1.0f, -1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return true;
    }

    public boolean onHammerRightClick(EntityPlayer aPlayer, ItemStack tCurrentItem, ForgeDirection wrenchSide, float aX, float aY, float aZ) {
        return true;
    }

    public boolean onMalletRightClick(EntityPlayer aPlayer, ItemStack tCurrentItem, ForgeDirection wrenchSide, float aX, float aY, float aZ) {
        return true;
    }

    public boolean onSolderingRightClick(EntityPlayer aPlayer, ItemStack tCurrentItem, ForgeDirection wrenchSide, float aX, float aY, float aZ) {
        return true;
    }

    public boolean onWireCutterRightClick(EntityPlayer aPlayer, ItemStack tCurrentItem, ForgeDirection wrenchSide, float aX, float aY, float aZ) {
        return true;
    }

    @Override
    public float getExplosionResistance(Entity aExploder, double aExplosionX, double aExplosionY, double aExplosionZ) {
        return this.getExplosionResistance();
    }

    @Override
    public float getExplosionResistance() {
        return 10.0f;
    }

    @Override
    public void onExploded(Explosion aExplosion) {
    }

    @Override
    public boolean isSideSolid(ForgeDirection side) {
        return true;
    }

    @Override
    public ArrayList<ItemStack> getDrops(int aFortune, boolean aSilkTouch) {
        ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
        MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry(this.getMultiTileEntityRegistryID());
        if (tRegistry != null) {
            rList.add(tRegistry.getItem((int)this.getMultiTileEntityID(), this.writeItemNBT(new NBTTagCompound())));
        }
        return rList;
    }

    @Override
    public boolean breakBlock() {
        this.isDead = true;
        this.onBaseTEDestroyed();
        return false;
    }

    @Override
    public boolean getSubItems(MultiTileEntityBlockInternal aBlock, Item aItem, CreativeTabs aTab, List<ItemStack> aList, short aID) {
        return true;
    }

    @Override
    public boolean recolourBlock(ForgeDirection side, byte aColor) {
        return false;
    }

    @Override
    public boolean playerOwnsThis(EntityPlayer aPlayer, boolean aCheckPrecicely) {
        if (aCheckPrecicely || this.privateAccess() || this.ownerName.length() == 0) {
            if (this.ownerName.length() == 0 && this.isServerSide()) {
                this.setOwnerName(aPlayer.getDisplayName());
                this.setOwnerUuid(aPlayer.func_110124_au());
            } else {
                return !this.privateAccess() || aPlayer.getDisplayName().equals("Player") || this.ownerName.equals("Player") || this.ownerName.equals(aPlayer.getDisplayName());
            }
        }
        return true;
    }

    @Override
    public boolean privateAccess() {
        return this.lockUpgrade;
    }

    public GT_Packet_MultiTileEntity getClientDataPacket() {
        GT_Packet_MultiTileEntity packet = new GT_Packet_MultiTileEntity(0, this.field_145851_c, (short)this.field_145848_d, this.field_145849_e, this.getMultiTileEntityRegistryID(), this.getMultiTileEntityID(), (byte)(this.facing.ordinal() & 7 | (this.mRedstone ? 16 : 0)), this.color);
        packet.setCoverData(this.getCoverInfoAtSide(ForgeDirection.DOWN).getCoverID(), this.getCoverInfoAtSide(ForgeDirection.UP).getCoverID(), this.getCoverInfoAtSide(ForgeDirection.NORTH).getCoverID(), this.getCoverInfoAtSide(ForgeDirection.SOUTH).getCoverID(), this.getCoverInfoAtSide(ForgeDirection.WEST).getCoverID(), this.getCoverInfoAtSide(ForgeDirection.EAST).getCoverID());
        packet.setRedstoneData((byte)((this.mSidedRedstone[0] > 0 ? 1 : 0) | (this.mSidedRedstone[1] > 0 ? 2 : 0) | (this.mSidedRedstone[2] > 0 ? 4 : 0) | (this.mSidedRedstone[3] > 0 ? 8 : 0) | (this.mSidedRedstone[4] > 0 ? 16 : 0) | (this.mSidedRedstone[5] > 0 ? 32 : 0)));
        return packet;
    }

    @Override
    public void sendClientData(EntityPlayerMP aPlayer) {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        GT_Packet_MultiTileEntity tPacket = this.getClientDataPacket();
        if (aPlayer == null) {
            GT_Values.NW.sendPacketToAllPlayersInRange(this.field_145850_b, tPacket, this.getXCoord(), this.getZCoord());
        } else {
            GT_Values.NW.sendToPlayer(tPacket, aPlayer);
        }
        this.sendCoverDataIfNeeded();
    }

    public boolean func_145842_c(int aEventID, int aValue) {
        super.func_145842_c(aEventID, aValue);
        if (this.isClientSide()) {
            this.issueTextureUpdate();
            switch (aEventID) {
                case 0: {
                    this.facing = ForgeDirection.getOrientation((int)(aValue & 7));
                    this.mRedstone = (aValue & 0x10) != 0;
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    if (aValue > 16 || aValue < 0) {
                        aValue = 0;
                    }
                    this.color = (byte)aValue;
                    break;
                }
                case 3: {
                    this.mSidedRedstone[0] = (byte)((aValue & 1) == 1 ? 15 : 0);
                    this.mSidedRedstone[1] = (byte)((aValue & 2) == 2 ? 15 : 0);
                    this.mSidedRedstone[2] = (byte)((aValue & 4) == 4 ? 15 : 0);
                    this.mSidedRedstone[3] = (byte)((aValue & 8) == 8 ? 15 : 0);
                    this.mSidedRedstone[4] = (byte)((aValue & 0x10) == 16 ? 15 : 0);
                    this.mSidedRedstone[5] = (byte)((aValue & 0x20) == 32 ? 15 : 0);
                }
            }
        }
        return true;
    }

    public Packet func_145844_m() {
        this.issueClientUpdate();
        return null;
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currentTip, accessor, config);
        currentTip.add(String.format("Facing: %s", this.getFrontFacing().name()));
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public ArrayList<String> getDebugInfo(EntityPlayer aPlayer, int aLogLevel) {
        ArrayList<String> tList = new ArrayList<String>();
        if (aLogLevel > 2) {
            tList.add("MultiTileRegistry-ID: " + EnumChatFormatting.BLUE + this.mteRegistry + EnumChatFormatting.RESET + " MultiTile-ID: " + EnumChatFormatting.BLUE + this.mteID + EnumChatFormatting.RESET);
        }
        this.addDebugInfo(aPlayer, aLogLevel, tList);
        return tList;
    }

    protected void addDebugInfo(EntityPlayer aPlayer, int aLogLevel, ArrayList<String> tList) {
    }

    protected IFluidTank getFluidTankFillable(ForgeDirection side, FluidStack aFluidToFill) {
        return null;
    }

    protected IFluidTank getFluidTankDrainable(ForgeDirection side, FluidStack aFluidToDrain) {
        return null;
    }

    protected IFluidTank[] getFluidTanks(ForgeDirection side) {
        return GT_Values.emptyFluidTank;
    }

    public boolean isLiquidInput(ForgeDirection side) {
        return true;
    }

    public boolean isLiquidOutput(ForgeDirection side) {
        return true;
    }

    public int fill(ForgeDirection aDirection, FluidStack aFluid, boolean aDoFill) {
        if (aFluid == null || aFluid.amount <= 0) {
            return 0;
        }
        IFluidTank tTank = this.getFluidTankFillable(aDirection, aFluid);
        return tTank == null ? 0 : tTank.fill(aFluid, aDoFill);
    }

    public FluidStack drain(ForgeDirection aDirection, FluidStack aFluid, boolean aDoDrain) {
        if (aFluid == null || aFluid.amount <= 0) {
            return null;
        }
        IFluidTank tTank = this.getFluidTankDrainable(aDirection, aFluid);
        if (tTank == null || tTank.getFluid() == null || tTank.getFluidAmount() == 0 || !tTank.getFluid().isFluidEqual(aFluid)) {
            return null;
        }
        return tTank.drain(aFluid.amount, aDoDrain);
    }

    public FluidStack drain(ForgeDirection aDirection, int aAmountToDrain, boolean aDoDrain) {
        if (aAmountToDrain <= 0) {
            return null;
        }
        IFluidTank tTank = this.getFluidTankDrainable(aDirection, null);
        if (tTank == null || tTank.getFluid() == null || tTank.getFluidAmount() == 0) {
            return null;
        }
        return tTank.drain(aAmountToDrain, aDoDrain);
    }

    public boolean canFill(ForgeDirection aDirection, Fluid aFluid) {
        if (aFluid == null) {
            return false;
        }
        IFluidTank tTank = this.getFluidTankFillable(aDirection, new FluidStack(aFluid, 0));
        return tTank != null && (tTank.getFluid() == null || tTank.getFluid().getFluid() == aFluid);
    }

    public boolean canDrain(ForgeDirection aDirection, Fluid aFluid) {
        if (aFluid == null) {
            return false;
        }
        IFluidTank tTank = this.getFluidTankDrainable(aDirection, new FluidStack(aFluid, 0));
        return tTank != null && tTank.getFluid() != null && tTank.getFluid().getFluid() == aFluid;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection aDirection) {
        IFluidTank[] tTanks = this.getFluidTanks(aDirection);
        if (tTanks == null || tTanks.length <= 0) {
            return GT_Values.emptyFluidTankInfo;
        }
        FluidTankInfo[] rInfo = new FluidTankInfo[tTanks.length];
        for (int i = 0; i < tTanks.length; ++i) {
            rInfo[i] = new FluidTankInfo(tTanks[i]);
        }
        return rInfo;
    }

    @Override
    public boolean isUniversalEnergyStored(long aEnergyAmount) {
        return false;
    }

    @Override
    public long getUniversalEnergyStored() {
        return 0L;
    }

    @Override
    public long getUniversalEnergyCapacity() {
        return 0L;
    }

    @Override
    public long getOutputAmperage() {
        return 0L;
    }

    @Override
    public long getOutputVoltage() {
        return 0L;
    }

    @Override
    public long getInputAmperage() {
        return 0L;
    }

    @Override
    public long getInputVoltage() {
        return 0L;
    }

    @Override
    public boolean decreaseStoredEnergyUnits(long energy, boolean ignoreTooLittleEnergy) {
        return false;
    }

    @Override
    public boolean increaseStoredEnergyUnits(long energy, boolean ignoreTooMuchEnergy) {
        return false;
    }

    @Override
    public boolean drainEnergyUnits(ForgeDirection side, long aVoltage, long aAmperage) {
        return false;
    }

    @Override
    public long getAverageElectricInput() {
        return 0L;
    }

    @Override
    public long getAverageElectricOutput() {
        return 0L;
    }

    @Override
    public long getStoredEU() {
        return 0L;
    }

    @Override
    public long getEUCapacity() {
        return 0L;
    }

    @Override
    public long injectEnergyUnits(ForgeDirection side, long aVoltage, long aAmperage) {
        return 0L;
    }

    @Override
    public boolean inputEnergyFrom(ForgeDirection side) {
        return false;
    }

    @Override
    public boolean outputsEnergyTo(ForgeDirection side) {
        return false;
    }

    public void func_70295_k_() {
        System.out.println("Open Inventory");
    }

    public void func_70305_f() {
        System.out.println("Close Inventory");
    }

    @Override
    public boolean hasInventoryBeenModified() {
        return false;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return false;
    }

    @Override
    public boolean addStackToSlot(int aIndex, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean addStackToSlot(int aIndex, ItemStack aStack, int aAmount) {
        return false;
    }

    public int[] func_94128_d(int ordinalSide) {
        return GT_Values.emptyIntArray;
    }

    public boolean func_102007_a(int aSlot, ItemStack aStack, int ordinalSide) {
        return false;
    }

    public boolean func_102008_b(int aSlot, ItemStack aStack, int ordinalSide) {
        return false;
    }

    public int func_70302_i_() {
        return 0;
    }

    public ItemStack func_70301_a(int aSlot) {
        return null;
    }

    public ItemStack func_70298_a(int aSlot, int aDecrement) {
        return null;
    }

    public ItemStack func_70304_b(int aSlot) {
        return null;
    }

    public void func_70299_a(int aSlot, ItemStack aStack) {
    }

    public int func_70297_j_() {
        return 0;
    }

    public boolean func_94041_b(int aSlot, ItemStack aStack) {
        return false;
    }

    @Override
    public void markInventoryBeenModified() {
        this.hasInventoryChanged = true;
    }

    public boolean coverLetsFluidIn(ForgeDirection side, Fluid aFluid) {
        return this.getCoverInfoAtSide(side).letsFluidIn(aFluid);
    }

    public boolean coverLetsFluidOut(ForgeDirection side, Fluid aFluid) {
        return this.getCoverInfoAtSide(side).letsFluidOut(aFluid);
    }

    public boolean coverLetsEnergyIn(ForgeDirection side) {
        return this.getCoverInfoAtSide(side).letsEnergyIn();
    }

    public boolean coverLetsEnergyOut(ForgeDirection side) {
        return this.getCoverInfoAtSide(side).letsEnergyOut();
    }

    public boolean coverLetsItemsIn(ForgeDirection side, int aSlot) {
        return this.getCoverInfoAtSide(side).letsItemsIn(aSlot);
    }

    public boolean coverLetsItemsOut(ForgeDirection side, int aSlot) {
        return this.getCoverInfoAtSide(side).letsItemsOut(aSlot);
    }

    @Override
    public ItemStack getStackForm(long aAmount) {
        return new ItemStack(Item.func_150899_d((int)this.getMultiTileEntityRegistryID()), (int)aAmount, (int)this.getMultiTileEntityID());
    }

    protected static enum SidedTextureNames {
        Base("base"),
        Left("left"),
        Right("right"),
        Top("top"),
        Bottom("bottom"),
        Back("back"),
        Front("front");

        private final String name;
        public static final SidedTextureNames[] TEXTURES;

        private SidedTextureNames(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        static {
            TEXTURES = new SidedTextureNames[]{Base, Left, Right, Top, Bottom, Back, Front};
        }
    }

    protected static enum StatusTextures {
        Active("active", false),
        ActiveWithGlow("active_glow", true),
        Inactive("inactive", false),
        InactiveWithGlow("inactive_glow", true);

        private final String name;
        private final boolean hasGlow;
        public static final StatusTextures[] TEXTURES;

        private StatusTextures(String name, boolean hasGlow) {
            this.name = name;
            this.hasGlow = hasGlow;
        }

        public String getName() {
            return this.name;
        }

        public boolean hasGlow() {
            return this.hasGlow;
        }

        static {
            TEXTURES = new StatusTextures[]{Active, ActiveWithGlow, Inactive, InactiveWithGlow};
        }
    }
}

