/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.command;

import com.github.lunatrius.schematica.Schematica;
import com.github.lunatrius.schematica.command.CommandSchematicaBase;
import com.github.lunatrius.schematica.reference.Reference;
import com.github.lunatrius.schematica.util.FileUtils;
import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import java.io.File;
import java.util.Arrays;
import joptsimple.internal.Strings;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.event.ClickEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class CommandSchematicaRemove
extends CommandSchematicaBase {
    public String func_71517_b() {
        return "schematicaRemove";
    }

    public String func_71518_a(ICommandSender sender) {
        return "schematica.command.remove.usage";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_71515_b(ICommandSender sender, String[] arguments) {
        File file;
        String potentialNameHash;
        if (arguments.length < 1) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        if (!(sender instanceof EntityPlayer)) {
            throw new CommandException("schematica.command.save.playersOnly", new Object[0]);
        }
        EntityPlayer player = (EntityPlayer)sender;
        boolean delete = false;
        String name = Strings.join((String[])arguments, (String)" ");
        if (arguments.length > 1 && (potentialNameHash = arguments[arguments.length - 1]).length() == 32) {
            String[] a = Arrays.copyOfRange(arguments, 0, arguments.length - 1);
            name = Strings.join((String[])a, (String)" ");
            String hash = Hashing.md5().hashString((CharSequence)name, Charsets.UTF_8).toString();
            if (potentialNameHash.equals(hash)) {
                delete = true;
            }
        }
        String filename = String.format("%s.schematic", name);
        File schematicDirectory = Schematica.proxy.getPlayerSchematicDirectory(player, true);
        if (!FileUtils.contains(schematicDirectory, file = new File(schematicDirectory, filename))) {
            Reference.logger.error("{} has tried to download the file {}", new Object[]{player.getDisplayName(), filename});
            throw new CommandException("schematica.command.remove.schematicNotFound", new Object[0]);
        }
        if (!file.exists()) throw new CommandException("schematica.command.remove.schematicNotFound", new Object[0]);
        if (delete) {
            if (!file.delete()) throw new CommandException("schematica.command.remove.schematicNotFound", new Object[0]);
            sender.func_145747_a((IChatComponent)new ChatComponentTranslation("schematica.command.remove.schematicRemoved", new Object[]{name}));
            return;
        } else {
            String hash = Hashing.md5().hashString((CharSequence)name, Charsets.UTF_8).toString();
            String confirmCommand = String.format("/%s %s %s", "schematicaRemove", name, hash);
            IChatComponent chatComponent = new ChatComponentTranslation("schematica.command.remove.areYouSure", new Object[]{name}).func_150257_a((IChatComponent)new ChatComponentText(" [")).func_150257_a(new ChatComponentTranslation("gui.yes", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, confirmCommand)))).func_150257_a((IChatComponent)new ChatComponentText("]"));
            sender.func_145747_a(chatComponent);
        }
    }
}

