/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.network.packet;

import appeng.api.AEApi;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerNull;
import appeng.container.ContainerOpenContext;
import appeng.container.implementations.ContainerCraftConfirm;
import appeng.container.implementations.ContainerCraftingTerm;
import appeng.core.AELog;
import appeng.core.sync.GuiBridge;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import com.github.vfyjxf.nee.block.tile.TilePatternInterface;
import com.github.vfyjxf.nee.container.ContainerCraftingAmount;
import com.github.vfyjxf.nee.container.ContainerCraftingConfirm;
import com.github.vfyjxf.nee.container.WCTContainerCraftingConfirm;
import com.github.vfyjxf.nee.network.NEEGuiHandler;
import com.github.vfyjxf.nee.utils.GuiUtils;
import com.google.common.base.Optional;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.concurrent.Future;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.p455w0rd.wirelesscraftingterminal.common.WCTGuiHandler;
import net.p455w0rd.wirelesscraftingterminal.common.container.ContainerWirelessCraftingTerminal;
import net.p455w0rd.wirelesscraftingterminal.helpers.WirelessTerminalGuiObject;
import net.p455w0rd.wirelesscraftingterminal.reference.Reference;
import org.apache.commons.lang3.tuple.Pair;

public class PacketCraftingRequest
implements IMessage {
    private IAEItemStack requireToCraftStack;
    private boolean isAutoStart;
    private int craftAmount;

    public PacketCraftingRequest() {
    }

    public PacketCraftingRequest(IAEItemStack requireToCraftStack, boolean isAutoStart) {
        this.requireToCraftStack = requireToCraftStack;
        this.isAutoStart = isAutoStart;
    }

    public PacketCraftingRequest(int craftAmount, boolean isAutoStart) {
        this.craftAmount = craftAmount;
        this.isAutoStart = isAutoStart;
    }

    public IAEItemStack getRequireToCraftStack() {
        return this.requireToCraftStack;
    }

    public boolean isAutoStart() {
        return this.isAutoStart;
    }

    public int getCraftAmount() {
        return this.craftAmount;
    }

    public void fromBytes(ByteBuf buf) {
        if (buf.readBoolean()) {
            try {
                this.requireToCraftStack = AEItemStack.loadItemStackFromPacket((ByteBuf)buf);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.isAutoStart = buf.readBoolean();
        this.craftAmount = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        if (this.requireToCraftStack != null) {
            try {
                buf.writeBoolean(true);
                this.requireToCraftStack.writeToPacket(buf);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            buf.writeBoolean(false);
        }
        buf.writeBoolean(this.isAutoStart);
        buf.writeInt(this.craftAmount);
    }

    private void handlerCraftingTermRequest(ContainerCraftingTerm container, PacketCraftingRequest message, IGrid grid, EntityPlayerMP player) {
        if (message.getRequireToCraftStack() != null) {
            Future futureJob = null;
            try {
                ICraftingGrid cg = (ICraftingGrid)grid.getCache(ICraftingGrid.class);
                futureJob = cg.beginCraftingJob(player.field_70170_p, grid, container.getActionSource(), message.getRequireToCraftStack(), null);
                ContainerOpenContext context = container.getOpenContext();
                if (context != null) {
                    TileEntity te = context.getTile();
                    Platform.openGUI((EntityPlayer)player, (TileEntity)te, (ForgeDirection)container.getOpenContext().getSide(), (GuiBridge)GuiBridge.GUI_CRAFTING_CONFIRM);
                    if (player.field_71070_bA instanceof ContainerCraftConfirm) {
                        ContainerCraftConfirm ccc = (ContainerCraftConfirm)player.field_71070_bA;
                        ccc.setJob(futureJob);
                        ccc.setAutoStart(message.isAutoStart());
                    }
                }
            }
            catch (Throwable e) {
                if (futureJob != null) {
                    futureJob.cancel(true);
                }
                AELog.debug((Throwable)e);
            }
        }
    }

    private void handlerCraftingAmountRequest(ContainerCraftingAmount container, PacketCraftingRequest message, IGrid grid, EntityPlayerMP player) {
        Pair<TilePatternInterface, Integer> pair;
        if (container.getResultStack() != null && (pair = this.setRecipe(grid, container.getRecipe(), (EntityPlayer)player)) != null) {
            IStorageGrid inv = (IStorageGrid)grid.getCache(IStorageGrid.class);
            IMEMonitor storage = inv.getItemInventory();
            IItemList all = storage.getStorageList();
            ItemStack resultStack = container.getResultStack().func_77946_l();
            IAEItemStack result = null;
            for (IAEItemStack aeStack : all) {
                if (!resultStack.func_77969_a(aeStack.getItemStack()) || !aeStack.isCraftable()) continue;
                result = aeStack.copy();
                break;
            }
            if (result != null) {
                result.setStackSize((long)message.getCraftAmount());
                Future futureJob = null;
                try {
                    ICraftingGrid cg = (ICraftingGrid)grid.getCache(ICraftingGrid.class);
                    futureJob = cg.beginCraftingJob(player.field_70170_p, grid, container.getActionSource(), result, null);
                    ContainerOpenContext context = container.getOpenContext();
                    if (context != null) {
                        TileEntity te = context.getTile();
                        NEEGuiHandler.openGui((EntityPlayer)player, 1, te, context.getSide());
                        if (player.field_71070_bA instanceof ContainerCraftingConfirm) {
                            ContainerCraftingConfirm ccc = (ContainerCraftingConfirm)player.field_71070_bA;
                            ccc.setAutoStart(message.isAutoStart());
                            ccc.setJob(futureJob);
                            ccc.setTile((TilePatternInterface)((Object)pair.getLeft()));
                            ccc.setPatternIndex((Integer)pair.getRight());
                            ccc.func_75142_b();
                        }
                    } else if (Loader.isModLoaded((String)"ae2wct")) {
                        NEEGuiHandler.openGui((EntityPlayer)player, 3, player.field_70170_p);
                        if (player.field_71070_bA instanceof WCTContainerCraftingConfirm) {
                            WCTContainerCraftingConfirm ccc = (WCTContainerCraftingConfirm)player.field_71070_bA;
                            ccc.setJob(futureJob);
                            ccc.setAutoStart(message.isAutoStart());
                            ccc.setTile((TilePatternInterface)((Object)pair.getLeft()));
                            ccc.setPatternIndex((Integer)pair.getRight());
                            ccc.func_75142_b();
                        }
                    }
                }
                catch (Throwable e) {
                    if (futureJob != null) {
                        futureJob.cancel(true);
                    }
                    AELog.debug((Throwable)e);
                }
            }
        }
    }

    private void handlerWirelessCraftingRequest(ContainerWirelessCraftingTerminal container, PacketCraftingRequest message, EntityPlayerMP player) {
        ISecurityGrid security;
        IGrid grid;
        Object target = container.getTarget();
        if (target instanceof WirelessTerminalGuiObject && (grid = ((WirelessTerminalGuiObject)target).getTargetGrid()) != null && (security = (ISecurityGrid)grid.getCache(ISecurityGrid.class)) != null && security.hasPermission((EntityPlayer)player, SecurityPermissions.CRAFT) && message.getRequireToCraftStack() != null) {
            Future futureJob = null;
            try {
                ICraftingGrid cg = (ICraftingGrid)grid.getCache(ICraftingGrid.class);
                futureJob = cg.beginCraftingJob(player.field_70170_p, grid, container.getActionSource(), message.getRequireToCraftStack(), null);
                int x = (int)player.field_70165_t;
                int y = (int)player.field_70163_u;
                int z = (int)player.field_70161_v;
                WCTGuiHandler.launchGui((int)Reference.GUI_CRAFT_CONFIRM, (EntityPlayer)player, (World)player.field_70170_p, (int)x, (int)y, (int)z);
                if (player.field_71070_bA instanceof net.p455w0rd.wirelesscraftingterminal.common.container.ContainerCraftConfirm) {
                    net.p455w0rd.wirelesscraftingterminal.common.container.ContainerCraftConfirm ccc = (net.p455w0rd.wirelesscraftingterminal.common.container.ContainerCraftConfirm)player.field_71070_bA;
                    ccc.setJob(futureJob);
                    ccc.setAutoStart(message.isAutoStart());
                }
            }
            catch (Throwable e) {
                if (futureJob != null) {
                    futureJob.cancel(true);
                }
                AELog.debug((Throwable)e);
            }
        }
    }

    private Pair<TilePatternInterface, Integer> setRecipe(IGrid grid, NBTTagCompound recipe, EntityPlayer player) {
        for (IGridNode gridNode : grid.getMachines(TilePatternInterface.class)) {
            int patternIndex;
            ItemStack patternStack;
            ItemStack result;
            if (!(gridNode.getMachine() instanceof TilePatternInterface)) continue;
            TilePatternInterface tpi = (TilePatternInterface)gridNode.getMachine();
            NBTTagCompound currentTag = recipe.func_74775_l("Outputs");
            ItemStack itemStack = result = currentTag == null ? null : ItemStack.func_77949_a((NBTTagCompound)currentTag);
            if (!tpi.getProxy().isActive() || !tpi.canPutPattern(result) || (patternStack = this.getPatternStack(player, recipe)) == null || (patternIndex = tpi.putPattern(patternStack)) < 0) continue;
            return Pair.of((Object)((Object)tpi), (Object)patternIndex);
        }
        return null;
    }

    private ItemStack getPatternStack(EntityPlayer player, NBTTagCompound recipe) {
        ItemStack[] recipeInputs = new ItemStack[9];
        for (int i = 0; i < recipeInputs.length; ++i) {
            NBTTagCompound currentStack = recipe.func_74775_l("#" + i);
            recipeInputs[i] = currentStack == null ? null : ItemStack.func_77949_a((NBTTagCompound)currentStack);
        }
        InventoryCrafting ic = new InventoryCrafting((Container)new ContainerNull(), 3, 3);
        for (int i = 0; i < 9; ++i) {
            ic.func_70299_a(i, recipeInputs[i]);
        }
        ItemStack result = CraftingManager.func_77594_a().func_82787_a(ic, player.field_70170_p);
        if (result != null) {
            ItemStack patternStack = null;
            Optional maybePattern = AEApi.instance().definitions().items().encodedPattern().maybeStack(1);
            if (maybePattern.isPresent()) {
                patternStack = (ItemStack)maybePattern.get();
            }
            if (patternStack != null) {
                NBTTagCompound patternValue = new NBTTagCompound();
                NBTTagList tagIn = new NBTTagList();
                for (ItemStack stack : recipeInputs) {
                    tagIn.func_74742_a((NBTBase)this.crateItemTag(stack));
                }
                patternValue.func_74782_a("in", (NBTBase)tagIn);
                patternValue.func_74782_a("out", (NBTBase)result.func_77955_b(new NBTTagCompound()));
                patternValue.func_74757_a("crafting", true);
                patternValue.func_74757_a("substitute", false);
                patternStack.func_77982_d(patternValue);
                return patternStack;
            }
        }
        return null;
    }

    private NBTTagCompound crateItemTag(ItemStack itemStack) {
        NBTTagCompound tag = new NBTTagCompound();
        if (itemStack != null) {
            itemStack.func_77955_b(tag);
        }
        return tag;
    }

    public static final class Handler
    implements IMessageHandler<PacketCraftingRequest, IMessage> {
        public IMessage onMessage(PacketCraftingRequest message, MessageContext ctx) {
            ISecurityGrid security;
            IGrid grid;
            IGridHost gh;
            IGridNode gn;
            AEBaseContainer baseContainer;
            Object target;
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            Container container = player.field_71070_bA;
            if (GuiUtils.isWirelessCraftingTermContainer(container)) {
                message.handlerWirelessCraftingRequest((ContainerWirelessCraftingTerminal)container, message, player);
            } else if (container instanceof AEBaseContainer && (target = (baseContainer = (AEBaseContainer)container).getTarget()) instanceof IGridHost && (gn = (gh = (IGridHost)target).getGridNode(ForgeDirection.UNKNOWN)) != null && (grid = gn.getGrid()) != null && (security = (ISecurityGrid)grid.getCache(ISecurityGrid.class)) != null && security.hasPermission((EntityPlayer)player, SecurityPermissions.CRAFT)) {
                if (container instanceof ContainerCraftingTerm) {
                    message.handlerCraftingTermRequest((ContainerCraftingTerm)container, message, grid, player);
                }
                if (container instanceof ContainerCraftingAmount) {
                    message.handlerCraftingAmountRequest((ContainerCraftingAmount)container, message, grid, player);
                }
            }
            return null;
        }
    }
}

