/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import openmods.Log;

public class StateTracker<T extends Enum<T>> {
    private final Map<String, StateUpdater<T>> states = Maps.newHashMap();
    private final T defaultInitialState;

    public StateTracker(T defaultInitialState) {
        this.defaultInitialState = defaultInitialState;
    }

    public StateUpdater<T> register(String name) {
        return this.register(name, this.defaultInitialState);
    }

    public StateUpdater<T> register(String name, T initialState) {
        StateUpdater<T> state = new StateUpdater<T>(name, initialState);
        StateUpdater<T> prev = this.states.put(name, state);
        Preconditions.checkState((prev == null ? 1 : 0) != 0, (String)"Duplicated tracked name: %s", (Object[])new Object[]{name});
        return state;
    }

    public Collection<StateUpdater<T>> states() {
        return Collections.unmodifiableCollection(this.states.values());
    }

    public static <T extends Enum<T>> StateTracker<T> create(T initialState) {
        return new StateTracker<T>(initialState);
    }

    public static class StateUpdater<T extends Enum<T>> {
        private final String name;
        private T state;

        public StateUpdater(String name, T state) {
            this.name = name;
            this.state = state;
        }

        public T state() {
            return this.state;
        }

        public void update(T state) {
            Log.trace("State of %s updated from %s to %s", this.name, this.state, state);
            this.state = state;
        }

        public String name() {
            return this.name;
        }

        public String toString() {
            return "[" + this.name + ":" + this.state + "]";
        }
    }
}

