/*
 * Decompiled with CFR 0.152.
 */
package openmods.shapes;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import openmods.shapes.DefaultShapeGenerator;
import openmods.shapes.IShapeable;
import openmods.utils.CollectionUtils;
import openmods.utils.render.GeometryUtils;

public class ShapeEquilateral2dGenerator
extends DefaultShapeGenerator {
    private final Symmetry symmetry;
    private final Trig[] angles;

    private static Symmetry findSymmetry(int sides) {
        if (sides % 4 == 0) {
            return Symmetry.EightFold;
        }
        if (sides % 2 == 0) {
            return Symmetry.FourFold;
        }
        return Symmetry.TwoFold;
    }

    public ShapeEquilateral2dGenerator(int sides) {
        double d;
        this.symmetry = ShapeEquilateral2dGenerator.findSymmetry(sides);
        ArrayList angles = Lists.newArrayList();
        for (int i = 0; i < sides && !((d = Math.PI * 2 * (double)i / (double)sides) > this.symmetry.angleLimit); ++i) {
            angles.add(new Trig(Math.sin(d), Math.cos(d)));
        }
        this.angles = angles.toArray(new Trig[angles.size()]);
    }

    @Override
    public void generateShape(int minX, final int minY, int minZ, int maxX, final int maxY, int maxZ, final IShapeable shapeable) {
        IShapeable columnShapeable = new IShapeable(){

            @Override
            public void setBlock(int x, int ingored, int z) {
                for (int y = minY; y <= maxY; ++y) {
                    shapeable.setBlock(x, y, z);
                }
            }
        };
        final double middleX = (double)(maxX + minX) / 2.0;
        final double radiusX = (double)(maxX - minX) / 2.0;
        final double middleZ = (double)(maxZ + minZ) / 2.0;
        final double radiusZ = (double)(maxZ - minZ) / 2.0;
        Point[] points = CollectionUtils.transform(this.angles, new Function<Trig, Point>(){

            public Point apply(Trig input) {
                int x = (int)Math.round(middleX + radiusX * input.cos);
                int z = (int)Math.round(middleZ + radiusZ * input.sin);
                return new Point(x, z);
            }
        });
        IShapeable mirroredShapeable = this.symmetry.createMirroredShapeable(columnShapeable);
        Point prevPoint = points[0];
        for (int i = 1; i < points.length; ++i) {
            Point point = points[i];
            GeometryUtils.line2D(0, prevPoint.x, prevPoint.y, point.x, point.y, mirroredShapeable);
            prevPoint = point;
        }
        Point lastPoint = this.symmetry.mirrorLastPoint(prevPoint);
        GeometryUtils.line2D(0, prevPoint.x, prevPoint.y, lastPoint.x, lastPoint.y, mirroredShapeable);
    }

    private static enum Symmetry {
        TwoFold(Math.PI){

            @Override
            public IShapeable createMirroredShapeable(final IShapeable shapeable) {
                return new IShapeable(){

                    @Override
                    public void setBlock(int x, int y, int z) {
                        if (z >= 0) {
                            shapeable.setBlock(x, y, z);
                            shapeable.setBlock(x, y, -z);
                        }
                    }
                };
            }

            @Override
            public Point mirrorLastPoint(Point point) {
                return new Point(point.x, -point.y);
            }
        }
        ,
        FourFold(1.5707963267948966){

            @Override
            public IShapeable createMirroredShapeable(final IShapeable shapeable) {
                return new IShapeable(){

                    @Override
                    public void setBlock(int x, int y, int z) {
                        if (x >= 0 && z >= 0) {
                            shapeable.setBlock(x, y, -z);
                            shapeable.setBlock(-x, y, -z);
                            shapeable.setBlock(-x, y, z);
                            shapeable.setBlock(x, y, z);
                        }
                    }
                };
            }

            @Override
            public Point mirrorLastPoint(Point point) {
                return new Point(-point.x, point.y);
            }
        }
        ,
        EightFold(0.7853981633974483){

            @Override
            public IShapeable createMirroredShapeable(final IShapeable shapeable) {
                return new IShapeable(){

                    @Override
                    public void setBlock(int x, int y, int z) {
                        if (x >= z) {
                            shapeable.setBlock(x, y, -z);
                            shapeable.setBlock(-x, y, -z);
                            shapeable.setBlock(-x, y, z);
                            shapeable.setBlock(x, y, z);
                            shapeable.setBlock(z, y, -x);
                            shapeable.setBlock(-z, y, -x);
                            shapeable.setBlock(-z, y, x);
                            shapeable.setBlock(z, y, x);
                        }
                    }
                };
            }

            @Override
            public Point mirrorLastPoint(Point point) {
                return new Point(point.y, point.x);
            }
        };

        public final double angleLimit;

        public abstract IShapeable createMirroredShapeable(IShapeable var1);

        public abstract Point mirrorLastPoint(Point var1);

        private Symmetry(double angleLimit) {
            this.angleLimit = angleLimit;
        }
    }

    private static class Point {
        final int x;
        final int y;

        public Point(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public String toString() {
            return "[" + this.x + "," + this.y + "]";
        }
    }

    private static class Trig {
        final double sin;
        final double cos;

        public Trig(double sin, double cos) {
            this.sin = sin;
            this.cos = cos;
        }
    }
}

