/*
 * Decompiled with CFR 0.152.
 */
package glowredman.txloader;

import glowredman.txloader.TXLoaderCore;
import glowredman.txloader.TXResourcePack;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class MinecraftClassTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (!"net.minecraft.client.Minecraft".equals(transformedName)) {
            return basicClass;
        }
        return MinecraftClassTransformer.transformMinecraft(basicClass);
    }

    private static byte[] transformMinecraft(byte[] basicClass) {
        TXLoaderCore.LOGGER.info("Transforming net.minecraft.client.Minecraft");
        boolean devEnv = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        MethodNode targetMethod = null;
        String refreshResourcesName = devEnv ? "refreshResources" : "func_110436_a";
        String refreshResourcesDesc = "()V";
        for (MethodNode method : classNode.methods) {
            if (!method.name.equals(refreshResourcesName) || !method.desc.equals("()V")) continue;
            targetMethod = method;
            break;
        }
        if (targetMethod == null) {
            throw new RuntimeException("Could not find method refreshResources()!");
        }
        AbstractInsnNode targetInsn = null;
        String reloadResourcesName = devEnv ? "reloadResources" : "func_110541_a";
        String reloadResourcesDesc = "(Ljava/util/List;)V";
        for (AbstractInsnNode ain : targetMethod.instructions.toArray()) {
            if (!(ain instanceof MethodInsnNode)) continue;
            MethodInsnNode min = (MethodInsnNode)ain;
            if (!min.name.equals(reloadResourcesName) || !min.desc.equals("(Ljava/util/List;)V")) continue;
            targetInsn = ain;
            break;
        }
        if (targetInsn == null) {
            throw new RuntimeException("Could not find invocation of reloadResources() in method refreshResources()!");
        }
        InsnList insertForcePackInsnList = new InsnList();
        insertForcePackInsnList.add((AbstractInsnNode)new MethodInsnNode(184, "glowredman/txloader/MinecraftClassTransformer", "insertForcePack", "(Ljava/util/List;)V", false));
        insertForcePackInsnList.add((AbstractInsnNode)new VarInsnNode(25, 1));
        targetMethod.instructions.insertBefore(targetInsn, insertForcePackInsnList);
        ClassWriter classWriter = new ClassWriter(3);
        classNode.accept((ClassVisitor)classWriter);
        return classWriter.toByteArray();
    }

    public static void insertForcePack(List resourcePackList) {
        resourcePackList.add(new TXResourcePack.Force());
    }
}

