/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.opis.network.rcon.server;

import io.nettyopis.buffer.ByteBuf;
import io.nettyopis.channel.ChannelHandlerContext;
import io.nettyopis.channel.ChannelInboundHandlerAdapter;
import io.nettyopis.handler.codec.compression.JdkZlibDecoder;
import io.nettyopis.handler.codec.compression.JdkZlibEncoder;
import io.nettyopis.util.ReferenceCountUtil;
import mcp.mobius.opis.modOpis;
import mcp.mobius.opis.network.rcon.server.RConHandshakeDecoder;
import mcp.mobius.opis.network.rcon.server.RConInboundHandler;
import mcp.mobius.opis.network.rcon.server.RConMsgDecoder;

public class RConHandshakeHandler
extends ChannelInboundHandlerAdapter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        try {
            modOpis.log.info(String.format("Connection to rcon from %s detected", ctx.channel().remoteAddress().toString()));
            if (((String)msg).equals(modOpis.rconpass)) {
                ByteBuf buf = ctx.alloc().buffer();
                buf.writeBoolean(true);
                ctx.writeAndFlush(buf);
                ctx.pipeline().remove(RConHandshakeDecoder.class);
                ctx.pipeline().remove(RConHandshakeHandler.class);
                ctx.pipeline().addLast(new JdkZlibDecoder());
                ctx.pipeline().addLast(new JdkZlibEncoder());
                ctx.pipeline().addLast(new RConMsgDecoder());
                ctx.pipeline().addLast(new RConInboundHandler());
            } else {
                modOpis.log.info(String.format("Password error. Closing socket", new Object[0]));
                ByteBuf buf = ctx.alloc().buffer();
                buf.writeBoolean(false);
                ctx.writeAndFlush(buf);
                ctx.close();
            }
        }
        finally {
            ReferenceCountUtil.release(msg);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        ctx.close();
    }
}

