/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.SolarSystem.moons.enceladus.world.dungeon;

import galaxyspace.SolarSystem.moons.enceladus.tile.TileEntityDungeonSpawnerEnceladus;
import galaxyspace.core.register.GSBlocks;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.tile.TileEntityDungeonSpawner;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.DungeonBoundingBox;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.DungeonRoom;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.MapGenDungeon;
import micdoodle8.mods.galacticraft.planets.mars.blocks.MarsBlocks;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.common.util.ForgeDirection;

public class RoomBossEnceladus
extends DungeonRoom {
    public int sizeX;
    public int sizeY;
    public int sizeZ;
    Random rand;
    ChunkCoordinates spawnerCoords;

    public RoomBossEnceladus(MapGenDungeon dungeon, int posX, int posY, int posZ, ForgeDirection entranceDir) {
        super(dungeon, posX, posY, posZ, entranceDir);
        if (this.worldObj != null) {
            this.rand = new Random(this.worldObj.func_72905_C() * (long)posX * (long)posY * 57L * (long)posZ);
            this.sizeX = 24;
            this.sizeY = 11;
            this.sizeZ = 24;
        }
    }

    public void generate(Block[] chunk, byte[] meta, int cx, int cz) {
        for (int i = this.posX - 1; i <= this.posX + this.sizeX; ++i) {
            for (int k = this.posZ - 1; k <= this.posZ + this.sizeZ; ++k) {
                for (int j = this.posY - 1; j <= this.posY + this.sizeY; ++j) {
                    if (i == this.posX - 1 || i == this.posX + this.sizeX || j == this.posY - 1 || j == this.posY + this.sizeY || k == this.posZ - 1 || k == this.posZ + this.sizeZ) {
                        if (j == this.posY - 1 && (i <= this.posX + 1 || i >= this.posX + this.sizeX - 2 || k == this.posZ + 1 || k == this.posZ + this.sizeZ - 2) && this.rand.nextInt(4) == 0) {
                            this.placeBlock(chunk, meta, i, j, k, cx, cz, GSBlocks.EnceladusGlowStone, 0);
                            continue;
                        }
                        this.placeBlock(chunk, meta, i, j, k, cx, cz, this.dungeonInstance.DUNGEON_WALL_ID, this.dungeonInstance.DUNGEON_WALL_META);
                        continue;
                    }
                    if (j == this.posY && (i <= this.posX + 1 || i >= this.posX + this.sizeX - 2 || k == this.posZ + 1 || k == this.posZ + this.sizeZ - 2) && this.rand.nextInt(6) == 0) {
                        this.placeBlock(chunk, meta, i, j, k, cx, cz, Blocks.field_150350_a, 0);
                        continue;
                    }
                    this.placeBlock(chunk, meta, i, j, k, cx, cz, Blocks.field_150350_a, 0);
                }
            }
        }
        int hx = (this.posX + this.posX + this.sizeX) / 2;
        int hz = (this.posZ + this.posZ + this.sizeZ) / 2;
        this.spawnerCoords = new ChunkCoordinates(hx, this.posY + 2, hz);
    }

    public DungeonBoundingBox getBoundingBox() {
        return new DungeonBoundingBox(this.posX, this.posZ, this.posX + this.sizeX, this.posZ + this.sizeZ);
    }

    protected DungeonRoom makeRoom(MapGenDungeon dungeon, int x, int y, int z, ForgeDirection dir) {
        return new RoomBossEnceladus(dungeon, x, y, z, dir);
    }

    protected void handleTileEntities(Random rand) {
        if (this.spawnerCoords == null) {
            return;
        }
        this.worldObj.func_147465_d(this.spawnerCoords.field_71574_a, this.spawnerCoords.field_71572_b, this.spawnerCoords.field_71573_c, MarsBlocks.marsBlock, 10, 3);
        TileEntity tile = this.worldObj.func_147438_o(this.spawnerCoords.field_71574_a, this.spawnerCoords.field_71572_b, this.spawnerCoords.field_71573_c);
        if (tile == null || !(tile instanceof TileEntityDungeonSpawnerEnceladus)) {
            TileEntityDungeonSpawnerEnceladus spawner = new TileEntityDungeonSpawnerEnceladus();
            spawner.setRoom(new Vector3((double)this.posX, (double)this.posY, (double)this.posZ), new Vector3((double)this.sizeX, (double)this.sizeY, (double)this.sizeZ));
            this.worldObj.func_147455_a(this.spawnerCoords.field_71574_a, this.spawnerCoords.field_71572_b, this.spawnerCoords.field_71573_c, (TileEntity)spawner);
        } else if (tile instanceof TileEntityDungeonSpawner) {
            ((TileEntityDungeonSpawner)tile).setRoom(new Vector3((double)this.posX, (double)this.posY, (double)this.posZ), new Vector3((double)this.sizeX, (double)this.sizeY, (double)this.sizeZ));
        }
    }
}

