/*
 * Decompiled with CFR 0.152.
 */
package pers.gwyog.gtneioreplugin.util;

import cpw.mods.fml.common.FMLLog;
import gregtech.api.GregTech_API;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import pers.gwyog.gtneioreplugin.GTNEIOrePlugin;
import pers.gwyog.gtneioreplugin.util.DimensionHelper;

public class GT5CFGHelper {
    public static final String oreVeinNotInAnyDim = "Not available in any Galactic Dim!";
    private static final File F = GregTech_API.sWorldgenFile.mConfig.getConfigFile();

    public static String GT5CFGSmallOres(String Veinname) {
        ArrayList<String> raw = new ArrayList<String>();
        ArrayList<String> rawbools = new ArrayList<String>();
        Configuration c = new Configuration(F);
        ConfigCategory configCategory = c.getCategory("worldgen." + Veinname);
        for (Property p : configCategory.getOrderedValues()) {
            if (!p.isBooleanValue() || !p.getBoolean()) continue;
            raw.add(p.getName() + "=" + p.getBoolean());
        }
        if (!raw.isEmpty()) {
            for (String s : raw) {
                for (int j = 0; j < DimensionHelper.DimName.length; ++j) {
                    if (!s.contains(DimensionHelper.DimName[j])) continue;
                    rawbools.add(s);
                }
            }
        } else {
            GTNEIOrePlugin.LOG.info("Config entry not found for Vein: " + Veinname);
        }
        StringBuilder ret = new StringBuilder(" ");
        HashSet<String> rawboolsset = new HashSet<String>();
        if (!rawbools.isEmpty()) {
            String st;
            for (String rawbool : rawbools) {
                st = rawbool.replace("B:", "").replace("_true", "").replace("_false", "").replaceAll(" ", "").replaceAll("\"", "");
                rawboolsset.add(st);
            }
            rawbools = new ArrayList(rawboolsset);
            for (int j = 0; j < DimensionHelper.DimName.length; ++j) {
                for (String rawbool : rawbools) {
                    st = rawbool;
                    if (!st.contains(DimensionHelper.DimName[j]) || !st.contains("=true")) continue;
                    ret.append(DimensionHelper.DimNameDisplayed[j]).append(",");
                }
            }
        }
        if ((ret = new StringBuilder(ret.toString().trim())).toString().equals("") || ret.toString().equals(" ")) {
            ret = new StringBuilder(oreVeinNotInAnyDim);
        }
        return ret.toString();
    }

    public static String GT5CFG(String Veinname) {
        if (F == null) {
            FMLLog.bigWarning((String)"GT_CFG_NOT_found[0]", (Object[])new Object[0]);
            return "Error while Loading CFG";
        }
        try {
            String st;
            int buffer = (int)(0.1 * (double)Runtime.getRuntime().freeMemory());
            if ((long)buffer > F.length()) {
                buffer = (int)F.length();
            }
            FileReader in = new FileReader(F);
            BufferedReader reader = new BufferedReader(in, buffer);
            ArrayList<String> raw = new ArrayList<String>();
            ArrayList<String> rawbools = new ArrayList<String>();
            Boolean[] found = new Boolean[]{false, false};
            do {
                if ((st = reader.readLine()) != null && st.trim().equals("mix {")) {
                    while (st != null && !found[0].booleanValue()) {
                        st = reader.readLine();
                        if (st == null || !st.trim().equals(Veinname + " {")) continue;
                        while (st != null && !found[0].booleanValue()) {
                            st = reader.readLine();
                            if (st != null && st.trim().equals("}")) {
                                found[0] = true;
                            }
                            raw.add(st);
                        }
                    }
                }
                if (st == null || !st.trim().equals("dimensions {")) continue;
                while (st != null && !found[1].booleanValue()) {
                    st = reader.readLine();
                    if (st == null || !st.trim().equals("mix {")) continue;
                    while (st != null && !found[1].booleanValue()) {
                        st = reader.readLine();
                        if (st == null || !st.trim().equals(Veinname + " {")) continue;
                        while (st != null && !found[1].booleanValue()) {
                            st = reader.readLine();
                            if (st != null && st.trim().equals("}")) {
                                found[1] = true;
                            }
                            raw.add(st);
                        }
                    }
                }
            } while (st != null);
            reader.close();
            if (!raw.isEmpty()) {
                for (String s : raw) {
                    for (int j = 0; j < DimensionHelper.DimName.length; ++j) {
                        if (!s.contains(DimensionHelper.DimName[j])) continue;
                        rawbools.add(s);
                    }
                }
            } else {
                GTNEIOrePlugin.LOG.info("Config entry not found for Vein: " + Veinname);
            }
            StringBuilder ret = new StringBuilder(" ");
            HashSet<String> rawboolsset = new HashSet<String>();
            if (!rawbools.isEmpty()) {
                for (String rawbool : rawbools) {
                    st = rawbool.replace("B:", "").replace("_true", "").replace("_false", "").replaceAll(" ", "").replaceAll("\"", "");
                    rawboolsset.add(st);
                }
                rawbools = new ArrayList(rawboolsset);
                for (int j = 0; j < DimensionHelper.DimName.length; ++j) {
                    for (String rawbool : rawbools) {
                        st = rawbool;
                        if (!st.contains(DimensionHelper.DimName[j]) || !st.contains("=true")) continue;
                        ret.append(DimensionHelper.DimNameDisplayed[j]).append(",");
                    }
                }
            }
            if ((ret = new StringBuilder(ret.toString().trim())).toString().equals("") || ret.toString().equals(" ")) {
                ret = new StringBuilder(oreVeinNotInAnyDim);
            }
            return ret.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "Error while Loading CFG";
        }
    }
}

