/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.item;

import com.google.common.base.Strings;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidContainerItem;
import openblocks.OpenBlocks;
import openblocks.common.tileentity.TileEntityTank;
import openmods.item.ItemOpenBlock;
import openmods.utils.ItemUtils;

public class ItemTankBlock
extends ItemOpenBlock
implements IFluidContainerItem {
    public static final String TANK_TAG = "tank";

    public ItemTankBlock(Block block) {
        super(block);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        FluidTank fakeTank = ItemTankBlock.readTank(stack);
        FluidStack fluidStack = fakeTank.getFluid();
        if (fluidStack != null && fluidStack.amount > 0) {
            float percent = Math.max(100.0f / (float)fakeTank.getCapacity() * (float)fluidStack.amount, 1.0f);
            list.add(String.format("%d mB (%.0f%%)", fluidStack.amount, Float.valueOf(percent)));
        }
    }

    public String func_77653_i(ItemStack stack) {
        FluidTank fakeTank = ItemTankBlock.readTank(stack);
        FluidStack fluidStack = fakeTank.getFluid();
        String unlocalizedName = this.func_77658_a();
        if (fluidStack != null && fluidStack.amount > 0) {
            String fluidName = ItemTankBlock.getFluidName(fluidStack);
            return StatCollector.func_74837_a((String)(unlocalizedName + ".filled.name"), (Object[])new Object[]{fluidName});
        }
        return super.func_77653_i(stack);
    }

    private static String getFluidName(FluidStack fluidStack) {
        Fluid fluid = fluidStack.getFluid();
        String localizedName = fluid.getLocalizedName(fluidStack);
        if (!Strings.isNullOrEmpty((String)localizedName) && !localizedName.equals(fluid.getUnlocalizedName())) {
            return fluid.getRarity((FluidStack)fluidStack).field_77937_e.toString() + localizedName;
        }
        return EnumChatFormatting.OBFUSCATED + "LOLNOPE" + EnumChatFormatting.RESET;
    }

    public static ItemStack createFilledTank(Fluid fluid) {
        int tankCapacity = TileEntityTank.getTankCapacity();
        FluidStack stack = FluidRegistry.getFluidStack((String)fluid.getName(), (int)tankCapacity);
        if (stack == null) {
            return null;
        }
        FluidTank tank = new FluidTank(tankCapacity);
        tank.setFluid(stack);
        ItemStack item = new ItemStack((Block)OpenBlocks.Blocks.tank);
        ItemTankBlock.saveTank(item, tank);
        return item;
    }

    private static FluidTank readTank(ItemStack stack) {
        FluidTank tank = new FluidTank(TileEntityTank.getTankCapacity());
        NBTTagCompound itemTag = stack.func_77978_p();
        if (itemTag != null && itemTag.func_74764_b(TANK_TAG)) {
            tank.readFromNBT(itemTag.func_74775_l(TANK_TAG));
            return tank;
        }
        return tank;
    }

    private static void saveTank(ItemStack container, FluidTank tank) {
        if (tank.getFluidAmount() > 0) {
            NBTTagCompound itemTag = ItemUtils.getItemTag((ItemStack)container);
            NBTTagCompound tankTag = new NBTTagCompound();
            tank.writeToNBT(tankTag);
            itemTag.func_74782_a(TANK_TAG, (NBTBase)tankTag);
        } else {
            container.field_77990_d = null;
        }
    }

    public FluidStack getFluid(ItemStack container) {
        FluidTank tank = ItemTankBlock.readTank(container);
        if (tank == null) {
            return null;
        }
        FluidStack result = tank.getFluid();
        if (result != null) {
            result.amount *= container.field_77994_a;
        }
        return result;
    }

    public int getCapacity(ItemStack container) {
        FluidTank tank = ItemTankBlock.readTank(container);
        return tank != null ? tank.getCapacity() * container.field_77994_a : 0;
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        FluidTank tank = ItemTankBlock.readTank(container);
        if (tank == null) {
            return 0;
        }
        int count = container.field_77994_a;
        if (count == 0) {
            return 0;
        }
        int amountPerTank = resource.amount / count;
        if (amountPerTank == 0) {
            return 0;
        }
        FluidStack resourcePerTank = resource.copy();
        resourcePerTank.amount = amountPerTank;
        int filledPerTank = tank.fill(resourcePerTank, doFill);
        if (doFill) {
            ItemTankBlock.saveTank(container, tank);
        }
        return filledPerTank * count;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        if (maxDrain <= 0) {
            return null;
        }
        FluidTank tank = ItemTankBlock.readTank(container);
        if (tank == null) {
            return null;
        }
        int count = container.field_77994_a;
        if (count == 0) {
            return null;
        }
        int amountPerTank = maxDrain / count;
        if (amountPerTank == 0) {
            return null;
        }
        FluidStack drained = tank.drain(amountPerTank, doDrain);
        if (doDrain) {
            ItemTankBlock.saveTank(container, tank);
        }
        if (drained != null) {
            drained.amount *= count;
        }
        return drained;
    }
}

