/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.client;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.potion.Potion;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.GL11;

public class HealthBarRenderer
extends Gui {
    private static final boolean isRpghudLoaded = Loader.isModLoaded((String)"rpghud");
    private static final boolean isTukmc_vzLoaded = Loader.isModLoaded((String)"tukmc_Vz");
    private static final boolean isBorderlandsModLoaded = Loader.isModLoaded((String)"borderlands");
    private static final ResourceLocation TINKER_HEARTS = new ResourceLocation("tinker", "textures/gui/newhearts.png");
    private static final Minecraft mc = Minecraft.func_71410_x();
    private final Random rand = new Random();
    private int updateCounter = 0;

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START && !mc.func_147113_T()) {
            ++this.updateCounter;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void renderHealthbar(RenderGameOverlayEvent.Pre event) {
        int y;
        int i;
        int TOP;
        boolean highlight;
        if (event.type != RenderGameOverlayEvent.ElementType.HEALTH) {
            return;
        }
        if (isRpghudLoaded) {
            return;
        }
        if (isTukmc_vzLoaded && !isBorderlandsModLoaded) {
            return;
        }
        HealthBarRenderer.mc.field_71424_I.func_76320_a("health");
        GL11.glEnable((int)3042);
        int width = event.resolution.func_78326_a();
        int height = event.resolution.func_78328_b();
        int xBasePos = width / 2 - 91;
        int yBasePos = height - 39;
        boolean bl = highlight = HealthBarRenderer.mc.field_71439_g.field_70172_ad / 3 % 2 == 1;
        if (HealthBarRenderer.mc.field_71439_g.field_70172_ad < 10) {
            highlight = false;
        }
        IAttributeInstance attrMaxHealth = HealthBarRenderer.mc.field_71439_g.func_110148_a(SharedMonsterAttributes.field_111267_a);
        int health = MathHelper.func_76123_f((float)HealthBarRenderer.mc.field_71439_g.func_110143_aJ());
        int healthLast = MathHelper.func_76123_f((float)HealthBarRenderer.mc.field_71439_g.field_70735_aL);
        float healthMax = Math.min(20.0f, (float)attrMaxHealth.func_111126_e());
        float absorb = HealthBarRenderer.mc.field_71439_g.func_110139_bj();
        int healthRows = MathHelper.func_76123_f((float)((healthMax + absorb) / 2.0f / 10.0f));
        int rowHeight = Math.max(10 - (healthRows - 2), 3);
        this.rand.setSeed((long)this.updateCounter * 312871L);
        int left = width / 2 - 91;
        int top = height - GuiIngameForge.left_height;
        if (!GuiIngameForge.renderExperiance) {
            top += 7;
            yBasePos += 7;
        }
        int regen = -1;
        if (HealthBarRenderer.mc.field_71439_g.func_70644_a(Potion.field_76428_l)) {
            regen = this.updateCounter % 25;
        }
        int tinkerTextureY = 0;
        if (HealthBarRenderer.mc.field_71441_e.func_72912_H().func_76093_s()) {
            TOP = 45;
            tinkerTextureY += 27;
        } else {
            TOP = 0;
        }
        int BACKGROUND = highlight ? 25 : 16;
        int MARGIN = 16;
        if (HealthBarRenderer.mc.field_71439_g.func_70644_a(Potion.field_76436_u)) {
            MARGIN += 36;
            tinkerTextureY = 9;
        } else if (HealthBarRenderer.mc.field_71439_g.func_70644_a(Potion.field_82731_v)) {
            MARGIN += 72;
            tinkerTextureY = 18;
        }
        float absorbRemaining = absorb;
        for (i = MathHelper.func_76123_f((float)((healthMax + absorb) / 2.0f)) - 1; i >= 0; --i) {
            int row = MathHelper.func_76123_f((float)((float)(i + 1) / 10.0f)) - 1;
            int x = left + i % 10 * 8;
            y = top - row * rowHeight;
            if (health <= 4) {
                y += this.rand.nextInt(2);
            }
            if (i == regen) {
                y -= 2;
            }
            this.func_73729_b(x, y, BACKGROUND, TOP, 9, 9);
            if (highlight) {
                if (i * 2 + 1 < healthLast) {
                    this.func_73729_b(x, y, MARGIN + 54, TOP, 9, 9);
                } else if (i * 2 + 1 == healthLast) {
                    this.func_73729_b(x, y, MARGIN + 63, TOP, 9, 9);
                }
            }
            if (absorbRemaining > 0.0f) {
                if (absorbRemaining == absorb && absorb % 2.0f == 1.0f) {
                    this.func_73729_b(x, y, MARGIN + 153, TOP, 9, 9);
                } else {
                    this.func_73729_b(x, y, MARGIN + 144, TOP, 9, 9);
                }
                absorbRemaining -= 2.0f;
                continue;
            }
            if (i * 2 + 1 + 20 < health) continue;
            if (i * 2 + 1 < health) {
                this.func_73729_b(x, y, MARGIN + 36, TOP, 9, 9);
                continue;
            }
            if (i * 2 + 1 != health) continue;
            this.func_73729_b(x, y, MARGIN + 45, TOP, 9, 9);
        }
        if (health > 20) {
            mc.func_110434_K().func_110577_a(TINKER_HEARTS);
            for (i = Math.max(0, health / 20 - 2); i < health / 20; ++i) {
                int heartIndexMax = Math.min(10, (health - 20 * (i + 1)) / 2);
                for (int j = 0; j < heartIndexMax; ++j) {
                    y = 0;
                    if (j == regen) {
                        y -= 2;
                    }
                    if ((i + 1) * 20 + j * 2 + 21 < health) continue;
                    this.func_73729_b(xBasePos + 8 * j, yBasePos + y, 18 * i, tinkerTextureY, 9, 9);
                }
                if (health % 2 != 1 || heartIndexMax >= 10) continue;
                int y2 = 0;
                if (heartIndexMax == regen) {
                    y2 -= 2;
                }
                this.func_73729_b(xBasePos + 8 * heartIndexMax, yBasePos + y2, 9 + 18 * i, tinkerTextureY, 9, 9);
            }
            mc.func_110434_K().func_110577_a(field_110324_m);
        }
        GuiIngameForge.left_height += 10;
        if (absorb > 0.0f) {
            GuiIngameForge.left_height += 10;
        }
        GL11.glDisable((int)3042);
        HealthBarRenderer.mc.field_71424_I.func_76319_b();
        event.setCanceled(true);
        MinecraftForge.EVENT_BUS.post((Event)new RenderGameOverlayEvent.Post((RenderGameOverlayEvent)event, RenderGameOverlayEvent.ElementType.HEALTH));
    }
}

