/*
 * Decompiled with CFR 0.152.
 */
package portablejim.bbw.core.conversion;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import portablejim.bbw.BetterBuildersWandsMod;
import portablejim.bbw.basics.Point3d;
import portablejim.bbw.shims.IWorldShim;

public class StackedBlockManager {
    private HashMap<String, ItemStack> cache = new HashMap();
    Method getStackedBlockMethod;
    String getStackedBlockMethodName;

    public StackedBlockManager() {
        try {
            this.getStackedBlockMethodName = "func_149644_j";
            this.getStackedBlockMethod = Block.class.getDeclaredMethod(this.getStackedBlockMethodName, Integer.TYPE);
            if (this.getStackedBlockMethod == null) {
                this.getStackedBlockMethodName = "createStackedBlock";
                this.getStackedBlockMethod = Block.class.getDeclaredMethod(this.getStackedBlockMethodName, Integer.TYPE);
            }
            this.getStackedBlockMethod.setAccessible(true);
            BetterBuildersWandsMod.logger.info("Access transform success createStackedBlock (" + this.getStackedBlockMethodName + ").");
        }
        catch (NoSuchMethodException e) {
            BetterBuildersWandsMod.logger.error("No Method Block.getStackedBlock(int)!");
        }
    }

    public ItemStack getStackedBlock(IWorldShim world, Point3d blockPos) {
        Block block = world.getBlock(blockPos);
        int meta = world.getMetadata(blockPos);
        String blockName = Block.field_149771_c.func_148750_c((Object)block);
        String blockIdentifier = String.format("%s|%d", blockName, meta);
        if (!this.cache.containsKey(blockIdentifier)) {
            this.cache.put(blockIdentifier, this.callGetStackedBlock(block, meta));
        }
        return this.cache.get(blockIdentifier);
    }

    private ItemStack callGetStackedBlock(Block block, int meta) {
        try {
            block4: for (Class<?> clazz = block.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                Method[] methods;
                for (Method method : methods = clazz.getDeclaredMethods()) {
                    if (!method.getName().equals(this.getStackedBlockMethodName) && !method.getName().equals("createStackedBlock")) continue;
                    this.getStackedBlockMethod = method;
                    continue block4;
                }
            }
            if (this.getStackedBlockMethod != null) {
                this.getStackedBlockMethod.setAccessible(true);
                return (ItemStack)this.getStackedBlockMethod.invoke((Object)block, meta);
            }
        }
        catch (IllegalAccessException e) {
            BetterBuildersWandsMod.logger.error("getStackedBlockMethod Illegal to call");
        }
        catch (InvocationTargetException e) {
            BetterBuildersWandsMod.logger.error("getStackedBlockMethod Invoker error");
        }
        catch (NoClassDefFoundError e) {
            BetterBuildersWandsMod.logger.error("No such method: " + e.getLocalizedMessage());
        }
        return null;
    }
}

