/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.block;

import com.carpentersblocks.block.BlockCoverable;
import com.carpentersblocks.data.GarageDoor;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.tileentity.TECarpentersGarageDoor;
import com.carpentersblocks.util.EntityLivingUtil;
import com.carpentersblocks.util.handler.ChatHandler;
import com.carpentersblocks.util.registry.BlockRegistry;
import com.carpentersblocks.util.registry.FeatureRegistry;
import com.carpentersblocks.util.registry.IconRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCarpentersGarageDoor
extends BlockCoverable {
    public static final String[] type = new String[]{"default", "glassTop", "glass", "siding", "hidden"};
    private static GarageDoor data = new GarageDoor();

    public BlockCarpentersGarageDoor(Material material) {
        super(material);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        IconRegistry.icon_garage_glass_top = iconRegister.func_94245_a("CarpentersBlocks:garagedoor/glass_top");
        IconRegistry.icon_garage_glass = iconRegister.func_94245_a("CarpentersBlocks:garagedoor/glass");
    }

    @Override
    protected boolean onHammerLeftClick(TEBase TE, EntityPlayer entityPlayer) {
        int temp = data.getType(TE);
        if (++temp > type.length - 1) {
            temp = 0;
        }
        Set<TEBase> pieces = data.getBlocks(TE, (Block)this);
        for (TEBase TE_block : pieces) {
            data.setType(TE_block, temp);
        }
        return true;
    }

    @Override
    protected boolean onHammerRightClick(TEBase TE, EntityPlayer entityPlayer) {
        int temp = data.getType(TE);
        if (--temp < 0) {
            temp = type.length - 1;
        }
        if (entityPlayer.func_70093_af()) {
            int rigidity = data.isRigid(TE) ? 0 : 1;
            switch (rigidity) {
                case 0: {
                    ChatHandler.sendMessageToPlayer("message.activation_wood.name", entityPlayer);
                    break;
                }
                case 1: {
                    ChatHandler.sendMessageToPlayer("message.activation_iron.name", entityPlayer);
                }
            }
            Set<TEBase> pieces = data.getBlocks(TE, (Block)this);
            for (TEBase piece : pieces) {
                data.setRigidity(piece, rigidity);
            }
        } else {
            Set<TEBase> pieces = data.getBlocks(TE, (Block)this);
            for (TEBase piece : pieces) {
                data.setType(piece, temp);
            }
        }
        return true;
    }

    public void func_149719_a(IBlockAccess blockAccess, int x, int y, int z) {
        TEBase TE = this.getTileEntity(blockAccess, x, y, z);
        if (TE != null) {
            float yMin = data.isHost(TE) && data.isOpen(TE) ? 0.5f : 0.0f;
            ForgeDirection dir = data.getDirection(TE);
            if (data.isVisible(TE)) {
                if (data.getType(TE) == 4) {
                    this.setBlockBounds(0.0f, yMin, 0.0f, 1.0f, 1.0f, 0.125f, dir);
                } else {
                    this.setBlockBounds(0.0f, yMin, 0.125f, 1.0f, 1.0f, 0.25f, dir);
                }
            }
        }
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null && !data.isVisible(TE)) {
            return null;
        }
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149668_a(world, x, y, z);
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 startVec, Vec3 endVec) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null && !data.isVisible(TE)) {
            return null;
        }
        return super.func_149731_a(world, x, y, z, startVec, endVec);
    }

    @Override
    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null && data.isOpen(TE) && !data.isHost(TE)) {
            return Blocks.field_150357_h.func_149638_a(entity);
        }
        return this.func_149638_a(entity);
    }

    public void func_149723_a(World world, int x, int y, int z, Explosion explosion) {
        this.destroy(world, x, y, z, true);
    }

    private void destroyInDirection(World world, int x, int y, int z, boolean doDrop, ForgeDirection dir) {
        if (y < 0 || y > world.func_72800_K()) {
            return;
        }
        Block block = world.func_147439_a(x, y, z);
        if (block.equals((Object)this)) {
            TEBase temp;
            boolean dropBlock = false;
            if (doDrop && (temp = this.getTileEntity((IBlockAccess)world, x, y, z)) != null && data.isHost(temp)) {
                dropBlock = true;
            }
            this.destroyBlock(world, x, y, z, dropBlock);
        } else if (!block.equals(Blocks.field_150350_a)) {
            return;
        }
        this.destroyInDirection(world, x, y + dir.offsetY, z, doDrop, dir);
    }

    private void destroy(World world, int x, int y, int z, boolean doDrop) {
        if (!world.field_72995_K) {
            this.destroyInDirection(world, x, y, z, doDrop, ForgeDirection.UP);
            this.destroyInDirection(world, x, y - 1, z, false, ForgeDirection.DOWN);
        }
    }

    private void create(TEBase TE, World world, int x, int y, int z) {
        while (this.func_149742_c(world, x, y, z)) {
            world.func_147449_b(x, y, z, (Block)this);
            TEBase temp = this.getTileEntity((IBlockAccess)world, x, y, z);
            if (temp != null) {
                data.replicate(TE, temp);
            }
            --y;
        }
    }

    @Override
    protected TEBase getTileEntityForBlockActivation(TEBase TE) {
        return data.isOpen(TE) ? data.getBottommost(TE.func_145831_w(), TE.field_145851_c, TE.field_145848_d, TE.field_145849_e) : TE;
    }

    @Override
    protected void postOnBlockActivated(TEBase TE, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ, BlockCoverable.ActionResult actionResult) {
        if (!data.isRigid(TE)) {
            int state = data.getState(TE) == 1 ? 0 : 1;
            Set<TEBase> pieces = data.getBlocks(TE, (Block)this);
            for (TEBase piece : pieces) {
                data.setState(piece, state);
            }
            actionResult.setAltered().setNoSound();
        }
    }

    @Override
    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (!world.field_72995_K) {
            TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
            if (TE != null) {
                if (data.isHost(TE) && !this.func_149707_d(world, x, y, z, 0) && !world.func_147439_a(x, y + 1, z).equals((Object)this)) {
                    this.destroy(world, x, y, z, true);
                } else {
                    int powerState;
                    int n = powerState = world.func_72864_z(x, y, z) ? 1 : 0;
                    if (block != null && block.func_149744_f() && powerState != data.getState(TE)) {
                        int old_state;
                        int state = old_state = data.getState(TE);
                        if (data.isOpen(TE)) {
                            boolean garageHasPower = false;
                            Set<TEBase> pieces = data.getBlocks(TE, (Block)this);
                            for (TEBase piece : pieces) {
                                if (!world.func_72864_z(piece.field_145851_c, piece.field_145848_d, piece.field_145849_e)) continue;
                                garageHasPower = true;
                                break;
                            }
                            if (!garageHasPower) {
                                state = 0;
                            }
                        } else {
                            state = 1;
                        }
                        if (state != old_state) {
                            data.setState(TE, state);
                            Set<TEBase> pieces = data.getBlocks(TE, (Block)this);
                            for (TEBase piece : pieces) {
                                data.setState(piece, state);
                            }
                        }
                    }
                }
            }
            if (FeatureRegistry.enableGarageDoorVoidFill && block != this && world.func_147439_a(x, y - 1, z).equals(Blocks.field_150350_a)) {
                this.create(TE, world, x, y - 1, z);
            }
        }
        super.func_149695_a(world, x, y, z, block);
    }

    public boolean removedByPlayer(World world, EntityPlayer entityPlayer, int x, int y, int z) {
        if (!this.suppressDestroyBlock(entityPlayer)) {
            this.destroy(world, x, y, z, !entityPlayer.field_71075_bZ.field_75098_d);
            return false;
        }
        return super.removedByPlayer(world, entityPlayer, x, y, z);
    }

    @Override
    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null && data.isHost(TE)) {
            list.add(this.getItemDrop(world, metadata));
        }
        list.addAll(super.getDrops(world, x, y, z, 16, fortune));
        return list;
    }

    public boolean func_149707_d(World world, int x, int y, int z, int side) {
        return world.isSideSolid(x, y + 1, z, ForgeDirection.DOWN);
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        if (super.func_149742_c(world, x, y, z)) {
            return this.func_149707_d(world, x, y, z, 0) || world.func_147439_a(x, y + 1, z).equals((Object)this);
        }
        return false;
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        super.func_149689_a(world, x, y, z, entityLiving, itemStack);
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        ForgeDirection facing = EntityLivingUtil.getFacing(entityLiving).getOpposite();
        data.setDirection(TE, facing);
        data.setHost(TE);
        TEBase temp = data.findReferencePiece(world, x, y, z, facing);
        if (temp != null) {
            data.replicate(temp, TE);
        }
        this.create(TE, world, x, y - 1, z);
    }

    public int func_149645_b() {
        return BlockRegistry.carpentersGarageDoorRenderID;
    }

    public ForgeDirection[] getValidRotations(World worldObj, int x, int y, int z) {
        ForgeDirection[] axises = new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN};
        return axises;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TEBase) {
            TEBase cbTile = (TEBase)tile;
            int dataAngle = (cbTile.getData() & 0x70) >> 4;
            ForgeDirection direction = ForgeDirection.getOrientation((int)dataAngle);
            int newAngle = 0;
            switch (axis) {
                case UP: {
                    switch (direction) {
                        case WEST: {
                            newAngle = cbTile.getData() & 0xFFFFFF8F | ForgeDirection.NORTH.ordinal() << 4;
                            break;
                        }
                        case NORTH: {
                            newAngle = cbTile.getData() & 0xFFFFFF8F | ForgeDirection.EAST.ordinal() << 4;
                            break;
                        }
                        case EAST: {
                            newAngle = cbTile.getData() & 0xFFFFFF8F | ForgeDirection.SOUTH.ordinal() << 4;
                            break;
                        }
                        case SOUTH: {
                            newAngle = cbTile.getData() & 0xFFFFFF8F | ForgeDirection.WEST.ordinal() << 4;
                            break;
                        }
                    }
                    cbTile.setData(newAngle);
                    return true;
                }
                case DOWN: {
                    switch (direction) {
                        case WEST: {
                            newAngle = cbTile.getData() & 0xFFFFFF8F | ForgeDirection.SOUTH.ordinal() << 4;
                            break;
                        }
                        case NORTH: {
                            newAngle = cbTile.getData() & 0xFFFFFF8F | ForgeDirection.EAST.ordinal() << 4;
                            break;
                        }
                        case EAST: {
                            newAngle = cbTile.getData() & 0xFFFFFF8F | ForgeDirection.NORTH.ordinal() << 4;
                            break;
                        }
                        case SOUTH: {
                            newAngle = cbTile.getData() & 0xFFFFFF8F | ForgeDirection.WEST.ordinal() << 4;
                            break;
                        }
                    }
                    cbTile.setData(newAngle);
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public TileEntity func_149915_a(World world, int metadata) {
        return new TECarpentersGarageDoor();
    }
}

