/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter.common.network;

import com.cleanroommc.bogosorter.common.dropoff.DropOffHandler;
import com.cleanroommc.bogosorter.common.dropoff.render.RendererCube;
import com.cleanroommc.bogosorter.common.dropoff.render.RendererCubeTarget;
import com.cleanroommc.bogosorter.common.network.IPacket;
import com.gtnewhorizon.gtnhlib.blockpos.BlockPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;

public class SDropOffMessage
implements IPacket {
    private int itemsCounter;
    private int affectedContainers;
    private int totalContainers;
    private List<RendererCubeTarget> rendererCubeTargets = new ArrayList<RendererCubeTarget>();
    private boolean timeQuotaReached;

    public SDropOffMessage() {
    }

    public SDropOffMessage(int itemsCounter, int affectedContainers, int totalContainers, List<RendererCubeTarget> rendererCubeTargets, boolean timeQuotaReached) {
        this.itemsCounter = itemsCounter;
        this.affectedContainers = affectedContainers;
        this.totalContainers = totalContainers;
        this.rendererCubeTargets = rendererCubeTargets;
        this.timeQuotaReached = timeQuotaReached;
    }

    @Override
    public void encode(PacketBuffer buf) throws IOException {
        buf.writeInt(this.itemsCounter);
        buf.writeInt(this.affectedContainers);
        buf.writeInt(this.totalContainers);
        buf.writeBoolean(this.timeQuotaReached);
        buf.writeInt(this.rendererCubeTargets.size());
        for (RendererCubeTarget target : this.rendererCubeTargets) {
            buf.writeInt(target.getBlockPos().getX());
            buf.writeInt(target.getBlockPos().getY());
            buf.writeInt(target.getBlockPos().getZ());
            buf.writeInt(target.getColor().getRed());
            buf.writeInt(target.getColor().getGreen());
            buf.writeInt(target.getColor().getBlue());
        }
    }

    @Override
    public void decode(PacketBuffer buf) throws IOException {
        this.itemsCounter = buf.readInt();
        this.affectedContainers = buf.readInt();
        this.totalContainers = buf.readInt();
        this.timeQuotaReached = buf.readBoolean();
        int targetsLen = buf.readInt();
        for (int i = 0; i < targetsLen; ++i) {
            this.rendererCubeTargets.add(new RendererCubeTarget(new BlockPos(buf.readInt(), buf.readInt(), buf.readInt()), new Color(buf.readInt(), buf.readInt(), buf.readInt())));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IPacket executeClient(NetHandlerPlayClient handler) {
        String message;
        if (DropOffHandler.dropoffRender) {
            RendererCube.INSTANCE.draw(this.rendererCubeTargets);
        }
        if (this.timeQuotaReached) {
            message = "[" + EnumChatFormatting.BLUE + "Inventory Bogo Sorter" + EnumChatFormatting.RESET + "]: " + EnumChatFormatting.RED + "Quota Time Limit Reached; Stopped Early";
            Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(message));
        }
        if (DropOffHandler.dropoffChatMessage) {
            message = "[" + EnumChatFormatting.BLUE + "Inventory Bogo Sorter" + EnumChatFormatting.RESET + "]: " + EnumChatFormatting.RED + this.itemsCounter + EnumChatFormatting.RESET + " items moved to " + EnumChatFormatting.RED + this.affectedContainers + EnumChatFormatting.RESET + " containers of " + EnumChatFormatting.RED + this.totalContainers + EnumChatFormatting.RESET + " checked in total.";
            Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(message));
        }
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147673_a((ResourceLocation)new ResourceLocation("gui.button.press")));
        return null;
    }
}

