/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter.common.network;

import com.cleanroommc.bogosorter.BogoSortAPI;
import com.cleanroommc.bogosorter.ShortcutHandler;
import com.cleanroommc.bogosorter.api.ISlot;
import com.cleanroommc.bogosorter.common.network.IPacket;
import com.cleanroommc.bogosorter.common.network.NetworkUtils;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;

public class CShortcut
implements IPacket {
    private Type type;
    private int slotNumber;

    public CShortcut(Type type, int slotNumber) {
        this.type = type;
        this.slotNumber = slotNumber;
    }

    public CShortcut() {
    }

    @Override
    public void encode(PacketBuffer buf) throws IOException {
        NetworkUtils.writeEnumValue(buf, this.type);
        buf.func_150787_b(this.slotNumber);
    }

    @Override
    public void decode(PacketBuffer buf) throws IOException {
        this.type = NetworkUtils.readEnumValue(buf, Type.class);
        this.slotNumber = buf.func_150792_a();
    }

    @Override
    public IPacket executeServer(NetHandlerPlayServer handler) {
        Container container = handler.field_147369_b.field_71070_bA;
        if (container == null) {
            throw new IllegalStateException("Expected open container on server");
        }
        ISlot slot = BogoSortAPI.getSlot(container, this.slotNumber);
        switch (this.type) {
            case MOVE_ALL: {
                ShortcutHandler.moveAllItems((EntityPlayer)handler.field_147369_b, container, slot, false);
                break;
            }
            case MOVE_ALL_SAME: {
                ShortcutHandler.moveAllItems((EntityPlayer)handler.field_147369_b, container, slot, true);
                break;
            }
            case MOVE_SINGLE: {
                ShortcutHandler.moveSingleItem((EntityPlayer)handler.field_147369_b, container, slot, false);
                break;
            }
            case MOVE_SINGLE_EMPTY: {
                ShortcutHandler.moveSingleItem((EntityPlayer)handler.field_147369_b, container, slot, true);
                break;
            }
            case DROP_ALL: {
                ShortcutHandler.dropItems((EntityPlayer)handler.field_147369_b, container, slot, false);
                break;
            }
            case DROP_ALL_SAME: {
                ShortcutHandler.dropItems((EntityPlayer)handler.field_147369_b, container, slot, true);
            }
        }
        container.func_75142_b();
        return null;
    }

    public static enum Type {
        MOVE_ALL,
        MOVE_ALL_SAME,
        MOVE_SINGLE,
        MOVE_SINGLE_EMPTY,
        DROP_ALL,
        DROP_ALL_SAME;

    }
}

