/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter.common.network;

import com.cleanroommc.bogosorter.common.dropoff.DropOffHandler;
import com.cleanroommc.bogosorter.common.dropoff.InteractionResult;
import com.cleanroommc.bogosorter.common.dropoff.InventoryData;
import com.cleanroommc.bogosorter.common.dropoff.InventoryManager;
import com.cleanroommc.bogosorter.common.dropoff.render.RendererCubeTarget;
import com.cleanroommc.bogosorter.common.network.IPacket;
import com.cleanroommc.bogosorter.common.network.SDropOffMessage;
import com.cleanroommc.bogosorter.common.network.SDropOffThrottled;
import com.gtnewhorizon.gtnhlib.blockpos.BlockPos;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;

public class CDropOff
implements IPacket {
    static final HashMap<UUID, Long> playerThrottles = new HashMap();

    @Override
    public void encode(PacketBuffer buf) throws IOException {
    }

    @Override
    public void decode(PacketBuffer buf) throws IOException {
    }

    @Override
    public IPacket executeServer(NetHandlerPlayServer handler) {
        EntityPlayerMP player = handler.field_147369_b;
        if (MinecraftServer.func_71276_C().func_71262_S()) {
            long lastPlayerTime = playerThrottles.computeIfAbsent(player.getPersistentID(), p -> 0L);
            long throttleTime = System.nanoTime();
            if (throttleTime - lastPlayerTime < TimeUnit.MILLISECONDS.toNanos(DropOffHandler.dropoffPacketThrottleInMS)) {
                return new SDropOffThrottled();
            }
            playerThrottles.replace(player.getPersistentID(), throttleTime);
        }
        InventoryManager inventoryManager = new InventoryManager(player);
        DropOffHandler dropOffHandler = new DropOffHandler(inventoryManager);
        dropOffHandler.setItemsCounter(0);
        List<InventoryData> inventoryDataList = inventoryManager.getNearbyInventories();
        boolean timeLimitExceeded = false;
        long startTime = System.nanoTime();
        for (InventoryData inventoryData : inventoryDataList) {
            if (timeLimitExceeded) {
                inventoryData.setInteractionResult(InteractionResult.DROPOFF_QUOTA_MET);
                continue;
            }
            IInventory inventory = inventoryData.getInventory();
            dropOffHandler.setStartSlot(0);
            dropOffHandler.setEndSlot(-1);
            if (inventory instanceof TileEntityFurnace) {
                if (inventory.func_70301_a(0) == null) {
                    dropOffHandler.setStartSlot(1);
                }
                dropOffHandler.setEndSlot(2);
            }
            dropOffHandler.dropOff(inventoryData);
            inventory.func_70296_d();
            long elapsedTime = System.nanoTime() - startTime;
            if (elapsedTime < TimeUnit.MILLISECONDS.toNanos(DropOffHandler.dropoffQuotaInMS)) continue;
            timeLimitExceeded = true;
        }
        player.field_71071_by.func_70296_d();
        player.field_71069_bz.func_75142_b();
        ArrayList<RendererCubeTarget> rendererCubeTargets = new ArrayList<RendererCubeTarget>();
        int affectedContainers = 0;
        for (InventoryData inventoryData : inventoryDataList) {
            Color color;
            InteractionResult result = inventoryData.getInteractionResult();
            if (result == InteractionResult.DROPOFF_QUOTA_MET) continue;
            if (result == InteractionResult.DROPOFF_SUCCESS) {
                ++affectedContainers;
                color = new Color(0, 255, 0);
            } else {
                color = new Color(255, 0, 0);
            }
            for (TileEntity entity : inventoryData.getEntities()) {
                BlockPos blockPos = new BlockPos(entity.field_145851_c, entity.field_145848_d, entity.field_145849_e);
                RendererCubeTarget rendererCubeTarget = new RendererCubeTarget(blockPos, color);
                rendererCubeTargets.add(rendererCubeTarget);
            }
        }
        return new SDropOffMessage(dropOffHandler.getItemsCounter(), affectedContainers, inventoryDataList.size(), rendererCubeTargets, timeLimitExceeded);
    }
}

