/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter.common.dropoff;

import com.cleanroommc.bogosorter.common.dropoff.InteractionResult;
import com.cleanroommc.bogosorter.common.dropoff.InventoryData;
import com.cleanroommc.bogosorter.common.dropoff.InventoryManager;
import com.cleanroommc.bogosorter.compat.loader.Mods;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class DropOffHandler {
    private final InventoryManager inventoryManager;
    private final InventoryPlayer playerInventory;
    private final ItemStack[] playerStacks;
    private int itemsCounter;
    private int startSlot;
    private int endSlot;
    public static boolean enableDropOff = true;
    public static boolean dropoffRender = true;
    public static boolean dropoffChatMessage = true;
    public static int dropoffQuotaInMS = 1;
    public static int dropoffPacketThrottleInMS = 500;
    public static String dropoffTargetNames = "*Chest*, *Barrel*, *Drawer*, *Crate*";

    public DropOffHandler(InventoryManager inventoryManager) {
        this.inventoryManager = inventoryManager;
        this.playerInventory = inventoryManager.getPlayer().field_71071_by;
        this.playerStacks = this.playerInventory.field_70462_a;
    }

    public void setStartSlot(int value) {
        this.startSlot = value;
    }

    public void setEndSlot(int value) {
        this.endSlot = value;
    }

    public int getItemsCounter() {
        return this.itemsCounter;
    }

    public void setItemsCounter(int value) {
        this.itemsCounter = Math.max(value, 0);
    }

    public void dropOff(InventoryData toInventoryData) {
        IInventory toInventory = toInventoryData.getInventory();
        if (this.endSlot == -1) {
            this.endSlot = toInventory.func_70302_i_();
        }
        for (int i = 9; i < this.playerStacks.length; ++i) {
            if (this.playerStacks[i] == null || !this.isItemValid(this.playerStacks[i].func_82833_r())) continue;
            int oldPlayerStackSize = this.playerStacks[i].field_77994_a;
            this.movePlayerStack(i, toInventory);
            int newPlayerStackSize = this.playerStacks[i] == null ? 0 : this.playerStacks[i].field_77994_a;
            int itemsMoved = oldPlayerStackSize - newPlayerStackSize;
            this.itemsCounter += itemsMoved;
            if (itemsMoved <= 0) continue;
            toInventoryData.setInteractionResult(InteractionResult.DROPOFF_SUCCESS);
        }
    }

    private boolean isItemValid(String name) {
        return true;
    }

    private void movePlayerStack(int playerStackIndex, IInventory toInventory) {
        Integer emptySlotIndex = null;
        boolean hasSameStack = false;
        for (int i = this.startSlot; i < this.endSlot; ++i) {
            ItemStack toCurrentStack = toInventory.func_70301_a(i);
            if (toCurrentStack == null) {
                if (emptySlotIndex != null) continue;
                emptySlotIndex = i;
                continue;
            }
            if (!this.inventoryManager.isStacksEqual(toCurrentStack, this.playerStacks[playerStackIndex])) continue;
            hasSameStack = true;
            int toCurrentStackMaxSize = this.inventoryManager.getMaxAllowedStackSize(toInventory, toCurrentStack);
            if (Mods.StorageDrawers.isLoaded() && toInventory instanceof TileEntityDrawers) {
                TileEntityDrawers drawer = (TileEntityDrawers)toInventory;
                int drawerSlot = drawer.getDrawerInventory().getDrawerSlot(i);
                if (drawer.func_102007_a(drawerSlot, this.playerStacks[playerStackIndex], 0)) {
                    int countAdded = drawer.putItemsIntoSlot(drawerSlot, this.playerStacks[playerStackIndex], this.playerStacks[playerStackIndex].field_77994_a);
                    if (countAdded == 0) continue;
                    if (this.playerStacks[playerStackIndex].field_77994_a <= 0) {
                        this.playerStacks[playerStackIndex] = null;
                    }
                }
                return;
            }
            if (toCurrentStack.field_77994_a + this.playerStacks[playerStackIndex].field_77994_a <= toCurrentStackMaxSize) {
                toCurrentStack.field_77994_a += this.playerStacks[playerStackIndex].field_77994_a;
                this.playerStacks[playerStackIndex] = null;
                return;
            }
            int leftToMax = toCurrentStackMaxSize - toCurrentStack.field_77994_a;
            toCurrentStack.field_77994_a = toCurrentStackMaxSize;
            this.playerStacks[playerStackIndex].field_77994_a -= leftToMax;
        }
        if (hasSameStack && emptySlotIndex != null && toInventory.func_94041_b(emptySlotIndex.intValue(), this.playerStacks[playerStackIndex])) {
            toInventory.func_70299_a(emptySlotIndex.intValue(), this.playerStacks[playerStackIndex]);
            this.playerStacks[playerStackIndex] = null;
        }
    }
}

