/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter.common.config;

import com.cleanroommc.bogosorter.client.usageticker.UsageTicker;
import com.cleanroommc.bogosorter.common.config.BogoSorterConfig;
import com.cleanroommc.bogosorter.common.network.NetworkUtils;
import com.cleanroommc.bogosorter.common.sort.SortHandler;
import com.cleanroommc.bogosorter.core.BogoSorterCore;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import org.apache.commons.lang3.StringUtils;

public class Serializer {
    public static final JsonParser jsonParser = new JsonParser();
    public static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public static final String cfgPath = Loader.instance().getConfigDir().toString();
    public static final File configJsonPath = new File(cfgPath + Serializer.path("", "bogosorter", "config.json"));
    public static final File orePrefixJsonPath = new File(cfgPath + Serializer.path("", "bogosorter", "orePrefix.json"));

    private static String path(String ... path) {
        return StringUtils.join((Object[])path, (char)File.separatorChar);
    }

    private Serializer() {
    }

    @SideOnly(value=Side.CLIENT)
    public static void saveConfig() {
        JsonObject json = new JsonObject();
        BogoSorterConfig.save(json);
        Serializer.saveJson(configJsonPath, (JsonElement)json);
    }

    public static void loadConfig() {
        JsonElement jsonElement;
        if (NetworkUtils.isDedicatedClient()) {
            if (!Files.exists(configJsonPath.toPath(), new LinkOption[0])) {
                BogoSorterConfig.loadDefaultRules();
                Serializer.saveConfig();
            }
            if ((jsonElement = Serializer.loadJson(configJsonPath)) == null || !jsonElement.isJsonObject()) {
                BogoSorterCore.LOGGER.error("Error loading config!");
            } else {
                BogoSorterConfig.load(jsonElement.getAsJsonObject());
                UsageTicker.reloadElements();
                SortHandler.cacheItemSortRules.put((EntityPlayer)Minecraft.func_71410_x().field_71439_g, BogoSorterConfig.sortRules);
                SortHandler.cacheNbtSortRules.put((EntityPlayer)Minecraft.func_71410_x().field_71439_g, BogoSorterConfig.nbtSortRules);
            }
        }
        if (!Files.exists(orePrefixJsonPath.toPath(), new LinkOption[0])) {
            Serializer.saveOrePrefixes();
            return;
        }
        jsonElement = Serializer.loadJson(orePrefixJsonPath);
        if (jsonElement == null || !jsonElement.isJsonObject()) {
            BogoSorterCore.LOGGER.error("Error loading ore prefix config!");
            return;
        }
        BogoSorterConfig.loadOrePrefixes(jsonElement.getAsJsonObject());
    }

    public static void saveOrePrefixes() {
        JsonObject json = new JsonObject();
        BogoSorterConfig.saveOrePrefixes(json);
        Serializer.saveJson(orePrefixJsonPath, (JsonElement)json);
    }

    public static JsonElement loadJson(File file) {
        try {
            if (!file.isFile()) {
                return null;
            }
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
            JsonElement json = jsonParser.parse(new JsonReader((Reader)reader));
            ((Reader)reader).close();
            return json;
        }
        catch (Exception e) {
            BogoSorterCore.LOGGER.error("Failed to read file on path {}", new Object[]{file, e});
            return null;
        }
    }

    public static boolean saveJson(File file, JsonElement element) {
        try {
            if (!file.getParentFile().isDirectory() && !file.getParentFile().mkdirs()) {
                BogoSorterCore.LOGGER.error("Failed to create file dirs on path {}", new Object[]{file});
            }
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);
            writer.write(gson.toJson(element));
            ((Writer)writer).close();
            return true;
        }
        catch (Exception e) {
            BogoSorterCore.LOGGER.error("Failed to save file on path {}", new Object[]{file, e});
            return false;
        }
    }
}

