/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter.common.config;

import com.cleanroommc.bogosorter.BogoSortAPI;
import com.cleanroommc.bogosorter.api.SortRule;
import com.cleanroommc.bogosorter.client.usageticker.UsageTicker;
import com.cleanroommc.bogosorter.common.HotbarSwap;
import com.cleanroommc.bogosorter.common.config.PlayerConfig;
import com.cleanroommc.bogosorter.common.config.Serializer;
import com.cleanroommc.bogosorter.common.dropoff.DropOffButtonHandler;
import com.cleanroommc.bogosorter.common.dropoff.DropOffHandler;
import com.cleanroommc.bogosorter.common.sort.NbtSortRule;
import com.cleanroommc.bogosorter.common.sort.SortHandler;
import com.cleanroommc.bogosorter.core.BogoSorterCore;
import com.cleanroommc.modularui.utils.JsonHelper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class BogoSorterConfig {
    public static final List<SortRule<ItemStack>> sortRules = new ArrayList<SortRule<ItemStack>>();
    public static final List<NbtSortRule> nbtSortRules = new ArrayList<NbtSortRule>();
    public static final Object2IntOpenHashMap<String> ORE_PREFIXES = new Object2IntOpenHashMap();
    public static final List<String> ORE_PREFIXES_LIST = new ArrayList<String>();
    public static int buttonColor = -1;

    @SideOnly(value=Side.CLIENT)
    public static void save(JsonObject json) {
        JsonObject ruleJson;
        PlayerConfig playerConfig = PlayerConfig.getClient();
        JsonObject general = new JsonObject();
        general.addProperty("enableHotbarSort", Boolean.valueOf(playerConfig.enableHotbarSort));
        general.addProperty("enableAutoRefill", Boolean.valueOf(playerConfig.enableAutoRefill));
        general.addProperty("refillDmgThreshold", (Number)playerConfig.autoRefillDamageThreshold);
        general.addProperty("enableDropoff", Boolean.valueOf(DropOffHandler.enableDropOff));
        general.addProperty("dropoffRender", Boolean.valueOf(DropOffHandler.dropoffRender));
        general.addProperty("dropoffChatMessage", Boolean.valueOf(DropOffHandler.dropoffChatMessage));
        general.addProperty("dropoffQuotaInMS", (Number)DropOffHandler.dropoffQuotaInMS);
        general.addProperty("dropoffPacketThrottleInMS", (Number)DropOffHandler.dropoffPacketThrottleInMS);
        general.addProperty("dropoffTargetNames", DropOffHandler.dropoffTargetNames);
        general.addProperty("dropoffButtonShow", Boolean.valueOf(DropOffButtonHandler.showButton));
        general.addProperty("dropoffButtonX", (Number)DropOffButtonHandler.buttonX);
        general.addProperty("dropoffButtonY", (Number)DropOffButtonHandler.buttonY);
        general.addProperty("enableHotbarSwap", Boolean.valueOf(HotbarSwap.isEnabled()));
        general.addProperty("sortSound", SortHandler.getSortSoundName());
        general.addProperty("buttonColor", "#" + Integer.toHexString(buttonColor));
        json.add("General", (JsonElement)general);
        JsonArray jsonRules = new JsonArray();
        for (SortRule<ItemStack> sortRule : sortRules) {
            if (sortRule == BogoSortAPI.EMPTY_ITEM_SORT_RULE) continue;
            ruleJson = new JsonObject();
            ruleJson.addProperty("name", sortRule.getKey());
            ruleJson.addProperty("inverted", Boolean.valueOf(sortRule.isInverted()));
            jsonRules.add((JsonElement)ruleJson);
        }
        json.add("ItemSortRules", (JsonElement)jsonRules);
        jsonRules = new JsonArray();
        for (NbtSortRule nbtSortRule : nbtSortRules) {
            if (nbtSortRule == BogoSortAPI.EMPTY_NBT_SORT_RULE) continue;
            ruleJson = new JsonObject();
            ruleJson.addProperty("name", nbtSortRule.getKey());
            ruleJson.addProperty("inverted", Boolean.valueOf(nbtSortRule.isInverted()));
            jsonRules.add((JsonElement)ruleJson);
        }
        json.add("NbtSortRules", (JsonElement)jsonRules);
        JsonObject usageTicker = new JsonObject();
        usageTicker.addProperty("enableModule", Boolean.valueOf(UsageTicker.enableModule));
        usageTicker.addProperty("enableMainHand", Boolean.valueOf(UsageTicker.enableMainHand));
        usageTicker.addProperty("enableOffHand", Boolean.valueOf(UsageTicker.enableOffHand));
        usageTicker.addProperty("enableArmor", Boolean.valueOf(UsageTicker.enableArmor));
        json.add("UsageTicker", (JsonElement)usageTicker);
    }

    @SideOnly(value=Side.CLIENT)
    public static void load(JsonObject json) {
        NbtSortRule rule;
        String key;
        boolean inverted;
        JsonArray sortRules;
        PlayerConfig playerConfig = PlayerConfig.getClient();
        if (json.has("General")) {
            JsonObject general = json.getAsJsonObject("General");
            playerConfig.enableHotbarSort = JsonHelper.getBoolean((JsonObject)general, (boolean)true, (String[])new String[]{"enableHotbarSort"});
            playerConfig.enableAutoRefill = JsonHelper.getBoolean((JsonObject)general, (boolean)true, (String[])new String[]{"enableAutoRefill"});
            playerConfig.autoRefillDamageThreshold = (short)JsonHelper.getInt((JsonObject)general, (int)1, (String[])new String[]{"refillDmgThreshold"});
            DropOffHandler.enableDropOff = JsonHelper.getBoolean((JsonObject)general, (boolean)true, (String[])new String[]{"enableDropoff"});
            DropOffHandler.dropoffRender = JsonHelper.getBoolean((JsonObject)general, (boolean)true, (String[])new String[]{"dropoffRender"});
            DropOffHandler.dropoffChatMessage = JsonHelper.getBoolean((JsonObject)general, (boolean)true, (String[])new String[]{"dropoffChatMessage"});
            DropOffHandler.dropoffQuotaInMS = JsonHelper.getInt((JsonObject)general, (int)1, (String[])new String[]{"dropoffQuotaInMS"});
            DropOffHandler.dropoffPacketThrottleInMS = JsonHelper.getInt((JsonObject)general, (int)500, (String[])new String[]{"dropoffPacketThrottleInMS"});
            DropOffHandler.dropoffTargetNames = JsonHelper.getString((JsonObject)general, (String)"*Chest*, *Barrel*, *Drawer*, *Crate*", (String[])new String[]{"dropoffTargetNames"});
            DropOffButtonHandler.showButton = JsonHelper.getBoolean((JsonObject)general, (boolean)true, (String[])new String[]{"dropoffButtonShow"});
            DropOffButtonHandler.buttonX = JsonHelper.getInt((JsonObject)general, (int)160, (String[])new String[]{"dropoffButtonX"});
            DropOffButtonHandler.buttonY = JsonHelper.getInt((JsonObject)general, (int)5, (String[])new String[]{"dropoffButtonY"});
            HotbarSwap.setEnabled(JsonHelper.getBoolean((JsonObject)general, (boolean)true, (String[])new String[]{"enableHotbarSwap"}));
            SortHandler.sortSound = (ResourceLocation)JsonHelper.getElement((JsonObject)general, (Object)new ResourceLocation("gui.button.press"), element -> {
                if (element.isJsonNull()) {
                    return null;
                }
                ResourceLocation soundEvent = new ResourceLocation(element.getAsString());
                return soundEvent != null ? soundEvent : new ResourceLocation("gui.button.press");
            }, (String[])new String[]{"sortSound"});
            buttonColor = JsonHelper.getColor((JsonObject)general, (int)-1, (String[])new String[]{"buttonColor"});
        }
        BogoSorterConfig.sortRules.clear();
        if (json.has("ItemSortRules")) {
            sortRules = json.getAsJsonArray("ItemSortRules");
            for (JsonElement jsonElement : sortRules) {
                inverted = false;
                if (jsonElement.isJsonObject()) {
                    key = JsonHelper.getString((JsonObject)jsonElement.getAsJsonObject(), (String)"", (String[])new String[]{"key", "name"});
                    inverted = JsonHelper.getBoolean((JsonObject)jsonElement.getAsJsonObject(), (boolean)false, (String[])new String[]{"inverted", "ascending", "asc"});
                } else {
                    key = jsonElement.getAsString();
                }
                rule = BogoSortAPI.INSTANCE.getItemSortRule(key);
                if (rule.isEmpty()) {
                    BogoSorterCore.LOGGER.error("Could not find item sort rule with key '{}'.", new Object[]{key});
                    continue;
                }
                rule.setInverted(inverted);
                BogoSorterConfig.sortRules.add(rule);
            }
        }
        nbtSortRules.clear();
        if (json.has("NbtSortRules")) {
            sortRules = json.getAsJsonArray("NbtSortRules");
            for (JsonElement jsonElement : sortRules) {
                inverted = false;
                if (jsonElement.isJsonObject()) {
                    key = JsonHelper.getString((JsonObject)jsonElement.getAsJsonObject(), (String)"", (String[])new String[]{"key", "name"});
                    inverted = JsonHelper.getBoolean((JsonObject)jsonElement.getAsJsonObject(), (boolean)false, (String[])new String[]{"inverted", "ascending", "asc"});
                } else {
                    key = jsonElement.getAsString();
                }
                rule = BogoSortAPI.INSTANCE.getNbtSortRule(key);
                if (rule.isEmpty()) {
                    BogoSorterCore.LOGGER.error("Could not find nbt sort rule with key '{}'.", new Object[]{key});
                    continue;
                }
                rule.setInverted(inverted);
                nbtSortRules.add(rule);
            }
        }
        if (json.has("UsageTicker")) {
            JsonObject ticker = json.getAsJsonObject("UsageTicker");
            UsageTicker.enableModule = JsonHelper.getBoolean((JsonObject)ticker, (boolean)true, (String[])new String[]{"enableModule"});
            UsageTicker.enableMainHand = JsonHelper.getBoolean((JsonObject)ticker, (boolean)true, (String[])new String[]{"enableMainHand"});
            UsageTicker.enableOffHand = JsonHelper.getBoolean((JsonObject)ticker, (boolean)true, (String[])new String[]{"enableOffHand"});
            UsageTicker.enableArmor = JsonHelper.getBoolean((JsonObject)ticker, (boolean)true, (String[])new String[]{"enableArmor"});
        }
    }

    public static void saveOrePrefixes(JsonObject json) {
        json.addProperty("_comment", "Setting this to true will recreate this entire file on next start");
        json.addProperty("reload", Boolean.valueOf(false));
        JsonArray orePrefixes = new JsonArray();
        json.add("orePrefixes", (JsonElement)orePrefixes);
        for (String orePrefix : ORE_PREFIXES_LIST) {
            JsonPrimitive jsonElement = new JsonPrimitive(orePrefix);
            orePrefixes.add((JsonElement)jsonElement);
        }
    }

    public static void loadOrePrefixes(JsonObject json) {
        if (json.has("reload") && json.get("reload").getAsBoolean()) {
            Serializer.saveOrePrefixes();
            return;
        }
        if (json.has("orePrefixes")) {
            ORE_PREFIXES.clear();
            ORE_PREFIXES_LIST.clear();
            int i = 0;
            for (JsonElement jsonElement : json.getAsJsonArray("orePrefixes")) {
                if (!jsonElement.isJsonPrimitive()) continue;
                String orePrefix = jsonElement.getAsString();
                ORE_PREFIXES.put((Object)orePrefix, i++);
                ORE_PREFIXES_LIST.add(orePrefix);
            }
        }
    }

    public static void loadDefaultRules() {
        String[] itemRules = new String[]{"mod", "material", "ore_prefix", "id", "meta", "nbt_has", "nbt_rules"};
        String[] nbtRules = new String[]{"enchantment", "enchantment_book", "potion", "gt_circ_config", "gt_item_damage"};
        sortRules.addAll(Arrays.stream(itemRules).map(BogoSortAPI.INSTANCE::getItemSortRule).filter(rule -> rule != BogoSortAPI.EMPTY_ITEM_SORT_RULE).collect(Collectors.toList()));
        nbtSortRules.addAll(Arrays.stream(nbtRules).map(BogoSortAPI.INSTANCE::getNbtSortRule).filter(rule -> rule != BogoSortAPI.EMPTY_NBT_SORT_RULE).collect(Collectors.toList()));
    }
}

