/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.mars.nei;

import codechicken.nei.PositionedStack;
import codechicken.nei.api.API;
import codechicken.nei.api.IConfigureNEI;
import codechicken.nei.api.IHighlightHandler;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import micdoodle8.mods.galacticraft.core.items.GCItems;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import micdoodle8.mods.galacticraft.planets.mars.blocks.MarsBlocks;
import micdoodle8.mods.galacticraft.planets.mars.items.MarsItems;
import micdoodle8.mods.galacticraft.planets.mars.nei.CargoRocketRecipeHandler;
import micdoodle8.mods.galacticraft.planets.mars.nei.GCMarsNEIHighlightHandler;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public class NEIGalacticraftMarsConfig
implements IConfigureNEI {
    private static final HashMap<ArrayList<PositionedStack>, PositionedStack> rocketBenchRecipes = new HashMap();
    private static final HashMap<ArrayList<PositionedStack>, PositionedStack> cargoBenchRecipes = new HashMap();
    private static final HashMap<PositionedStack, PositionedStack> liquefierRecipes = new HashMap();
    private static final HashMap<PositionedStack, PositionedStack> synthesizerRecipes = new HashMap();
    public static GCMarsNEIHighlightHandler planetsHighlightHandler = new GCMarsNEIHighlightHandler();

    public void loadConfig() {
        this.registerRecipes();
        API.registerRecipeHandler((ICraftingHandler)new CargoRocketRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new CargoRocketRecipeHandler());
        API.registerHighlightIdentifier((Block)MarsBlocks.marsBlock, (IHighlightHandler)planetsHighlightHandler);
    }

    public String getName() {
        return "Galacticraft Mars NEI Plugin";
    }

    public String getVersion() {
        return "3.3.5-GTNH";
    }

    public void registerRocketBenchRecipe(ArrayList<PositionedStack> input, PositionedStack output) {
        rocketBenchRecipes.put(input, output);
    }

    public void registerCargoBenchRecipe(ArrayList<PositionedStack> input, PositionedStack output) {
        cargoBenchRecipes.put(input, output);
    }

    public static Set<Map.Entry<ArrayList<PositionedStack>, PositionedStack>> getRocketBenchRecipes() {
        return rocketBenchRecipes.entrySet();
    }

    public static Set<Map.Entry<ArrayList<PositionedStack>, PositionedStack>> getCargoBenchRecipes() {
        return cargoBenchRecipes.entrySet();
    }

    private void registerLiquefierRecipe(PositionedStack inputStack, PositionedStack outputStack) {
        liquefierRecipes.put(inputStack, outputStack);
    }

    public static Set<Map.Entry<PositionedStack, PositionedStack>> getLiquefierRecipes() {
        return liquefierRecipes.entrySet();
    }

    private void registerSynthesizerRecipe(PositionedStack inputStack, PositionedStack outputStack) {
        synthesizerRecipes.put(inputStack, outputStack);
    }

    public static Set<Map.Entry<PositionedStack, PositionedStack>> getSynthesizerRecipes() {
        return synthesizerRecipes.entrySet();
    }

    public void registerRecipes() {
        this.registerLiquefierRecipe(new PositionedStack((Object)new ItemStack(AsteroidsItems.methaneCanister, 1, 1), 2, 3), new PositionedStack((Object)new ItemStack(GCItems.fuelCanister, 1, 1), 127, 3));
        this.registerLiquefierRecipe(new PositionedStack((Object)new ItemStack(AsteroidsItems.atmosphericValve, 1, 0), 2, 3), new PositionedStack((Object)new ItemStack(AsteroidsItems.canisterLN2, 1, 1), 127, 3));
        this.registerLiquefierRecipe(new PositionedStack((Object)new ItemStack(AsteroidsItems.atmosphericValve, 1, 0), 2, 3), new PositionedStack((Object)new ItemStack(AsteroidsItems.canisterLOX, 1, 1), 148, 3));
        this.registerLiquefierRecipe(new PositionedStack((Object)new ItemStack(AsteroidsItems.canisterLN2, 1, 501), 2, 3), new PositionedStack((Object)new ItemStack(AsteroidsItems.canisterLN2, 1, 1), 127, 3));
        this.registerLiquefierRecipe(new PositionedStack((Object)new ItemStack(AsteroidsItems.canisterLOX, 1, 501), 2, 3), new PositionedStack((Object)new ItemStack(AsteroidsItems.canisterLOX, 1, 1), 148, 3));
        this.registerSynthesizerRecipe(new PositionedStack((Object)new ItemStack(AsteroidsItems.atmosphericValve, 1, 0), 23, 3), new PositionedStack((Object)new ItemStack(AsteroidsItems.methaneCanister, 1, 1), 148, 3));
        this.registerSynthesizerRecipe(new PositionedStack((Object)new ItemStack(MarsItems.carbonFragments, 25, 0), 23, 49), new PositionedStack((Object)new ItemStack(AsteroidsItems.methaneCanister, 1, 1), 148, 3));
    }
}

